/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.operacion.pedido;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import showcase.meta.entidad.pedido.Pedido;

@ProcessOperationClass(overloading = Kleenean.UNSPECIFIED, serviceable = Kleenean.TRUE,
    deadline = "1m", priority = 1,
    newTaskNotification = "1m", notifySupervisor = true,
    notifyAssignment = true, notifyRelief = true, notifyAssumption = true, notifyAbandonment = true, notifyCancellation = true, notifyCompletion = true,
    automaticAssumption = true,
    unassignedTaskNotification = "2m",
    unfinishedTaskNotification = "3m",
    unassignedTaskEscalation = "4m",
    unfinishedTaskEscalation = "5m",
    nextUnassignedTaskNotification = "1m",
    nextUnfinishedTaskNotification = "1m",
    nextUnassignedTaskEscalation = "2m",
    nextUnfinishedTaskEscalation = "2m"
)
@OperationClass(access = OperationAccess.RESTRICTED)
public class Procesar extends ProcessOperation {

    @InstanceReference
    protected Pedido pedido;

    @Override
    protected void settleParameters() {
        super.settleParameters();
        pedido.estado.setCurrentValue(pedido.estado.PROCESADO);
        pedido.fechaHoraProcesado.setCurrentValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        pedido.fechaHoraTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        pedido.usuarioTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
    }

    protected Check check101;

    /*
    protected Check check201;

    /**/
    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        check101 = pedido.monto.isGreaterThan(0);
        check101.setDefaultErrorMessage("el pedido no tiene renglones");
        /*
        check201 = pedido.evaluate("PredicadoProcesarPedido");
        /**/
    }

}
