/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.operacion.pedido;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.parameters.*;
import showcase.meta.entidad.cliente.Cliente;
import showcase.meta.entidad.pedido.Pedido;
import showcase.meta.entidad.producto.Producto;

@ConstructionOperationClass(type = Pedido.class, onsuccess = OnConstructionOperationSuccess.DISPLAY_NEW_INSTANCE)
@OperationClass(access = OperationAccess.RESTRICTED)
public class Recibir extends ProcessOperation {

    @ParameterField(required = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.DISPLAY, displayMode = DisplayMode.WRITING)
    protected Cliente cliente;

    @ParameterField(required = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.DISPLAY, displayMode = DisplayMode.READING)
    protected Producto producto;

    @ParameterField(required = Kleenean.TRUE)
    @NumericField(type = NumericFieldType.KNOB)
    protected IntegerParameter cantidad;

    @Override
    protected void settleParameters() {
        super.settleParameters();
        /**/
        cantidad.setInitialValue(1);
        cantidad.setDefaultValue(1);
        cantidad.setMinValue(1);
        cantidad.setMaxValue(100);
        /**/
    }

}
