/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.operacion.producto;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.parameters.*;
import showcase.meta.entidad.documento.DocumentoProducto;
import showcase.meta.entidad.producto.Producto;

@OperationClass(access = OperationAccess.RESTRICTED)
@ConstructionOperationClass(type = DocumentoProducto.class)
public class AdjuntarDocumento extends ProcessOperation {

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("agregar y adjuntar documento");
        setDefaultShortLabel("adjuntar documento");
        setDefaultDescription("agrega y adjunta un documento al producto");
    }

    @InstanceReference
    protected Producto producto;

    @FileReference(fileLimit = 100, max = 0)
    @ParameterField(required = Kleenean.TRUE)
    protected StringParameter archivo;

    @ParameterField(required = Kleenean.FALSE)
    protected StringParameter descripcion;

}
