/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.operacion.producto;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.Check;
import adalid.core.parameters.*;

@ProcedureOperationClass(type = ProcedureType.VOID)
@ProcessOperationClass(processingGroup = "procesos_batch", serviceable = Kleenean.TRUE)
@OperationClass(access = OperationAccess.RESTRICTED, confirmation = Kleenean.TRUE)
public class CargarArchivo extends ProcedureOperation {

    @FileReference
    @ParameterField(required = Kleenean.TRUE)
    protected StringParameter archivo;

    @ParameterField()
    protected BooleanParameter encabezado;

    /**/
    @ParameterField()
    protected CharacterParameter caracterDelimitador;

    /**/
    @ParameterField()
    protected CharacterParameter caracterComillas;

    /*
    @ParameterField()
    protected CharacterParameter caracterEscape;

    /*
    @ParameterField()
    @StringField(maxLength = 15)
    protected StringParameter cadenaNula;

    /**/
    @Override
    protected void settleParameters() {
        super.settleParameters();
        /**/
        encabezado.setInitialValue(true);
        encabezado.setDefaultValue(true);
        /**/
        caracterDelimitador.setInitialValue(";");
        caracterDelimitador.setDefaultValue(";");
        /**/
        caracterComillas.setInitialValue("\"");
        caracterComillas.setDefaultValue("\"");
        /*
        caracterEscape.setInitialValue(caracterComillas);
        caracterEscape.setDefaultValue(caracterComillas);
        /*
        cadenaNula.setInitialValue("\\N");
        cadenaNula.setDefaultValue("\\N");
        /**/
    }

    /**/
    protected Check checkCaracterDelimitador, checkCaracterComillas;

    /*
    protected Check checkCaracterEscape;

    /**/
    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        /**/
        checkCaracterDelimitador = or(caracterDelimitador.isEqualTo(","), caracterDelimitador.isEqualTo(";"));
        checkCaracterDelimitador.setDefaultErrorMessage("carácter delimitador inválido; solo se permiten coma y punto y coma");
        /**/
        checkCaracterComillas = or(caracterComillas.isEqualTo("'"), caracterComillas.isEqualTo("\""));
        checkCaracterComillas.setDefaultErrorMessage("carácter comillas inválido; solo se permiten comillas simples y comillas dobles");
        /*
        checkCaracterEscape = or(caracterEscape.isEqualTo("'"), caracterEscape.isEqualTo("\""));
        checkCaracterEscape.setDefaultErrorMessage("carácter comillas inválido; solo se permiten comillas simples y comillas dobles");
        /**/
    }

}
