/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.operacion.producto;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.parameters.*;
import showcase.meta.entidad.producto.Producto;

@ProcessOperationClass(overloading = Kleenean.UNSPECIFIED, serviceable = Kleenean.TRUE)
@OperationClass(access = OperationAccess.RESTRICTED)
public class CargarImagen extends ProcessOperation {

    @InstanceReference
    protected Producto producto;

    @FileReference
    @ParameterField(linkedField = "archivoImagen", required = Kleenean.TRUE)
    protected StringParameter imagen;

}
