/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.proyecto;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.jee2.bundles.BundleBase;
import adalid.jee2.meta.proyecto.base.*;
import meta.proyecto.comun.*;
import showcase.meta.modulo.*;
import showcase.meta.modulo.i18n.*;

public abstract class Maestro extends ProyectoPrime {

    public static final String ACRONYM = "showcase";

    public static final String PACKAGE = "showcase";

    /**
     * Guía de Operación, Proyecto Adalid, Plataforma jee2
     */
    public static final String HELP_DOCUMENT_URL = adalid.jee2.constants.JEE2.OPERACION_PDF;

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        /**/
        setLocalizedLabel(SPANISH, "Gestión de Recursos Empresariales");
        setLocalizedDescription(SPANISH, BundleBase.getString("project.description", SPANISH));
        setLocalizedShortDescription(SPANISH, "Gestión de Recursos Empresariales");
        /**/
        setLocalizedLabel(ENGLISH, "Enterprise Resource Management");
        setLocalizedDescription(ENGLISH, BundleBase.getString("project.description", ENGLISH));
        setLocalizedShortDescription(ENGLISH, "Enterprise Resource Management");
        /**/
        setHelpDocument(iframe("https://www.youtube.com/embed/yyF1rWcYYiA", 960, 540)); // URL del video tutorial almacenado en YouTube
        setHelpFileAutoName(HelpFileAutoName.ENTITY);
        setHelpFileAutoType("xhtml");
        /**/
    }

    @Override
    protected void setStaticAttributes() {
        super.setStaticAttributes();
        /**/
        InstanceTag.BLUE.setPillShaped(true);
        InstanceTag.BLUISH.setPillShaped(true);
        InstanceTag.CYAN.setPillShaped(true);
        InstanceTag.CYANISH.setPillShaped(true);
        InstanceTag.GREEN.setPillShaped(true);
        InstanceTag.GREENISH.setPillShaped(true);
        InstanceTag.LIGHT_GREEN.setPillShaped(true);
        InstanceTag.ORANGE.setPillShaped(true);
        InstanceTag.ORANGISH.setPillShaped(true);
        InstanceTag.PURPLE.setPillShaped(true);
        InstanceTag.PURPLISH.setPillShaped(true);
        InstanceTag.RED.setPillShaped(true);
        InstanceTag.REDISH.setPillShaped(true);
        InstanceTag.SANDY_BEACH.setPillShaped(true);
        InstanceTag.YELLOW.setPillShaped(true);
        InstanceTag.YELLOWISH.setPillShaped(true);
        /**/
        setDefaultEntityTableViewResponsiveMode(TableResponsiveMode.AUTO);
        /**/
    }

    @Override
    public void configureGenerator() {
        super.configureGenerator();
    }

    @ProjectModule(menu = Kleenean.TRUE, role = Kleenean.TRUE)
    protected Clientes mod1;

    @ProjectModule(menu = Kleenean.TRUE, role = Kleenean.TRUE)
    protected Pedidos mod3;

    @ProjectModule(menu = Kleenean.FALSE, role = Kleenean.FALSE)
    protected Documentos mod4;

    @ProjectModule(menu = Kleenean.TRUE, menuType = MenuType.REGISTRATION, role = Kleenean.TRUE)
    protected RecursosCompartidosVE mod9;

    @ProjectModule(menu = Kleenean.TRUE, role = Kleenean.TRUE, roleTypes = {RoleType.PROCESSOR, RoleType.READER})
    protected Auditoria modx1;

    @ProjectModule(menu = Kleenean.TRUE, role = Kleenean.TRUE)
    protected showcase.meta.modulo.ControlAcceso modx2;

    @ProjectModule(role = Kleenean.TRUE, roleTypes = RoleType.PROCESSOR)
    protected ControlProcesos modx3;

    @ProjectModule(role = Kleenean.TRUE, roleTypes = {RoleType.PROCESSOR, RoleType.READER})
    protected ControlServicios modx4;

    @ProjectModule(role = Kleenean.TRUE, roleTypes = {RoleType.PROCESSOR, RoleType.READER})
    protected ControlTareas modx5;

}
