/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.proyecto;

import adalid.commons.enums.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.jee2.WebApplication;
import adalid.jee2.constants.*;
import meta.psm.PrimeFacesThemes;
import meta.psm.ProjectAttributeKeys;
import showcase.meta.modulo.i18n.I18n;

/**
 * @author Jorge Campins
 */
@MasterProject(acronym = Maestro.ACRONYM, alias = Maestro102.ALIAS, helpFile = Maestro102.ALIAS, runnable = true)
public class Maestro102 extends Maestro {

    public static final String ALIAS = "showcase102";

    public static void main(String[] args) throws Exception {
        newInstance(Maestro102.class).build(PLATAFORMA_MAVEN_POSTGRESQL_WILDFLY);
    }

    @ProjectModule(menu = Kleenean.FALSE, role = Kleenean.FALSE)
    protected I18n i18n;

    @Override
    protected void setStaticAttributes() {
        super.setStaticAttributes();
//      setBootstrappingFileName("bootstrapping.properties");
//      setLocale(SPANISH);
//      setDecimalSeparator(ENGLISH, '.');
//      setDecimalSeparator(SPANISH, ',');
//      setThousandSeparator(ENGLISH, ',');
//      setThousandSeparator(SPANISH, '.');
//      setDateFormat(ENGLISH, "MM/dd/yyyy");
//      setDateFormat(SPANISH, "dd/MM/yyyy");
//      setTimeFormat(ENGLISH, "hh:mm a");
//      setTimeFormat(SPANISH, "hh:mm a");
//      setTimestampFormat(ENGLISH, "MM/dd/yyyy hh:mm a");
//      setTimestampFormat(SPANISH, "dd/MM/yyyy hh:mm a");
//      setAlertLoggingLevel(LoggingLevel.WARN);
//      setDetailLoggingLevel(LoggingLevel.INFO);
//      setDictionaryLoggingLevel(LoggingLevel.INFO);
//      setTrackingLoggingLevel(LoggingLevel.INFO);
//      setTransitionLoggingLevel(LoggingLevel.INFO);
//      setSpecialExpressionLoggingLevel(LoggingLevel.WARN);
//      setUnusualExpressionLoggingLevel(LoggingLevel.WARN);
//      setDefaultEntityCodeGenBPL(true);
//      setDefaultEntityCodeGenBWS(true);
//      setDefaultEntityCodeGenFWS(true);
//      setDefaultEntityCodeGenGUI(true);
//      setDefaultEntityCodeGenSMC(true);
//      setDefaultEntityCodeGenSQL(true);
//      setDefaultPropertyFieldSerializable(false);
//      setDefaultPropertyFieldSerializableIUID(true);
//      setDefaultStringFieldMaxLength(2000);
//      setDefaultStringIndexMaxLength(1596);
//      setDefaultInlineHelpType(InlineHelpType.DESCRIPTION);
    }

    @Override
    public void configureBuilder() {
        super.configureBuilder();
        /**/
//      enableDictionary();
        /**/
        setSupportedLocales(ENGLISH, SPANISH);
        /**/
//      setBusinessOperationConfirmationRequired(Kleenean.TRUE);
//      setDatabaseOperationConfirmationRequired(Kleenean.TRUE);
        /**/
        setMissingValueGraphicImageName(FA.MISSING_VALUE);
//      setNullValueGraphicImageName(FA.NULL_VALUE);
        setUnnecessaryValueGraphicImageName(FA.UNNECESSARY_VALUE);
        /**/
        addWebApplication(WebApplication.of("showcase10201-web", "Gestión de Clientes"));
        addWebApplication(WebApplication.of("showcase10202-web", "Gestión de Pedidos"));
        addWebApplication(WebApplication.of("showcase10203-web", "Gestión de Recursos Compartidos"));
        /**/
        setRoleWebAppDissociationAllowed(true);
        /**/
    }

    @Override
    public void configureGenerator() {
        super.configureGenerator();
        loadEnvironmentVariables(LoggingLevel.TRACE);
//      putEnvironmentVariable(CONTENT_ROOT_DIR_LINUX, "/opt/content-root");
//      putEnvironmentVariable(CONTENT_ROOT_DIR_WINDOWS, "%SystemDrive%/content-root");
//      loadPrivateProperties(LoggingLevel.INFO);
        setTheme(PrimeFacesThemes.NOVA_LIGHT);
        setThemeSwitchingEnabled(true);
        setInternetAccessAllowed(true);
//      setWebServicesEnabled(true);
        setProjectMailingEnabled(true);
//      setProjectTextingEnabled(true);
//      setDefaultSMSProvider(ShortMessageServiceProvider.TWILIO);
        setProjectRecaptchaEnabled(true);
        setProjectRecaptchaSiteVerificationEnabled(false);
//      setGoogleRecaptchaSiteKey(FilUtils.scanTextFile(System.getenv("GoogleRecaptchaSiteKey")));
//      setProjectStage(ProjectStage.PRODUCTION);
        setDatabaseName("showcase");
//      setWebAuthMethod(WebLoginAuthMethod.FORM);
//      setWebApiAuthMethod(WebLoginAuthMethod.BASIC);
//      setSecurityRealmName(ALIAS + "-auth-realm");
//      setSecurityRealmType(SecurityRealmType.LDAP);
//      setRoleBasedAccessControllerName("LDAP");
//      setRoleCodePrefix(ALIAS);
//      setAuthenticatedUserAutomaticRegistrationEnabled(false);
//      setAuthenticatedUserAutomaticSynchronizationEnabled(false);
        setMessageDigestAlgorithm("SHA-256");
//      setExporterShellEnabled(true);
//      setReporterShellEnabled(true);
//      setSqlAgentShellEnabled(true);
//      setOperatingSystemShellKeepTempFiles(true);
//      setVersion("1.0.0");
//      taskNotifierSchedule.minute = "*/15";
//      addProjectDependency(dependencia adicional, tipo del módulo al que se debe agregar la dependencia adicional);
//      por ejemplo: addProjectDependency(MavenDependencies.PrimeFaces.freya(), ProjectModuleType.WEB);
    }

    @Override
    public void addDirectives() {
        super.addDirectives();
//      addFileExclusionPattern(expresión regular para evaluar el nombre de los archivos que se deben excluir);
        addFileExclusionPattern("^.*/data-migration/base/insert-select-past-data-[\\d]{8}-[\\d]{4}\\.sql$");
        addFileExclusionPattern("^.*/src/main/resources/.*/lib/base/bundle/code/BundleWebui\\.properties$");
//      addFilePreservationPattern(expresión regular para evaluar el nombre de los archivos que se deben preservar);
//      por ejemplo: addFilePreservationPattern("^.*/\\.gitignore$"); // preserva los archivos .gitignore
    }

    @Override
    public void attachAddAttributesMethods() {
        super.attachAddAttributesMethods();
//      attachAddAttributesMethods(showcase.meta.psm.PostgreSQLAttributes.class);
        attachAddAttributesMethods(showcase.meta.psm.DescriptiveAttributes.class);
    }

    @Override
    public void addAttributes() {
        super.addAttributes();
//      addAttribute(ProjectAttributeKeys.ALTERNATE_DOCUMENT_ROOT_SECURED, true);
//      addAttribute(ProjectAttributeKeys.ALWAYS_OPEN_CONTENT_VIEWER_AS_DIALOG, false);
//      addAttribute(ProjectAttributeKeys.CHECK_BOXES_ALLOWED, false);
//      addAttribute(ProjectAttributeKeys.CUSTOM_LAYOUT, true);
//      addAttribute(ProjectAttributeKeys.DATA_TABLE_SHOW_GRID_LINES, true);
//      addAttribute(ProjectAttributeKeys.DATA_TABLE_SHOW_STRIPED_ROWS, true);
        addAttribute(ProjectAttributeKeys.DATA_TABLE_SIZE, DataTableSize.SMALL);
//      addAttribute(ProjectAttributeKeys.DISABLE_BPL_IMPL_GENERATION, true);
//      addAttribute(ProjectAttributeKeys.DISABLE_PAGE_ASSISTANT_GENERATION, true);
//      addAttribute(ProjectAttributeKeys.FACELETS_REFRESH_PERIOD, -1);
        addAttribute(ProjectAttributeKeys.HELP_DOCUMENT_URL, HELP_DOCUMENT_URL);
//      addAttribute(ProjectAttributeKeys.HELP_WINDOW_WIDTH_KEY, 3);
//      addAttribute(ProjectAttributeKeys.HCB_RENDERING, true);
//      addAttribute(ProjectAttributeKeys.HLB_RENDERING, true);
//      addAttribute(ProjectAttributeKeys.HRB_RENDERING, true);
//      addAttribute(ProjectAttributeKeys.HTML_SANITIZER_VERSION, "20200713.1");
//      addAttribute(ProjectAttributeKeys.INITIAL_PAGE_LOCATION, "/faces/views/custom-made/Dashboard.xhtml");
//      addAttribute(ProjectAttributeKeys.INITIAL_PAGE_LOCATION, IPL.DEFAULT);
//      addAttribute(ProjectAttributeKeys.INITIAL_WINDOW_TARGET, IWT.DEFAULT);
//      addAttribute(ProjectAttributeKeys.MEDIA_FILE_EXPOSURE_RISK_ACCEPTABLE, true);
//      addAttribute(ProjectAttributeKeys.NUMERIC_BOXES_ALLOWED, false);
//      addAttribute(ProjectAttributeKeys.PERSISTENCE_UNIT_ECLIPSELINK_LOGGER, "DefaultLogger");
//      addAttribute(ProjectAttributeKeys.PERSISTENCE_UNIT_HIBERNATE_STATISTICS, "enabled");
//      addAttribute(ProjectAttributeKeys.RPH_DOUBLE_HEIGHT, true);
//      addAttribute(ProjectAttributeKeys.RPH_LEFT_IMAGE_HEIGHT, 60);
//      addAttribute(ProjectAttributeKeys.RPH_LEFT_IMAGE_WIDTH, 105);
//      addAttribute(ProjectAttributeKeys.RPH_NO_LEFT_IMAGE, false);
//      addAttribute(ProjectAttributeKeys.RPH_NO_RIGHT_IMAGE, false);
//      addAttribute(ProjectAttributeKeys.RPH_RIGHT_IMAGE_HEIGHT, 60);
//      addAttribute(ProjectAttributeKeys.RPH_RIGHT_IMAGE_WIDTH, 105);
//      addAttribute(ProjectAttributeKeys.SESSION_TIMEOUT, 5);
//      addAttribute(ProjectAttributeKeys.TASK_MAIL_PER_TASK, true);
//      addAttribute(ProjectAttributeKeys.TASK_TEXT_PER_TYPE, true);
        /**/
        addPageAbstractAttribute("SolicitudCambiarCorreoUsuario34");
        addPageAbstractAttribute("SolicitudCrearCuentaUsuario34");
        /*
        addWebContextParameter("primefaces.virusscan.VIRUSTOTAL_KEY", "e7e433d46a4577375eb595ed12297311b54bce6ba369f8456ec2fcead1d21cea");
        /**/
    }

}
