/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.proyecto;

import adalid.commons.util.ColUtils;
import adalid.core.annotations.*;
import adalid.core.interfaces.Entity;
import adalid.util.ProjectI18n;
import adalid.util.i18n.BasicTranslator;
import java.util.Collection;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

/**
 * @author Jorge Campins
 */
@MasterProject(acronym = Maestro.ACRONYM, alias = Maestro.ACRONYM)
public class MaestroI18n extends Maestro implements ProjectI18n {

    private static final String PLATFORM = adalid.util.Platform.META_JAVA_I18N;

    private static final boolean translation_enabled = false;

    public static void main(String[] args) throws Exception {
        MaestroI18n maestro = newInstance(MaestroI18n.class);
        if (translation_enabled) {
            maestro.translator = new BasicTranslator();
            maestro.translator.build("es", "en");
            maestro.build(PLATFORM);
            maestro.translator.close();
        } else {
            maestro.build(PLATFORM);
        }
    }

    private BasicTranslator translator;

    @Override
    public BasicTranslator getTranslator() {
        return translator;
    }

    private final String[] prefixes = {
        "meta.entidad.comun.",
        "showcase."
    };

    private final String[] exclusions = {
        "TipoCliente",
        "Usuario"
    };

    private final Predicate predicate = new EntityPredicate();

    private class EntityPredicate implements Predicate {

        @Override
        public boolean evaluate(Object object) {
            return object instanceof Entity
                && StringUtils.startsWithAny(object.getClass().getCanonicalName(), prefixes)
                && !ArrayUtils.contains(exclusions, object.getClass().getSimpleName());
        }

    }

    @Override
    public Collection<Entity> getTranslatableEntities() {
        return ColUtils.filter(getEntitiesList(), predicate);
    }

}
