/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.psm;

import adalid.commons.util.*;
import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.ExpressionUsage;
import adalid.core.interfaces.*;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;

/**
 * @author ADALID meta-jee2-archetype
 */
public class DescriptiveAttributes {

    private static final String PACKAGE = showcase.meta.proyecto.Maestro.PACKAGE;

    private static final String description = LoremIpsum.getString(); // 5, 11, 17, 21, 27, 56, 123, 148, 231, 334, 382, 445, 865, 1311, 1710, 2156

    private static final String short_description = LoremIpsum.getString(500);

    private static final String shorter_description = LoremIpsum.getString(250);

    private static final String shortest_description = LoremIpsum.getString(125);

    @AddAttributesMethod
    public static void addAttributes(Project project) {
        setDescriptiveAttributes(project);
    }

    @AddAttributesMethod
    public static void addAttributes(Entity entity) {
        setDescriptiveAttributes(entity);
    }

    @AddAttributesMethod
    public static void addAttributes(Expression expression) {
        if (expression == null || expression instanceof Primitive) {
            return;
        }
        Field declaringField = expression.getDeclaringField();
        if (declaringField == null) {
            setExpressionTags(expression);
        } else {
            Artifact declaringArtifact = expression.getDeclaringArtifact();
            if (declaringArtifact.getClass().getCanonicalName().startsWith(PACKAGE)) {
                boolean b1 = declaringArtifact instanceof Entity && declaringArtifact.depth() == 0;
                boolean b2 = declaringArtifact instanceof Operation; // Operation --> depth() == 0
                if (b1 || b2) {
                    setDescriptiveAttributes(declaringArtifact, expression);
                    setExpressionTags(expression);
                }
            }
        }
    }

    private static void setExpressionTags(Expression expression) {
        Map<ExpressionUsage, Set<Artifact>> verifiedUsages = expression.getVerifiedUsageMap();
        if (!verifiedUsages.isEmpty()) {
            for (ExpressionUsage key : verifiedUsages.keySet()) {
                for (Artifact user : expression.getVerifiedUsers(key)) {
                    Artifact declaringArtifact = user.getDeclaringArtifact();
                    if (declaringArtifact != null && declaringArtifact.getClass().getCanonicalName().startsWith(PACKAGE)) {
                        String defaultLabel = expression.getDefaultLabel();
                        String defaultShortDescripcion = expression.getDefaultDescription();
                        String defaultDescripcion = expression.getDefaultDescription();
//                      String expressionString = expression.getExpressionString();
                        String tag = StrUtils.coalesce(defaultLabel, defaultShortDescripcion, defaultDescripcion, shortest_description);
                        if (user instanceof AbstractDataArtifact da) {
//                          System.out.println(da.getFullName() + "." + key + "=" + expressionString);
                            switch (key) {
                                case RENDERING_FILTER -> {
                                    da.setRenderingFilterTag(StrUtils.coalesce(da.getRenderingFilterTag(), tag));
                                }
                                case REQUIRING_FILTER -> {
                                    da.setRequiringFilterTag(StrUtils.coalesce(da.getRequiringFilterTag(), tag));
                                }
                                case MODIFYING_FILTER -> {
                                    da.setModifyingFilterTag(StrUtils.coalesce(da.getModifyingFilterTag(), tag));
                                }
                                case NULLIFYING_FILTER -> {
                                    da.setNullifyingFilterTag(StrUtils.coalesce(da.getNullifyingFilterTag(), tag));
                                }
                                case CURRENT_VALUE -> {
                                    da.setCurrentValueTag(StrUtils.coalesce(da.getCurrentValueTag(), tag));
                                }
                                case DEFAULT_VALUE -> {
                                    da.setDefaultValueTag(StrUtils.coalesce(da.getDefaultValueTag(), tag));
                                }
                                case INITIAL_VALUE -> {
                                    da.setInitialValueTag(StrUtils.coalesce(da.getInitialValueTag(), tag));
                                }
                            }
                        }
                        if (user instanceof IntervalizedArtifact da) {
//                          System.out.println(da.getFullName() + "." + key + "=" + expressionString);
                            switch (key) {
                                case MAX_VALUE -> {
                                    da.setMaximumValueTag(StrUtils.coalesce(da.getMaximumValueTag(), tag));
                                }
                                case MIN_VALUE -> {
                                    da.setMinimumValueTag(StrUtils.coalesce(da.getMinimumValueTag(), tag));
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @AddAttributesMethod
    public static void addAttributes(Operation operation) {
        setDescriptiveAttributes(operation);
    }

    private static void setDescriptiveAttributes(Artifact artifact) {
        if (artifact.getClass().getCanonicalName().startsWith(PACKAGE)) {
            artifact.setDefaultDescription(StrUtils.coalesce(artifact.getDefaultDescription(), description));
            artifact.setDefaultShortDescription(StrUtils.coalesce(artifact.getDefaultShortDescription(), short_description));
        }
    }

    private static void setDescriptiveAttributes(Artifact declaringArtifact, Artifact artifact) {
        if (declaringArtifact.getClass().getCanonicalName().startsWith(PACKAGE)) {
            artifact.setDefaultShortDescription(StrUtils.coalesce(artifact.getDefaultShortDescription(), artifact.getDefaultDescription(), shortest_description));
            artifact.setDefaultDescription(StrUtils.coalesce(artifact.getDefaultDescription(), shorter_description));
        }
    }

}
