/*
 * Decompiled with CFR 0.152.
 */
package showcase.meta.entidad.cliente;

import adalid.core.Step;
import adalid.core.Tab;
import adalid.core.View;
import adalid.core.ViewField;
import adalid.core.annotations.AbstractClass;
import adalid.core.annotations.BooleanDataGen;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.CharacterDataGen;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DateField;
import adalid.core.annotations.DiscriminatorColumn;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityDataGen;
import adalid.core.annotations.EntityReferenceDataGen;
import adalid.core.annotations.EntityReferenceDisplay;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ImageProperty;
import adalid.core.annotations.InheritanceMapping;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.NumericDataGen;
import adalid.core.annotations.OneToOne;
import adalid.core.annotations.OwnerProperty;
import adalid.core.annotations.PropertyAggregation;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.SegmentProperty;
import adalid.core.annotations.StringField;
import adalid.core.annotations.TemporalDataGen;
import adalid.core.annotations.UrlProperty;
import adalid.core.enums.AggregateFunction;
import adalid.core.enums.AnchorType;
import adalid.core.enums.AutoComplete;
import adalid.core.enums.AvatarDefault;
import adalid.core.enums.AvatarShape;
import adalid.core.enums.Checkpoint;
import adalid.core.enums.DataGenNumericAction;
import adalid.core.enums.DataGenType;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.EntityReferenceStyle;
import adalid.core.enums.InheritanceMappingStrategy;
import adalid.core.enums.Kleenean;
import adalid.core.enums.LetterCase;
import adalid.core.enums.ListStyle;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.MimeType;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.PropertyAccess;
import adalid.core.enums.SearchDisplayFormat;
import adalid.core.enums.SearchType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.enums.SortOption;
import adalid.core.enums.UrlDisplayType;
import adalid.core.enums.UrlType;
import adalid.core.enums.ViewFieldAggregation;
import adalid.core.expressions.CharacterOtherwiseX;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityExpression;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.Segment;
import adalid.core.properties.BinaryProperty;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.DateProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.ext.EmailAddressProperty;
import adalid.core.properties.ext.LocalSmartphoneNumberProperty;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;
import meta.entidad.comun.control.acceso.Usuario;
import showcase.meta.entidad.cliente.DireccionCliente;
import showcase.meta.entidad.configuracion.ActividadEconomica;
import showcase.meta.entidad.configuracion.Banco;
import showcase.meta.entidad.configuracion.Departamento;
import showcase.meta.entidad.configuracion.Distrito;
import showcase.meta.entidad.configuracion.Jurisdiccion;
import showcase.meta.entidad.configuracion.Municipio;
import showcase.meta.entidad.configuracion.fija.ConfiguracionGlobal;
import showcase.meta.entidad.configuracion.fija.FormaPago;
import showcase.meta.entidad.configuracion.fija.Pais;
import showcase.meta.entidad.configuracion.fija.TipoCliente;
import showcase.meta.operacion.cliente.AdjuntarDocumento;
import showcase.meta.operacion.cliente.AprobarCredito;
import showcase.meta.operacion.cliente.CargarImagen;
import showcase.meta.propiedad.PropiedadDinero;

@AbstractClass
@EntityCodeGen(bws=Kleenean.TRUE, fws=Kleenean.TRUE)
@EntityDataGen(start=1, step=1, stop=100)
@EntitySelectOperation(onload=SelectOnloadOption.PROMPT)
@EntityTableView(inserts=Kleenean.FALSE, updates=Kleenean.FALSE, rows=5)
@InheritanceMapping(strategy=InheritanceMappingStrategy.JOINED)
public class Cliente
extends PersistentEntityBase {
    @DiscriminatorColumn
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    public TipoCliente tipo;
    @BusinessKey
    @StringField(maxLength=10, regex="^[A-Za-z]{1,3}[0-9]{1,7}$", letterCase=LetterCase.UPPER, allowDiacritics=Kleenean.FALSE)
    public StringProperty codigo;
    @NameProperty
    public StringProperty nombre;
    @ImageProperty(displayWidth={144, 96, 72}, displayHeight={192, 128, 96}, avatarShape=AvatarShape.CIRCLE)
    @PropertyField(table=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public BinaryProperty imagen;
    @ColumnField(calculable=Kleenean.TRUE)
    @FileReference(types={MimeType.IMAGE}, blobField="imagen")
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.FALSE, report=Kleenean.FALSE)
    public StringProperty archivoImagen;
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, search=Kleenean.TRUE, table=Kleenean.FALSE)
    @EntityReferenceSearch(searchType=SearchType.DISPLAY, displayMode=DisplayMode.WRITING)
    public ActividadEconomica actividadEconomica;
    @DateField(disabledWeekends=Kleenean.TRUE, disabledHolidays=Kleenean.TRUE, yearRange=5)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, search=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.FALSE, overlay=Kleenean.TRUE)
    @TemporalDataGen(type=DataGenType.RANDOM, min="-10Y", max="0")
    public DateProperty fechaInicioRelacion;
    @OwnerProperty
    @SegmentProperty
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, overlay=Kleenean.TRUE, prominent=Kleenean.TRUE, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public Usuario ejecutivo;
    @ColumnField(calculable=Kleenean.TRUE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(hidden=Kleenean.TRUE)
    public ConfiguracionGlobal global;
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.TRUE, overlay=Kleenean.TRUE, required=Kleenean.TRUE, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public Pais pais;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, search=Kleenean.TRUE, table=Kleenean.FALSE)
    @EntityReferenceSearch(searchType=SearchType.DISPLAY, displayFormat=SearchDisplayFormat.TREE, displayMode=DisplayMode.WRITING)
    @EntityReferenceDataGen(nullable=0, type=DataGenType.RANDOM)
    public Jurisdiccion jurisdiccion;
    @ColumnField(calculable=Kleenean.TRUE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.FALSE)
    @EntityReferenceSearch(searchType=SearchType.LIST)
    public Departamento departamento;
    @ColumnField(calculable=Kleenean.TRUE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.FALSE)
    @EntityReferenceSearch(searchType=SearchType.LIST)
    public Distrito distrito;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.TABLE_AND_DETAIL)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.FALSE)
    @EntityReferenceSearch(searchType=SearchType.LIST)
    @EntityReferenceDataGen(nullable=0, type=DataGenType.RANDOM)
    public Municipio municipio;
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.FALSE)
    @StringField(maxLength=20, mask="(999) 999-9999[ x9999]", autoComplete=AutoComplete.OFF)
    @CharacterDataGen(type=DataGenType.RANDOM, pattern="(000) 000-0000 \\x0000")
    public StringProperty telefonoFijo;
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.FALSE)
    @StringField(maxLength=20, mask="(999) 999-9999", autoComplete=AutoComplete.OFF)
    @CharacterDataGen(type=DataGenType.RANDOM, pattern="(000) 000-0000")
    public StringProperty telefonoMovil;
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.FALSE, report=Kleenean.FALSE)
    public LocalSmartphoneNumberProperty telefonoInteligente;
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.FALSE)
    public EmailAddressProperty correoElectronico;
    @UrlProperty(urlDisplayType=UrlDisplayType.BUTTON, urlType=UrlType.EXTERNAL)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.FALSE)
    @CharacterDataGen(type=DataGenType.DEFAULT)
    public StringProperty paginaWeb;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @OneToOne
    @EntityReferenceDisplay(style=EntityReferenceStyle.NAME)
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.NAME, displayMode=DisplayMode.WRITING)
    @CharacterDataGen(type=DataGenType.DEFAULT)
    public DireccionCliente direccionPrincipal;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, search=Kleenean.TRUE, table=Kleenean.FALSE, report=Kleenean.FALSE, overlay=Kleenean.TRUE)
    public BooleanProperty analizado;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, search=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.FALSE, overlay=Kleenean.TRUE)
    public BooleanProperty aprobado;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, search=Kleenean.TRUE, table=Kleenean.FALSE, report=Kleenean.FALSE, overlay=Kleenean.TRUE)
    @BooleanDataGen(nullable=50)
    public BooleanProperty auditado;
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, search=Kleenean.TRUE, table=Kleenean.TRUE, access=PropertyAccess.RESTRICTED_READING)
    @NumericDataGen(type=DataGenType.RANDOM, nullable=0, min="100", max="200", action=DataGenNumericAction.TRUNCATE, factor="100")
    public PropiedadDinero ingresoPromedio;
    @PropertyAggregation(function=AggregateFunction.AVERAGE)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, search=Kleenean.TRUE, table=Kleenean.TRUE, access=PropertyAccess.RESTRICTED_WRITING, overlay=Kleenean.TRUE)
    @NumericDataGen(type=DataGenType.RANDOM, nullable=0, min="100", max="200", action=DataGenNumericAction.TRUNCATE, factor="100")
    public PropiedadDinero limiteCredito;
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.FALSE, required=Kleenean.TRUE)
    @EntityReferenceDataGen(type=DataGenType.DEFAULT)
    public FormaPago formaPago;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.FALSE, anchor="formaPago", anchorType=AnchorType.INLINE)
    @EntityReferenceDataGen(type=DataGenType.DEFAULT)
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.NAME, displayMode=DisplayMode.WRITING)
    public Banco banco;
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.FALSE, anchor="banco", anchorType=AnchorType.INLINE)
    @StringField(maxLength=20)
    @CharacterDataGen(type=DataGenType.DEFAULT)
    public StringProperty tarjeta;
    protected Step step001;
    protected Step step002;
    protected Step step003;
    protected Tab tab001;
    protected Tab tab002;
    protected Tab tab003;
    protected View v1;
    protected Segment clientesAAA;
    protected Segment misClientes;
    protected Segment pagoConEfectivo;
    protected Segment pagoConCheque;
    protected Segment pagoConTarjeta;
    protected Check check101;
    protected Check check103;
    protected Check check111;
    protected Check check113;
    protected Check check121;
    protected Check check123;
    protected AprobarCredito aprobarCredito;
    protected AdjuntarDocumento adjuntarDocumento;
    protected CargarImagen cargarImagen;

    public Cliente(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    protected void addAllocationStrings() {
        super.addAllocationStrings();
        this.addAllocationStrings(new String[]{"global.paisSede", "jurisdiccion.superior", "municipio.distrito.departamento", "distrito.departamento", "direccionPrincipal.cliente"});
    }

    protected void localizeAttributes() {
        super.localizeAttributes();
        this.setLocalizedLabel(ENGLISH, "customer");
        this.setLocalizedCollectionLabel(ENGLISH, "Customers");
    }

    protected void localizeProperties() {
        super.localizeProperties();
        this.tipo.setLocalizedLabel(ENGLISH, "customer type");
        this.tipo.setLocalizedLabel(SPANISH, "tipo de cliente");
        this.codigo.setLocalizedLabel(ENGLISH, "code");
        this.codigo.setLocalizedLabel(SPANISH, "c\u00f3digo");
        this.codigo.setLocalizedRegexErrorMessage(ENGLISH, "client code does not conform to the specified pattern; It must be a sequence of characters of up to 3 capital letters followed by a sequence of up to 7 digits; for example, N1005323");
        this.codigo.setLocalizedRegexErrorMessage(SPANISH, "c\u00f3digo de cliente no cumple con el patr\u00f3n especificado;  debe ser una secuencia caracteres de hasta 3 letras may\u00fasculas seguida de una secuencia de hasta 7 digitos; por ejemplo, N1005323");
        this.nombre.setLocalizedLabel(ENGLISH, "customer name");
        this.nombre.setLocalizedShortLabel(ENGLISH, "name");
        this.imagen.setLocalizedLabel(ENGLISH, "image");
        this.imagen.setLocalizedTooltip(ENGLISH, "client's photo or logo");
        this.imagen.setLocalizedTooltip(SPANISH, "foto o logo del cliente");
        this.archivoImagen.setLocalizedLabel(ENGLISH, "image file");
        this.archivoImagen.setLocalizedLabel(SPANISH, "archivo imagen");
        this.archivoImagen.setLocalizedTooltip(ENGLISH, "URL of the file that contains the image (photo or logo) of the client");
        this.archivoImagen.setLocalizedTooltip(SPANISH, "URL del archivo que contiene la imagen (foto o logo) del cliente");
        this.actividadEconomica.setLocalizedLabel(ENGLISH, "economic activity");
        this.actividadEconomica.setLocalizedLabel(SPANISH, "actividad econ\u00f3mica");
        this.fechaInicioRelacion.setLocalizedLabel(ENGLISH, "relationship start date");
        this.fechaInicioRelacion.setLocalizedLabel(SPANISH, "fecha de inicio de la relaci\u00f3n");
        this.fechaInicioRelacion.setLocalizedShortLabel(ENGLISH, "start");
        this.fechaInicioRelacion.setLocalizedShortLabel(SPANISH, "inicio");
        this.ejecutivo.setLocalizedLabel(ENGLISH, "client executive");
        this.ejecutivo.setLocalizedShortLabel(ENGLISH, "executive");
        this.global.setLocalizedLabel(ENGLISH, "global setting");
        this.global.setLocalizedLabel(SPANISH, "configuraci\u00f3n global");
        this.global.setLocalizedShortLabel(ENGLISH, "setting");
        this.global.setLocalizedShortLabel(SPANISH, "configuraci\u00f3n");
        this.pais.setLocalizedLabel(ENGLISH, "country");
        this.pais.setLocalizedLabel(SPANISH, "pa\u00eds");
        this.jurisdiccion.setLocalizedLabel(ENGLISH, "jurisdiction");
        this.jurisdiccion.setLocalizedLabel(SPANISH, "jurisdicci\u00f3n");
        this.departamento.setLocalizedLabel(ENGLISH, "department");
        this.distrito.setLocalizedLabel(ENGLISH, "district");
        this.municipio.setLocalizedLabel(ENGLISH, "municipality");
        this.telefonoFijo.setLocalizedLabel(ENGLISH, "landline");
        this.telefonoFijo.setLocalizedLabel(SPANISH, "tel\u00e9fono fijo");
        this.telefonoMovil.setLocalizedLabel(ENGLISH, "mobile phone");
        this.telefonoMovil.setLocalizedLabel(SPANISH, "tel\u00e9fono m\u00f3vil");
        this.telefonoInteligente.setLocalizedLabel(ENGLISH, "WhatsApp phone number");
        this.telefonoInteligente.setLocalizedLabel(SPANISH, "n\u00famero de tel\u00e9fono WhatsApp");
        this.telefonoInteligente.setLocalizedDescription(ENGLISH, "mobile phone number capable of running WhatsApp; this is an international phone number; it must start with a country code, followed by a global subscriber number or an area code and a subscriber number; for example: +58 4121234567, +58-412-1234567");
        this.telefonoInteligente.setLocalizedDescription(SPANISH, "n\u00famero de tel\u00e9fono m\u00f3vil capaz de ejecutar WhatsApp; este es un n\u00famero de tel\u00e9fono internacional; debe comenzar con un c\u00f3digo de pa\u00eds, seguido de un n\u00famero de suscriptor global o un c\u00f3digo de \u00e1rea y un n\u00famero de suscriptor; por ejemplo: +58 4121234567, +58-412-1234567");
        this.telefonoInteligente.setLocalizedShortDescription(ENGLISH, "mobile phone number capable of running WhatsApp; this is an international phone number; it must start with a country code, followed by a global subscriber number or an area code and a subscriber number; for example: +58 4121234567, +58-412-1234567");
        this.telefonoInteligente.setLocalizedShortDescription(SPANISH, "n\u00famero de tel\u00e9fono m\u00f3vil capaz de ejecutar WhatsApp; este es un n\u00famero de tel\u00e9fono internacional; debe comenzar con un c\u00f3digo de pa\u00eds, seguido de un n\u00famero de suscriptor global o un c\u00f3digo de \u00e1rea y un n\u00famero de suscriptor; por ejemplo: +58 4121234567, +58-412-1234567");
        this.correoElectronico.setLocalizedLabel(ENGLISH, "email");
        this.correoElectronico.setLocalizedLabel(SPANISH, "correo electr\u00f3nico");
        this.correoElectronico.setLocalizedRegexErrorMessage(ENGLISH, "email does not meet the required pattern");
        this.correoElectronico.setLocalizedRegexErrorMessage(SPANISH, "correo electr\u00f3nico no cumple con el patr\u00f3n requerido");
        this.paginaWeb.setLocalizedLabel(ENGLISH, "Web page");
        this.paginaWeb.setLocalizedLabel(SPANISH, "p\u00e1gina web");
        this.direccionPrincipal.setLocalizedLabel(ENGLISH, "Main address");
        this.analizado.setLocalizedLabel(ENGLISH, "analyzed");
        this.analizado.setLocalizedTooltip(ENGLISH, "the client's credit analysis has already been carried out");
        this.analizado.setLocalizedTooltip(SPANISH, "el an\u00e1lisis de cr\u00e9dito del cliente ya se llev\u00f3 a cabo");
        this.aprobado.setLocalizedLabel(ENGLISH, "approved");
        this.aprobado.setLocalizedTooltip(ENGLISH, "the customer's credit limit has been approved");
        this.aprobado.setLocalizedTooltip(SPANISH, "el l\u00edmite de cr\u00e9dito del cliente ha sido aprobado");
        this.auditado.setLocalizedLabel(ENGLISH, "audited");
        this.auditado.setLocalizedTooltip(ENGLISH, "the analysis and/or approval of the client's credit limit has been audited");
        this.auditado.setLocalizedTooltip(SPANISH, "el an\u00e1lisis y/o la aprobaci\u00f3n del l\u00edmite de cr\u00e9dito del cliente han sido auditados");
        this.ingresoPromedio.setLocalizedLabel(ENGLISH, "average income");
        this.ingresoPromedio.setLocalizedLabel(SPANISH, "ingreso promedio");
        this.limiteCredito.setLocalizedLabel(ENGLISH, "credit limit");
        this.limiteCredito.setLocalizedLabel(SPANISH, "l\u00edmite de cr\u00e9dito");
        this.formaPago.setLocalizedLabel(ENGLISH, "payment method");
        this.formaPago.setLocalizedLabel(SPANISH, "forma de pago");
        this.formaPago.setLocalizedAnchoredLabel(ENGLISH, "method");
        this.formaPago.setLocalizedAnchoredLabel(SPANISH, "medio de pago");
        this.banco.setLocalizedLabel(ENGLISH, "bank");
        this.banco.setLocalizedAnchoredLabel(ENGLISH, "bank");
        this.banco.setLocalizedDescription(ENGLISH, "bank to which the account or card corresponds; it is only necessary if the payment method is Check or Card");
        this.banco.setLocalizedDescription(SPANISH, "banco al que corresponde la cuenta o la tarjeta; solo es necesario si la forma de pago es Cheque o Tarjeta");
        this.tarjeta.setLocalizedLabel(ENGLISH, "card number");
        this.tarjeta.setLocalizedAnchoredLabel(ENGLISH, "card");
        this.tarjeta.setLocalizedDescription(ENGLISH, "credit or debit card number used for payment; it is only necessary if the payment method is Card");
        this.tarjeta.setLocalizedDescription(SPANISH, "n\u00famero de tarjeta de cr\u00e9dito o d\u00e9bito utilizada para el pago; solo es necesaria si la forma de pago es Tarjeta");
    }

    protected void localizeSteps() {
        super.localizeSteps();
        this.step001.setLocalizedLabel(ENGLISH, "Basic customer information");
        this.step001.setLocalizedLabel(SPANISH, "Datos b\u00e1sicos del cliente");
        this.step001.setLocalizedShortLabel(ENGLISH, "customer");
        this.step001.setLocalizedShortLabel(SPANISH, "cliente");
        this.step002.setLocalizedLabel(ENGLISH, "Contact information");
        this.step002.setLocalizedLabel(SPANISH, "Informaci\u00f3n de contacto");
        this.step002.setLocalizedShortLabel(ENGLISH, "contact");
        this.step002.setLocalizedShortLabel(SPANISH, "contacto");
        this.step003.setLocalizedLabel(ENGLISH, "Credit information and payment method");
        this.step003.setLocalizedLabel(SPANISH, "Informaci\u00f3n de cr\u00e9dito y forma de pago");
        this.step003.setLocalizedShortLabel(ENGLISH, "credit and payment method");
        this.step003.setLocalizedShortLabel(SPANISH, "cr\u00e9dito y forma de pago");
    }

    protected void localizeTabs() {
        super.localizeTabs();
        this.tab001.setLocalizedLabel(ENGLISH, "Basic customer information");
        this.tab001.setLocalizedLabel(SPANISH, "Datos b\u00e1sicos del cliente");
        this.tab001.setLocalizedShortLabel(ENGLISH, "customer");
        this.tab001.setLocalizedShortLabel(SPANISH, "cliente");
        this.tab002.setLocalizedLabel(ENGLISH, "Contact information");
        this.tab002.setLocalizedLabel(SPANISH, "Informaci\u00f3n de contacto");
        this.tab002.setLocalizedShortLabel(ENGLISH, "contact");
        this.tab002.setLocalizedShortLabel(SPANISH, "contacto");
        this.tab003.setLocalizedLabel(ENGLISH, "Credit information and payment method");
        this.tab003.setLocalizedLabel(SPANISH, "Informaci\u00f3n de cr\u00e9dito y forma de pago");
        this.tab003.setLocalizedShortLabel(ENGLISH, "credit and payment method");
        this.tab003.setLocalizedShortLabel(SPANISH, "cr\u00e9dito y forma de pago");
    }

    protected void localizeViews() {
        ViewField vf0014;
        ViewField vf0013;
        ViewField vf0012;
        ViewField vf0011;
        ViewField vf0010;
        ViewField vf0009;
        ViewField vf0008;
        ViewField vf0007;
        ViewField vf0006;
        ViewField vf0005;
        ViewField vf0004;
        ViewField vf0003;
        ViewField vf0002;
        super.localizeViews();
        this.v1.setLocalizedLabel(ENGLISH, "Clients by Jurisdiction, Economic Activity and Client Type");
        this.v1.setLocalizedLabel(SPANISH, "Clientes por Jurisdicci\u00f3n, Actividad Econ\u00f3mica y Tipo de Cliente");
        ViewField vf0001 = this.v1.getField((Property)this.jurisdiccion.codigo);
        if (vf0001 != null) {
            vf0001.setLocalizedLabel(ENGLISH, "jurisdiction");
            vf0001.setLocalizedLabel(SPANISH, "jurisdicci\u00f3n");
        }
        if ((vf0002 = this.v1.getField((Property)this.jurisdiccion.nombre)) != null) {
            vf0002.setLocalizedLabel(ENGLISH, "name");
        }
        if ((vf0003 = this.v1.getField((Property)this.jurisdiccion.superior.codigo)) != null) {
            vf0003.setLocalizedLabel(ENGLISH, "higher jurisdiction");
            vf0003.setLocalizedLabel(SPANISH, "jurisdicci\u00f3n superior");
        }
        if ((vf0004 = this.v1.getField((Property)this.jurisdiccion.superior.nombre)) != null) {
            vf0004.setLocalizedLabel(ENGLISH, "top jurisdiction name");
            vf0004.setLocalizedLabel(SPANISH, "nombre de jurisdicci\u00f3n superior");
        }
        if ((vf0005 = this.v1.getField((Property)this.actividadEconomica.codigo)) != null) {
            vf0005.setLocalizedLabel(ENGLISH, "economic activity");
            vf0005.setLocalizedLabel(SPANISH, "actividad econ\u00f3mica");
        }
        if ((vf0006 = this.v1.getField((Property)this.actividadEconomica.nombre)) != null) {
            vf0006.setLocalizedLabel(ENGLISH, "name");
        }
        if ((vf0007 = this.v1.getField((Property)this.tipo.codigo)) != null) {
            vf0007.setLocalizedLabel(ENGLISH, "customer type");
            vf0007.setLocalizedLabel(SPANISH, "tipo de cliente");
        }
        if ((vf0008 = this.v1.getField((Property)this.codigo)) != null) {
            vf0008.setLocalizedLabel(ENGLISH, "code");
        }
        if ((vf0009 = this.v1.getField((Property)this.nombre)) != null) {
            vf0009.setLocalizedLabel(ENGLISH, "name");
        }
        if ((vf0010 = this.v1.getField((Property)this.fechaInicioRelacion)) != null) {
            vf0010.setLocalizedLabel(ENGLISH, "beginning of the relationship");
            vf0010.setLocalizedLabel(SPANISH, "inicio de la relaci\u00f3n");
            vf0010.setLocalizedShortLabel(ENGLISH, "client since");
            vf0010.setLocalizedShortLabel(SPANISH, "cliente desde");
        }
        if ((vf0011 = this.v1.getField((Property)this.analizado)) != null) {
            vf0011.setLocalizedLabel(ENGLISH, "analyzed");
        }
        if ((vf0012 = this.v1.getField((Property)this.aprobado)) != null) {
            vf0012.setLocalizedLabel(ENGLISH, "approved");
        }
        if ((vf0013 = this.v1.getField((Property)this.auditado)) != null) {
            vf0013.setLocalizedLabel(ENGLISH, "audited");
        }
        if ((vf0014 = this.v1.getField((Property)this.limiteCredito)) != null) {
            vf0014.setLocalizedLabel(ENGLISH, "credit limit");
        }
    }

    protected void localizeExpressions() {
        super.localizeExpressions();
        this.clientesAAA.setLocalizedCollectionLabel(ENGLISH, "all clients with credit analyzed, approved and audited");
        this.clientesAAA.setLocalizedCollectionLabel(SPANISH, "todos los clientes con cr\u00e9dito analizado, aprobado y auditado");
        this.clientesAAA.setLocalizedCollectionShortLabel(ENGLISH, "AAA clients");
        this.clientesAAA.setLocalizedCollectionShortLabel(SPANISH, "Clientes AAA");
        this.clientesAAA.setLocalizedDescription(ENGLISH, "the client's credit is analyzed, approved and audited");
        this.clientesAAA.setLocalizedDescription(SPANISH, "el cr\u00e9dito del cliente est\u00e1 analizado, aprobado y auditado");
        this.clientesAAA.setLocalizedErrorMessage(ENGLISH, "the client's credit is not analyzed, approved and audited");
        this.clientesAAA.setLocalizedErrorMessage(SPANISH, "el cr\u00e9dito del cliente no est\u00e1 analizado, aprobado y auditado");
        this.misClientes.setLocalizedCollectionLabel(ENGLISH, "all clients whose executive is the current user");
        this.misClientes.setLocalizedCollectionLabel(SPANISH, "todos los clientes cuyo ejecutivo es el usuario actual");
        this.misClientes.setLocalizedCollectionShortLabel(ENGLISH, "My clients");
        this.misClientes.setLocalizedCollectionShortLabel(SPANISH, "Mis clientes");
        this.misClientes.setLocalizedDescription(ENGLISH, "the current user is the client's executive");
        this.misClientes.setLocalizedDescription(SPANISH, "el usuario actual es el ejecutivo del cliente");
        this.misClientes.setLocalizedErrorMessage(ENGLISH, "the current user is not the client's executive");
        this.misClientes.setLocalizedErrorMessage(SPANISH, "el usuario actual no es el ejecutivo del cliente");
        this.pagoConEfectivo.setLocalizedDescription(ENGLISH, "the payment method is cash");
        this.pagoConEfectivo.setLocalizedDescription(SPANISH, "la forma de pago es efectivo");
        this.pagoConEfectivo.setLocalizedErrorMessage(ENGLISH, "the payment method is not cash");
        this.pagoConEfectivo.setLocalizedErrorMessage(SPANISH, "la forma de pago no es efectivo");
        this.pagoConCheque.setLocalizedDescription(ENGLISH, "the payment method is check");
        this.pagoConCheque.setLocalizedDescription(SPANISH, "la forma de pago es cheque");
        this.pagoConCheque.setLocalizedErrorMessage(ENGLISH, "the payment method is not check");
        this.pagoConCheque.setLocalizedErrorMessage(SPANISH, "la forma de pago no es cheque");
        this.pagoConTarjeta.setLocalizedDescription(ENGLISH, "the payment method is card");
        this.pagoConTarjeta.setLocalizedDescription(SPANISH, "la forma de pago es tarjeta");
        this.pagoConTarjeta.setLocalizedErrorMessage(ENGLISH, "the payment method is not card");
        this.pagoConTarjeta.setLocalizedErrorMessage(SPANISH, "la forma de pago no es tarjeta");
        this.check101.setLocalizedErrorMessage(ENGLISH, "If the payment is in cash then the bank cannot be specified");
        this.check101.setLocalizedErrorMessage(SPANISH, "si el pago es en efectivo entonces no se puede especificar el banco");
        this.check103.setLocalizedErrorMessage(ENGLISH, "If the payment is in cash then the card cannot be specified");
        this.check103.setLocalizedErrorMessage(SPANISH, "si el pago es en efectivo entonces no se puede especificar la tarjeta");
        this.check111.setLocalizedErrorMessage(ENGLISH, "If payment is by check then the bank must be specified");
        this.check111.setLocalizedErrorMessage(SPANISH, "si el pago es con cheque entonces se tiene que especificar el banco");
        this.check113.setLocalizedErrorMessage(ENGLISH, "If payment is by check then the card cannot be specified");
        this.check113.setLocalizedErrorMessage(SPANISH, "si el pago es con cheque entonces no se puede especificar la tarjeta");
        this.check121.setLocalizedErrorMessage(ENGLISH, "If the payment is by card then the bank must be specified");
        this.check121.setLocalizedErrorMessage(SPANISH, "si el pago es con tarjeta entonces se tiene que especificar el banco");
        this.check123.setLocalizedErrorMessage(ENGLISH, "If the payment is by card then the card must be specified");
        this.check123.setLocalizedErrorMessage(SPANISH, "si el pago es con tarjeta entonces se tiene que especificar la tarjeta");
    }

    protected void settleAttributes() {
        super.settleAttributes();
    }

    protected void settleProperties() {
        super.settleProperties();
        this.codigo.setDefaultLabel("c\u00f3digo");
        this.codigo.setDefaultRegexErrorMessage("c\u00f3digo de cliente no cumple con el patr\u00f3n especificado;  debe ser una secuencia caracteres de hasta 3 letras may\u00fasculas seguida de una secuencia de hasta 7 digitos; por ejemplo, N1005323");
        this.imagen.setDefaultLabel("imagen");
        this.imagen.setDefaultTooltip("foto o logo del cliente");
        this.imagen.setAvatarDefault(AvatarDefault.UNSEEN);
        this.archivoImagen.setDefaultLabel("archivo imagen");
        this.archivoImagen.setDefaultTooltip("URL del archivo que contiene la imagen (foto o logo) del cliente");
        this.archivoImagen.setCalculableValueExpression(this.imagen.fileReferenceCalculableValueExpression());
        this.fechaInicioRelacion.setDefaultLabel("fecha de inicio de la relaci\u00f3n");
        this.fechaInicioRelacion.setDefaultShortLabel("inicio");
        this.global.setInitialValue(this.global.GLOBAL);
        this.global.setCalculableValueExpression((EntityExpression)this.global.GLOBAL.toEntityExpression());
        this.pais.setInitialValue((Entity)this.global.paisSede);
        this.pais.setDefaultValue((Entity)this.global.paisSede);
        this.distrito.setMasterDependentProperties(new Property[]{this.departamento});
        this.telefonoFijo.setDefaultLabel("tel\u00e9fono fijo");
        this.telefonoMovil.setDefaultLabel("tel\u00e9fono m\u00f3vil");
        this.telefonoInteligente.setDefaultLabel("n\u00famero de tel\u00e9fono inteligente");
        this.correoElectronico.setDefaultLabel("correo electr\u00f3nico");
        this.correoElectronico.setDefaultRegexErrorMessage("correo electr\u00f3nico no cumple con el patr\u00f3n requerido");
        this.paginaWeb.setDefaultLabel("p\u00e1gina web");
        this.analizado.setDefaultLabel("analizado");
        this.aprobado.setDefaultLabel("aprobado");
        this.auditado.setDefaultLabel("auditado");
        this.analizado.setDefaultTooltip("el an\u00e1lisis de cr\u00e9dito del cliente ya se llev\u00f3 a cabo");
        this.aprobado.setDefaultTooltip("el l\u00edmite de cr\u00e9dito del cliente ha sido aprobado");
        this.auditado.setDefaultTooltip("el an\u00e1lisis y/o la aprobaci\u00f3n del l\u00edmite de cr\u00e9dito del cliente han sido auditados");
        this.ingresoPromedio.setDefaultLabel("ingreso promedio");
        this.ingresoPromedio.setMaxValue(10000000);
        this.limiteCredito.setDefaultLabel("l\u00edmite de cr\u00e9dito");
        this.limiteCredito.setMaxValue(50000);
        String imagenLimiteCredito1 = this.fa(" fa fa-question-circle-o  fa-lg ");
        String imagenLimiteCredito2 = this.fa(" w3-text-indigo  fa fa-check-circle  fa-lg ");
        String imagenLimiteCredito3 = this.fa(" w3-text-blue  fa fa-check-circle  fa-lg ");
        String imagenLimiteCredito4 = this.fa(" w3-text-teal  fa fa-check-circle  fa-lg ");
        String imagenLimiteCredito5 = this.fa(" w3-text-green  fa fa-check-circle  fa-lg ");
        String imagenLimiteCredito6 = this.fa(" w3-text-deep-orange  fa fa-exclamation-circle  fa-lg ");
        String imagenLimiteCredito7 = this.fa(" w3-text-pink  fa fa-exclamation-circle  fa-lg ");
        CharacterOtherwiseX imagenLimiteCreditoX = this.limiteCredito.isNull().then(imagenLimiteCredito1).otherwise((Expression)this.limiteCredito.isLessThan(500).then(imagenLimiteCredito2).otherwise((Expression)this.limiteCredito.isLessThan(1000).then(imagenLimiteCredito3).otherwise((Expression)this.limiteCredito.isLessThan(2000).then(imagenLimiteCredito4).otherwise((Expression)this.limiteCredito.isLessThan(5000).then(imagenLimiteCredito5).otherwise((Expression)this.limiteCredito.isLessThan(10000).then(imagenLimiteCredito6).otherwise(imagenLimiteCredito7))))));
        this.limiteCredito.setGraphicImageFontAwesomeClassNameExpression((CharacterExpression)imagenLimiteCreditoX);
        this.limiteCredito.setMissingValueGraphicImageName(this.fa(" fa fa-question-circle-o  fa-lg "));
        this.limiteCredito.setNullValueGraphicImageName(this.fa(" fa fa-question-circle-o  fa-lg "));
        this.limiteCredito.setUnnecessaryValueGraphicImageName(this.fa(" fa fa-times  fa-lg "));
        this.limiteCredito.setDefaultGraphicImageTooltip(imagenLimiteCredito1, "valor no especificado");
        this.limiteCredito.setDefaultGraphicImageTooltip(imagenLimiteCredito2, "limite de cr\u00e9dito < 500");
        this.limiteCredito.setDefaultGraphicImageTooltip(imagenLimiteCredito3, "limite de cr\u00e9dito < 1.000");
        this.limiteCredito.setDefaultGraphicImageTooltip(imagenLimiteCredito4, "limite de cr\u00e9dito < 2.000");
        this.limiteCredito.setDefaultGraphicImageTooltip(imagenLimiteCredito5, "limite de cr\u00e9dito < 5.000");
        this.limiteCredito.setDefaultGraphicImageTooltip(imagenLimiteCredito6, "limite de cr\u00e9dito < 10.000");
        this.limiteCredito.setDefaultGraphicImageTooltip(imagenLimiteCredito7, "limite de cr\u00e9dito >= 10.000");
        this.limiteCredito.setLocalizedGraphicImageTooltip(ENGLISH, imagenLimiteCredito1, "unspecified value");
        this.limiteCredito.setLocalizedGraphicImageTooltip(ENGLISH, imagenLimiteCredito2, "credit limit < 500");
        this.limiteCredito.setLocalizedGraphicImageTooltip(ENGLISH, imagenLimiteCredito3, "credit limit < 1.000");
        this.limiteCredito.setLocalizedGraphicImageTooltip(ENGLISH, imagenLimiteCredito4, "credit limit < 2.000");
        this.limiteCredito.setLocalizedGraphicImageTooltip(ENGLISH, imagenLimiteCredito5, "credit limit < 5.000");
        this.limiteCredito.setLocalizedGraphicImageTooltip(ENGLISH, imagenLimiteCredito6, "credit limit < 10.000");
        this.limiteCredito.setLocalizedGraphicImageTooltip(ENGLISH, imagenLimiteCredito7, "credit limit >= 10.000");
        this.formaPago.setInitialValue(this.formaPago.EFECTIVO);
        this.formaPago.setDefaultValue(this.formaPago.EFECTIVO);
        this.formaPago.setDefaultAnchoredLabel("medio de pago");
        this.banco.setDefaultAnchoredLabel("banco");
        this.banco.setDefaultDescription("banco al que corresponde la cuenta o la tarjeta; solo es necesario si la forma de pago es Cheque o Tarjeta");
        this.tarjeta.setDefaultAnchoredLabel("tarjeta");
        this.tarjeta.setDefaultDescription("n\u00famero de tarjeta de cr\u00e9dito o d\u00e9bito utilizada para el pago; solo es necesaria si la forma de pago es Tarjeta");
    }

    protected void settleCollections() {
        super.settleCollections();
    }

    protected void settleLinks() {
        super.settleLinks();
        this.departamento.linkCalculableValueEntityReference((Entity)this.municipio.distrito.departamento);
        this.distrito.linkCalculableValueEntityReference((Entity)this.municipio.distrito);
        this.linkForeignQueryProperty((Property)this.municipio.distrito.codigo);
        this.linkForeignQueryProperty((Property)this.municipio.distrito.nombre);
        this.linkForeignQueryProperty((Property)this.municipio.distrito.departamento.codigo);
        this.linkForeignQueryProperty((Property)this.municipio.distrito.departamento.nombre);
    }

    protected void settleSteps() {
        super.settleSteps();
        this.step001.setDefaultLabel("Datos b\u00e1sicos del cliente");
        this.step001.setDefaultShortLabel("cliente");
        this.step001.newStepField(new Property[]{this.codigo, this.nombre, this.imagen, this.archivoImagen, this.fechaInicioRelacion, this.actividadEconomica});
        this.step002.setDefaultLabel("Informaci\u00f3n de contacto");
        this.step002.setDefaultShortLabel("contacto");
        this.step002.newStepField((Property)this.pais);
        this.step002.newStepField((Property)this.jurisdiccion);
        this.step002.newStepField((Property)this.departamento);
        this.step002.newStepField((Property)this.distrito);
        this.step002.newStepField((Property)this.municipio);
        this.step002.newStepField((Property)this.telefonoFijo);
        this.step002.newStepField((Property)this.telefonoMovil);
        this.step002.newStepField((Property)this.telefonoInteligente);
        this.step002.newStepField((Property)this.correoElectronico);
        this.step002.newStepField((Property)this.paginaWeb);
        this.step002.newStepField((Property)this.direccionPrincipal);
        this.step003.setDefaultLabel("Informaci\u00f3n de cr\u00e9dito y forma de pago");
        this.step003.setDefaultShortLabel("cr\u00e9dito y forma de pago");
        this.step003.newStepField(new Property[]{this.analizado, this.aprobado, this.auditado, this.ingresoPromedio, this.limiteCredito});
        this.step003.newStepField(new Property[]{this.formaPago, this.banco, this.tarjeta});
    }

    protected void settleTabs() {
        super.settleTabs();
        this.tab001.copy(this.step001, false);
        this.tab001.newTabField(new Property[]{this.imagen, this.archivoImagen, this.fechaInicioRelacion, this.actividadEconomica});
        this.tab002.copy(this.step002);
        this.tab003.copy(this.step003);
    }

    protected void settleViews() {
        super.settleViews();
        this.v1.setDefaultLabel("Clientes por Jurisdicci\u00f3n, Actividad Econ\u00f3mica y Tipo de Cliente");
        ViewField vf = this.v1.newControlField((Property)this.jurisdiccion.codigo);
        vf.setDefaultLabel("jurisdicci\u00f3n");
        this.v1.newHeadingField((Property)this.jurisdiccion.nombre, (Property)this.jurisdiccion.codigo);
        vf = this.v1.newHeadingField((Property)this.jurisdiccion.superior.codigo, (Property)this.jurisdiccion.codigo);
        vf.setDefaultLabel("jurisdicci\u00f3n superior");
        vf = this.v1.newHeadingField((Property)this.jurisdiccion.superior.nombre, (Property)this.jurisdiccion.codigo);
        vf.setDefaultLabel("nombre de jurisdicci\u00f3n superior");
        vf = this.v1.newControlField((Property)this.actividadEconomica.codigo);
        vf.setDefaultLabel("actividad econ\u00f3mica");
        this.v1.newHeadingField((Property)this.actividadEconomica.nombre, (Property)this.actividadEconomica.codigo);
        vf = this.v1.newControlField((Property)this.tipo.codigo);
        vf.setDefaultLabel("tipo de cliente");
        this.v1.newDetailField((Property)this.codigo);
        this.v1.newDetailField((Property)this.nombre, SortOption.ASC);
        vf = this.v1.newDetailField((Property)this.fechaInicioRelacion);
        vf.setDefaultLabel("inicio de la relaci\u00f3n");
        vf.setDefaultShortLabel("cliente desde");
        vf.setPixels(Integer.valueOf(96));
        vf = this.v1.newDetailField((Property)this.analizado);
        vf.setPixels(Integer.valueOf(64));
        vf = this.v1.newDetailField((Property)this.aprobado);
        vf.setPixels(Integer.valueOf(64));
        vf = this.v1.newDetailField((Property)this.auditado);
        vf.setPixels(Integer.valueOf(64));
        this.v1.newDetailField((Property)this.limiteCredito, ViewFieldAggregation.AVERAGE_DEVIATION_MINIMUM_MAXIMUM);
    }

    protected void settleExpressions() {
        super.settleExpressions();
        this.clientesAAA = Cliente.and((BooleanExpression)this.analizado, (BooleanExpression)this.aprobado, (BooleanExpression[])new BooleanExpression[]{this.auditado});
        this.clientesAAA.setDefaultCollectionLabel("todos los clientes con cr\u00e9dito analizado, aprobado y auditado");
        this.clientesAAA.setDefaultCollectionShortLabel("Clientes AAA");
        this.clientesAAA.setDefaultDescription("el cr\u00e9dito del cliente est\u00e1 analizado, aprobado y auditado");
        this.clientesAAA.setDefaultErrorMessage("el cr\u00e9dito del cliente no est\u00e1 analizado, aprobado y auditado");
        this.misClientes = this.ejecutivo.id.isEqualTo((NumericExpression)CURRENT_USER_ID);
        this.misClientes.setDefaultCollectionLabel("todos los clientes cuyo ejecutivo es el usuario actual");
        this.misClientes.setDefaultCollectionShortLabel("Mis clientes");
        this.misClientes.setDefaultDescription("el usuario actual es el ejecutivo del cliente");
        this.misClientes.setDefaultErrorMessage("el usuario actual no es el ejecutivo del cliente");
        this.pagoConEfectivo = this.formaPago.isEqualTo(this.formaPago.EFECTIVO);
        this.pagoConEfectivo.setDefaultDescription("la forma de pago es efectivo");
        this.pagoConEfectivo.setDefaultErrorMessage("la forma de pago no es efectivo");
        this.pagoConCheque = this.formaPago.isEqualTo(this.formaPago.CHEQUE);
        this.pagoConCheque.setDefaultDescription("la forma de pago es cheque");
        this.pagoConCheque.setDefaultErrorMessage("la forma de pago no es cheque");
        this.pagoConTarjeta = this.formaPago.isEqualTo(this.formaPago.TARJETA);
        this.pagoConTarjeta.setDefaultDescription("la forma de pago es tarjeta");
        this.pagoConTarjeta.setDefaultErrorMessage("la forma de pago no es tarjeta");
        this.check101 = this.pagoConEfectivo.implies((BooleanExpression)this.banco.isNull());
        this.check101.setDefaultErrorMessage("si el pago es en efectivo entonces no se puede especificar el banco");
        this.check103 = this.pagoConEfectivo.implies((BooleanExpression)this.tarjeta.isNull());
        this.check103.setDefaultErrorMessage("si el pago es en efectivo entonces no se puede especificar la tarjeta");
        this.check111 = this.pagoConCheque.implies((BooleanExpression)this.banco.isNotNull());
        this.check111.setDefaultErrorMessage("si el pago es con cheque entonces se tiene que especificar el banco");
        this.check113 = this.pagoConCheque.implies((BooleanExpression)this.tarjeta.isNull());
        this.check113.setDefaultErrorMessage("si el pago es con cheque entonces no se puede especificar la tarjeta");
        this.check121 = this.pagoConTarjeta.implies((BooleanExpression)this.banco.isNotNull());
        this.check121.setDefaultErrorMessage("si el pago es con tarjeta entonces se tiene que especificar el banco");
        this.check123 = this.pagoConTarjeta.implies((BooleanExpression)this.tarjeta.isNotNull());
        this.check123.setDefaultErrorMessage("si el pago es con tarjeta entonces se tiene que especificar la tarjeta");
    }

    protected void settleFilters() {
        super.settleFilters();
        this.addSelectSegment(new Segment[]{this.clientesAAA, this.misClientes});
        this.limiteCredito.setRequiringFilter((BooleanExpression)this.aprobado);
        this.direccionPrincipal.setSearchQueryFilter((BooleanExpression)this.direccionPrincipal.cliente.isEqualTo((Entity)this));
        this.jurisdiccion.setModifyingFilter((BooleanExpression)this.pais.sede);
        this.jurisdiccion.setNullifyingFilter((BooleanExpression)Cliente.not((BooleanExpression)this.pais.sede));
        this.jurisdiccion.setRenderingFilter((BooleanExpression)this.pais.sede, true);
        this.departamento.setModifyingFilter((BooleanExpression)this.pais.sede);
        this.departamento.setNullifyingFilter((BooleanExpression)Cliente.not((BooleanExpression)this.pais.sede));
        this.departamento.setRenderingFilter((BooleanExpression)this.pais.sede, true);
        this.distrito.setModifyingFilter((BooleanExpression)this.pais.sede);
        this.distrito.setNullifyingFilter((BooleanExpression)Cliente.not((BooleanExpression)this.pais.sede));
        this.distrito.setSearchQueryFilter((BooleanExpression)this.distrito.departamento.isEqualTo((Entity)this.departamento));
        this.distrito.setRenderingFilter((BooleanExpression)this.pais.sede, true);
        this.municipio.setModifyingFilter((BooleanExpression)this.pais.sede);
        this.municipio.setNullifyingFilter((BooleanExpression)Cliente.not((BooleanExpression)this.pais.sede));
        this.municipio.setSearchQueryFilter((BooleanExpression)this.municipio.distrito.isEqualTo((Entity)this.distrito));
        this.municipio.setRenderingFilter((BooleanExpression)this.pais.sede, true);
        this.banco.setModifyingFilter((BooleanExpression)this.pagoConCheque.or((BooleanExpression)this.pagoConTarjeta));
        this.banco.setRenderingFilter((BooleanExpression)this.pagoConCheque.or((BooleanExpression)this.pagoConTarjeta), true);
        this.banco.setRequiringFilter((BooleanExpression)this.pagoConCheque.or((BooleanExpression)this.pagoConTarjeta));
        this.banco.setNullifyingFilter((BooleanExpression)this.pagoConEfectivo);
        this.tarjeta.setModifyingFilter((BooleanExpression)this.pagoConTarjeta);
        this.tarjeta.setRenderingFilter((BooleanExpression)this.pagoConTarjeta, true);
        this.tarjeta.setRequiringFilter((BooleanExpression)this.pagoConTarjeta);
        this.tarjeta.setNullifyingFilter((BooleanExpression)this.pagoConEfectivo.or((BooleanExpression)this.pagoConCheque));
    }
}

