/*
 * Decompiled with CFR 0.152.
 */
package showcase.meta.entidad.cliente;

import adalid.core.annotations.CharacterDataGen;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EmbeddedDocument;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityDataGen;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.enums.AnchorType;
import adalid.core.enums.DataGenType;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SearchType;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.Entity;
import adalid.core.properties.StringProperty;
import adalid.core.properties.ext.GoogleMapProperty;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;
import showcase.meta.entidad.cliente.Cliente;
import showcase.meta.entidad.configuracion.Ciudad;
import showcase.meta.entidad.configuracion.Departamento;

@EntityDataGen
@EntityClass(independent=Kleenean.FALSE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.FEMININE)
public class DireccionCliente
extends PersistentEntityBase {
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.TABLE_AND_DETAIL)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE, heading=Kleenean.TRUE)
    public Cliente cliente;
    @NameProperty
    public StringProperty direccion;
    @ColumnField(calculable=Kleenean.TRUE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.TRUE, anchor="direccion", anchorType=AnchorType.INLINE)
    @EntityReferenceSearch(searchType=SearchType.LIST)
    public Departamento departamento;
    @ColumnField
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.TRUE, anchor="departamento", anchorType=AnchorType.INLINE)
    @EntityReferenceSearch(searchType=SearchType.LIST)
    public Ciudad ciudad;
    @ColumnField
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.TRUE, anchor="departamento", anchorType=AnchorType.INLINE)
    @StringField(maxLength=10)
    public StringProperty codigoPostal;
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    @CharacterDataGen(type=DataGenType.RANDOM, pattern="000-0000, 000-0000")
    public StringProperty telefonos;
    @EmbeddedDocument
    @PropertyField(create=Kleenean.TRUE)
    public GoogleMapProperty mapa;

    public DireccionCliente(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    protected void addAllocationStrings() {
        super.addAllocationStrings();
        this.addAllocationStrings(new String[]{"ciudad.departamento"});
    }

    protected void settleAttributes() {
        super.settleAttributes();
        this.setDefaultLabel("direcci\u00f3n del cliente");
        this.setDefaultCollectionLabel("Direcciones del Cliente");
    }

    protected void settleProperties() {
        super.settleProperties();
        this.direccion.setDefaultLabel("direcci\u00f3n");
        this.direccion.setDefaultAnchorLabel("direcci\u00f3n");
        this.direccion.setDefaultAnchoredLabel("direcci\u00f3n");
        this.direccion.setDefaultDescription("calle o avenida, n\u00famero, apartamento o suite o unidad, edificio, piso, etc.");
        this.telefonos.setDefaultLabel("tel\u00e9fonos");
    }

    protected void settleLinks() {
        super.settleLinks();
        this.departamento.linkCalculableValueEntityReference((Entity)this.ciudad.departamento);
    }

    protected void settleFilters() {
        super.settleFilters();
        this.ciudad.setSearchQueryFilter((BooleanExpression)this.ciudad.departamento.isEqualTo((Entity)this.departamento));
    }
}

