/*
 * Decompiled with CFR 0.152.
 */
package showcase.meta.entidad.cliente;

import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DateField;
import adalid.core.annotations.DiscriminatorValue;
import adalid.core.annotations.EntityDataGen;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityReferenceDataGen;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.OneToOne;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.TemporalDataGen;
import adalid.core.enums.AvatarDefault;
import adalid.core.enums.DataGenType;
import adalid.core.enums.DisplayFormat;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.ViewMenuOption;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.TemporalExpression;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.DateProperty;
import adalid.core.properties.IntegerProperty;
import java.lang.reflect.Field;
import showcase.meta.entidad.cliente.Cliente;
import showcase.meta.entidad.cliente.PersonaJuridica;
import showcase.meta.entidad.configuracion.fija.EstadoCivil;
import showcase.meta.entidad.configuracion.fija.SexoPersona;

@DiscriminatorValue(value="1")
@EntityDataGen(start=1, step=1, stop=25)
@EntityDetailView(enabled=Kleenean.TRUE, menu=ViewMenuOption.WRITING, inserting=Kleenean.TRUE)
public class PersonaFisica
extends Cliente {
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.FALSE, report=Kleenean.TRUE)
    @TemporalDataGen(type=DataGenType.RANDOM, min="-60Y", max="-21Y")
    @DateField(yearRange=100)
    public DateProperty fechaNacimiento;
    @ColumnField(calculable=Kleenean.TRUE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public IntegerProperty edad;
    @ColumnField(calculable=Kleenean.TRUE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public BooleanProperty personaAdulta;
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.FALSE, report=Kleenean.TRUE)
    public SexoPersona sexo;
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.FALSE, report=Kleenean.TRUE)
    public EstadoCivil estadoCivil;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @OneToOne(navigability=Navigability.UNIDIRECTIONAL)
    @PropertyField(create=Kleenean.TRUE)
    @EntityReferenceDataGen(nullable=100)
    @EntityReferenceSearch(displayMode=DisplayMode.WRITING)
    public PersonaFisica conyuge;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE)
    @EntityReferenceSearch(displayMode=DisplayMode.WRITING)
    public PersonaJuridica empleador;
    protected Check check301;
    protected Check check302;
    protected Check check303;

    public PersonaFisica(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        this.addAllocationStrings(new String[]{"conyuge.sexo"});
    }

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        this.setLocalizedLabel(ENGLISH, "natural person");
        this.setLocalizedLabel(SPANISH, "persona f\u00edsica");
        this.setLocalizedCollectionLabel(ENGLISH, "Natural persons");
        this.setLocalizedCollectionLabel(SPANISH, "Personas F\u00edsicas");
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        this.fechaNacimiento.setLocalizedLabel(ENGLISH, "birth date");
        this.edad.setLocalizedLabel(ENGLISH, "age");
        this.personaAdulta.setLocalizedLabel(ENGLISH, "adult person");
        this.sexo.setLocalizedLabel(ENGLISH, "sex");
        this.estadoCivil.setLocalizedLabel(ENGLISH, "civil status");
        this.estadoCivil.setLocalizedLabel(SPANISH, "estado civil");
        this.conyuge.setLocalizedLabel(ENGLISH, "spouse");
        this.conyuge.setLocalizedLabel(SPANISH, "c\u00f3nyuge");
        this.empleador.setLocalizedLabel(ENGLISH, "employer");
    }

    @Override
    protected void localizeExpressions() {
        super.localizeExpressions();
        this.check301.setLocalizedErrorMessage(ENGLISH, "spouse cannot be specified if the person is single");
        this.check301.setLocalizedErrorMessage(SPANISH, "c\u00f3nyuge no se puede especificar si la persona est\u00e1 soltera");
        this.check302.setLocalizedErrorMessage(ENGLISH, "spouse has to be someone else");
        this.check302.setLocalizedErrorMessage(SPANISH, "c\u00f3nyuge tiene que ser otra persona");
        this.check303.setLocalizedErrorMessage(ENGLISH, "spouse must be a person of the opposite sex");
        this.check303.setLocalizedErrorMessage(SPANISH, "c\u00f3nyuge tiene que ser una persona del sexo opuesto");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setDefaultLabel("persona f\u00edsica");
        this.setDefaultCollectionLabel("Personas F\u00edsicas");
        this.setDefaultMenuOptionLabel(DisplayFormat.DETAIL, "Agregar Personas F\u00edsicas");
        this.setLocalizedMenuOptionLabel(ENGLISH, DisplayFormat.DETAIL, "Add Natural Persons");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.imagen.setAvatarDefault(AvatarDefault.PERSON);
        this.fechaNacimiento.setMinValue("1901-01-01");
        this.fechaNacimiento.setMaxValue((TemporalExpression)CURRENT_DATE);
        this.edad.setCalculableValueExpression((NumericExpression)CURRENT_DATE.diffInYears((TemporalExpression)this.fechaNacimiento));
        this.personaAdulta.setCalculableValueExpression((BooleanExpression)CURRENT_DATE.isGreaterOrEqualTo((TemporalExpression)this.fechaNacimiento.addYears((Number)21)));
        this.conyuge.setDefaultLabel("c\u00f3nyuge");
        this.empleador.setDefaultLabel("empleador");
    }

    @Override
    protected void settleLinks() {
        super.settleLinks();
        this.linkForeignQueryProperty(new Property[]{this.conyuge.fechaNacimiento, this.empleador.fechaRegistro});
    }

    @Override
    protected void settleSteps() {
        super.settleSteps();
        this.step001.newStepField(new Property[]{this.fechaNacimiento, this.edad, this.personaAdulta, this.sexo, this.estadoCivil, this.conyuge, this.empleador});
    }

    @Override
    protected void settleTabs() {
        super.settleTabs();
        this.tab001.newTabField(new Property[]{this.fechaNacimiento, this.edad, this.personaAdulta, this.sexo, this.estadoCivil, this.conyuge, this.empleador});
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.check301 = this.estadoCivil.isEqualTo(this.estadoCivil.SOLTERO).implies((BooleanExpression)this.conyuge.isNull());
        this.check301.setDefaultErrorMessage("c\u00f3nyuge no se puede especificar si la persona est\u00e1 soltera");
        this.check302 = this.conyuge.isNull().or((BooleanExpression)this.conyuge.isNotEqualTo((Entity)this));
        this.check302.setDefaultErrorMessage("c\u00f3nyuge tiene que ser otra persona");
        this.check303 = this.conyuge.isNull().or((BooleanExpression)this.conyuge.sexo.isNotEqualTo((Entity)this.sexo));
        this.check303.setDefaultErrorMessage("c\u00f3nyuge tiene que ser una persona del sexo opuesto");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.conyuge.setSearchQueryFilter((BooleanExpression)this.conyuge.isNotEqualTo((Entity)this).and((BooleanExpression)this.conyuge.sexo.isNotEqualTo((Entity)this.sexo)));
    }
}

