/*
 * Decompiled with CFR 0.152.
 */
package showcase.meta.entidad.cliente;

import adalid.core.annotations.DiscriminatorValue;
import adalid.core.annotations.EntityDataGen;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NumericDataGen;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.TemporalDataGen;
import adalid.core.enums.AvatarDefault;
import adalid.core.enums.DataGenType;
import adalid.core.enums.DisplayFormat;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.ViewMenuOption;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.TemporalExpression;
import adalid.core.properties.BigDecimalProperty;
import adalid.core.properties.DateProperty;
import java.lang.reflect.Field;
import showcase.meta.entidad.cliente.Cliente;
import showcase.meta.entidad.cliente.PersonaFisica;

@DiscriminatorValue(value="2")
@EntityDataGen(start=1, step=1, stop=25)
@EntityDetailView(enabled=Kleenean.TRUE, menu=ViewMenuOption.WRITING, inserting=Kleenean.TRUE)
public class PersonaJuridica
extends Cliente {
    @PropertyField(create=Kleenean.TRUE)
    @TemporalDataGen(type=DataGenType.RANDOM, min="-60Y", max="-21Y")
    public DateProperty fechaRegistro;
    @PropertyField(create=Kleenean.TRUE)
    @NumericDataGen(type=DataGenType.RANDOM, min="10000", max="1000000")
    public BigDecimalProperty capitalPagado;
    @PropertyField(create=Kleenean.TRUE)
    @NumericDataGen(type=DataGenType.RANDOM, min="10000", max="1000000")
    public BigDecimalProperty capitalSuscrito;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE)
    @EntityReferenceSearch(displayMode=DisplayMode.WRITING)
    public PersonaFisica contacto;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, report=Kleenean.TRUE)
    @EntityReferenceSearch(displayMode=DisplayMode.WRITING)
    public PersonaJuridica matriz;

    public PersonaJuridica(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        this.setLocalizedLabel(ENGLISH, "legal person");
        this.setLocalizedLabel(SPANISH, "persona jur\u00eddica");
        this.setLocalizedCollectionLabel(ENGLISH, "Legal persons");
        this.setLocalizedCollectionLabel(SPANISH, "Personas Jur\u00eddicas");
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        this.fechaRegistro.setLocalizedLabel(ENGLISH, "registration date");
        this.capitalPagado.setLocalizedLabel(ENGLISH, "paid-in capital");
        this.capitalSuscrito.setLocalizedLabel(ENGLISH, "subscribed capital");
        this.contacto.setLocalizedLabel(ENGLISH, "contact");
        this.matriz.setLocalizedLabel(ENGLISH, "matrix");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setDefaultLabel("persona jur\u00eddica");
        this.setDefaultCollectionLabel("Personas Jur\u00eddicas");
        this.setDefaultMenuOptionLabel(DisplayFormat.DETAIL, "Agregar Personas Jur\u00eddicas");
        this.setLocalizedMenuOptionLabel(ENGLISH, DisplayFormat.DETAIL, "Add Legal Persons");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.imagen.setAvatarDefault(AvatarDefault.COMPANY);
        this.fechaRegistro.setMinValue("1901-01-01");
        this.fechaRegistro.setMaxValue((TemporalExpression)CURRENT_DATE);
        this.contacto.setDefaultLabel("contacto");
        this.matriz.setDefaultLabel("matriz");
    }

    @Override
    protected void settleSteps() {
        super.settleSteps();
        this.step001.newStepField(new Property[]{this.fechaRegistro, this.capitalPagado, this.capitalSuscrito, this.contacto, this.matriz});
    }

    @Override
    protected void settleTabs() {
        super.settleTabs();
        this.tab001.newTabField(new Property[]{this.fechaRegistro, this.capitalPagado, this.capitalSuscrito, this.contacto, this.matriz});
    }
}

