/*
 * Decompiled with CFR 0.152.
 */
package showcase.meta.entidad.configuracion;

import adalid.core.EntityCollection;
import adalid.core.Step;
import adalid.core.Tab;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCollectionField;
import adalid.core.annotations.EntityDataGen;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.OneToMany;
import adalid.core.annotations.PropertyField;
import adalid.core.enums.CascadeType;
import adalid.core.enums.DataEntryFormat;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.ResourceType;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Property;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;
import showcase.meta.entidad.cliente.Cliente;
import showcase.meta.entidad.configuracion.Distrito;

@EntityClass(resourceType=ResourceType.CONFIGURATION, independent=Kleenean.FALSE)
@EntityDataGen(start=1, step=1, stop=100)
@EntityDetailView(readingViewBelowDetailSnippet="/entity/Municipio/belowDetailSnippet", writingViewBelowDetailSnippet="/entity/Municipio/belowDetailSnippet")
public class Municipio
extends PersistentEntityBase {
    @BusinessKey
    public StringProperty codigo;
    @NameProperty
    public StringProperty nombre;
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.TABLE_AND_DETAIL)
    @PropertyField(update=Kleenean.FALSE)
    public Distrito distrito;
    @OneToMany(targetEntity=Cliente.class, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH})
    @EntityCollectionField(format=DataEntryFormat.DETAIL_OR_TABLE, readingViewRowActionSnippet="/entity/Municipio/clientesRowActionSnippet", writingViewRowActionSnippet="/entity/Municipio/clientesRowActionSnippet")
    public EntityCollection clientes;
    protected Step step001;
    protected Step step002;
    protected Tab tab001;
    protected Tab tab002;

    public Municipio(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    protected void addAllocationStrings() {
        super.addAllocationStrings();
        this.addAllocationStrings(new String[]{"distrito.departamento.region"});
    }

    protected void settleCollections() {
        super.settleCollections();
        this.clientes.setDefaultLabel("clientes del municipio");
        this.clientes.setDefaultShortLabel("clientes");
        this.clientes.setDefaultDescription("colecci\u00f3n de clientes que habitan en el municipio");
    }

    protected void settleSteps() {
        super.settleSteps();
        this.step001.setDefaultLabel("Datos b\u00e1sicos");
        this.step001.setDefaultShortLabel("municipio");
        this.step001.newStepField(new Property[]{this.codigo, this.nombre, this.distrito});
        this.step002.setDefaultLabel("Clientes que habitan en el municipio");
        this.step002.setDefaultShortLabel("clientes");
        this.step002.newStepField(this.clientes);
    }

    protected void settleTabs() {
        super.settleTabs();
        this.tab001.copy(this.step001);
        this.tab002.copy(this.step002);
    }
}

