/*
 * Decompiled with CFR 0.152.
 */
package showcase.meta.entidad.cuenta;

import adalid.core.ProcessOperation;
import adalid.core.annotations.ConstructionOperationClass;
import adalid.core.annotations.DateField;
import adalid.core.annotations.DiscriminatorValue;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.ProcessOperationClass;
import adalid.core.annotations.StringField;
import adalid.core.enums.Kleenean;
import adalid.core.enums.LetterCase;
import adalid.core.enums.MimeType;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.enums.UploadStorageOption;
import adalid.core.enums.ViewMenuOption;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.State;
import adalid.core.interfaces.TemporalExpression;
import adalid.core.parameters.DateParameter;
import adalid.core.parameters.StringParameter;
import adalid.core.parameters.ext.EmailAddressParameter;
import java.lang.reflect.Field;
import showcase.meta.entidad.cuenta.SolicitudCuentaUsuario;

@DiscriminatorValue(value="2")
@EntityInsertOperation(enabled=Kleenean.FALSE)
@EntityTableView(inserts=Kleenean.FALSE, updates=Kleenean.FALSE, menu=ViewMenuOption.NONE)
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityConsoleView(enabled=Kleenean.TRUE, menu=Kleenean.FALSE)
public class SolicitudCambiarCorreoUsuario
extends SolicitudCuentaUsuario {
    protected Registrar registrar;
    protected Verificar verificar;
    protected Anular anular;
    protected Aprobar aprobar;
    protected Rechazar rechazar;

    public SolicitudCambiarCorreoUsuario(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
    }

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        this.setLocalizedLabel(ENGLISH, "email change request");
        this.setLocalizedLabel(SPANISH, "solicitud de cambio de correo electr\u00f3nico");
        this.setLocalizedShortLabel(SPANISH, "solicitud de cambio de correo");
        this.setLocalizedCollectionLabel(ENGLISH, "Email Change Requests");
        this.setLocalizedCollectionLabel(SPANISH, "Solicitudes de Cambio de Correo Electr\u00f3nico");
        this.setLocalizedCollectionShortLabel(SPANISH, "Solicitudes de Cambio de Correo");
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        this.usuario.setLocalizedDescription(ENGLISH, "application user to whom the email change request corresponds");
        this.usuario.setLocalizedDescription(SPANISH, "usuario de la aplicaci\u00f3n al que corresponde la solicitud de cambio de correo electr\u00f3nico");
        this.usuario.setLocalizedShortDescription(ENGLISH, "application user to whom the email change request corresponds");
        this.usuario.setLocalizedShortDescription(SPANISH, "usuario de la aplicaci\u00f3n al que corresponde la solicitud de cambio de correo electr\u00f3nico");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setDefaultLabel("solicitud de cambio de correo electr\u00f3nico");
        this.setDefaultShortLabel("solicitud de cambio de correo");
        this.setDefaultCollectionLabel("Solicitudes de Cambio de Correo Electr\u00f3nico");
        this.setDefaultCollectionShortLabel("Solicitudes de Cambio de Correo");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.usuario.setDefaultDescription("usuario de la aplicaci\u00f3n al que corresponde la solicitud de cambio de correo electr\u00f3nico");
        this.usuario.setDefaultShortDescription("usuario de la aplicaci\u00f3n al que corresponde la solicitud de cambio de correo electr\u00f3nico");
    }

    protected void settleOperations() {
        super.settleOperations();
        this.registrar.addTransition(null, this.registrada);
        this.verificar.addTransition(this.registrada, this.verificada);
        this.anular.addTransition(this.registrada, this.anulada);
        this.aprobar.addTransition(this.verificada, this.aprobada);
        this.rechazar.addTransition(this.verificada, this.rechazada);
        this.verificar.addTriggerOn(new State[]{this.registrada});
        this.aprobar.addTriggerOn(new State[]{this.verificada});
    }

    @OperationClass(access=OperationAccess.PUBLIC)
    @ProcessOperationClass(serviceable=Kleenean.FALSE)
    @ConstructionOperationClass(type=SolicitudCambiarCorreoUsuario.class)
    public class Registrar
    extends ProcessOperation {
        @ParameterField(required=Kleenean.TRUE, linkedField="cedula")
        @StringField(maxLength=10, regex="^[0-9]{1,9}[A-Za-z]?$", letterCase=LetterCase.UPPER)
        protected StringParameter cedula;
        @ParameterField(required=Kleenean.TRUE, linkedField="fechaNacimiento")
        @DateField(yearRange=100)
        protected DateParameter fechaNacimiento;
        @ParameterField(required=Kleenean.TRUE, linkedField="nombre")
        @StringField(maxLength=100, regex="^[\\p{IsLatin}][-' \\p{IsLatin}]*$", letterCase=LetterCase.UPPER)
        protected StringParameter nombre;
        @ParameterField(required=Kleenean.TRUE, linkedField="correoElectronico")
        protected EmailAddressParameter correoElectronico;
        @ParameterField(required=Kleenean.TRUE)
        protected EmailAddressParameter confirmacionCorreoElectronico;
        @ParameterField(required=Kleenean.TRUE, linkedField="archivoCedula")
        @FileReference(types={MimeType.IMAGE}, storage=UploadStorageOption.FILE, max=0x100000, virusScan=Kleenean.TRUE, pathTemplate="solicitud_cuenta_usuario.[cedula]")
        protected StringParameter archivoCedula;
        protected Check check100;
        protected Check check110;

        public Registrar(SolicitudCambiarCorreoUsuario this$0) {
        }

        protected void localizeAttributes() {
            super.localizeAttributes();
            this.setLocalizedLabel(ENGLISH, "request change of email");
            this.setLocalizedLabel(SPANISH, "solicitar cambio de correo");
        }

        protected void localizeParameters() {
            super.localizeParameters();
            this.cedula.setLocalizedLabel(ENGLISH, "identification card");
            this.cedula.setLocalizedLabel(SPANISH, "c\u00e9dula");
            this.cedula.setLocalizedRegexErrorMessage(ENGLISH, "ID card does not meet the specified pattern; must be a sequence of up to 9 digits, optionally ending with a letter; for example, 1234567, 1235813A");
            this.cedula.setLocalizedRegexErrorMessage(SPANISH, "c\u00e9dula de identidad no cumple con el patr\u00f3n especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            this.fechaNacimiento.setLocalizedLabel(ENGLISH, "birthdate");
            this.fechaNacimiento.setLocalizedLabel(SPANISH, "fecha de nacimiento");
            this.nombre.setLocalizedLabel(ENGLISH, "names and surnames");
            this.nombre.setLocalizedLabel(SPANISH, "nombres y apellidos");
            this.nombre.setLocalizedRegexErrorMessage(ENGLISH, "names and surnames does not comply with the specified pattern; can only contain letters, spaces, hyphens and single quotes");
            this.nombre.setLocalizedRegexErrorMessage(SPANISH, "nombres y apellidos no cumple con el patr\u00f3n especificado; solo puede contener letras, espacios, guiones y comillas sencillas");
            this.correoElectronico.setLocalizedLabel(ENGLISH, "email");
            this.correoElectronico.setLocalizedLabel(SPANISH, "correo electr\u00f3nico");
            this.correoElectronico.setLocalizedRegexErrorMessage(ENGLISH, "email does not meet the specified pattern");
            this.correoElectronico.setLocalizedRegexErrorMessage(SPANISH, "correo electr\u00f3nico no cumple con el patr\u00f3n especificado");
            this.confirmacionCorreoElectronico.setLocalizedLabel(ENGLISH, "email confirmation");
            this.confirmacionCorreoElectronico.setLocalizedLabel(SPANISH, "confirmaci\u00f3n del correo");
            this.confirmacionCorreoElectronico.setLocalizedDescription(ENGLISH, "retype your email in this field");
            this.confirmacionCorreoElectronico.setLocalizedDescription(SPANISH, "escriba nuevamante su correo electr\u00f3nico en este campo");
            this.confirmacionCorreoElectronico.setLocalizedRegexErrorMessage(ENGLISH, "confirmation email does not match the specified pattern");
            this.confirmacionCorreoElectronico.setLocalizedRegexErrorMessage(SPANISH, "confirmaci\u00f3n del correo no cumple con el patr\u00f3n especificado");
            this.archivoCedula.setLocalizedLabel(ENGLISH, "image of the ID");
            this.archivoCedula.setLocalizedLabel(SPANISH, "imagen de la c\u00e9dula");
            this.archivoCedula.setLocalizedDescription(ENGLISH, "File containing the image of the identity card; Its size should not exceed 1 MB.");
            this.archivoCedula.setLocalizedDescription(SPANISH, "Archivo que contiene la imagen de la c\u00e9dula de identidad; su tama\u00f1o no debe superar 1 MB.");
        }

        protected void localizeExpressions() {
            super.localizeExpressions();
            this.check100.setLocalizedErrorMessage(ENGLISH, "the email domain is invalid; must be gmail.com, hotmail.com, outlook.com or yahoo.com");
            this.check100.setLocalizedErrorMessage(SPANISH, "el dominio del correo electr\u00f3nico no es v\u00e1lido; debe ser gmail.com, hotmail.com, outlook.com o yahoo.com");
            this.check110.setLocalizedErrorMessage(ENGLISH, "email and email confirmation are not the same");
            this.check110.setLocalizedErrorMessage(SPANISH, "el correo electr\u00f3nico y la confirmaci\u00f3n del correo no son iguales");
        }

        protected void settleAttributes() {
            super.settleAttributes();
            this.setDefaultLabel("solicitar cambio de correo");
            this.setDefaultSuccessMessage("la solicitud fue registrada con \u00e9xito");
        }

        protected void settleParameters() {
            super.settleParameters();
            this.cedula.setDefaultLabel("c\u00e9dula");
            this.cedula.setDefaultRegexErrorMessage("c\u00e9dula de identidad no cumple con el patr\u00f3n especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            this.fechaNacimiento.setDefaultLabel("fecha de nacimiento");
            this.fechaNacimiento.setInitialValue((TemporalExpression)this.cedula.isNull().then((TemporalExpression)NULL_TEMPORAL));
            this.fechaNacimiento.setMinValue((TemporalExpression)CURRENT_DATE.addYears((Number)-100));
            this.fechaNacimiento.setMaxValue((TemporalExpression)CURRENT_DATE.addYears((Number)-18));
            this.nombre.setDefaultLabel("nombres y apellidos");
            this.nombre.setInitialValue((CharacterExpression)this.cedula.isNull().or((BooleanExpression)this.fechaNacimiento.isNull()).then((Expression)NULL_STRING));
            this.nombre.setDefaultRegexErrorMessage("nombres y apellidos no cumple con el patr\u00f3n especificado; solo puede contener letras, espacios, guiones y comillas sencillas");
            this.correoElectronico.setDefaultLabel("correo electr\u00f3nico");
            this.correoElectronico.setDefaultRegexErrorMessage("correo electr\u00f3nico no cumple con el patr\u00f3n especificado");
            this.confirmacionCorreoElectronico.setDefaultLabel("confirmaci\u00f3n del correo");
            this.confirmacionCorreoElectronico.setDefaultDescription("escriba nuevamante su correo electr\u00f3nico en este campo");
            this.confirmacionCorreoElectronico.setDefaultRegexErrorMessage("confirmaci\u00f3n del correo no cumple con el patr\u00f3n especificado");
            this.archivoCedula.setDefaultLabel("imagen de la c\u00e9dula");
            this.archivoCedula.setDefaultDescription("Archivo que contiene la imagen de la c\u00e9dula de identidad; su tama\u00f1o no debe superar 1 MB. ");
        }

        protected void settleExpressions() {
            super.settleExpressions();
            this.check100 = Registrar.or((BooleanExpression)this.correoElectronico.endsWith("@gmail.com"), (BooleanExpression)this.correoElectronico.endsWith("@hotmail.com"), (BooleanExpression[])new BooleanExpression[]{this.correoElectronico.endsWith("@outlook.com"), this.correoElectronico.endsWith("@yahoo.com")});
            this.check100.setDefaultErrorMessage("el dominio del correo electr\u00f3nico no es v\u00e1lido; debe ser gmail.com, hotmail.com, outlook.com o yahoo.com");
            this.check110 = this.confirmacionCorreoElectronico.isEqualTo((Expression)this.correoElectronico);
            this.check110.setDefaultErrorMessage("el correo electr\u00f3nico y la confirmaci\u00f3n del correo no son iguales");
        }

        protected void settleFilters() {
            super.settleFilters();
            this.cedula.setModifyingFilter((BooleanExpression)this.archivoCedula.isNull());
            this.nombre.setModifyingFilter((BooleanExpression)UNTRUTH);
            this.archivoCedula.setModifyingFilter((BooleanExpression)this.cedula.isNotNull());
        }
    }

    @OperationClass(access=OperationAccess.PUBLIC)
    @ProcessOperationClass(serviceable=Kleenean.FALSE)
    public class Verificar
    extends ProcessOperation {
        @InstanceReference
        protected SolicitudCambiarCorreoUsuario solicitud;
        @ParameterField(required=Kleenean.TRUE, linkedField="cedula")
        @StringField(maxLength=10, regex="^[0-9]{1,9}[A-Za-z]?$", letterCase=LetterCase.UPPER)
        protected StringParameter cedula;
        @ParameterField(required=Kleenean.TRUE, linkedField="fechaNacimiento")
        @DateField(yearRange=100)
        protected DateParameter fechaNacimiento;
        protected Check check100;
        protected Check check110;

        public Verificar(SolicitudCambiarCorreoUsuario this$0) {
        }

        protected void localizeAttributes() {
            super.localizeAttributes();
            this.setLocalizedLabel(ENGLISH, "verify email account");
            this.setLocalizedLabel(SPANISH, "verificar cuenta de correo");
        }

        protected void localizeParameters() {
            super.localizeParameters();
            this.solicitud.setLocalizedLabel(ENGLISH, "application");
            this.cedula.setLocalizedLabel(ENGLISH, "identification card");
            this.cedula.setLocalizedLabel(SPANISH, "c\u00e9dula");
            this.cedula.setLocalizedRegexErrorMessage(ENGLISH, "ID card does not meet the specified pattern; must be a sequence of up to 9 digits, optionally ending with a letter; for example, 1234567, 1235813A");
            this.cedula.setLocalizedRegexErrorMessage(SPANISH, "c\u00e9dula de identidad no cumple con el patr\u00f3n especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            this.fechaNacimiento.setLocalizedLabel(ENGLISH, "birthdate");
            this.fechaNacimiento.setLocalizedLabel(SPANISH, "fecha de nacimiento");
        }

        protected void localizeExpressions() {
            super.localizeExpressions();
            this.check100.setLocalizedErrorMessage(ENGLISH, "the ID is not the same as the applicant's ID");
            this.check100.setLocalizedErrorMessage(SPANISH, "la c\u00e9dula no es igual a la c\u00e9dula del solicitante");
            this.check110.setLocalizedErrorMessage(ENGLISH, "the date of birth is not the same as the applicant's date of birth");
            this.check110.setLocalizedErrorMessage(SPANISH, "la fecha de nacimiento no es igual a la fecha de nacimiento del solicitante");
        }

        protected void settleAttributes() {
            super.settleAttributes();
            this.setDefaultLabel("verificar cuenta de correo");
            this.setDefaultSuccessMessage("la cuenta de correo fue verificada con \u00e9xito");
        }

        protected void settleParameters() {
            super.settleParameters();
            this.solicitud.setDefaultLabel("solicitud");
            this.solicitud.condicion.setCurrentValue(this.solicitud.condicion.VERIFICADA);
            this.solicitud.fechaVerificada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
            this.cedula.setDefaultLabel("c\u00e9dula");
            this.cedula.setDefaultRegexErrorMessage("c\u00e9dula de identidad no cumple con el patr\u00f3n especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            this.fechaNacimiento.setDefaultLabel("fecha de nacimiento");
            this.fechaNacimiento.setInitialValue((TemporalExpression)this.cedula.isNull().then((TemporalExpression)NULL_TEMPORAL));
            this.fechaNacimiento.setMinValue((TemporalExpression)CURRENT_DATE.addYears((Number)-100));
            this.fechaNacimiento.setMaxValue((TemporalExpression)CURRENT_DATE.addYears((Number)-18));
        }

        protected void settleExpressions() {
            super.settleExpressions();
            this.check100 = this.cedula.isEqualTo((Expression)this.solicitud.cedula);
            this.check100.setDefaultErrorMessage("la c\u00e9dula no es igual a la c\u00e9dula del solicitante");
            this.check110 = this.fechaNacimiento.isEqualTo((TemporalExpression)this.solicitud.fechaNacimiento);
            this.check110.setDefaultErrorMessage("la fecha de nacimiento no es igual a la fecha de nacimiento del solicitante");
        }
    }

    @OperationClass(access=OperationAccess.PRIVATE)
    @ProcessOperationClass(serviceable=Kleenean.FALSE)
    public class Anular
    extends ProcessOperation {
        @InstanceReference
        protected SolicitudCambiarCorreoUsuario solicitud;

        public Anular(SolicitudCambiarCorreoUsuario this$0) {
        }

        protected void localizeAttributes() {
            super.localizeAttributes();
            this.setLocalizedLabel(ENGLISH, "cancel request");
            this.setLocalizedLabel(SPANISH, "anular solicitud");
        }

        protected void localizeParameters() {
            super.localizeParameters();
            this.solicitud.setLocalizedLabel(ENGLISH, "application");
        }

        protected void settleAttributes() {
            super.settleAttributes();
            this.setDefaultLabel("anular solicitud");
            this.setDefaultSuccessMessage("la solicitud fue anulada con \u00e9xito");
        }

        protected void settleParameters() {
            super.settleParameters();
            this.solicitud.setDefaultLabel("solicitud");
            this.solicitud.condicion.setCurrentValue(this.solicitud.condicion.ANULADA);
            this.solicitud.fechaAnulada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
        }
    }

    @OperationClass(access=OperationAccess.RESTRICTED)
    @ProcessOperationClass(serviceable=Kleenean.FALSE)
    public class Aprobar
    extends ProcessOperation {
        @InstanceReference
        protected SolicitudCambiarCorreoUsuario solicitud;

        public Aprobar(SolicitudCambiarCorreoUsuario this$0) {
        }

        protected void localizeAttributes() {
            super.localizeAttributes();
            this.setLocalizedLabel(ENGLISH, "approve request");
            this.setLocalizedLabel(SPANISH, "aprobar solicitud");
        }

        protected void localizeParameters() {
            super.localizeParameters();
            this.solicitud.setLocalizedLabel(ENGLISH, "application");
        }

        protected void settleAttributes() {
            super.settleAttributes();
            this.setDefaultLabel("aprobar solicitud");
            this.setDefaultSuccessMessage("la solicitud fue aprobada con \u00e9xito");
        }

        protected void settleParameters() {
            super.settleParameters();
            this.solicitud.setDefaultLabel("solicitud");
            this.solicitud.condicion.setCurrentValue(this.solicitud.condicion.APROBADA);
            this.solicitud.fechaAprobada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
        }
    }

    @OperationClass(access=OperationAccess.RESTRICTED)
    @ProcessOperationClass(serviceable=Kleenean.FALSE)
    public class Rechazar
    extends ProcessOperation {
        @InstanceReference
        protected SolicitudCambiarCorreoUsuario solicitud;
        @ParameterField(required=Kleenean.TRUE, linkedField="observacionesUltimaTransicion")
        protected StringParameter observaciones;

        public Rechazar(SolicitudCambiarCorreoUsuario this$0) {
        }

        protected void localizeAttributes() {
            super.localizeAttributes();
            this.setLocalizedLabel(ENGLISH, "reject request");
            this.setLocalizedLabel(SPANISH, "rechazar solicitud");
        }

        protected void localizeParameters() {
            super.localizeParameters();
            this.solicitud.setLocalizedLabel(ENGLISH, "application");
            this.observaciones.setLocalizedLabel(ENGLISH, "reason for rejection");
            this.observaciones.setLocalizedLabel(SPANISH, "motivo del rechazo");
            this.observaciones.setLocalizedDescription(ENGLISH, "Please describe in detail the reason why the application is being rejected.");
            this.observaciones.setLocalizedDescription(SPANISH, "Describa detalladamente el motivo por el cual se rechaza la solicitud");
        }

        protected void settleAttributes() {
            super.settleAttributes();
            this.setDefaultLabel("rechazar solicitud");
            this.setDefaultSuccessMessage("la solicitud fue rechazada con \u00e9xito");
        }

        protected void settleParameters() {
            super.settleParameters();
            this.solicitud.setDefaultLabel("solicitud");
            this.solicitud.condicion.setCurrentValue(this.solicitud.condicion.RECHAZADA);
            this.solicitud.fechaRechazada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
            this.observaciones.setDefaultLabel("motivo del rechazo");
            this.observaciones.setDefaultDescription("Describa detalladamente el motivo por el cual se rechaza la solicitud");
        }
    }
}

