/*
 * Decompiled with CFR 0.152.
 */
package showcase.meta.entidad.cuenta;

import adalid.core.ProcessOperation;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.ConstructionOperationClass;
import adalid.core.annotations.DateField;
import adalid.core.annotations.DiscriminatorValue;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.ProcessOperationClass;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.enums.AutoComplete;
import adalid.core.enums.HappyPathDisplaySpots;
import adalid.core.enums.Kleenean;
import adalid.core.enums.LetterCase;
import adalid.core.enums.MimeType;
import adalid.core.enums.OnConstructionOperationSuccess;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.enums.UploadStorageOption;
import adalid.core.enums.ViewMenuOption;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.State;
import adalid.core.interfaces.TemporalExpression;
import adalid.core.parameters.DateParameter;
import adalid.core.parameters.StringParameter;
import adalid.core.parameters.ext.EmailAddressParameter;
import adalid.core.parameters.ext.InternationalSmartphoneNumberParameter;
import adalid.core.properties.StringProperty;
import adalid.core.properties.ext.InternationalSmartphoneNumberProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.ModuloAplicacion;
import meta.entidad.comun.control.acceso.GrupoUsuario;
import meta.entidad.comun.control.acceso.Rol;
import showcase.meta.entidad.cuenta.SolicitudCuentaUsuario;
import showcase.meta.entidad.cuenta.Usuario;

@DiscriminatorValue(value="1")
@EntityInsertOperation(enabled=Kleenean.FALSE)
@EntityTableView(inserts=Kleenean.FALSE, updates=Kleenean.FALSE, menu=ViewMenuOption.NONE)
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityConsoleView(enabled=Kleenean.TRUE, menu=Kleenean.FALSE)
public class SolicitudCrearCuentaUsuario
extends SolicitudCuentaUsuario {
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.FALSE, anchor="correoElectronico")
    public InternationalSmartphoneNumberProperty numeroTelefonoMovil;
    @StringField(maxLength=2000)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.FALSE, anchor="correoElectronico")
    public StringProperty direccion;
    @FileReference(types={MimeType.IMAGE}, storage=UploadStorageOption.FILE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, anchor="correoElectronico")
    public StringProperty archivoSolicitud;
    protected State activada;
    protected Registrar registrar;
    protected Verificar verificar;
    protected Anular anular;
    protected Aprobar aprobar;
    protected Rechazar rechazar;
    protected Activar activar;

    public SolicitudCrearCuentaUsuario(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
    }

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        this.setLocalizedLabel(ENGLISH, "user account creation request");
        this.setLocalizedLabel(SPANISH, "solicitud de creaci\u00f3n de cuenta de usuario");
        this.setLocalizedShortLabel(ENGLISH, "account creation request");
        this.setLocalizedShortLabel(SPANISH, "solicitud de creaci\u00f3n de cuenta");
        this.setLocalizedCollectionLabel(ENGLISH, "User Account Creation Requests");
        this.setLocalizedCollectionLabel(SPANISH, "Solicitudes de Creaci\u00f3n de Cuentas de Usuario");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Account Creation Requests");
        this.setLocalizedCollectionShortLabel(SPANISH, "Solicitudes de Creaci\u00f3n de Cuentas");
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        this.numeroTelefonoMovil.setLocalizedLabel(ENGLISH, "cell phone");
        this.numeroTelefonoMovil.setLocalizedLabel(SPANISH, "tel\u00e9fono celular");
        this.numeroTelefonoMovil.setLocalizedDescription(ENGLISH, "cell phone number in international format");
        this.numeroTelefonoMovil.setLocalizedDescription(SPANISH, "n\u00famero de tel\u00e9fono celular en formato internacional");
        this.numeroTelefonoMovil.setLocalizedRegexErrorMessage(ENGLISH, "the phone number does not meet the required pattern; This must begin with a country code, i.e. a plus sign and a group of 1 to 3 digits, followed by a global subscriber number, i.e. a group of 7 to 14 digits; the country code and global subscriber number must be separated by a single blank or hyphen; The global subscriber number can be divided into area code, a group of 1 to 4 digits, and subscriber number, a group of 6 to 10 digits; the area code and subscriber number must be separated by a single blank space or hyphen; Whatever their distribution between the groups, the total number of digits must be between 8 and 15.");
        this.numeroTelefonoMovil.setLocalizedRegexErrorMessage(SPANISH, "el n\u00famero de tel\u00e9fono no cumple con el patr\u00f3n requerido; \u00e9ste debe comenzar con un c\u00f3digo de pa\u00eds, es decir, un signo m\u00e1s y un grupo de 1 hasta 3 d\u00edgitos, seguido de un n\u00famero de suscriptor global, es decir, un grupo de 7 hasta 14 d\u00edgitos; el c\u00f3digo de pa\u00eds y el n\u00famero de suscriptor global deben estar separados por un solo espacio en blanco o gui\u00f3n; el n\u00famero de suscriptor global se puede dividir en c\u00f3digo de \u00e1rea, un grupo de 1 hasta 4 d\u00edgitos, y n\u00famero de suscriptor, un grupo de 6 a 10 d\u00edgitos; el c\u00f3digo de \u00e1rea y el n\u00famero de suscriptor deben estar separados por un solo espacio en blanco o gui\u00f3n; cualquiera que sea su distribuci\u00f3n entre los grupos, el n\u00famero total de d\u00edgitos debe estar entre 8 y 15.");
        this.direccion.setLocalizedLabel(ENGLISH, "address");
        this.direccion.setLocalizedLabel(SPANISH, "direcci\u00f3n");
        this.archivoSolicitud.setLocalizedLabel(ENGLISH, "application form");
        this.archivoSolicitud.setLocalizedLabel(SPANISH, "planilla de solicitud");
        this.archivoSolicitud.setLocalizedDescription(ENGLISH, "file containing the image of the application form");
        this.archivoSolicitud.setLocalizedDescription(SPANISH, "archivo que contiene la imagen de la planilla de solicitud");
        this.usuario.setLocalizedDescription(ENGLISH, "application user created when approving the request");
        this.usuario.setLocalizedDescription(SPANISH, "usuario de la aplicaci\u00f3n creado al aprobar la solicitud");
        this.usuario.setLocalizedShortDescription(ENGLISH, "application user created when approving the request");
        this.usuario.setLocalizedShortDescription(SPANISH, "usuario de la aplicaci\u00f3n creado al aprobar la solicitud");
    }

    @Override
    protected void localizeExpressions() {
        super.localizeExpressions();
        this.activada.setLocalizedLabel(ENGLISH, "activated");
        this.activada.setLocalizedLabel(SPANISH, "activada");
        this.activada.setLocalizedDescription(ENGLISH, "activated");
        this.activada.setLocalizedErrorMessage(ENGLISH, "the request is not in state \"Activated\"");
        this.activada.setLocalizedErrorMessage(SPANISH, "la solicitud no se encuentra en estado \"Activada\"");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setDefaultLabel("solicitud de creaci\u00f3n de cuenta de usuario");
        this.setDefaultShortLabel("solicitud de creaci\u00f3n de cuenta");
        this.setDefaultCollectionLabel("Solicitudes de Creaci\u00f3n de Cuentas de Usuario");
        this.setDefaultCollectionShortLabel("Solicitudes de Creaci\u00f3n de Cuentas");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.numeroTelefonoMovil.setDefaultLabel("tel\u00e9fono celular");
        this.numeroTelefonoMovil.setDefaultDescription("n\u00famero de tel\u00e9fono celular en formato internacional");
        this.numeroTelefonoMovil.setDefaultRegexErrorMessage("el n\u00famero de tel\u00e9fono no cumple con el patr\u00f3n requerido; \u00e9ste debe comenzar con un c\u00f3digo de pa\u00eds, es decir, un signo m\u00e1s y un grupo de 1 hasta 3 d\u00edgitos, seguido de un n\u00famero de suscriptor global, es decir, un grupo de 7 hasta 14 d\u00edgitos; el c\u00f3digo de pa\u00eds y el n\u00famero de suscriptor global deben estar separados por un solo espacio en blanco o gui\u00f3n; el n\u00famero de suscriptor global se puede dividir en c\u00f3digo de \u00e1rea, un grupo de 1 hasta 4 d\u00edgitos, y n\u00famero de suscriptor, un grupo de 6 a 10 d\u00edgitos; el c\u00f3digo de \u00e1rea y el n\u00famero de suscriptor deben estar separados por un solo espacio en blanco o gui\u00f3n; cualquiera que sea su distribuci\u00f3n entre los grupos, el n\u00famero total de d\u00edgitos debe estar entre 8 y 15.");
        this.direccion.setDefaultLabel("direcci\u00f3n");
        this.archivoSolicitud.setDefaultLabel("planilla de solicitud");
        this.archivoSolicitud.setDefaultDescription("archivo que contiene la imagen de la planilla de solicitud");
        this.usuario.setDefaultDescription("usuario de la aplicaci\u00f3n creado al aprobar la solicitud");
        this.usuario.setDefaultShortDescription("usuario de la aplicaci\u00f3n creado al aprobar la solicitud");
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.activada = this.condicion.isEqualTo(this.condicion.ACTIVADA);
        this.activada.setDefaultShortLabel("Activada");
        this.activada.setDefaultErrorMessage("la solicitud no se encuentra en estado \"Activada\"");
        this.activada.setTransitionDate(this.fechaActivada);
        this.setHappyPath(new State[]{this.registrada, this.verificada, this.aprobada, this.activada});
        this.setHappyPathDisplaySpots(HappyPathDisplaySpots.DETAIL_VIEW_AND_MASTER_HEADING);
    }

    protected void settleOperations() {
        super.settleOperations();
        this.registrar.addTransition(null, this.registrada);
        this.verificar.addTransition(this.registrada, this.verificada);
        this.anular.addTransition(this.registrada, this.anulada);
        this.aprobar.addTransition(this.verificada, this.aprobada);
        this.rechazar.addTransition(this.verificada, this.rechazada);
        this.activar.addTransition(this.aprobada, this.activada);
        this.verificar.addTriggerOn(new State[]{this.registrada});
        this.aprobar.addTriggerOn(new State[]{this.verificada});
    }

    @OperationClass(access=OperationAccess.PUBLIC)
    @ProcessOperationClass(serviceable=Kleenean.FALSE)
    @ConstructionOperationClass(type=SolicitudCrearCuentaUsuario.class)
    public class Registrar
    extends ProcessOperation {
        @ParameterField(required=Kleenean.TRUE, linkedField="cedula")
        @StringField(maxLength=10, regex="^[0-9]{1,9}[A-Za-z]?$", letterCase=LetterCase.UPPER)
        protected StringParameter cedula;
        @ParameterField(required=Kleenean.TRUE, linkedField="fechaNacimiento")
        @DateField(yearRange=100)
        protected DateParameter fechaNacimiento;
        @ParameterField(required=Kleenean.TRUE, linkedField="nombre")
        @StringField(maxLength=100, regex="^[\\p{IsLatin}][-' \\p{IsLatin}]*$", letterCase=LetterCase.UPPER)
        protected StringParameter nombre;
        @ParameterField(required=Kleenean.TRUE, linkedField="correoElectronico")
        protected EmailAddressParameter correoElectronico;
        @ParameterField(required=Kleenean.TRUE)
        protected EmailAddressParameter confirmacionCorreoElectronico;
        @ParameterField(required=Kleenean.FALSE, linkedField="numeroTelefonoMovil")
        protected InternationalSmartphoneNumberParameter numeroTelefonoMovil;
        @ParameterField(required=Kleenean.TRUE, linkedField="direccion")
        @StringField(maxLength=2000)
        protected StringParameter direccion;
        @ParameterField(required=Kleenean.TRUE, linkedField="archivoSolicitud")
        @FileReference(types={MimeType.IMAGE}, storage=UploadStorageOption.FILE, max=0x100000, virusScan=Kleenean.TRUE, pathTemplate="solicitud_cuenta_usuario.[cedula]")
        protected StringParameter archivoSolicitud;
        @ParameterField(required=Kleenean.TRUE, linkedField="archivoCedula")
        @FileReference(types={MimeType.IMAGE}, storage=UploadStorageOption.FILE, max=0x100000, virusScan=Kleenean.TRUE, pathTemplate="solicitud_cuenta_usuario.[cedula]")
        protected StringParameter archivoCedula;
        protected Check check100;
        protected Check check110;

        public Registrar(SolicitudCrearCuentaUsuario this$0) {
        }

        protected void localizeAttributes() {
            super.localizeAttributes();
            this.setLocalizedLabel(ENGLISH, "request account creation");
            this.setLocalizedLabel(SPANISH, "solicitar creaci\u00f3n de cuenta");
        }

        protected void localizeParameters() {
            super.localizeParameters();
            this.cedula.setLocalizedLabel(ENGLISH, "identification card");
            this.cedula.setLocalizedLabel(SPANISH, "c\u00e9dula");
            this.cedula.setLocalizedRegexErrorMessage(ENGLISH, "ID card does not meet the specified pattern; must be a sequence of up to 9 digits, optionally ending with a letter; for example, 1234567, 1235813A");
            this.cedula.setLocalizedRegexErrorMessage(SPANISH, "c\u00e9dula de identidad no cumple con el patr\u00f3n especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            this.fechaNacimiento.setLocalizedLabel(ENGLISH, "birthdate");
            this.fechaNacimiento.setLocalizedLabel(SPANISH, "fecha de nacimiento");
            this.nombre.setLocalizedLabel(ENGLISH, "names and surnames");
            this.nombre.setLocalizedLabel(SPANISH, "nombres y apellidos");
            this.nombre.setLocalizedRegexErrorMessage(ENGLISH, "names and surnames does not comply with the specified pattern; can only contain letters, spaces, hyphens and single quotes");
            this.nombre.setLocalizedRegexErrorMessage(SPANISH, "nombres y apellidos no cumple con el patr\u00f3n especificado; solo puede contener letras, espacios, guiones y comillas sencillas");
            this.correoElectronico.setLocalizedLabel(ENGLISH, "email");
            this.correoElectronico.setLocalizedLabel(SPANISH, "correo electr\u00f3nico");
            this.correoElectronico.setLocalizedRegexErrorMessage(ENGLISH, "email does not meet the specified pattern");
            this.correoElectronico.setLocalizedRegexErrorMessage(SPANISH, "correo electr\u00f3nico no cumple con el patr\u00f3n especificado");
            this.confirmacionCorreoElectronico.setLocalizedLabel(ENGLISH, "email confirmation");
            this.confirmacionCorreoElectronico.setLocalizedLabel(SPANISH, "confirmaci\u00f3n del correo");
            this.confirmacionCorreoElectronico.setLocalizedDescription(ENGLISH, "retype your email in this field");
            this.confirmacionCorreoElectronico.setLocalizedDescription(SPANISH, "escriba nuevamante su correo electr\u00f3nico en este campo");
            this.confirmacionCorreoElectronico.setLocalizedRegexErrorMessage(ENGLISH, "confirmation email does not match the specified pattern");
            this.confirmacionCorreoElectronico.setLocalizedRegexErrorMessage(SPANISH, "confirmaci\u00f3n del correo no cumple con el patr\u00f3n especificado");
            this.numeroTelefonoMovil.setLocalizedLabel(ENGLISH, "cell phone");
            this.numeroTelefonoMovil.setLocalizedLabel(SPANISH, "tel\u00e9fono celular");
            this.numeroTelefonoMovil.setLocalizedDescription(ENGLISH, "cellphone number; this is an international phone number; must begin with a country code, followed by a global subscriber number or an area code and a subscriber number; for example: +58 4121234567, +58-412-1234567");
            this.numeroTelefonoMovil.setLocalizedDescription(SPANISH, "n\u00famero de tel\u00e9fono celular; este es un n\u00famero de tel\u00e9fono internacional; debe comenzar con un c\u00f3digo de pa\u00eds, seguido de un n\u00famero de suscriptor global o un c\u00f3digo de \u00e1rea y un n\u00famero de suscriptor; por ejemplo: +58 4121234567, +58-412-1234567");
            this.numeroTelefonoMovil.setLocalizedRegexErrorMessage(ENGLISH, "the phone number does not meet the required pattern; This must begin with a country code, i.e. a plus sign and a group of 1 to 3 digits, followed by a global subscriber number, i.e. a group of 7 to 14 digits; the country code and global subscriber number must be separated by a single blank or hyphen; The global subscriber number can be divided into area code, a group of 1 to 4 digits, and subscriber number, a group of 6 to 10 digits; the area code and subscriber number must be separated by a single blank space or hyphen; Whatever their distribution between the groups, the total number of digits must be between 8 and 15.");
            this.numeroTelefonoMovil.setLocalizedRegexErrorMessage(SPANISH, "el n\u00famero de tel\u00e9fono no cumple con el patr\u00f3n requerido; \u00e9ste debe comenzar con un c\u00f3digo de pa\u00eds, es decir, un signo m\u00e1s y un grupo de 1 hasta 3 d\u00edgitos, seguido de un n\u00famero de suscriptor global, es decir, un grupo de 7 hasta 14 d\u00edgitos; el c\u00f3digo de pa\u00eds y el n\u00famero de suscriptor global deben estar separados por un solo espacio en blanco o gui\u00f3n; el n\u00famero de suscriptor global se puede dividir en c\u00f3digo de \u00e1rea, un grupo de 1 hasta 4 d\u00edgitos, y n\u00famero de suscriptor, un grupo de 6 a 10 d\u00edgitos; el c\u00f3digo de \u00e1rea y el n\u00famero de suscriptor deben estar separados por un solo espacio en blanco o gui\u00f3n; cualquiera que sea su distribuci\u00f3n entre los grupos, el n\u00famero total de d\u00edgitos debe estar entre 8 y 15.");
            this.direccion.setLocalizedLabel(ENGLISH, "address");
            this.direccion.setLocalizedLabel(SPANISH, "direcci\u00f3n");
            this.archivoSolicitud.setLocalizedLabel(ENGLISH, "application form");
            this.archivoSolicitud.setLocalizedLabel(SPANISH, "planilla de solicitud");
            this.archivoSolicitud.setLocalizedDescription(ENGLISH, "File that contains the image of the application form, signed by the user; Its size should not exceed 1 MB.");
            this.archivoSolicitud.setLocalizedDescription(SPANISH, "Archivo que contiene la imagen de la planilla de solicitud, firmada por el usuario; su tama\u00f1o no debe superar 1 MB.");
            this.archivoCedula.setLocalizedLabel(ENGLISH, "image of the ID");
            this.archivoCedula.setLocalizedLabel(SPANISH, "imagen de la c\u00e9dula");
            this.archivoCedula.setLocalizedDescription(ENGLISH, "File containing the image of the identity card; Its size should not exceed 1 MB.");
            this.archivoCedula.setLocalizedDescription(SPANISH, "Archivo que contiene la imagen de la c\u00e9dula de identidad; su tama\u00f1o no debe superar 1 MB.");
        }

        protected void localizeExpressions() {
            super.localizeExpressions();
            this.check100.setLocalizedErrorMessage(ENGLISH, "the email domain is invalid; must be gmail.com, hotmail.com, outlook.com or yahoo.com");
            this.check100.setLocalizedErrorMessage(SPANISH, "el dominio del correo electr\u00f3nico no es v\u00e1lido; debe ser gmail.com, hotmail.com, outlook.com o yahoo.com");
            this.check110.setLocalizedErrorMessage(ENGLISH, "email and email confirmation are not the same");
            this.check110.setLocalizedErrorMessage(SPANISH, "el correo electr\u00f3nico y la confirmaci\u00f3n del correo no son iguales");
        }

        protected void settleAttributes() {
            super.settleAttributes();
            this.setDefaultLabel("solicitar creaci\u00f3n de cuenta");
            this.setDefaultSuccessMessage("la solicitud fue registrada con \u00e9xito");
        }

        protected void settleParameters() {
            super.settleParameters();
            this.cedula.setDefaultLabel("c\u00e9dula");
            this.cedula.setDefaultRegexErrorMessage("c\u00e9dula de identidad no cumple con el patr\u00f3n especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            this.fechaNacimiento.setDefaultLabel("fecha de nacimiento");
            this.fechaNacimiento.setInitialValue((TemporalExpression)this.cedula.isNull().then((TemporalExpression)NULL_TEMPORAL));
            this.fechaNacimiento.setMinValue((TemporalExpression)CURRENT_DATE.addYears((Number)-100));
            this.fechaNacimiento.setMaxValue((TemporalExpression)CURRENT_DATE.addYears((Number)-18));
            this.nombre.setDefaultLabel("nombres y apellidos");
            this.nombre.setInitialValue((CharacterExpression)this.cedula.isNull().or((BooleanExpression)this.fechaNacimiento.isNull()).then((Expression)NULL_STRING));
            this.nombre.setDefaultRegexErrorMessage("nombres y apellidos no cumple con el patr\u00f3n especificado; solo puede contener letras, espacios, guiones y comillas sencillas");
            this.correoElectronico.setDefaultLabel("correo electr\u00f3nico");
            this.correoElectronico.setDefaultRegexErrorMessage("correo electr\u00f3nico no cumple con el patr\u00f3n especificado");
            this.confirmacionCorreoElectronico.setDefaultLabel("confirmaci\u00f3n del correo");
            this.confirmacionCorreoElectronico.setDefaultDescription("escriba nuevamante su correo electr\u00f3nico en este campo");
            this.confirmacionCorreoElectronico.setDefaultRegexErrorMessage("confirmaci\u00f3n del correo no cumple con el patr\u00f3n especificado");
            this.numeroTelefonoMovil.setDefaultLabel("tel\u00e9fono celular");
            this.numeroTelefonoMovil.setDefaultDescription("n\u00famero de tel\u00e9fono celular; este es un n\u00famero de tel\u00e9fono internacional; debe comenzar con un c\u00f3digo de pa\u00eds, seguido de un n\u00famero de suscriptor global o un c\u00f3digo de \u00e1rea y un n\u00famero de suscriptor; por ejemplo: +58 4121234567, +58-412-1234567");
            this.numeroTelefonoMovil.setDefaultRegexErrorMessage("el n\u00famero de tel\u00e9fono no cumple con el patr\u00f3n requerido; \u00e9ste debe comenzar con un c\u00f3digo de pa\u00eds, es decir, un signo m\u00e1s y un grupo de 1 hasta 3 d\u00edgitos, seguido de un n\u00famero de suscriptor global, es decir, un grupo de 7 hasta 14 d\u00edgitos; el c\u00f3digo de pa\u00eds y el n\u00famero de suscriptor global deben estar separados por un solo espacio en blanco o gui\u00f3n; el n\u00famero de suscriptor global se puede dividir en c\u00f3digo de \u00e1rea, un grupo de 1 hasta 4 d\u00edgitos, y n\u00famero de suscriptor, un grupo de 6 a 10 d\u00edgitos; el c\u00f3digo de \u00e1rea y el n\u00famero de suscriptor deben estar separados por un solo espacio en blanco o gui\u00f3n; cualquiera que sea su distribuci\u00f3n entre los grupos, el n\u00famero total de d\u00edgitos debe estar entre 8 y 15.");
            this.direccion.setDefaultLabel("direcci\u00f3n");
            this.archivoSolicitud.setDefaultLabel("planilla de solicitud");
            this.archivoSolicitud.setDefaultDescription("Archivo que contiene la imagen de la planilla de solicitud, firmada por el usuario; su tama\u00f1o no debe superar 1 MB. ");
            this.archivoCedula.setDefaultLabel("imagen de la c\u00e9dula");
            this.archivoCedula.setDefaultDescription("Archivo que contiene la imagen de la c\u00e9dula de identidad; su tama\u00f1o no debe superar 1 MB. ");
        }

        protected void settleExpressions() {
            super.settleExpressions();
            this.check100 = Registrar.or((BooleanExpression)this.correoElectronico.endsWith("@gmail.com"), (BooleanExpression)this.correoElectronico.endsWith("@hotmail.com"), (BooleanExpression[])new BooleanExpression[]{this.correoElectronico.endsWith("@outlook.com"), this.correoElectronico.endsWith("@yahoo.com")});
            this.check100.setDefaultErrorMessage("el dominio del correo electr\u00f3nico no es v\u00e1lido; debe ser gmail.com, hotmail.com, outlook.com o yahoo.com");
            this.check110 = this.confirmacionCorreoElectronico.isEqualTo((Expression)this.correoElectronico);
            this.check110.setDefaultErrorMessage("el correo electr\u00f3nico y la confirmaci\u00f3n del correo no son iguales");
        }

        protected void settleFilters() {
            super.settleFilters();
            this.cedula.setModifyingFilter((BooleanExpression)this.archivoSolicitud.isNull().and((BooleanExpression)this.archivoCedula.isNull()));
            this.nombre.setModifyingFilter((BooleanExpression)UNTRUTH);
            this.archivoSolicitud.setModifyingFilter((BooleanExpression)this.cedula.isNotNull());
            this.archivoCedula.setModifyingFilter((BooleanExpression)this.cedula.isNotNull());
        }
    }

    @OperationClass(access=OperationAccess.PUBLIC)
    @ProcessOperationClass(serviceable=Kleenean.FALSE)
    public class Verificar
    extends ProcessOperation {
        @InstanceReference
        protected SolicitudCrearCuentaUsuario solicitud;
        @ParameterField(required=Kleenean.TRUE, linkedField="cedula")
        @StringField(maxLength=10, regex="^[0-9]{1,9}[A-Za-z]?$", letterCase=LetterCase.UPPER)
        protected StringParameter cedula;
        @ParameterField(required=Kleenean.TRUE, linkedField="fechaNacimiento")
        @DateField(yearRange=100)
        protected DateParameter fechaNacimiento;
        protected Check check100;
        protected Check check110;

        public Verificar(SolicitudCrearCuentaUsuario this$0) {
        }

        protected void localizeAttributes() {
            super.localizeAttributes();
            this.setLocalizedLabel(ENGLISH, "verify email account");
            this.setLocalizedLabel(SPANISH, "verificar cuenta de correo");
        }

        protected void localizeParameters() {
            super.localizeParameters();
            this.solicitud.setLocalizedLabel(ENGLISH, "application");
            this.cedula.setLocalizedLabel(ENGLISH, "identification card");
            this.cedula.setLocalizedLabel(SPANISH, "c\u00e9dula");
            this.cedula.setLocalizedRegexErrorMessage(ENGLISH, "ID card does not meet the specified pattern; must be a sequence of up to 9 digits, optionally ending with a letter; for example, 1234567, 1235813A");
            this.cedula.setLocalizedRegexErrorMessage(SPANISH, "c\u00e9dula de identidad no cumple con el patr\u00f3n especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            this.fechaNacimiento.setLocalizedLabel(ENGLISH, "birthdate");
            this.fechaNacimiento.setLocalizedLabel(SPANISH, "fecha de nacimiento");
        }

        protected void localizeExpressions() {
            super.localizeExpressions();
            this.check100.setLocalizedErrorMessage(ENGLISH, "the ID is not the same as the applicant's ID");
            this.check100.setLocalizedErrorMessage(SPANISH, "la c\u00e9dula no es igual a la c\u00e9dula del solicitante");
            this.check110.setLocalizedErrorMessage(ENGLISH, "the date of birth is not the same as the applicant's date of birth");
            this.check110.setLocalizedErrorMessage(SPANISH, "la fecha de nacimiento no es igual a la fecha de nacimiento del solicitante");
        }

        protected void settleAttributes() {
            super.settleAttributes();
            this.setDefaultLabel("verificar cuenta de correo");
            this.setDefaultSuccessMessage("la cuenta de correo fue verificada con \u00e9xito");
        }

        protected void settleParameters() {
            super.settleParameters();
            this.solicitud.setDefaultLabel("solicitud");
            this.solicitud.condicion.setCurrentValue(this.solicitud.condicion.VERIFICADA);
            this.solicitud.fechaVerificada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
            this.cedula.setDefaultLabel("c\u00e9dula");
            this.cedula.setDefaultRegexErrorMessage("c\u00e9dula de identidad no cumple con el patr\u00f3n especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            this.fechaNacimiento.setDefaultLabel("fecha de nacimiento");
            this.fechaNacimiento.setInitialValue((TemporalExpression)this.cedula.isNull().then((TemporalExpression)NULL_TEMPORAL));
            this.fechaNacimiento.setMinValue((TemporalExpression)CURRENT_DATE.addYears((Number)-100));
            this.fechaNacimiento.setMaxValue((TemporalExpression)CURRENT_DATE.addYears((Number)-18));
        }

        protected void settleExpressions() {
            super.settleExpressions();
            this.check100 = this.cedula.isEqualTo((Expression)this.solicitud.cedula);
            this.check100.setDefaultErrorMessage("la c\u00e9dula no es igual a la c\u00e9dula del solicitante");
            this.check110 = this.fechaNacimiento.isEqualTo((TemporalExpression)this.solicitud.fechaNacimiento);
            this.check110.setDefaultErrorMessage("la fecha de nacimiento no es igual a la fecha de nacimiento del solicitante");
        }
    }

    @OperationClass(access=OperationAccess.PRIVATE)
    @ProcessOperationClass(serviceable=Kleenean.FALSE)
    public class Anular
    extends ProcessOperation {
        @InstanceReference
        protected SolicitudCrearCuentaUsuario solicitud;

        public Anular(SolicitudCrearCuentaUsuario this$0) {
        }

        protected void localizeAttributes() {
            super.localizeAttributes();
            this.setLocalizedLabel(ENGLISH, "cancel request");
            this.setLocalizedLabel(SPANISH, "anular solicitud");
        }

        protected void localizeParameters() {
            super.localizeParameters();
            this.solicitud.setLocalizedLabel(ENGLISH, "application");
        }

        protected void settleAttributes() {
            super.settleAttributes();
            this.setDefaultLabel("anular solicitud");
            this.setDefaultSuccessMessage("la solicitud fue anulada con \u00e9xito");
        }

        protected void settleParameters() {
            super.settleParameters();
            this.solicitud.setDefaultLabel("solicitud");
            this.solicitud.condicion.setCurrentValue(this.solicitud.condicion.ANULADA);
            this.solicitud.fechaAnulada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
        }
    }

    @OperationClass(access=OperationAccess.RESTRICTED, complex=Kleenean.TRUE)
    @ProcessOperationClass(serviceable=Kleenean.FALSE)
    @ConstructionOperationClass(type=Usuario.class, onsuccess=OnConstructionOperationSuccess.DISPLAY_NEW_INSTANCE)
    public class Aprobar
    extends ProcessOperation {
        @InstanceReference
        protected SolicitudCrearCuentaUsuario solicitud;
        @ParameterField(required=Kleenean.FALSE)
        @StringField(maxLength=254)
        protected StringParameter codigoUsuario;
        @ParameterField(required=Kleenean.FALSE)
        protected GrupoUsuario grupo;
        @ParameterField(required=Kleenean.FALSE)
        protected Rol rol;
        @ParameterField(required=Kleenean.FALSE)
        protected ModuloAplicacion modulo;
        protected Check check111;
        protected Check check112;
        protected BooleanExpression query113;

        public Aprobar(SolicitudCrearCuentaUsuario this$0) {
        }

        protected void localizeAttributes() {
            super.localizeAttributes();
            this.setLocalizedLabel(ENGLISH, "approve request");
            this.setLocalizedLabel(SPANISH, "aprobar solicitud");
        }

        protected void localizeParameters() {
            super.localizeParameters();
            this.solicitud.setLocalizedLabel(ENGLISH, "application");
            this.codigoUsuario.setLocalizedLabel(ENGLISH, "user code");
            this.grupo.setLocalizedLabel(ENGLISH, "user group");
            this.grupo.setLocalizedLabel(SPANISH, "grupo de usuarios");
            this.rol.setLocalizedLabel(ENGLISH, "role");
            this.rol.setLocalizedDescription(ENGLISH, "application role");
            this.rol.setLocalizedDescription(SPANISH, "rol de la aplicaci\u00f3n");
            this.modulo.setLocalizedLabel(ENGLISH, "module");
            this.modulo.setLocalizedLabel(SPANISH, "m\u00f3dulo");
        }

        protected void localizeExpressions() {
            super.localizeExpressions();
            this.check111.setLocalizedErrorMessage(ENGLISH, "the role cannot be an inactive role");
            this.check111.setLocalizedErrorMessage(SPANISH, "el rol no puede ser un rol inactivo");
            this.check112.setLocalizedErrorMessage(ENGLISH, "the role cannot be a super role");
            this.check112.setLocalizedErrorMessage(SPANISH, "el rol no puede ser un s\u00faper-rol");
            this.query113.setLocalizedErrorMessage(ENGLISH, "the role cannot be an inactive role or a super role");
            this.query113.setLocalizedErrorMessage(SPANISH, "el rol no puede ser un rol inactivo ni un s\u00faper-rol");
        }

        protected void settleAttributes() {
            super.settleAttributes();
            this.setDefaultLabel("aprobar solicitud");
            this.setDefaultSuccessMessage("la solicitud fue aprobada con \u00e9xito");
        }

        protected void settleParameters() {
            super.settleParameters();
            this.solicitud.setDefaultLabel("solicitud");
            this.solicitud.condicion.setCurrentValue(this.solicitud.condicion.APROBADA);
            this.solicitud.fechaAprobada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
            this.codigoUsuario.setDefaultValue((CharacterExpression)this.solicitud.cedula);
            this.codigoUsuario.setInitialValue((CharacterExpression)this.solicitud.cedula);
        }

        protected void settleExpressions() {
            super.settleExpressions();
            this.check111 = this.rol.isNull().or((BooleanExpression)this.rol.esRolInactivo.isFalse());
            this.check111.setDefaultErrorMessage("el rol no puede ser un rol inactivo");
            this.check112 = this.rol.isNull().or((BooleanExpression)this.rol.esSuperRol.isFalse());
            this.check112.setDefaultErrorMessage("el rol no puede ser un s\u00faper-rol");
            this.query113 = this.rol.esRolInactivo.isFalse().and((BooleanExpression)this.rol.esSuperRol.isFalse());
            this.query113.setDefaultErrorMessage("el rol no puede ser un rol inactivo ni un s\u00faper-rol");
        }

        protected void settleFilters() {
            super.settleFilters();
            this.codigoUsuario.setModifyingFilter((BooleanExpression)UNTRUTH);
            this.rol.setSearchQueryFilter(this.query113);
        }
    }

    @OperationClass(access=OperationAccess.RESTRICTED)
    @ProcessOperationClass(serviceable=Kleenean.FALSE)
    public class Rechazar
    extends ProcessOperation {
        @InstanceReference
        protected SolicitudCrearCuentaUsuario solicitud;
        @ParameterField(required=Kleenean.TRUE, linkedField="observacionesUltimaTransicion")
        protected StringParameter observaciones;

        public Rechazar(SolicitudCrearCuentaUsuario this$0) {
        }

        protected void localizeAttributes() {
            super.localizeAttributes();
            this.setLocalizedLabel(ENGLISH, "reject request");
            this.setLocalizedLabel(SPANISH, "rechazar solicitud");
        }

        protected void localizeParameters() {
            super.localizeParameters();
            this.solicitud.setLocalizedLabel(ENGLISH, "application");
            this.observaciones.setLocalizedLabel(ENGLISH, "reason for rejection");
            this.observaciones.setLocalizedLabel(SPANISH, "motivo del rechazo");
            this.observaciones.setLocalizedDescription(ENGLISH, "Please describe in detail the reason why the application is being rejected.");
            this.observaciones.setLocalizedDescription(SPANISH, "Describa detalladamente el motivo por el cual se rechaza la solicitud");
        }

        protected void settleAttributes() {
            super.settleAttributes();
            this.setDefaultLabel("rechazar solicitud");
            this.setDefaultSuccessMessage("la solicitud fue rechazada con \u00e9xito");
        }

        protected void settleParameters() {
            super.settleParameters();
            this.solicitud.setDefaultLabel("solicitud");
            this.solicitud.condicion.setCurrentValue(this.solicitud.condicion.RECHAZADA);
            this.solicitud.fechaRechazada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
            this.observaciones.setDefaultLabel("motivo del rechazo");
            this.observaciones.setDefaultDescription("Describa detalladamente el motivo por el cual se rechaza la solicitud");
        }
    }

    @OperationClass(access=OperationAccess.PUBLIC)
    @ProcessOperationClass(serviceable=Kleenean.FALSE)
    public class Activar
    extends ProcessOperation {
        @InstanceReference
        protected SolicitudCrearCuentaUsuario solicitud;
        @ParameterField(required=Kleenean.TRUE, linkedField="cedula")
        @StringField(maxLength=10, regex="^[0-9]{1,9}[A-Za-z]?$", letterCase=LetterCase.UPPER)
        protected StringParameter cedula;
        @ParameterField(required=Kleenean.TRUE, linkedField="fechaNacimiento")
        @DateField(yearRange=100)
        protected DateParameter fechaNacimiento;
        @ParameterField(auditable=Kleenean.FALSE, password=Kleenean.TRUE, required=Kleenean.TRUE)
        @StringField(maxLength=128, autoComplete=AutoComplete.NEW_PASSWORD)
        protected StringParameter password;
        @ParameterField(auditable=Kleenean.FALSE, password=Kleenean.TRUE, required=Kleenean.TRUE)
        @StringField(maxLength=128, autoComplete=AutoComplete.OFF)
        protected StringParameter confirmacionPassword;
        protected Check check100;
        protected Check check110;
        protected Check check120;

        public Activar(SolicitudCrearCuentaUsuario this$0) {
        }

        protected void localizeAttributes() {
            super.localizeAttributes();
            this.setLocalizedLabel(ENGLISH, "activate account");
            this.setLocalizedLabel(SPANISH, "activar cuenta");
        }

        protected void localizeParameters() {
            super.localizeParameters();
            this.solicitud.setLocalizedLabel(ENGLISH, "application");
            this.cedula.setLocalizedLabel(ENGLISH, "identification card");
            this.cedula.setLocalizedLabel(SPANISH, "c\u00e9dula");
            this.cedula.setLocalizedRegexErrorMessage(ENGLISH, "ID card does not meet the specified pattern; must be a sequence of up to 9 digits, optionally ending with a letter; for example, 1234567, 1235813A");
            this.cedula.setLocalizedRegexErrorMessage(SPANISH, "c\u00e9dula de identidad no cumple con el patr\u00f3n especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            this.fechaNacimiento.setLocalizedLabel(ENGLISH, "birthdate");
            this.fechaNacimiento.setLocalizedLabel(SPANISH, "fecha de nacimiento");
            this.password.setLocalizedLabel(ENGLISH, "password");
            this.password.setLocalizedLabel(SPANISH, "contrase\u00f1a");
            this.password.setLocalizedDescription(ENGLISH, "The password must be a sequence of up to 128 letters, numbers and other characters");
            this.password.setLocalizedDescription(SPANISH, "La contrase\u00f1a debe ser una secuencia de hasta 128 letras, n\u00fameros y otros caracteres");
            this.confirmacionPassword.setLocalizedLabel(ENGLISH, "password confirmation");
            this.confirmacionPassword.setLocalizedLabel(SPANISH, "confirmaci\u00f3n de la contrase\u00f1a");
            this.confirmacionPassword.setLocalizedDescription(ENGLISH, "Retype the password in this field");
            this.confirmacionPassword.setLocalizedDescription(SPANISH, "Escriba nuevamante la contrase\u00f1a en este campo");
        }

        protected void localizeExpressions() {
            super.localizeExpressions();
            this.check100.setLocalizedErrorMessage(ENGLISH, "the ID is not the same as the applicant's ID");
            this.check100.setLocalizedErrorMessage(SPANISH, "la c\u00e9dula no es igual a la c\u00e9dula del solicitante");
            this.check110.setLocalizedErrorMessage(ENGLISH, "the date of birth is not the same as the applicant's date of birth");
            this.check110.setLocalizedErrorMessage(SPANISH, "la fecha de nacimiento no es igual a la fecha de nacimiento del solicitante");
            this.check120.setLocalizedErrorMessage(ENGLISH, "password and password confirmation are not the same");
            this.check120.setLocalizedErrorMessage(SPANISH, "la contrase\u00f1a y la confirmaci\u00f3n de la contrase\u00f1a no son iguales");
        }

        protected void settleAttributes() {
            super.settleAttributes();
            this.setDefaultLabel("activar cuenta");
            this.setDefaultSuccessMessage("la cuenta fue activada con \u00e9xito");
        }

        protected void settleParameters() {
            super.settleParameters();
            this.solicitud.setDefaultLabel("solicitud");
            this.solicitud.condicion.setCurrentValue(this.solicitud.condicion.ACTIVADA);
            this.solicitud.fechaActivada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            this.solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
            this.cedula.setDefaultLabel("c\u00e9dula");
            this.cedula.setDefaultRegexErrorMessage("c\u00e9dula de identidad no cumple con el patr\u00f3n especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            this.fechaNacimiento.setDefaultLabel("fecha de nacimiento");
            this.fechaNacimiento.setInitialValue((TemporalExpression)this.cedula.isNull().then((TemporalExpression)NULL_TEMPORAL));
            this.fechaNacimiento.setMinValue((TemporalExpression)CURRENT_DATE.addYears((Number)-100));
            this.fechaNacimiento.setMaxValue((TemporalExpression)CURRENT_DATE.addYears((Number)-18));
            this.password.setDefaultLabel("contrase\u00f1a");
            this.password.setDefaultDescription("La contrase\u00f1a debe ser una secuencia de hasta 128 letras, n\u00fameros y otros caracteres");
            this.confirmacionPassword.setDefaultLabel("confirmaci\u00f3n de la contrase\u00f1a");
            this.confirmacionPassword.setDefaultDescription("Escriba nuevamante la contrase\u00f1a en este campo");
        }

        protected void settleExpressions() {
            super.settleExpressions();
            this.check100 = this.cedula.isEqualTo((Expression)this.solicitud.cedula);
            this.check100.setDefaultErrorMessage("la c\u00e9dula no es igual a la c\u00e9dula del solicitante");
            this.check110 = this.fechaNacimiento.isEqualTo((TemporalExpression)this.solicitud.fechaNacimiento);
            this.check110.setDefaultErrorMessage("la fecha de nacimiento no es igual a la fecha de nacimiento del solicitante");
            this.check120 = this.password.isNullOrEqualTo((Expression)this.confirmacionPassword);
            this.check120.setDefaultErrorMessage("la contrase\u00f1a y la confirmaci\u00f3n de la contrase\u00f1a no son iguales");
        }
    }
}

