/*
 * Decompiled with CFR 0.152.
 */
package showcase.meta.entidad.cuenta;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Key;
import adalid.core.annotations.AbstractClass;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DateField;
import adalid.core.annotations.DiscriminatorColumn;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.InheritanceMapping;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StateProperty;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.DefaultCondition;
import adalid.core.enums.HappyPathDisplaySpots;
import adalid.core.enums.InheritanceMappingStrategy;
import adalid.core.enums.Kleenean;
import adalid.core.enums.LetterCase;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.MimeType;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.enums.UploadStorageOption;
import adalid.core.enums.ViewMenuOption;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.Segment;
import adalid.core.interfaces.State;
import adalid.core.properties.DateProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.ext.EmailAddressProperty;
import java.lang.reflect.Field;
import showcase.meta.entidad.cuenta.CondicionSolicitudCuentaUsuario;
import showcase.meta.entidad.cuenta.TipoSolicitudCuentaUsuario;
import showcase.meta.entidad.cuenta.Usuario;

@AbstractClass
@InheritanceMapping(strategy=InheritanceMappingStrategy.SINGLE_TABLE)
@EntityDeleteOperation(enabled=Kleenean.FALSE)
@EntityTableView(inserts=Kleenean.FALSE, updates=Kleenean.FALSE, menu=ViewMenuOption.NONE)
@EntityDetailView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE, menu=Kleenean.FALSE)
public class SolicitudCuentaUsuario
extends AbstractPersistentEntity {
    final String solicitud_cedula = "solicitud_cuenta_usuario.[cedula]";
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @DiscriminatorColumn
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(overlay=Kleenean.TRUE)
    public TipoSolicitudCuentaUsuario tipo;
    @BusinessKey
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.FALSE)
    public StringProperty codigo;
    @ColumnField(nullable=Kleenean.FALSE)
    @StringField(maxLength=10, regex="^[0-9]{1,9}[A-Za-z]?$", letterCase=LetterCase.UPPER)
    public StringProperty cedula;
    @ColumnField(nullable=Kleenean.FALSE)
    @DateField(yearRange=100)
    public DateProperty fechaNacimiento;
    @NameProperty
    @StringField(maxLength=100, regex="^[\\p{IsLatin}][-' \\p{IsLatin}]*$", letterCase=LetterCase.UPPER)
    public StringProperty nombre;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.FALSE, overlay=Kleenean.TRUE)
    public EmailAddressProperty correoElectronico;
    @FileReference(types={MimeType.IMAGE}, storage=UploadStorageOption.FILE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public StringProperty archivoCedula;
    @StateProperty(transitionUser="usuarioUltimaTransicion", transitionDateTime="fechaUltimaTransicion")
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, defaultCondition=DefaultCondition.IF_NULL_ON_INSERT)
    public CondicionSolicitudCuentaUsuario condicion;
    @PropertyField(hidden=Kleenean.TRUE, defaultCondition=DefaultCondition.IF_NULL_ON_INSERT)
    public DateProperty fechaRegistrada;
    @PropertyField(hidden=Kleenean.TRUE)
    public DateProperty fechaVerificada;
    @PropertyField(hidden=Kleenean.TRUE)
    public DateProperty fechaAnulada;
    @PropertyField(hidden=Kleenean.TRUE)
    public DateProperty fechaAprobada;
    @PropertyField(hidden=Kleenean.TRUE)
    public DateProperty fechaRechazada;
    @PropertyField(hidden=Kleenean.TRUE)
    public DateProperty fechaActivada;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, overlay=Kleenean.TRUE, defaultCondition=DefaultCondition.IF_NULL_ON_INSERT)
    public DateProperty fechaUltimaTransicion;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public Usuario usuarioUltimaTransicion;
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public StringProperty observacionesUltimaTransicion;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE)
    public Usuario usuario;
    Key key101;
    protected State registrada;
    protected State verificada;
    protected State anulada;
    protected State aprobada;
    protected State rechazada;
    protected Check check100;

    public SolicitudCuentaUsuario(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    protected void addAllocationStrings() {
        super.addAllocationStrings();
    }

    protected void localizeAttributes() {
        super.localizeAttributes();
        this.setLocalizedLabel(ENGLISH, "user account request");
        this.setLocalizedLabel(SPANISH, "solicitud de cuenta de usuario");
        this.setLocalizedShortLabel(ENGLISH, "application");
        this.setLocalizedShortLabel(SPANISH, "solicitud");
        this.setLocalizedCollectionLabel(ENGLISH, "User Account Requests");
        this.setLocalizedCollectionLabel(SPANISH, "Solicitudes de Cuentas de Usuario");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Requests");
        this.setLocalizedCollectionShortLabel(SPANISH, "Solicitudes");
    }

    protected void localizeProperties() {
        super.localizeProperties();
        this.tipo.setLocalizedLabel(ENGLISH, "type");
        this.codigo.setLocalizedLabel(ENGLISH, "code");
        this.codigo.setLocalizedLabel(SPANISH, "c\u00f3digo");
        this.cedula.setLocalizedLabel(ENGLISH, "identification card");
        this.cedula.setLocalizedLabel(SPANISH, "c\u00e9dula");
        this.cedula.setLocalizedRegexErrorMessage(ENGLISH, "ID card does not meet the specified pattern; must be a sequence of up to 9 digits, optionally ending with a letter; for example, 1234567, 1235813A");
        this.cedula.setLocalizedRegexErrorMessage(SPANISH, "c\u00e9dula de identidad no cumple con el patr\u00f3n especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
        this.fechaNacimiento.setLocalizedLabel(ENGLISH, "birthdate");
        this.fechaNacimiento.setLocalizedLabel(SPANISH, "fecha de nacimiento");
        this.nombre.setLocalizedLabel(ENGLISH, "names and surnames");
        this.nombre.setLocalizedLabel(SPANISH, "nombres y apellidos");
        this.nombre.setLocalizedRegexErrorMessage(ENGLISH, "names and surnames does not comply with the specified pattern; can only contain letters, spaces, hyphens and single quotes");
        this.nombre.setLocalizedRegexErrorMessage(SPANISH, "nombres y apellidos no cumple con el patr\u00f3n especificado; solo puede contener letras, espacios, guiones y comillas sencillas");
        this.correoElectronico.setLocalizedLabel(ENGLISH, "email");
        this.correoElectronico.setLocalizedLabel(SPANISH, "correo electr\u00f3nico");
        this.correoElectronico.setLocalizedRegexErrorMessage(ENGLISH, "email does not meet the specified pattern");
        this.correoElectronico.setLocalizedRegexErrorMessage(SPANISH, "correo electr\u00f3nico no cumple con el patr\u00f3n especificado");
        this.archivoCedula.setLocalizedLabel(ENGLISH, "image of the ID");
        this.archivoCedula.setLocalizedLabel(SPANISH, "imagen de la c\u00e9dula");
        this.archivoCedula.setLocalizedDescription(ENGLISH, "file containing the image of the identity card");
        this.archivoCedula.setLocalizedDescription(SPANISH, "archivo que contiene la imagen de la c\u00e9dula de identidad");
        this.condicion.setLocalizedLabel(ENGLISH, "condition");
        this.condicion.setLocalizedLabel(SPANISH, "condici\u00f3n");
        this.fechaUltimaTransicion.setLocalizedLabel(ENGLISH, "last transition date");
        this.fechaUltimaTransicion.setLocalizedLabel(SPANISH, "fecha \u00faltima transici\u00f3n");
        this.fechaUltimaTransicion.setLocalizedShortLabel(ENGLISH, "transition date");
        this.fechaUltimaTransicion.setLocalizedShortLabel(SPANISH, "fecha transici\u00f3n");
        this.fechaUltimaTransicion.setLocalizedDescription(ENGLISH, "date of registration or last transition (change of status)");
        this.fechaUltimaTransicion.setLocalizedDescription(SPANISH, "fecha de registro o de la \u00faltima transici\u00f3n (cambio de condici\u00f3n)");
        this.usuarioUltimaTransicion.setLocalizedLabel(ENGLISH, "user last transition");
        this.usuarioUltimaTransicion.setLocalizedLabel(SPANISH, "usuario \u00faltima transici\u00f3n");
        this.usuarioUltimaTransicion.setLocalizedShortLabel(ENGLISH, "user transition");
        this.usuarioUltimaTransicion.setLocalizedShortLabel(SPANISH, "usuario transici\u00f3n");
        this.usuarioUltimaTransicion.setLocalizedDescription(ENGLISH, "user who made the last transition (condition change)");
        this.usuarioUltimaTransicion.setLocalizedDescription(SPANISH, "usuario que realiz\u00f3 la \u00faltima transici\u00f3n (cambio de condici\u00f3n)");
        this.observacionesUltimaTransicion.setLocalizedLabel(ENGLISH, "last transition observations");
        this.observacionesUltimaTransicion.setLocalizedLabel(SPANISH, "observaciones \u00faltima transici\u00f3n");
        this.observacionesUltimaTransicion.setLocalizedShortLabel(ENGLISH, "observations");
        this.observacionesUltimaTransicion.setLocalizedShortLabel(SPANISH, "observaciones");
        this.observacionesUltimaTransicion.setLocalizedDescription(ENGLISH, "observations of the last transition (condition change)");
        this.observacionesUltimaTransicion.setLocalizedDescription(SPANISH, "observaciones de la \u00faltima transici\u00f3n (cambio de condici\u00f3n)");
        this.usuario.setLocalizedLabel(ENGLISH, "user");
        this.usuario.setLocalizedDescription(ENGLISH, "application user");
        this.usuario.setLocalizedDescription(SPANISH, "usuario de la aplicaci\u00f3n");
    }

    protected void localizeExpressions() {
        super.localizeExpressions();
        this.registrada.setLocalizedLabel(ENGLISH, "registered");
        this.registrada.setLocalizedLabel(SPANISH, "registrada");
        this.registrada.setLocalizedDescription(ENGLISH, "registered");
        this.registrada.setLocalizedErrorMessage(ENGLISH, "The request is not in status \"Registered\"");
        this.registrada.setLocalizedErrorMessage(SPANISH, "la solicitud no se encuentra en estado \"Registrada\"");
        this.verificada.setLocalizedLabel(ENGLISH, "verified");
        this.verificada.setLocalizedLabel(SPANISH, "verificada");
        this.verificada.setLocalizedDescription(ENGLISH, "verified");
        this.verificada.setLocalizedErrorMessage(ENGLISH, "The request is not in status \"Verified\"");
        this.verificada.setLocalizedErrorMessage(SPANISH, "la solicitud no se encuentra en estado \"Verificada\"");
        this.anulada.setLocalizedLabel(ENGLISH, "annulled");
        this.anulada.setLocalizedLabel(SPANISH, "anulada");
        this.anulada.setLocalizedDescription(ENGLISH, "annulled");
        this.anulada.setLocalizedErrorMessage(ENGLISH, "The request is not in status \"Annulled\"");
        this.anulada.setLocalizedErrorMessage(SPANISH, "la solicitud no se encuentra en estado \"Anulada\"");
        this.aprobada.setLocalizedLabel(ENGLISH, "approved");
        this.aprobada.setLocalizedLabel(SPANISH, "aprobada");
        this.aprobada.setLocalizedDescription(ENGLISH, "approved");
        this.aprobada.setLocalizedErrorMessage(ENGLISH, "The request is not in status \"Approved\"");
        this.aprobada.setLocalizedErrorMessage(SPANISH, "la solicitud no se encuentra en estado \"Aprobada\"");
        this.rechazada.setLocalizedLabel(ENGLISH, "rejected");
        this.rechazada.setLocalizedLabel(SPANISH, "rechazada");
        this.rechazada.setLocalizedDescription(ENGLISH, "rejected");
        this.rechazada.setLocalizedErrorMessage(ENGLISH, "The request is not in status \"Rejected\"");
        this.rechazada.setLocalizedErrorMessage(SPANISH, "la solicitud no se encuentra en estado \"Rechazada\"");
        this.check100.setLocalizedErrorMessage(ENGLISH, "the email domain is invalid; must be gmail.com, hotmail.com, outlook.com or yahoo.com");
        this.check100.setLocalizedErrorMessage(SPANISH, "el dominio del correo electr\u00f3nico no es v\u00e1lido; debe ser gmail.com, hotmail.com, outlook.com o yahoo.com");
    }

    protected void settleAttributes() {
        super.settleAttributes();
        this.setDefaultLabel("solicitud de cuenta de usuario");
        this.setDefaultShortLabel("solicitud");
        this.setDefaultCollectionLabel("Solicitudes de Cuentas de Usuario");
        this.setDefaultCollectionShortLabel("Solicitudes");
    }

    protected void settleProperties() {
        super.settleProperties();
        this.codigo.setDefaultLabel("c\u00f3digo");
        this.codigo.setDefaultValue((CharacterExpression)this.id.toCharString());
        this.codigo.setInitialValue((CharacterExpression)this.id.toCharString());
        this.cedula.setDefaultLabel("c\u00e9dula");
        this.cedula.setDefaultRegexErrorMessage("c\u00e9dula de identidad no cumple con el patr\u00f3n especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
        this.fechaNacimiento.setDefaultLabel("fecha de nacimiento");
        this.nombre.setDefaultLabel("nombres y apellidos");
        this.nombre.setDefaultRegexErrorMessage("nombres y apellidos no cumple con el patr\u00f3n especificado; solo puede contener letras, espacios, guiones y comillas sencillas");
        this.correoElectronico.setDefaultLabel("correo electr\u00f3nico");
        this.correoElectronico.setDefaultRegexErrorMessage("correo electr\u00f3nico no cumple con el patr\u00f3n especificado");
        this.archivoCedula.setDefaultLabel("imagen de la c\u00e9dula");
        this.archivoCedula.setDefaultDescription("archivo que contiene la imagen de la c\u00e9dula de identidad");
        this.condicion.setDefaultLabel("condici\u00f3n");
        this.condicion.setDefaultValue(this.condicion.REGISTRADA);
        this.condicion.setInitialValue(this.condicion.REGISTRADA);
        this.fechaRegistrada.setDefaultValue(SpecialTemporalValue.CURRENT_DATE);
        this.fechaRegistrada.setInitialValue(SpecialTemporalValue.CURRENT_DATE);
        this.fechaUltimaTransicion.setDefaultLabel("fecha \u00faltima transici\u00f3n");
        this.fechaUltimaTransicion.setDefaultShortLabel("fecha transici\u00f3n");
        this.fechaUltimaTransicion.setDefaultDescription("fecha de registro o de la \u00faltima transici\u00f3n (cambio de condici\u00f3n)");
        this.fechaUltimaTransicion.setDefaultValue(SpecialTemporalValue.CURRENT_DATE);
        this.fechaUltimaTransicion.setInitialValue(SpecialTemporalValue.CURRENT_DATE);
        this.usuarioUltimaTransicion.setDefaultLabel("usuario \u00faltima transici\u00f3n");
        this.usuarioUltimaTransicion.setDefaultShortLabel("usuario transici\u00f3n");
        this.usuarioUltimaTransicion.setDefaultDescription("usuario que realiz\u00f3 la \u00faltima transici\u00f3n (cambio de condici\u00f3n)");
        this.usuarioUltimaTransicion.setDefaultValue(SpecialEntityValue.CURRENT_USER);
        this.usuarioUltimaTransicion.setInitialValue(SpecialEntityValue.CURRENT_USER);
        this.observacionesUltimaTransicion.setDefaultLabel("observaciones \u00faltima transici\u00f3n");
        this.observacionesUltimaTransicion.setDefaultShortLabel("observaciones");
        this.observacionesUltimaTransicion.setDefaultDescription("observaciones de la \u00faltima transici\u00f3n (cambio de condici\u00f3n)");
    }

    protected void settleKeys() {
        super.settleKeys();
        this.key101.setUnique(false);
        this.key101.newKeyField((Property)this.cedula);
    }

    protected void settleExpressions() {
        super.settleExpressions();
        this.registrada = this.condicion.isEqualTo(this.condicion.REGISTRADA);
        this.registrada.setDefaultShortLabel("Registrada");
        this.registrada.setDefaultErrorMessage("la solicitud no se encuentra en estado \"Registrada\"");
        this.registrada.setTransitionDate(this.fechaRegistrada);
        this.verificada = this.condicion.isEqualTo(this.condicion.VERIFICADA);
        this.verificada.setDefaultShortLabel("Verificada");
        this.verificada.setDefaultErrorMessage("la solicitud no se encuentra en estado \"Verificada\"");
        this.verificada.setTransitionDate(this.fechaVerificada);
        this.anulada = this.condicion.isEqualTo(this.condicion.ANULADA);
        this.anulada.setDefaultShortLabel("Anulada");
        this.anulada.setDefaultErrorMessage("la solicitud no se encuentra en estado \"Anulada\"");
        this.anulada.setTransitionDate(this.fechaAnulada);
        this.aprobada = this.condicion.isEqualTo(this.condicion.APROBADA);
        this.aprobada.setDefaultShortLabel("Aprobada");
        this.aprobada.setDefaultErrorMessage("la solicitud no se encuentra en estado \"Aprobada\"");
        this.aprobada.setTransitionDate(this.fechaAprobada);
        this.rechazada = this.condicion.isEqualTo(this.condicion.RECHAZADA);
        this.rechazada.setDefaultShortLabel("Rechazada");
        this.rechazada.setDefaultErrorMessage("la solicitud no se encuentra en estado \"Rechazada\"");
        this.rechazada.setTransitionDate(this.fechaRechazada);
        this.setHappyPath(new State[]{this.registrada, this.verificada, this.aprobada});
        this.setHappyPathDisplaySpots(HappyPathDisplaySpots.DETAIL_VIEW_AND_MASTER_HEADING);
        this.check100 = SolicitudCuentaUsuario.or((BooleanExpression)this.correoElectronico.endsWith("@gmail.com"), (BooleanExpression)this.correoElectronico.endsWith("@hotmail.com"), (BooleanExpression[])new BooleanExpression[]{this.correoElectronico.endsWith("@outlook.com"), this.correoElectronico.endsWith("@yahoo.com")});
        this.check100.setDefaultErrorMessage("el dominio del correo electr\u00f3nico no es v\u00e1lido; debe ser gmail.com, hotmail.com, outlook.com o yahoo.com");
    }

    protected void settleFilters() {
        super.settleFilters();
        this.setUpdateFilter((BooleanExpression)this.verificada);
        this.addSelectSegment((Segment)this.verificada, true);
    }
}

