/*
 * Decompiled with CFR 0.152.
 */
package showcase.meta.entidad.documento;

import adalid.core.ProcessOperation;
import adalid.core.annotations.AbstractClass;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.DiscriminatorColumn;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.InheritanceMapping;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.ProcessOperationClass;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.SequenceProperty;
import adalid.core.annotations.StateProperty;
import adalid.core.annotations.StringField;
import adalid.core.annotations.UserProperty;
import adalid.core.enums.HappyPathDisplaySpots;
import adalid.core.enums.InheritanceMappingStrategy;
import adalid.core.enums.Kleenean;
import adalid.core.enums.ListStyle;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SearchType;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.State;
import adalid.core.parameters.StringParameter;
import adalid.core.primitives.BinaryPrimitive;
import adalid.core.properties.BinaryProperty;
import adalid.core.properties.DateProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimestampProperty;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;
import meta.entidad.comun.auditoria.ArchivoAdjunto;
import meta.entidad.comun.control.acceso.Usuario;
import showcase.meta.entidad.configuracion.fija.EstadoDocumento;
import showcase.meta.entidad.configuracion.fija.TipoDocumento;

@AbstractClass
@EntityClass(resourceType=ResourceType.OPERATION, independent=Kleenean.FALSE)
@EntityCodeGen(bws=Kleenean.TRUE, fws=Kleenean.TRUE)
@InheritanceMapping(strategy=InheritanceMappingStrategy.SINGLE_TABLE)
@EntityUpdateOperation(access=OperationAccess.PROTECTED)
@EntityInsertOperation(access=OperationAccess.PROTECTED)
@EntityDeleteOperation(access=OperationAccess.PROTECTED)
@EntitySelectOperation(access=OperationAccess.PROTECTED)
@EntityTableView(inserts=Kleenean.FALSE)
public class Documento
extends PersistentEntityBase {
    @DiscriminatorColumn
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    public TipoDocumento tipo;
    @BusinessKey
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.FALSE, report=Kleenean.FALSE)
    public StringProperty codigo;
    @NameProperty
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public StringProperty nombre;
    @FileReference(max=0, joinField="adjunto", loadField="ultimaCarga", textField="nombre")
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.FALSE)
    public StringProperty archivo;
    @ColumnField(calculable=Kleenean.TRUE)
    public BinaryProperty octetos;
    @SequenceProperty
    public LongProperty secuencia;
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE)
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.NAME)
    public ArchivoAdjunto adjunto;
    @DescriptionProperty
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public StringProperty descripcion;
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.FALSE, report=Kleenean.FALSE)
    public TimestampProperty ultimaCarga;
    @StateProperty(transitionDateTime="fechaEstado")
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public EstadoDocumento estado;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    public DateProperty fechaEstado;
    @UserProperty
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    public Usuario usuarioActualizacion;
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    @StringField(maxLength=0)
    public StringProperty observaciones;
    public State modificable;
    public State verificable;
    public State verificado;
    public State rechazado;
    protected Cargar cargar;
    protected SolicitarVerificacion solicitarVerificacion;
    protected Aceptar aceptar;
    protected Rechazar rechazar;

    public Documento(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    protected void localizeAttributes() {
        super.localizeAttributes();
        this.setLocalizedLabel(ENGLISH, "document");
        this.setLocalizedCollectionLabel(ENGLISH, "Documents");
    }

    protected void localizeProperties() {
        super.localizeProperties();
        this.tipo.setLocalizedLabel(ENGLISH, "document type");
        this.tipo.setLocalizedLabel(SPANISH, "tipo de documento");
        this.codigo.setLocalizedLabel(ENGLISH, "document code");
        this.codigo.setLocalizedShortLabel(ENGLISH, "code");
        this.nombre.setLocalizedLabel(ENGLISH, "document name");
        this.nombre.setLocalizedShortLabel(ENGLISH, "name");
        this.nombre.setLocalizedDefaultValueTag(ENGLISH, "If &lt;**attachment**&gt; is null, &lt;**code**&gt;; if not, &lt;**client file**&gt; of &lt;**attachment**&gt;");
        this.nombre.setLocalizedDefaultValueTag(SPANISH, "Si <**adjunto**> es nulo, <**c\u00f3digo**>; si no, <**archivo cliente**> de <**adjunto**>");
        this.archivo.setLocalizedLabel(ENGLISH, "archive");
        this.archivo.setLocalizedTooltip(ENGLISH, "hyperlink to open file");
        this.archivo.setLocalizedTooltip(SPANISH, "hiperv\u00ednculo para abrir el archivo");
        this.octetos.setLocalizedLabel(ENGLISH, "octets");
        this.secuencia.setLocalizedLabel(ENGLISH, "document sequence");
        this.secuencia.setLocalizedShortLabel(ENGLISH, "sequence");
        this.adjunto.setLocalizedLabel(ENGLISH, "attached file");
        this.adjunto.setLocalizedLabel(SPANISH, "archivo adjunto");
        this.descripcion.setLocalizedLabel(ENGLISH, "file description");
        this.descripcion.setLocalizedLabel(SPANISH, "descripci\u00f3n del archivo");
        this.ultimaCarga.setLocalizedLabel(ENGLISH, "last load");
        this.estado.setLocalizedLabel(ENGLISH, "document status");
        this.estado.setLocalizedLabel(SPANISH, "estado de documento");
        this.fechaEstado.setLocalizedLabel(ENGLISH, "state's date");
        this.usuarioActualizacion.setLocalizedLabel(ENGLISH, "document update user");
        this.usuarioActualizacion.setLocalizedShortLabel(ENGLISH, "user update");
        this.observaciones.setLocalizedLabel(ENGLISH, "observations");
    }

    protected void localizeExpressions() {
        super.localizeExpressions();
        this.modificable.setLocalizedLabel(ENGLISH, "modifiable");
        this.modificable.setLocalizedDescription(ENGLISH, "modifiable");
        this.modificable.setLocalizedErrorMessage(ENGLISH, "The document is not Modifiable");
        this.modificable.setLocalizedErrorMessage(SPANISH, "el documento no est\u00e1 Modificable");
        this.verificable.setLocalizedLabel(ENGLISH, "verifiable");
        this.verificable.setLocalizedDescription(ENGLISH, "verifiable");
        this.verificable.setLocalizedErrorMessage(ENGLISH, "the document is not Verifiable");
        this.verificable.setLocalizedErrorMessage(SPANISH, "el documento no est\u00e1 Verificable");
        this.verificado.setLocalizedLabel(ENGLISH, "verified");
        this.verificado.setLocalizedDescription(ENGLISH, "verified");
        this.verificado.setLocalizedErrorMessage(ENGLISH, "the document is not Verified");
        this.verificado.setLocalizedErrorMessage(SPANISH, "el documento no est\u00e1 Verificado");
        this.rechazado.setLocalizedLabel(ENGLISH, "rejected");
        this.rechazado.setLocalizedDescription(ENGLISH, "rejected");
        this.rechazado.setLocalizedErrorMessage(ENGLISH, "the document is not Rejected");
        this.rechazado.setLocalizedErrorMessage(SPANISH, "el documento no est\u00e1 Rechazado");
    }

    protected void settleAttributes() {
        super.settleAttributes();
    }

    protected void settleProperties() {
        super.settleProperties();
        this.codigo.setDefaultValue((CharacterExpression)this.id.toCharString().format("(RTL)XXXX-XXXX-XXXX-XXXX-XXXX"));
        this.nombre.setDefaultValue((CharacterExpression)this.adjunto.isNull().then((Expression)this.codigo).otherwise((Expression)this.adjunto.archivoCliente));
        this.nombre.setDefaultValueTag("Si " + this.b("adjunto") + " es nulo, " + this.b("c\u00f3digo") + "; si no, " + this.b("archivo cliente") + " de " + this.b("adjunto"));
        this.archivo.setDefaultTooltip("hiperv\u00ednculo para abrir el archivo");
        this.octetos.setCalculableValueExpression((BinaryPrimitive)this.adjunto.octetos);
        this.descripcion.setDefaultLabel("descripci\u00f3n del archivo");
        this.descripcion.setDefaultValue((CharacterExpression)this.adjunto.tipoContenido.concat(" ").concat((Expression)this.adjunto.archivoCliente));
        this.estado.setInitialValue(this.estado.MODIFICABLE);
        this.estado.setDefaultValue(this.estado.MODIFICABLE);
        this.fechaEstado.setInitialValue(SpecialTemporalValue.CURRENT_DATE);
        this.fechaEstado.setDefaultValue(SpecialTemporalValue.CURRENT_DATE);
    }

    protected void settleExpressions() {
        super.settleExpressions();
        this.modificable = this.estado.isEqualTo(this.estado.MODIFICABLE);
        this.modificable.setDefaultErrorMessage("el documento no est\u00e1 Modificable");
        this.verificable = this.estado.isEqualTo(this.estado.VERIFICABLE);
        this.verificable.setDefaultErrorMessage("el documento no est\u00e1 Verificable");
        this.verificado = this.estado.isEqualTo(this.estado.VERIFICADO);
        this.verificado.setDefaultErrorMessage("el documento no est\u00e1 Verificado");
        this.rechazado = this.estado.isEqualTo(this.estado.RECHAZADO);
        this.rechazado.setDefaultErrorMessage("el documento no est\u00e1 Rechazado");
        this.setHappyPath(new State[]{this.modificable, this.verificable, this.verificado});
        this.setHappyPathDisplaySpots(HappyPathDisplaySpots.DETAIL_VIEW_AND_MASTER_HEADING);
    }

    protected void settleFilters() {
        this.setUpdateFilter((BooleanExpression)this.modificable);
        this.setDeleteFilter((BooleanExpression)this.modificable);
    }

    protected void settleOperations() {
        super.settleOperations();
        this.insert.addTransition(null, this.modificable);
        this.solicitarVerificacion.addTransition(this.modificable, this.verificable);
        this.aceptar.addTransition(this.verificable, this.verificado);
        this.rechazar.addTransition(this.verificable, this.rechazado);
        this.solicitarVerificacion.addTriggerOn(new State[]{this.modificable});
        this.aceptar.addTriggerOn(new State[]{this.verificable});
    }

    @OperationClass
    @ProcessOperationClass(overloading=Kleenean.UNSPECIFIED, serviceable=Kleenean.TRUE, automaticAssumption=true)
    public class SolicitarVerificacion
    extends ProcessOperation {
        @InstanceReference
        protected Documento documento;

        protected void localizeAttributes() {
            super.localizeAttributes();
            this.setLocalizedLabel(ENGLISH, "request verification");
        }

        protected void localizeParameters() {
            super.localizeParameters();
            this.documento.setLocalizedLabel(ENGLISH, "document");
        }

        protected void settleParameters() {
            super.settleParameters();
            this.documento.estado.setCurrentValue(Documento.this.estado.VERIFICABLE);
            this.documento.fechaEstado.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
        }
    }

    @OperationClass
    @ProcessOperationClass(overloading=Kleenean.UNSPECIFIED, serviceable=Kleenean.TRUE, automaticAssumption=true)
    public class Aceptar
    extends ProcessOperation {
        @InstanceReference
        protected Documento documento;
        @ParameterField(required=Kleenean.FALSE, linkedField="observaciones")
        protected StringParameter observaciones;

        protected void localizeAttributes() {
            super.localizeAttributes();
            this.setLocalizedLabel(ENGLISH, "accept");
        }

        protected void localizeParameters() {
            super.localizeParameters();
            this.documento.setLocalizedLabel(ENGLISH, "document");
            this.observaciones.setLocalizedLabel(ENGLISH, "observations");
        }

        protected void settleParameters() {
            super.settleParameters();
            this.documento.estado.setCurrentValue(Documento.this.estado.VERIFICADO);
            this.documento.fechaEstado.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
        }
    }

    @OperationClass
    @ProcessOperationClass(overloading=Kleenean.UNSPECIFIED, serviceable=Kleenean.TRUE)
    public class Rechazar
    extends ProcessOperation {
        @InstanceReference
        protected Documento documento;
        @ParameterField(required=Kleenean.FALSE, linkedField="observaciones")
        protected StringParameter observaciones;

        protected void localizeAttributes() {
            super.localizeAttributes();
            this.setLocalizedLabel(ENGLISH, "decline");
        }

        protected void localizeParameters() {
            super.localizeParameters();
            this.documento.setLocalizedLabel(ENGLISH, "document");
            this.observaciones.setLocalizedLabel(ENGLISH, "observations");
        }

        protected void settleParameters() {
            super.settleParameters();
            this.documento.estado.setCurrentValue(Documento.this.estado.RECHAZADO);
            this.documento.fechaEstado.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
        }
    }

    @OperationClass(access=OperationAccess.RESTRICTED)
    @ProcessOperationClass(overloading=Kleenean.TRUE)
    public class Cargar
    extends ProcessOperation {
        @InstanceReference
        protected Documento documento;
        @FileReference
        @ParameterField(required=Kleenean.TRUE, linkedField="archivo")
        protected StringParameter archivo;
        protected Check check0101;

        public Cargar(Documento this$0) {
        }

        protected void localizeAttributes() {
            super.localizeAttributes();
            this.setLocalizedLabel(ENGLISH, "carry");
        }

        protected void localizeParameters() {
            super.localizeParameters();
            this.documento.setLocalizedLabel(ENGLISH, "document");
            this.archivo.setLocalizedLabel(ENGLISH, "archive");
            this.archivo.setLocalizedTooltip(ENGLISH, "hyperlink to open file");
        }

        protected void localizeExpressions() {
            super.localizeExpressions();
        }

        protected void settleParameters() {
            super.settleParameters();
            this.archivo.setDefaultValue((CharacterExpression)this.documento.archivo);
            this.archivo.setInitialValue((CharacterExpression)this.documento.archivo);
        }

        protected void settleExpressions() {
            super.settleExpressions();
            this.check0101 = this.documento.modificable.isTrue();
        }

        protected void settleFilters() {
            super.settleFilters();
            this.documento.setSearchQueryFilter((BooleanExpression)this.check0101);
        }
    }
}

