/*
 * Decompiled with CFR 0.152.
 */
package showcase.meta.entidad.pedido;

import adalid.core.AbstractPersistentEntity;
import adalid.core.EntityCollection;
import adalid.core.Tab;
import adalid.core.View;
import adalid.core.ViewField;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.CharacterDataGen;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityCollectionField;
import adalid.core.annotations.EntityDataGen;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityReferenceDataGen;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NumericDataGen;
import adalid.core.annotations.NumericField;
import adalid.core.annotations.OneToMany;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyAggregation;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StateProperty;
import adalid.core.annotations.StringField;
import adalid.core.annotations.TemporalDataGen;
import adalid.core.annotations.UserProperty;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.AggregateFunction;
import adalid.core.enums.CascadeType;
import adalid.core.enums.DataEntryFormat;
import adalid.core.enums.DataGenType;
import adalid.core.enums.DefaultCondition;
import adalid.core.enums.DisplayFormat;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.HappyPathDisplaySpots;
import adalid.core.enums.Kleenean;
import adalid.core.enums.ListStyle;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.NumericFieldType;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.SearchType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.enums.SortOption;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.enums.TableResponsiveMode;
import adalid.core.enums.ViewFieldAggregation;
import adalid.core.enums.ViewMenuOption;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.Segment;
import adalid.core.interfaces.State;
import adalid.core.interfaces.TemporalExpression;
import adalid.core.page.format.LandscapeLegal;
import adalid.core.page.format.LandscapeLetter;
import adalid.core.page.format.PortraitLetter;
import adalid.core.properties.DateProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimestampProperty;
import java.lang.reflect.Field;
import java.util.Date;
import meta.entidad.comun.control.acceso.Usuario;
import showcase.meta.entidad.cliente.Cliente;
import showcase.meta.entidad.configuracion.Banco;
import showcase.meta.entidad.configuracion.fija.EstadoPedido;
import showcase.meta.entidad.configuracion.fija.FormaPago;
import showcase.meta.entidad.pedido.RenglonPedido;
import showcase.meta.operacion.pedido.Cancelar;
import showcase.meta.operacion.pedido.Cobrar;
import showcase.meta.operacion.pedido.EmitirInformeDinamico;
import showcase.meta.operacion.pedido.EmitirInformeParametrizado;
import showcase.meta.operacion.pedido.EmitirInformePorEstadoAprobacionV1;
import showcase.meta.operacion.pedido.EmitirInformePorEstadoAprobacionV2;
import showcase.meta.operacion.pedido.EmitirInformePorEstadoAprobacionV3;
import showcase.meta.operacion.pedido.Enviar;
import showcase.meta.operacion.pedido.ExportarArchivoPorEstadoAprobacion;
import showcase.meta.operacion.pedido.Procesar;
import showcase.meta.operacion.pedido.Recibir;
import showcase.meta.propiedad.PropiedadDinero;
import showcase.meta.propiedad.PropiedadPorcentaje;

@EntityCodeGen(bws=Kleenean.TRUE, fws=Kleenean.TRUE)
@EntityDataGen(start=1, step=1, stop=2000)
@EntityTableView(inserts=Kleenean.FALSE, updates=Kleenean.TRUE, responsiveMode=TableResponsiveMode.AUTO)
@EntityDetailView(enabled=Kleenean.TRUE, menu=ViewMenuOption.WRITING, inserting=Kleenean.TRUE)
@EntitySelectOperation(onload=SelectOnloadOption.EXECUTE, rowsLimit=100, sortOption=SortOption.DESC)
public class Pedido
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @BusinessKey
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE)
    @CharacterDataGen(type=DataGenType.SERIES, pattern="00000000000000000000")
    public StringProperty numero;
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.TABLE_AND_DETAIL)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE, responsivePriority=0)
    @EntityReferenceSearch(searchType=SearchType.DISPLAY, displayMode=DisplayMode.WRITING)
    public Cliente cliente;
    @PropertyAggregation(function=AggregateFunction.MINIMUM)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE, responsivePriority=0)
    @TemporalDataGen(type=DataGenType.RANDOM, min="-30D", max="0")
    public DateProperty fecha;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyAggregation(function=AggregateFunction.SUM)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, search=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE, overlay=Kleenean.TRUE, responsivePriority=5)
    @NumericDataGen(type=DataGenType.DEFAULT)
    public PropiedadDinero monto;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @EntityReferenceDataGen(type=DataGenType.DEFAULT)
    public FormaPago formaPago;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @EntityReferenceDataGen(type=DataGenType.DEFAULT)
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.NAME, displayMode=DisplayMode.WRITING)
    public Banco banco;
    @StringField(maxLength=20)
    @CharacterDataGen(type=DataGenType.DEFAULT)
    public StringProperty cheque;
    @StringField(maxLength=20)
    @CharacterDataGen(type=DataGenType.DEFAULT)
    public StringProperty tarjeta;
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(hidden=Kleenean.TRUE)
    @NumericDataGen(type=DataGenType.DEFAULT)
    @NumericField(type=NumericFieldType.PERCENT)
    public PropiedadPorcentaje descuento;
    @StateProperty(transitionUser="usuarioTransicion", transitionDateTime="fechaHoraTransicion")
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE, defaultCondition=DefaultCondition.IF_NULL_ON_INSERT)
    public EstadoPedido estado;
    @PropertyField(hidden=Kleenean.TRUE, defaultCondition=DefaultCondition.IF_NULL_ON_INSERT)
    public TimestampProperty fechaHoraRecibido;
    @PropertyField(hidden=Kleenean.TRUE)
    public TimestampProperty fechaHoraProcesado;
    @PropertyField(hidden=Kleenean.TRUE)
    public TimestampProperty fechaHoraCobrado;
    @PropertyField(hidden=Kleenean.TRUE)
    public TimestampProperty fechaHoraEnviado;
    @PropertyField(hidden=Kleenean.TRUE)
    public TimestampProperty fechaHoraCancelado;
    @PropertyField(hidden=Kleenean.TRUE, defaultCondition=DefaultCondition.IF_NULL_ON_INSERT)
    @TemporalDataGen(type=DataGenType.RANDOM, min="-720h", max="0")
    public TimestampProperty fechaHoraTransicion;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(hidden=Kleenean.TRUE)
    public Usuario usuarioTransicion;
    @UserProperty
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE)
    @PropertyField(hidden=Kleenean.TRUE)
    public Usuario usuarioActualizacion;
    private static final String renglonesWS = "/entity/Pedido/renglones/writingSnippet";
    @OneToMany(targetEntity=RenglonPedido.class, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH})
    @EntityCollectionField(format=DataEntryFormat.TABLE_OR_DETAIL, beforeWritingSnippet="/entity/Pedido/renglones/writingSnippet", afterWritingSnippet="/entity/Pedido/renglones/writingSnippet")
    public EntityCollection renglones;
    protected Tab tab001;
    protected Tab tab002;
    protected View v1;
    protected View v2;
    protected View v3;
    protected Segment pagoConEfectivo;
    protected Segment pagoConCheque;
    protected Segment pagoConTarjeta;
    protected Segment cancelable;
    protected State recibido;
    protected State procesado;
    protected State cobrado;
    protected State enviado;
    protected State cancelado;
    protected Recibir recibir;
    protected Procesar procesar;
    protected Cobrar cobrar;
    protected Enviar enviar;
    protected Cancelar cancelar;
    protected EmitirInformeDinamico informeDinamico;
    protected EmitirInformeParametrizado informeParametrizado;
    protected EmitirInformePorEstadoAprobacionV1 informePorEstadoAprobacionV1;
    protected EmitirInformePorEstadoAprobacionV2 informePorEstadoAprobacionV2;
    protected EmitirInformePorEstadoAprobacionV3 informePorEstadoAprobacionV3;
    protected ExportarArchivoPorEstadoAprobacion archivoPorEstadoAprobacion;

    public Pedido(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings(new String[]{"cliente.direccionPrincipal", "cliente.formaPago", "cliente.banco"});
    }

    protected void settleAttributes() {
        super.settleAttributes();
        this.setDefaultMenuOptionLabel(DisplayFormat.DETAIL, "Agregar Pedidos");
    }

    protected void settleProperties() {
        super.settleProperties();
        this.numero.setDefaultLabel("n\u00famero del pedido");
        this.numero.setDefaultShortLabel("n\u00famero");
        this.numero.setInitialValue((CharacterExpression)this.id.toZeroPaddedString(20));
        this.numero.setDefaultValue((CharacterExpression)this.id.toZeroPaddedString(20));
        this.fecha.setInitialValue(SpecialTemporalValue.CURRENT_DATE);
        this.fecha.setDefaultValue(SpecialTemporalValue.CURRENT_DATE);
        this.fecha.setMinValue((Date)EPOCH_DATE);
        this.fecha.setMaxValue((TemporalExpression)CURRENT_DATE);
        this.monto.setDefaultValue(0);
        this.monto.setInitialValue(0);
        this.banco.setDefaultDescription("banco al que corresponde la cuenta o la tarjeta; solo es necesario si la forma de pago es Cheque o Tarjeta");
        this.cheque.setDefaultDescription("n\u00famero de cheque utilizado para el pago; solo es necesario si la forma de pago es Cheque");
        this.tarjeta.setDefaultDescription("n\u00famero de tarjeta de cr\u00e9dito utilizada para el pago; solo es necesaria si la forma de pago es Tarjeta");
        this.descuento.setMinValue(0);
        this.descuento.setMaxValue(50);
        this.estado.setDefaultLabel("estado del pedido");
        this.estado.setDefaultShortLabel("estado");
        this.estado.setInitialValue(this.estado.RECIBIDO);
        this.estado.setDefaultValue(this.estado.RECIBIDO);
        this.fechaHoraRecibido.setDefaultValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.fechaHoraTransicion.setDefaultLabel("fecha/hora \u00faltima transici\u00f3n");
        this.fechaHoraTransicion.setDefaultShortLabel("fecha/hora transici\u00f3n");
        this.fechaHoraTransicion.setDefaultValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.usuarioTransicion.setDefaultLabel("usuario \u00faltima transici\u00f3n");
        this.usuarioTransicion.setDefaultShortLabel("usuario transici\u00f3n");
        this.usuarioTransicion.setDefaultValue(SpecialEntityValue.CURRENT_USER);
    }

    protected void settleCollections() {
        super.settleCollections();
        this.renglones.setDefaultLabel("renglones del pedido");
        this.renglones.setDefaultShortLabel("renglones");
        this.renglones.setDefaultDescription("colecci\u00f3n de renglones del pedido");
        this.renglones.addCount(1);
    }

    protected void settleTabs() {
        super.settleTabs();
        this.tab001.setDefaultLabel("Renglones del pedido");
        this.tab001.setDefaultShortLabel("renglones");
        this.tab001.newTabField(this.renglones);
        this.tab002.setDefaultLabel("Datos del pago");
        this.tab002.setDefaultShortLabel("pago");
        this.tab002.newTabField(new Property[]{this.formaPago, this.banco, this.cheque, this.tarjeta, this.descuento});
    }

    protected void settleLinks() {
        super.settleLinks();
    }

    protected void settleViews() {
        super.settleViews();
        this.v1.setPageFormatClass(LandscapeLegal.class);
        this.v1.setShareable(true);
        this.v1.setDefaultLabel("Pedidos por Estado y Aprobaci\u00f3n V1");
        ViewField vf = this.v1.newControlField((Property)this.estado.codigo);
        vf.setDefaultLabel("estado");
        this.v1.newControlField((Property)this.cliente.aprobado);
        this.v1.newDetailField((Property)this.numero, SortOption.ASC);
        this.v1.newDetailField((Property)this.fecha);
        this.v1.newDetailField((Property)this.fechaHoraTransicion);
        this.v1.newDetailField((Property)this.cliente.nombre);
        this.v1.newDetailField((Property)this.cliente.codigo);
        this.v1.newDetailField((Property)this.monto, ViewFieldAggregation.SUM_COUNT_AVERAGE_DEVIATION_MINIMUM_MAXIMUM);
        this.v2.setPageFormatClass(LandscapeLetter.class);
        this.v2.setShareable(true);
        this.v2.setDefaultLabel("Pedidos por Estado y Aprobaci\u00f3n V2");
        vf = this.v2.newControlField((Property)this.estado.codigo);
        vf.setDefaultLabel("estado");
        this.v2.newControlField((Property)this.cliente.aprobado);
        this.v2.newDetailField((Property)this.numero, SortOption.ASC);
        this.v2.newDetailField((Property)this.fecha);
        this.v2.newDetailField((Property)this.cliente.nombre);
        this.v2.newDetailField((Property)this.cliente.codigo);
        this.v2.newDetailField((Property)this.monto, ViewFieldAggregation.SUM_COUNT_AVERAGE_DEVIATION_MINIMUM_MAXIMUM);
        this.v3.setPageFormatClass(PortraitLetter.class);
        this.v3.setShareable(true);
        this.v3.setDefaultLabel("Pedidos por Estado y Aprobaci\u00f3n V3");
        vf = this.v3.newControlField((Property)this.estado.codigo);
        vf.setDefaultLabel("estado");
        this.v3.newControlField((Property)this.cliente.aprobado);
        this.v3.newDetailField((Property)this.numero, SortOption.ASC);
        this.v3.newDetailField((Property)this.fecha);
        this.v3.newDetailField((Property)this.cliente.nombre);
        this.v3.newDetailField((Property)this.monto, ViewFieldAggregation.SUM_COUNT_AVERAGE_DEVIATION_MINIMUM_MAXIMUM);
    }

    protected void settleExpressions() {
        super.settleExpressions();
        this.pagoConEfectivo = this.formaPago.isEqualTo(this.formaPago.EFECTIVO);
        this.pagoConEfectivo.setDefaultCollectionLabel("todos los pedidos pagados con efectivo");
        this.pagoConEfectivo.setDefaultCollectionShortLabel("Pedidos pagados con efectivo");
        this.pagoConEfectivo.setDefaultDescription("el pedido fue pagado con efectivo");
        this.pagoConEfectivo.setDefaultErrorMessage("la forma de pago no es efectivo");
        this.pagoConCheque = this.formaPago.isEqualTo(this.formaPago.CHEQUE);
        this.pagoConCheque.setDefaultCollectionLabel("todos los pedidos pagados con cheque");
        this.pagoConCheque.setDefaultCollectionShortLabel("Pedidos pagados con cheque");
        this.pagoConCheque.setDefaultDescription("el pedido fue pagado con cheque");
        this.pagoConCheque.setDefaultErrorMessage("la forma de pago no es cheque");
        this.pagoConTarjeta = this.formaPago.isEqualTo(this.formaPago.TARJETA);
        this.pagoConTarjeta.setDefaultCollectionLabel("todos los pedidos pagados con tarjeta de cr\u00e9dito o d\u00e9bito");
        this.pagoConTarjeta.setDefaultCollectionShortLabel("Pedidos pagados con tarjeta");
        this.pagoConTarjeta.setDefaultDescription("el pedido fue pagado con tarjeta de cr\u00e9dito o d\u00e9bito");
        this.pagoConTarjeta.setDefaultErrorMessage("la forma de pago no es tarjeta");
        this.recibido = this.estado.isEqualTo(this.estado.RECIBIDO);
        this.recibido.setDefaultErrorMessage("el pedido no est\u00e1 recibido");
        this.recibido.setTransitionTimestamp(this.fechaHoraRecibido);
        this.procesado = this.estado.isEqualTo(this.estado.PROCESADO);
        this.procesado.setDefaultErrorMessage("el pedido no est\u00e1 procesado");
        this.procesado.setTransitionTimestamp(this.fechaHoraProcesado);
        this.cobrado = this.estado.isEqualTo(this.estado.COBRADO);
        this.cobrado.setDefaultErrorMessage("el pedido no est\u00e1 cobrado");
        this.cobrado.setTransitionTimestamp(this.fechaHoraCobrado);
        this.enviado = this.estado.isEqualTo(this.estado.ENVIADO);
        this.enviado.setDefaultErrorMessage("el pedido no est\u00e1 enviado");
        this.enviado.setTransitionTimestamp(this.fechaHoraEnviado);
        this.cancelado = this.estado.isEqualTo(this.estado.CANCELADO);
        this.cancelado.setDefaultErrorMessage("el pedido no est\u00e1 cancelado");
        this.cancelado.setTransitionTimestamp(this.fechaHoraCancelado);
        this.cancelable = this.recibido.or((BooleanExpression)this.procesado).or((BooleanExpression)this.cobrado);
        this.cancelable.setDefaultErrorMessage("el pedido no est\u00e1 recibido, procesado o cobrado");
        this.setHappyPath(new State[]{this.recibido, this.procesado, this.cobrado, this.enviado});
        this.setHappyPathDisplaySpots(HappyPathDisplaySpots.DETAIL_VIEW_AND_MASTER_HEADING);
    }

    protected void settleFilters() {
        this.addSelectSegment(new Segment[]{this.pagoConEfectivo, this.pagoConCheque, this.pagoConTarjeta});
        this.setUpdateFilter((BooleanExpression)this.recibido);
        this.setDeleteFilter((BooleanExpression)this.recibido);
        this.tab002.setRenderingFilter((BooleanExpression)this.cobrado.or((BooleanExpression)this.cancelado));
    }

    protected void settleOperations() {
        super.settleOperations();
        this.insert.addTransition(null, this.recibido);
        this.procesar.addTransition(this.recibido, this.procesado);
        this.cobrar.addTransition(this.procesado, this.cobrado);
        this.enviar.addTransition(this.cobrado, this.enviado);
        this.cancelar.addTransition(this.recibido, this.cancelado);
        this.cancelar.addTransition(this.procesado, this.cancelado);
        this.cancelar.addTransition(this.cobrado, this.cancelado);
        this.procesar.addTriggerOn(new State[]{this.recibido});
        this.cobrar.addTriggerOn(new State[]{this.procesado});
        this.enviar.addTriggerOn(new State[]{this.cobrado});
    }
}

