/*
 * Decompiled with CFR 0.152.
 */
package showcase.meta.entidad.pedido;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Key;
import adalid.core.annotations.BigDecimalField;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityDataGen;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NumericDataGen;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Checkpoint;
import adalid.core.enums.DataGenType;
import adalid.core.enums.DefaultCondition;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.QuickAddingFilter;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.Segment;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import java.lang.reflect.Field;
import showcase.meta.entidad.pedido.Pedido;
import showcase.meta.entidad.producto.Producto;
import showcase.meta.propiedad.PropiedadDinero;

@EntityClass(independent=Kleenean.FALSE)
@EntityCodeGen(bws=Kleenean.TRUE, fws=Kleenean.TRUE)
@EntityDataGen(start=1, step=1, stop=5000)
public class RenglonPedido
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.TABLE_AND_DETAIL)
    public Pedido pedido;
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.NONE, quickAdding=QuickAddingFilter.MISSING)
    public Producto producto;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.TRUE)
    @NumericDataGen(type=DataGenType.RANDOM, min="1", max="5")
    public IntegerProperty cantidad;
    @BigDecimalField(precision=9)
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, defaultCondition=DefaultCondition.UNCONDITIONALLY, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    @NumericDataGen(factor="0")
    public PropiedadDinero precio;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE, defaultCondition=DefaultCondition.UNCONDITIONALLY, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    @NumericDataGen(factor="0")
    public PropiedadDinero total;
    protected Key key_pedido_producto;
    protected Segment modificable;

    public RenglonPedido(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings(new String[]{"pedido.estado"});
    }

    protected void settleAttributes() {
        super.settleAttributes();
        this.setDefaultCollectionLabel("Renglones de Pedido");
        this.setDefaultCollectionShortLabel("Renglones");
        this.setDefaultLabel("rengl\u00f3n de pedido");
        this.setDefaultShortLabel("rengl\u00f3n");
    }

    protected void settleProperties() {
        super.settleProperties();
        this.cantidad.setInitialValue((Number)1);
        this.cantidad.setDefaultValue((Number)1);
        this.cantidad.setMinValue((Number)1);
        this.cantidad.setMaxValue((Number)100);
        this.precio.setInitialValue((NumericExpression)this.producto.precio);
        this.precio.setDefaultValue((NumericExpression)this.producto.precio);
        this.total.setInitialValue((NumericExpression)this.producto.precio.times((NumericExpression)this.cantidad));
        this.total.setDefaultValue((NumericExpression)this.producto.precio.times((NumericExpression)this.cantidad));
        this.total.keepSumOn(new Property[]{this.pedido.monto});
    }

    protected void settleKeys() {
        super.settleKeys();
        this.key_pedido_producto.setUnique(false);
        this.key_pedido_producto.newKeyField(new Property[]{this.pedido, this.producto});
    }

    protected void settleLinks() {
        super.settleLinks();
    }

    protected void settleExpressions() {
        super.settleExpressions();
        this.modificable = this.pedido.estado.isEqualTo(this.pedido.estado.RECIBIDO);
        this.modificable.setDefaultErrorMessage("el pedido no est\u00e1 recibido");
    }

    protected void settleFilters() {
        this.setInsertFilter((BooleanExpression)this.pedido.recibido);
        this.setUpdateFilter((BooleanExpression)this.modificable);
        this.setDeleteFilter((BooleanExpression)this.modificable);
    }
}

