/*
 * Decompiled with CFR 0.152.
 */
package showcase.meta.entidad.producto;

import adalid.core.annotations.BigDecimalField;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.CharacterDataGen;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.EmbeddedDocument;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityDataGen;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.ImageProperty;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.NumericDataGen;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.enums.AvatarDefault;
import adalid.core.enums.AvatarShape;
import adalid.core.enums.DataGenType;
import adalid.core.enums.EmbeddedDocumentStyle;
import adalid.core.enums.EmbeddedDocumentType;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MimeType;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.interfaces.Artifact;
import adalid.core.properties.BinaryProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;
import showcase.meta.operacion.producto.AdjuntarDocumento;
import showcase.meta.operacion.producto.CargarArchivo;
import showcase.meta.operacion.producto.CargarImagen;
import showcase.meta.propiedad.PropiedadDinero;

@EntityClass(resourceType=ResourceType.CONFIGURATION)
@EntityCodeGen(bws=Kleenean.TRUE, fws=Kleenean.TRUE)
@EntityDataGen(start=1, step=1, stop=10)
@EntitySelectOperation(onload=SelectOnloadOption.EXECUTE)
@EntityTableView(rows=5)
public class Producto
extends PersistentEntityBase {
    @BusinessKey
    @CharacterDataGen(function="util.string_codigo_entidad")
    public StringProperty codigo;
    @NameProperty
    @CharacterDataGen(function="util.string_nombre_entidad")
    public StringProperty nombre;
    @DescriptionProperty
    @StringField(richTextFormat=Kleenean.TRUE)
    public StringProperty descripcion;
    @ImageProperty(displayWidth={144, 96, 72}, displayHeight={192, 128, 96}, avatarShape=AvatarShape.RECTANGLE, avatarDefault=AvatarDefault.UNSEEN)
    @PropertyField(table=Kleenean.TRUE)
    public BinaryProperty imagen;
    @ColumnField(calculable=Kleenean.TRUE)
    @FileReference(types={MimeType.IMAGE}, blobField="imagen")
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.FALSE, report=Kleenean.FALSE)
    public StringProperty archivoImagen;
    @ColumnField
    @EmbeddedDocument(sourceType=EmbeddedDocumentType.BOTH, style=EmbeddedDocumentStyle.POPUP)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.TRUE)
    public StringProperty documento;
    @BigDecimalField(precision=9)
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.TRUE)
    @NumericDataGen(type=DataGenType.RANDOM, min="10", max="100")
    public PropiedadDinero precio;
    protected AdjuntarDocumento adjuntarDocumento;
    protected CargarArchivo cargarArchivo;
    protected CargarImagen cargarImagen;

    public Producto(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    protected void addAllocationStrings() {
        super.addAllocationStrings();
    }

    protected void settleAttributes() {
        super.settleAttributes();
    }

    protected void settleProperties() {
        super.settleProperties();
        this.codigo.setDefaultShortLabel("c\u00f3digo");
        this.imagen.setDefaultLabel("imagen");
        this.imagen.setDefaultTooltip("foto del producto");
        this.archivoImagen.setDefaultLabel("archivo imagen");
        this.archivoImagen.setDefaultTooltip("URL del archivo que contiene la imagen (foto) del producto");
        this.archivoImagen.setCalculableValueExpression(this.imagen.fileReferenceCalculableValueExpression());
    }

    protected void settleFilters() {
        super.settleFilters();
    }
}

