/*
 * Decompiled with CFR 0.152.
 */
package showcase.meta.operacion.pedido;

import adalid.core.ProcessOperation;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.ProcessOperationClass;
import adalid.core.annotations.StringField;
import adalid.core.enums.AnchorType;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.Kleenean;
import adalid.core.enums.ListStyle;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.SearchType;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Entity;
import adalid.core.parameters.StringParameter;
import showcase.meta.entidad.configuracion.Banco;
import showcase.meta.entidad.configuracion.fija.FormaPago;
import showcase.meta.entidad.pedido.Pedido;

@ProcessOperationClass(overloading=Kleenean.UNSPECIFIED, serviceable=Kleenean.TRUE, deadline="2m", priority=2, newTaskNotification="1m", notifySupervisor=true, notifyAssumption=true, notifyAbandonment=true, notifyCancellation=true, notifyCompletion=true, unassignedTaskNotification="2m", unfinishedTaskNotification="3m", unassignedTaskEscalation="4m", unfinishedTaskEscalation="5m", nextUnassignedTaskNotification="1m", nextUnfinishedTaskNotification="1m", nextUnassignedTaskEscalation="2m", nextUnfinishedTaskEscalation="2m")
@OperationClass(access=OperationAccess.RESTRICTED, confirmation=Kleenean.TRUE)
public class Cobrar
extends ProcessOperation {
    @InstanceReference
    protected Pedido pedido;
    @ParameterField(linkedField="formaPago", required=Kleenean.TRUE)
    public FormaPago formaPago;
    @ParameterField(linkedField="banco", anchor="formaPago", anchorType=AnchorType.INLINE)
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.NAME, displayMode=DisplayMode.WRITING)
    public Banco banco;
    @ParameterField(linkedField="cheque", anchor="banco", anchorType=AnchorType.INLINE)
    @StringField(maxLength=20)
    protected StringParameter cheque;
    @ParameterField(linkedField="tarjeta", anchor="banco", anchorType=AnchorType.INLINE)
    @StringField(maxLength=20)
    protected StringParameter tarjeta;
    protected BooleanExpression pagoConEfectivo;
    protected BooleanExpression pagoConCheque;
    protected BooleanExpression pagoConTarjeta;
    protected Check check100;
    protected Check check102;
    protected Check check103;
    protected Check check110;
    protected Check check112;
    protected Check check113;
    protected Check check120;
    protected Check check122;
    protected Check check123;

    protected void settleParameters() {
        super.settleParameters();
        this.pedido.estado.setCurrentValue(this.pedido.estado.COBRADO);
        this.pedido.fechaHoraCobrado.setCurrentValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.pedido.fechaHoraTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.pedido.usuarioTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
        this.formaPago.setInitialValue((Entity)this.pedido.cliente.formaPago);
        this.banco.setInitialValue((Entity)this.pedido.cliente.banco);
        this.tarjeta.setInitialValue((CharacterExpression)this.pedido.cliente.tarjeta);
        this.formaPago.setDefaultAnchoredLabel("medio de pago");
        this.banco.setDefaultAnchoredLabel("banco");
        this.cheque.setDefaultAnchoredLabel("cheque");
        this.tarjeta.setDefaultAnchoredLabel("tarjeta");
    }

    protected void settleExpressions() {
        super.settleExpressions();
        this.pagoConEfectivo = this.formaPago.isEqualTo(this.formaPago.EFECTIVO);
        this.pagoConEfectivo.setDefaultErrorMessage("la forma de pago no es efectivo");
        this.pagoConCheque = this.formaPago.isEqualTo(this.formaPago.CHEQUE);
        this.pagoConCheque.setDefaultErrorMessage("la forma de pago no es cheque");
        this.pagoConTarjeta = this.formaPago.isEqualTo(this.formaPago.TARJETA);
        this.pagoConTarjeta.setDefaultErrorMessage("la forma de pago no es tarjeta");
        this.check100 = this.pagoConEfectivo.implies((BooleanExpression)this.banco.isNull());
        this.check100.setDefaultErrorMessage("si el pago es en efectivo entonces no se puede especificar el banco");
        this.check102 = this.pagoConEfectivo.implies((BooleanExpression)this.cheque.isNull());
        this.check102.setDefaultErrorMessage("si el pago es en efectivo entonces no se puede especificar el cheque");
        this.check103 = this.pagoConEfectivo.implies((BooleanExpression)this.tarjeta.isNull());
        this.check103.setDefaultErrorMessage("si el pago es en efectivo entonces no se puede especificar la tarjeta");
        this.check110 = this.pagoConCheque.implies((BooleanExpression)this.banco.isNotNull());
        this.check110.setDefaultErrorMessage("si el pago es con cheque entonces se tiene que especificar el banco");
        this.check112 = this.pagoConCheque.implies((BooleanExpression)this.cheque.isNotNull());
        this.check112.setDefaultErrorMessage("si el pago es con cheque entonces se tiene que especificar el cheque");
        this.check113 = this.pagoConCheque.implies((BooleanExpression)this.tarjeta.isNull());
        this.check113.setDefaultErrorMessage("si el pago es con cheque entonces no se puede especificar la tarjeta");
        this.check120 = this.pagoConTarjeta.implies((BooleanExpression)this.banco.isNotNull());
        this.check120.setDefaultErrorMessage("si el pago es con tarjeta entonces se tiene que especificar el banco");
        this.check122 = this.pagoConTarjeta.implies((BooleanExpression)this.cheque.isNull());
        this.check122.setDefaultErrorMessage("si el pago es con tarjeta entonces no se puede especificar el cheque");
        this.check123 = this.pagoConTarjeta.implies((BooleanExpression)this.tarjeta.isNotNull());
        this.check123.setDefaultErrorMessage("si el pago es con tarjeta entonces se tiene que especificar la tarjeta");
    }

    protected void settleFilters() {
        super.settleFilters();
        this.banco.setRenderingFilter((BooleanExpression)this.pagoConCheque.or(this.pagoConTarjeta));
        this.banco.setRequiringFilter((BooleanExpression)this.pagoConCheque.or(this.pagoConTarjeta));
        this.banco.setNullifyingFilter(this.pagoConEfectivo);
        this.cheque.setRenderingFilter(this.pagoConCheque);
        this.cheque.setRequiringFilter(this.pagoConCheque);
        this.cheque.setNullifyingFilter((BooleanExpression)this.pagoConEfectivo.or(this.pagoConTarjeta));
        this.tarjeta.setRenderingFilter(this.pagoConTarjeta);
        this.tarjeta.setRequiringFilter(this.pagoConTarjeta);
        this.tarjeta.setNullifyingFilter((BooleanExpression)this.pagoConEfectivo.or(this.pagoConCheque));
    }
}

