/*
 * Decompiled with CFR 0.152.
 */
package showcase.meta.operacion.pedido;

import adalid.core.ReportOperation;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.ReportOperationClass;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ReportChartType;
import adalid.core.enums.StandardRelationalOp;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.TemporalExpression;
import adalid.core.parameters.BigDecimalParameter;
import adalid.core.parameters.DateParameter;
import java.awt.Color;
import showcase.meta.entidad.cliente.Cliente;
import showcase.meta.entidad.configuracion.fija.EstadoPedido;

@ReportOperationClass(viewField="v3", detailRowsLimit=5000, summaryRowsLimit=5000, chartRowsLimit=1000, chartTypes={ReportChartType.BAR, ReportChartType.AREA, ReportChartType.LINE, ReportChartType.AREA_BY_GROUP, ReportChartType.LINE_BY_GROUP, ReportChartType.PIE})
@OperationClass(access=OperationAccess.RESTRICTED)
public class EmitirInformePorEstadoAprobacionV3
extends ReportOperation {
    @ParameterField
    protected Cliente cliente;
    @ParameterField(linkedField="fecha", operator=StandardRelationalOp.GTEQ)
    protected DateParameter desdeFecha;
    @ParameterField(linkedField="fecha", operator=StandardRelationalOp.LTEQ)
    protected DateParameter hastaFecha;
    @ParameterField(linkedField="monto", operator=StandardRelationalOp.GTEQ)
    protected BigDecimalParameter desdeMonto;
    @ParameterField(linkedField="monto", operator=StandardRelationalOp.LTEQ)
    protected BigDecimalParameter hastaMonto;
    @ParameterField
    protected EstadoPedido estado;
    Check chack201;
    Check check301;

    protected void settleAttributes() {
        super.settleAttributes();
        this.setDefaultLabel("emitir informe por estado y aprobaci\u00f3n V3");
        this.clearChartColorList();
        this.addChartColor(new Color[]{Color.RED, Color.BLUE, Color.GREEN, Color.YELLOW, Color.MAGENTA, Color.ORANGE});
    }

    protected void settleExpressions() {
        super.settleExpressions();
        this.chack201 = EmitirInformePorEstadoAprobacionV3.or((BooleanExpression)this.desdeFecha.isNull(), (BooleanExpression)this.hastaFecha.isNull(), (BooleanExpression[])new BooleanExpression[]{this.desdeFecha.isLessOrEqualTo((TemporalExpression)this.hastaFecha)});
        this.chack201.setDefaultErrorMessage("desde fecha es mayor que hasta fecha");
        this.check301 = EmitirInformePorEstadoAprobacionV3.or((BooleanExpression)this.desdeMonto.isNull(), (BooleanExpression)this.hastaMonto.isNull(), (BooleanExpression[])new BooleanExpression[]{this.desdeMonto.isLessOrEqualTo((NumericExpression)this.hastaMonto)});
        this.check301.setDefaultErrorMessage("desde monto es mayor que hasta monto");
    }
}

