/*
 * Decompiled with CFR 0.152.
 */
package showcase.meta.psm;

import adalid.commons.util.LoremIpsum;
import adalid.commons.util.StrUtils;
import adalid.core.AbstractDataArtifact;
import adalid.core.Operation;
import adalid.core.Primitive;
import adalid.core.Project;
import adalid.core.annotations.AddAttributesMethod;
import adalid.core.enums.ExpressionUsage;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.IntervalizedArtifact;
import java.lang.reflect.Field;
import java.util.Map;

public class DescriptiveAttributes {
    private static final String PACKAGE = "showcase";
    private static final String description = LoremIpsum.getString();
    private static final String short_description = LoremIpsum.getString((int)500);
    private static final String shorter_description = LoremIpsum.getString((int)250);
    private static final String shortest_description = LoremIpsum.getString((int)125);

    @AddAttributesMethod
    public static void addAttributes(Project project) {
        DescriptiveAttributes.setDescriptiveAttributes((Artifact)project);
    }

    @AddAttributesMethod
    public static void addAttributes(Entity entity) {
        DescriptiveAttributes.setDescriptiveAttributes((Artifact)entity);
    }

    @AddAttributesMethod
    public static void addAttributes(Expression expression) {
        if (expression == null || expression instanceof Primitive) {
            return;
        }
        Field declaringField = expression.getDeclaringField();
        if (declaringField == null) {
            DescriptiveAttributes.setExpressionTags(expression);
        } else {
            Artifact declaringArtifact = expression.getDeclaringArtifact();
            if (declaringArtifact.getClass().getCanonicalName().startsWith(PACKAGE)) {
                boolean b1 = declaringArtifact instanceof Entity && declaringArtifact.depth() == 0;
                boolean b2 = declaringArtifact instanceof Operation;
                if (b1 || b2) {
                    DescriptiveAttributes.setDescriptiveAttributes(declaringArtifact, (Artifact)expression);
                    DescriptiveAttributes.setExpressionTags(expression);
                }
            }
        }
    }

    private static void setExpressionTags(Expression expression) {
        Map verifiedUsages = expression.getVerifiedUsageMap();
        if (!verifiedUsages.isEmpty()) {
            for (ExpressionUsage key : verifiedUsages.keySet()) {
                for (Artifact user : expression.getVerifiedUsers(key)) {
                    AbstractDataArtifact da;
                    Artifact declaringArtifact = user.getDeclaringArtifact();
                    if (declaringArtifact == null || !declaringArtifact.getClass().getCanonicalName().startsWith(PACKAGE)) continue;
                    String defaultLabel = expression.getDefaultLabel();
                    String defaultShortDescripcion = expression.getDefaultDescription();
                    String defaultDescripcion = expression.getDefaultDescription();
                    String tag = StrUtils.coalesce((String[])new String[]{defaultLabel, defaultShortDescripcion, defaultDescripcion, shortest_description});
                    if (user instanceof AbstractDataArtifact) {
                        da = (AbstractDataArtifact)user;
                        switch (key) {
                            case RENDERING_FILTER: {
                                da.setRenderingFilterTag(StrUtils.coalesce((String[])new String[]{da.getRenderingFilterTag(), tag}));
                                break;
                            }
                            case REQUIRING_FILTER: {
                                da.setRequiringFilterTag(StrUtils.coalesce((String[])new String[]{da.getRequiringFilterTag(), tag}));
                                break;
                            }
                            case MODIFYING_FILTER: {
                                da.setModifyingFilterTag(StrUtils.coalesce((String[])new String[]{da.getModifyingFilterTag(), tag}));
                                break;
                            }
                            case NULLIFYING_FILTER: {
                                da.setNullifyingFilterTag(StrUtils.coalesce((String[])new String[]{da.getNullifyingFilterTag(), tag}));
                                break;
                            }
                            case CURRENT_VALUE: {
                                da.setCurrentValueTag(StrUtils.coalesce((String[])new String[]{da.getCurrentValueTag(), tag}));
                                break;
                            }
                            case DEFAULT_VALUE: {
                                da.setDefaultValueTag(StrUtils.coalesce((String[])new String[]{da.getDefaultValueTag(), tag}));
                                break;
                            }
                            case INITIAL_VALUE: {
                                da.setInitialValueTag(StrUtils.coalesce((String[])new String[]{da.getInitialValueTag(), tag}));
                            }
                        }
                    }
                    if (!(user instanceof IntervalizedArtifact)) continue;
                    da = (IntervalizedArtifact)user;
                    switch (key) {
                        case MAX_VALUE: {
                            da.setMaximumValueTag(StrUtils.coalesce((String[])new String[]{da.getMaximumValueTag(), tag}));
                            break;
                        }
                        case MIN_VALUE: {
                            da.setMinimumValueTag(StrUtils.coalesce((String[])new String[]{da.getMinimumValueTag(), tag}));
                        }
                    }
                }
            }
        }
    }

    @AddAttributesMethod
    public static void addAttributes(Operation operation) {
        DescriptiveAttributes.setDescriptiveAttributes((Artifact)operation);
    }

    private static void setDescriptiveAttributes(Artifact artifact) {
        if (artifact.getClass().getCanonicalName().startsWith(PACKAGE)) {
            artifact.setDefaultDescription(StrUtils.coalesce((String[])new String[]{artifact.getDefaultDescription(), description}));
            artifact.setDefaultShortDescription(StrUtils.coalesce((String[])new String[]{artifact.getDefaultShortDescription(), short_description}));
        }
    }

    private static void setDescriptiveAttributes(Artifact declaringArtifact, Artifact artifact) {
        if (declaringArtifact.getClass().getCanonicalName().startsWith(PACKAGE)) {
            artifact.setDefaultShortDescription(StrUtils.coalesce((String[])new String[]{artifact.getDefaultShortDescription(), artifact.getDefaultDescription(), shortest_description}));
            artifact.setDefaultDescription(StrUtils.coalesce((String[])new String[]{artifact.getDefaultDescription(), shorter_description}));
        }
    }
}

