/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.opencorporates.schemas.OCAccountsElement;
import com.opencorporates.schemas.OCEntity;
import com.opencorporates.schemas.OCFilingDocument;
import com.opencorporates.schemas.OCOtherAttributes;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"filing_subject", "uid", "filing_date", "accounts_date", "accounts_type", "profit", "revenue", "current_assets", "total_assets", "fixed_assets", "current_liabilities", "total_liabilities", "cash_at_bank", "documents", "filing_type_name", "filing_type_code", "title", "description", "url", "source_url", "confidence", "sample_date", "retrieved_at", "currency", "language", "source_location", "other_attributes"})
public class OCAccountsStatementSchema {
    @JsonProperty(value="filing_subject")
    @Valid
    @NotNull
    private OCEntity filingSubject;
    @JsonProperty(value="uid")
    @JsonPropertyDescription(value="Unique id/reference for the filing if it has one")
    private String uid;
    @JsonProperty(value="filing_date")
    @JsonPropertyDescription(value="Date on which the filing was made \u2013 note this is not necessarily the same date as the date on which it was published or the reporting/applicable data on the information contained within it")
    @NotNull
    private LocalDate filingDate;
    @JsonProperty(value="accounts_date")
    private LocalDate accountsDate;
    @JsonProperty(value="accounts_type")
    @JsonPropertyDescription(value="The type of accounts \u2013 either annual, or quarterly, or null if not known")
    @NotNull
    private AccountsType accountsType;
    @JsonProperty(value="profit")
    @Valid
    private List<OCAccountsElement> profit = new ArrayList<OCAccountsElement>();
    @JsonProperty(value="revenue")
    private List<OCAccountsElement> revenue = new ArrayList<OCAccountsElement>();
    @JsonProperty(value="current_assets")
    private List<OCAccountsElement> currentAssets = new ArrayList<OCAccountsElement>();
    @JsonProperty(value="total_assets")
    private List<OCAccountsElement> totalAssets = new ArrayList<OCAccountsElement>();
    @JsonProperty(value="fixed_assets")
    private List<OCAccountsElement> fixedAssets = new ArrayList<OCAccountsElement>();
    @JsonProperty(value="current_liabilities")
    private List<OCAccountsElement> currentLiabilities = new ArrayList<OCAccountsElement>();
    @JsonProperty(value="total_liabilities")
    private List<OCAccountsElement> totalLiabilities = new ArrayList<OCAccountsElement>();
    @JsonProperty(value="cash_at_bank")
    private List<OCAccountsElement> cashAtBank = new ArrayList<OCAccountsElement>();
    @JsonProperty(value="documents")
    private List<OCFilingDocument> documents = new ArrayList<OCFilingDocument>();
    @JsonProperty(value="filing_type_name")
    @JsonPropertyDescription(value="The filing type in words, if given (e.g. 'Annual Return')")
    private String filingTypeName;
    @JsonProperty(value="filing_type_code")
    @JsonPropertyDescription(value="The code for filing type, if given (e.g. 'AR01')")
    private String filingTypeCode;
    @JsonProperty(value="title")
    @JsonPropertyDescription(value="The title of the filing, if given")
    private String title;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="The description or precis of the filing, if given")
    private String description;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="Persistent URL for the filing, if there is one")
    private String url;
    @JsonProperty(value="source_url")
    @JsonPropertyDescription(value="Source of the accounts, e.g. the URL of the XBRL statement, or the download dump")
    @Size(min=11)
    @NotNull
    private @Size(min=11) @NotNull String sourceUrl;
    @JsonProperty(value="confidence")
    @JsonPropertyDescription(value="Confidence in accuracy of data")
    @NotNull
    private Confidence confidence;
    @JsonProperty(value="sample_date")
    @JsonPropertyDescription(value="Date on which we know this to be true (usually date this information was retrieved from the source)")
    @NotNull
    private LocalDate sampleDate;
    @JsonProperty(value="retrieved_at")
    private LocalDate retrievedAt;
    @JsonProperty(value="currency")
    @JsonPropertyDescription(value="Standard ISO 4217 3-letter code for currency, e.g. USD, GBP, EUR")
    private String currency;
    @JsonProperty(value="language")
    @JsonPropertyDescription(value="Should be represented as two-letter ISO-639 code")
    @Size(min=2, max=2)
    private @Size(min=2, max=2) String language;
    @JsonProperty(value="source_location")
    @JsonPropertyDescription(value="If the accounts filing has been put on sources.opencorporates.com the path to the filing")
    private String sourceLocation;
    @JsonProperty(value="other_attributes")
    @JsonPropertyDescription(value="Use for other attributes for which we don't yet have curated schema attributes")
    @Valid
    private OCOtherAttributes otherAttributes;

    @JsonProperty(value="filing_subject")
    public OCEntity getFilingSubject() {
        return this.filingSubject;
    }

    @JsonProperty(value="filing_subject")
    public void setFilingSubject(OCEntity filingSubject) {
        this.filingSubject = filingSubject;
    }

    @JsonProperty(value="uid")
    public String getUid() {
        return this.uid;
    }

    @JsonProperty(value="uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    @JsonProperty(value="filing_date")
    public LocalDate getFilingDate() {
        return this.filingDate;
    }

    @JsonProperty(value="filing_date")
    public void setFilingDate(LocalDate filingDate) {
        this.filingDate = filingDate;
    }

    @JsonProperty(value="accounts_date")
    public LocalDate getAccountsDate() {
        return this.accountsDate;
    }

    @JsonProperty(value="accounts_date")
    public void setAccountsDate(LocalDate accountsDate) {
        this.accountsDate = accountsDate;
    }

    @JsonProperty(value="accounts_type")
    public AccountsType getAccountsType() {
        return this.accountsType;
    }

    @JsonProperty(value="accounts_type")
    public void setAccountsType(AccountsType accountsType) {
        this.accountsType = accountsType;
    }

    @JsonProperty(value="profit")
    public List<OCAccountsElement> getProfit() {
        return this.profit;
    }

    @JsonProperty(value="profit")
    public void setProfit(List<OCAccountsElement> profit) {
        this.profit = profit;
    }

    @JsonProperty(value="revenue")
    public List<OCAccountsElement> getRevenue() {
        return this.revenue;
    }

    @JsonProperty(value="revenue")
    public void setRevenue(List<OCAccountsElement> revenue) {
        this.revenue = revenue;
    }

    @JsonProperty(value="current_assets")
    public List<OCAccountsElement> getCurrentAssets() {
        return this.currentAssets;
    }

    @JsonProperty(value="current_assets")
    public void setCurrentAssets(List<OCAccountsElement> currentAssets) {
        this.currentAssets = currentAssets;
    }

    @JsonProperty(value="total_assets")
    public List<OCAccountsElement> getTotalAssets() {
        return this.totalAssets;
    }

    @JsonProperty(value="total_assets")
    public void setTotalAssets(List<OCAccountsElement> totalAssets) {
        this.totalAssets = totalAssets;
    }

    @JsonProperty(value="fixed_assets")
    public List<OCAccountsElement> getFixedAssets() {
        return this.fixedAssets;
    }

    @JsonProperty(value="fixed_assets")
    public void setFixedAssets(List<OCAccountsElement> fixedAssets) {
        this.fixedAssets = fixedAssets;
    }

    @JsonProperty(value="current_liabilities")
    public List<OCAccountsElement> getCurrentLiabilities() {
        return this.currentLiabilities;
    }

    @JsonProperty(value="current_liabilities")
    public void setCurrentLiabilities(List<OCAccountsElement> currentLiabilities) {
        this.currentLiabilities = currentLiabilities;
    }

    @JsonProperty(value="total_liabilities")
    public List<OCAccountsElement> getTotalLiabilities() {
        return this.totalLiabilities;
    }

    @JsonProperty(value="total_liabilities")
    public void setTotalLiabilities(List<OCAccountsElement> totalLiabilities) {
        this.totalLiabilities = totalLiabilities;
    }

    @JsonProperty(value="cash_at_bank")
    public List<OCAccountsElement> getCashAtBank() {
        return this.cashAtBank;
    }

    @JsonProperty(value="cash_at_bank")
    public void setCashAtBank(List<OCAccountsElement> cashAtBank) {
        this.cashAtBank = cashAtBank;
    }

    @JsonProperty(value="documents")
    public List<OCFilingDocument> getDocuments() {
        return this.documents;
    }

    @JsonProperty(value="documents")
    public void setDocuments(List<OCFilingDocument> documents) {
        this.documents = documents;
    }

    @JsonProperty(value="filing_type_name")
    public String getFilingTypeName() {
        return this.filingTypeName;
    }

    @JsonProperty(value="filing_type_name")
    public void setFilingTypeName(String filingTypeName) {
        this.filingTypeName = filingTypeName;
    }

    @JsonProperty(value="filing_type_code")
    public String getFilingTypeCode() {
        return this.filingTypeCode;
    }

    @JsonProperty(value="filing_type_code")
    public void setFilingTypeCode(String filingTypeCode) {
        this.filingTypeCode = filingTypeCode;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="source_url")
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    @JsonProperty(value="confidence")
    public Confidence getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="confidence")
    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    @JsonProperty(value="sample_date")
    public LocalDate getSampleDate() {
        return this.sampleDate;
    }

    @JsonProperty(value="sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    @JsonProperty(value="retrieved_at")
    public LocalDate getRetrievedAt() {
        return this.retrievedAt;
    }

    @JsonProperty(value="retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    @JsonProperty(value="source_location")
    public String getSourceLocation() {
        return this.sourceLocation;
    }

    @JsonProperty(value="source_location")
    public void setSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @JsonProperty(value="other_attributes")
    public OCOtherAttributes getOtherAttributes() {
        return this.otherAttributes;
    }

    @JsonProperty(value="other_attributes")
    public void setOtherAttributes(OCOtherAttributes otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCAccountsStatementSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("filingSubject");
        sb.append('=');
        sb.append(this.filingSubject == null ? "<null>" : this.filingSubject);
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(this.uid == null ? "<null>" : this.uid);
        sb.append(',');
        sb.append("filingDate");
        sb.append('=');
        sb.append(this.filingDate == null ? "<null>" : this.filingDate);
        sb.append(',');
        sb.append("accountsDate");
        sb.append('=');
        sb.append(this.accountsDate == null ? "<null>" : this.accountsDate);
        sb.append(',');
        sb.append("accountsType");
        sb.append('=');
        sb.append(this.accountsType == null ? "<null>" : this.accountsType);
        sb.append(',');
        sb.append("profit");
        sb.append('=');
        sb.append(this.profit == null ? "<null>" : this.profit);
        sb.append(',');
        sb.append("revenue");
        sb.append('=');
        sb.append(this.revenue == null ? "<null>" : this.revenue);
        sb.append(',');
        sb.append("currentAssets");
        sb.append('=');
        sb.append(this.currentAssets == null ? "<null>" : this.currentAssets);
        sb.append(',');
        sb.append("totalAssets");
        sb.append('=');
        sb.append(this.totalAssets == null ? "<null>" : this.totalAssets);
        sb.append(',');
        sb.append("fixedAssets");
        sb.append('=');
        sb.append(this.fixedAssets == null ? "<null>" : this.fixedAssets);
        sb.append(',');
        sb.append("currentLiabilities");
        sb.append('=');
        sb.append(this.currentLiabilities == null ? "<null>" : this.currentLiabilities);
        sb.append(',');
        sb.append("totalLiabilities");
        sb.append('=');
        sb.append(this.totalLiabilities == null ? "<null>" : this.totalLiabilities);
        sb.append(',');
        sb.append("cashAtBank");
        sb.append('=');
        sb.append(this.cashAtBank == null ? "<null>" : this.cashAtBank);
        sb.append(',');
        sb.append("documents");
        sb.append('=');
        sb.append(this.documents == null ? "<null>" : this.documents);
        sb.append(',');
        sb.append("filingTypeName");
        sb.append('=');
        sb.append(this.filingTypeName == null ? "<null>" : this.filingTypeName);
        sb.append(',');
        sb.append("filingTypeCode");
        sb.append('=');
        sb.append(this.filingTypeCode == null ? "<null>" : this.filingTypeCode);
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(this.title == null ? "<null>" : this.title);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(this.sourceUrl == null ? "<null>" : this.sourceUrl);
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(this.confidence == null ? "<null>" : this.confidence);
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(this.sampleDate == null ? "<null>" : this.sampleDate);
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(this.retrievedAt == null ? "<null>" : this.retrievedAt);
        sb.append(',');
        sb.append("currency");
        sb.append('=');
        sb.append(this.currency == null ? "<null>" : this.currency);
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(this.language == null ? "<null>" : this.language);
        sb.append(',');
        sb.append("sourceLocation");
        sb.append('=');
        sb.append(this.sourceLocation == null ? "<null>" : this.sourceLocation);
        sb.append(',');
        sb.append("otherAttributes");
        sb.append('=');
        sb.append(this.otherAttributes == null ? "<null>" : this.otherAttributes);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.totalAssets == null ? 0 : this.totalAssets.hashCode());
        result = result * 31 + (this.filingTypeName == null ? 0 : this.filingTypeName.hashCode());
        result = result * 31 + (this.filingDate == null ? 0 : this.filingDate.hashCode());
        result = result * 31 + (this.documents == null ? 0 : this.documents.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.language == null ? 0 : this.language.hashCode());
        result = result * 31 + (this.title == null ? 0 : this.title.hashCode());
        result = result * 31 + (this.otherAttributes == null ? 0 : this.otherAttributes.hashCode());
        result = result * 31 + (this.sourceUrl == null ? 0 : this.sourceUrl.hashCode());
        result = result * 31 + (this.uid == null ? 0 : this.uid.hashCode());
        result = result * 31 + (this.revenue == null ? 0 : this.revenue.hashCode());
        result = result * 31 + (this.currentLiabilities == null ? 0 : this.currentLiabilities.hashCode());
        result = result * 31 + (this.cashAtBank == null ? 0 : this.cashAtBank.hashCode());
        result = result * 31 + (this.filingTypeCode == null ? 0 : this.filingTypeCode.hashCode());
        result = result * 31 + (this.accountsType == null ? 0 : this.accountsType.hashCode());
        result = result * 31 + (this.fixedAssets == null ? 0 : this.fixedAssets.hashCode());
        result = result * 31 + (this.currency == null ? 0 : this.currency.hashCode());
        result = result * 31 + (this.profit == null ? 0 : this.profit.hashCode());
        result = result * 31 + (this.accountsDate == null ? 0 : this.accountsDate.hashCode());
        result = result * 31 + (this.confidence == null ? 0 : this.confidence.hashCode());
        result = result * 31 + (this.totalLiabilities == null ? 0 : this.totalLiabilities.hashCode());
        result = result * 31 + (this.currentAssets == null ? 0 : this.currentAssets.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        result = result * 31 + (this.retrievedAt == null ? 0 : this.retrievedAt.hashCode());
        result = result * 31 + (this.sampleDate == null ? 0 : this.sampleDate.hashCode());
        result = result * 31 + (this.sourceLocation == null ? 0 : this.sourceLocation.hashCode());
        result = result * 31 + (this.filingSubject == null ? 0 : this.filingSubject.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCAccountsStatementSchema)) {
            return false;
        }
        OCAccountsStatementSchema rhs = (OCAccountsStatementSchema)other;
        return (this.totalAssets == rhs.totalAssets || this.totalAssets != null && this.totalAssets.equals(rhs.totalAssets)) && (this.filingTypeName == rhs.filingTypeName || this.filingTypeName != null && this.filingTypeName.equals(rhs.filingTypeName)) && (this.filingDate == rhs.filingDate || this.filingDate != null && this.filingDate.equals(rhs.filingDate)) && (this.documents == rhs.documents || this.documents != null && this.documents.equals(rhs.documents)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.language == rhs.language || this.language != null && this.language.equals(rhs.language)) && (this.title == rhs.title || this.title != null && this.title.equals(rhs.title)) && (this.otherAttributes == rhs.otherAttributes || this.otherAttributes != null && this.otherAttributes.equals(rhs.otherAttributes)) && (this.sourceUrl == rhs.sourceUrl || this.sourceUrl != null && this.sourceUrl.equals(rhs.sourceUrl)) && (this.uid == rhs.uid || this.uid != null && this.uid.equals(rhs.uid)) && (this.revenue == rhs.revenue || this.revenue != null && this.revenue.equals(rhs.revenue)) && (this.currentLiabilities == rhs.currentLiabilities || this.currentLiabilities != null && this.currentLiabilities.equals(rhs.currentLiabilities)) && (this.cashAtBank == rhs.cashAtBank || this.cashAtBank != null && this.cashAtBank.equals(rhs.cashAtBank)) && (this.filingTypeCode == rhs.filingTypeCode || this.filingTypeCode != null && this.filingTypeCode.equals(rhs.filingTypeCode)) && (this.accountsType == rhs.accountsType || this.accountsType != null && this.accountsType.equals((Object)rhs.accountsType)) && (this.fixedAssets == rhs.fixedAssets || this.fixedAssets != null && this.fixedAssets.equals(rhs.fixedAssets)) && (this.currency == rhs.currency || this.currency != null && this.currency.equals(rhs.currency)) && (this.profit == rhs.profit || this.profit != null && this.profit.equals(rhs.profit)) && (this.accountsDate == rhs.accountsDate || this.accountsDate != null && this.accountsDate.equals(rhs.accountsDate)) && (this.confidence == rhs.confidence || this.confidence != null && this.confidence.equals((Object)rhs.confidence)) && (this.totalLiabilities == rhs.totalLiabilities || this.totalLiabilities != null && this.totalLiabilities.equals(rhs.totalLiabilities)) && (this.currentAssets == rhs.currentAssets || this.currentAssets != null && this.currentAssets.equals(rhs.currentAssets)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url)) && (this.retrievedAt == rhs.retrievedAt || this.retrievedAt != null && this.retrievedAt.equals(rhs.retrievedAt)) && (this.sampleDate == rhs.sampleDate || this.sampleDate != null && this.sampleDate.equals(rhs.sampleDate)) && (this.sourceLocation == rhs.sourceLocation || this.sourceLocation != null && this.sourceLocation.equals(rhs.sourceLocation)) && (this.filingSubject == rhs.filingSubject || this.filingSubject != null && this.filingSubject.equals(rhs.filingSubject));
    }

    public static enum Confidence {
        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");

        private final String value;
        private static final Map<String, Confidence> CONSTANTS;

        private Confidence(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Confidence fromValue(String value) {
            Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Confidence>();
            for (Confidence c : Confidence.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AccountsType {
        ANNUAL("annual"),
        QUARTERLY("quarterly");

        private final String value;
        private static final Map<String, AccountsType> CONSTANTS;

        private AccountsType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AccountsType fromValue(String value) {
            AccountsType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AccountsType>();
            for (AccountsType c : AccountsType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

