/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "jurisdiction", "company_number", "identifier"})
public class OCCompany {
    @JsonProperty(value="name")
    @NotNull
    private String name;
    @JsonProperty(value="jurisdiction")
    @NotNull
    private String jurisdiction;
    @JsonProperty(value="company_number")
    private String companyNumber;
    @JsonProperty(value="identifier")
    @JsonPropertyDescription(value="An official identifier paired with a code for the issuer of the identifier, e.g sec/12345")
    @Pattern(regexp="^[^/]+/[^/]+$")
    private @Pattern(regexp="^[^/]+/[^/]+$") String identifier;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="jurisdiction")
    public String getJurisdiction() {
        return this.jurisdiction;
    }

    @JsonProperty(value="jurisdiction")
    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    @JsonProperty(value="company_number")
    public String getCompanyNumber() {
        return this.companyNumber;
    }

    @JsonProperty(value="company_number")
    public void setCompanyNumber(String companyNumber) {
        this.companyNumber = companyNumber;
    }

    @JsonProperty(value="identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCCompany.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("jurisdiction");
        sb.append('=');
        sb.append(this.jurisdiction == null ? "<null>" : this.jurisdiction);
        sb.append(',');
        sb.append("companyNumber");
        sb.append('=');
        sb.append(this.companyNumber == null ? "<null>" : this.companyNumber);
        sb.append(',');
        sb.append("identifier");
        sb.append('=');
        sb.append(this.identifier == null ? "<null>" : this.identifier);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.companyNumber == null ? 0 : this.companyNumber.hashCode());
        result = result * 31 + (this.jurisdiction == null ? 0 : this.jurisdiction.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCCompany)) {
            return false;
        }
        OCCompany rhs = (OCCompany)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.identifier == rhs.identifier || this.identifier != null && this.identifier.equals(rhs.identifier)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.companyNumber == rhs.companyNumber || this.companyNumber != null && this.companyNumber.equals(rhs.companyNumber)) && (this.jurisdiction == rhs.jurisdiction || this.jurisdiction != null && this.jurisdiction.equals(rhs.jurisdiction));
    }
}

