/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.opencorporates.schemas.OCAllAttributes;
import com.opencorporates.schemas.OCAlternateRegistrationSchema;
import com.opencorporates.schemas.OCAlternativeName;
import com.opencorporates.schemas.OCCompanyAddress;
import com.opencorporates.schemas.OCFiling;
import com.opencorporates.schemas.OCIdentifier;
import com.opencorporates.schemas.OCIndustryCode;
import com.opencorporates.schemas.OCOfficer;
import com.opencorporates.schemas.OCPreviousName;
import com.opencorporates.schemas.OCShareParcel;
import com.opencorporates.schemas.OCSourceElement;
import com.opencorporates.schemas.OCSubsequentRegistrationSchema;
import com.opencorporates.schemas.OCTotalShares;
import java.net.URI;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.pubcoi.fos.aspects.OCCompanySchemaAspect;
import org.springframework.data.mongodb.core.mapping.Document;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "company_number", "jurisdiction_code", "incorporation_date", "dissolution_date", "company_type", "registry_url", "branch", "branch_status", "inactive", "current_status", "created_at", "updated_at", "retrieved_at", "opencorporates_url", "source", "agent_name", "agent_address", "alternative_names", "previous_names", "number_of_employees", "native_company_number", "registered_address_in_full", "industry_codes", "identifiers", "registered_address", "filings", "officers", "website", "telephone_number", "fax_number", "headquarters_address", "mailing_address", "share_parcels", "total_shares", "subsequent_registrations", "alternate_registrations", "all_attributes"})
@Document(collection="oc_companies")
public class OCCompanySchema {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Legal name of the company")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String name;
    @JsonProperty(value="company_number")
    @JsonPropertyDescription(value="unique identifier given by the corporate register with which it is incorporated")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String companyNumber;
    @JsonProperty(value="jurisdiction_code")
    @JsonPropertyDescription(value="Code representing the jurisdiction/company register which is the canonical record of the company\u2019s existence. Uses underscored ISO 3166-2 to represent it, e.g. es for Spain, us_de for Delaware")
    @Size(min=2, max=5)
    @NotNull
    private @Size(min=2, max=5) @NotNull String jurisdictionCode;
    @JsonProperty(value="incorporation_date")
    private LocalDate incorporationDate;
    @JsonProperty(value="dissolution_date")
    private LocalDate dissolutionDate;
    @JsonProperty(value="company_type")
    private String companyType;
    @JsonProperty(value="registry_url")
    private URI registryUrl;
    @JsonProperty(value="branch")
    @JsonPropertyDescription(value="A flag to denote whether a company is a branch entity. This should only be set if the company is a type of branch (otherwise should be null). In general the only option here is 'F' for a 'Foreign' branch, i.e. an out-of-jurisdiction entity that has registered as having a presence in the jurisdiction. In the US this is sometimes called a Foreign Corporation")
    private Branch branch;
    @JsonProperty(value="branch_status")
    private String branchStatus;
    @JsonProperty(value="inactive")
    private Boolean inactive;
    @JsonProperty(value="current_status")
    private String currentStatus;
    @JsonProperty(value="created_at")
    private OffsetDateTime createdAt;
    @JsonProperty(value="updated_at")
    private OffsetDateTime updatedAt;
    @JsonProperty(value="retrieved_at")
    @NotNull
    private OffsetDateTime retrievedAt;
    @JsonProperty(value="opencorporates_url")
    private URI opencorporatesUrl;
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="Upstream data source for OC data")
    @Valid
    private OCSourceElement source;
    @JsonProperty(value="agent_name")
    @JsonPropertyDescription(value="The 'Agent' of the company \u2013 a person or entity that is empowered to accept service for the company")
    @Size(min=1)
    private @Size(min=1) String agentName;
    @JsonProperty(value="agent_address")
    @JsonPropertyDescription(value="The address of the 'Agent', a public address to which legal papers can be served")
    @Size(min=1)
    private @Size(min=1) String agentAddress;
    @JsonProperty(value="alternative_names")
    @Valid
    private List<OCAlternativeName> alternativeNames;
    @JsonProperty(value="previous_names")
    @Valid
    private List<OCPreviousName> previousNames;
    @JsonProperty(value="number_of_employees")
    @JsonPropertyDescription(value="The number of employees")
    private Object numberOfEmployees;
    @JsonProperty(value="native_company_number")
    private String nativeCompanyNumber;
    @JsonProperty(value="registered_address_in_full")
    private String registeredAddressInFull;
    @JsonProperty(value="industry_codes")
    @Valid
    private List<OCIndustryCode> industryCodes;
    @JsonProperty(value="identifiers")
    private List<OCIdentifier> identifiers;
    @JsonProperty(value="registered_address")
    @JsonPropertyDescription(value="Used in the company-schema object (different nesting from 'company')")
    @Valid
    private OCCompanyAddress registeredAddress;
    @JsonProperty(value="filings")
    @Valid
    private List<OCFiling> filings;
    @JsonProperty(value="officers")
    @Valid
    private List<OCOfficer> officers;
    @JsonProperty(value="website")
    private Object website;
    @JsonProperty(value="telephone_number")
    @Size(min=4)
    private @Size(min=4) String telephoneNumber;
    @JsonProperty(value="fax_number")
    @Size(min=4)
    private @Size(min=4) String faxNumber;
    @JsonProperty(value="headquarters_address")
    private Object headquartersAddress;
    @JsonProperty(value="mailing_address")
    private Object mailingAddress;
    @JsonProperty(value="share_parcels")
    @Valid
    private List<OCShareParcel> shareParcels;
    @JsonProperty(value="total_shares")
    @JsonPropertyDescription(value="The total number of shares a company has issued")
    @Valid
    private OCTotalShares totalShares;
    @JsonProperty(value="subsequent_registrations")
    @Valid
    private List<OCSubsequentRegistrationSchema> subsequentRegistrations;
    @JsonProperty(value="alternate_registrations")
    @Valid
    private List<OCAlternateRegistrationSchema> alternateRegistrations;
    @JsonProperty(value="all_attributes")
    @JsonPropertyDescription(value="Other arbitrary attributes for a given company")
    @Valid
    private OCAllAttributes allAttributes;
    public String id;

    public OCCompanySchema() {
        OCCompanySchemaAspect.ajc$interFieldInit$org_pubcoi_fos_aspects_OCCompanySchemaAspect$com_opencorporates_schemas_OCCompanySchema$id(this);
        this.alternativeNames = new ArrayList<OCAlternativeName>();
        this.previousNames = new ArrayList<OCPreviousName>();
        this.industryCodes = new ArrayList<OCIndustryCode>();
        this.identifiers = new ArrayList<OCIdentifier>();
        this.filings = new ArrayList<OCFiling>();
        this.officers = new ArrayList<OCOfficer>();
        this.shareParcels = new ArrayList<OCShareParcel>();
        this.subsequentRegistrations = new ArrayList<OCSubsequentRegistrationSchema>();
        this.alternateRegistrations = new ArrayList<OCAlternateRegistrationSchema>();
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="company_number")
    public String getCompanyNumber() {
        return this.companyNumber;
    }

    @JsonProperty(value="company_number")
    public void setCompanyNumber(String companyNumber) {
        try {
            this.companyNumber = companyNumber;
        }
        finally {
            OCCompanySchemaAspect.aspectOf().ajc$after$org_pubcoi_fos_aspects_OCCompanySchemaAspect$1$6fe4e68a(this);
        }
    }

    @JsonProperty(value="jurisdiction_code")
    public String getJurisdictionCode() {
        return this.jurisdictionCode;
    }

    @JsonProperty(value="jurisdiction_code")
    public void setJurisdictionCode(String jurisdictionCode) {
        try {
            this.jurisdictionCode = jurisdictionCode;
        }
        finally {
            OCCompanySchemaAspect.aspectOf().ajc$after$org_pubcoi_fos_aspects_OCCompanySchemaAspect$2$81d32ce(this);
        }
    }

    @JsonProperty(value="incorporation_date")
    public LocalDate getIncorporationDate() {
        return this.incorporationDate;
    }

    @JsonProperty(value="incorporation_date")
    public void setIncorporationDate(LocalDate incorporationDate) {
        this.incorporationDate = incorporationDate;
    }

    @JsonProperty(value="dissolution_date")
    public LocalDate getDissolutionDate() {
        return this.dissolutionDate;
    }

    @JsonProperty(value="dissolution_date")
    public void setDissolutionDate(LocalDate dissolutionDate) {
        this.dissolutionDate = dissolutionDate;
    }

    @JsonProperty(value="company_type")
    public String getCompanyType() {
        return this.companyType;
    }

    @JsonProperty(value="company_type")
    public void setCompanyType(String companyType) {
        this.companyType = companyType;
    }

    @JsonProperty(value="registry_url")
    public URI getRegistryUrl() {
        return this.registryUrl;
    }

    @JsonProperty(value="registry_url")
    public void setRegistryUrl(URI registryUrl) {
        this.registryUrl = registryUrl;
    }

    @JsonProperty(value="branch")
    public Branch getBranch() {
        return this.branch;
    }

    @JsonProperty(value="branch")
    public void setBranch(Branch branch) {
        this.branch = branch;
    }

    @JsonProperty(value="branch_status")
    public String getBranchStatus() {
        return this.branchStatus;
    }

    @JsonProperty(value="branch_status")
    public void setBranchStatus(String branchStatus) {
        this.branchStatus = branchStatus;
    }

    @JsonProperty(value="inactive")
    public Boolean getInactive() {
        return this.inactive;
    }

    @JsonProperty(value="inactive")
    public void setInactive(Boolean inactive) {
        this.inactive = inactive;
    }

    @JsonProperty(value="current_status")
    public String getCurrentStatus() {
        return this.currentStatus;
    }

    @JsonProperty(value="current_status")
    public void setCurrentStatus(String currentStatus) {
        this.currentStatus = currentStatus;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="retrieved_at")
    public OffsetDateTime getRetrievedAt() {
        return this.retrievedAt;
    }

    @JsonProperty(value="retrieved_at")
    public void setRetrievedAt(OffsetDateTime retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    @JsonProperty(value="opencorporates_url")
    public URI getOpencorporatesUrl() {
        return this.opencorporatesUrl;
    }

    @JsonProperty(value="opencorporates_url")
    public void setOpencorporatesUrl(URI opencorporatesUrl) {
        this.opencorporatesUrl = opencorporatesUrl;
    }

    @JsonProperty(value="source")
    public OCSourceElement getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(OCSourceElement source) {
        this.source = source;
    }

    @JsonProperty(value="agent_name")
    public String getAgentName() {
        return this.agentName;
    }

    @JsonProperty(value="agent_name")
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    @JsonProperty(value="agent_address")
    public String getAgentAddress() {
        return this.agentAddress;
    }

    @JsonProperty(value="agent_address")
    public void setAgentAddress(String agentAddress) {
        this.agentAddress = agentAddress;
    }

    @JsonProperty(value="alternative_names")
    public List<OCAlternativeName> getAlternativeNames() {
        return this.alternativeNames;
    }

    @JsonProperty(value="alternative_names")
    public void setAlternativeNames(List<OCAlternativeName> alternativeNames) {
        this.alternativeNames = alternativeNames;
    }

    @JsonProperty(value="previous_names")
    public List<OCPreviousName> getPreviousNames() {
        return this.previousNames;
    }

    @JsonProperty(value="previous_names")
    public void setPreviousNames(List<OCPreviousName> previousNames) {
        this.previousNames = previousNames;
    }

    @JsonProperty(value="number_of_employees")
    public Object getNumberOfEmployees() {
        return this.numberOfEmployees;
    }

    @JsonProperty(value="number_of_employees")
    public void setNumberOfEmployees(Object numberOfEmployees) {
        this.numberOfEmployees = numberOfEmployees;
    }

    @JsonProperty(value="native_company_number")
    public String getNativeCompanyNumber() {
        return this.nativeCompanyNumber;
    }

    @JsonProperty(value="native_company_number")
    public void setNativeCompanyNumber(String nativeCompanyNumber) {
        this.nativeCompanyNumber = nativeCompanyNumber;
    }

    @JsonProperty(value="registered_address_in_full")
    public String getRegisteredAddressInFull() {
        return this.registeredAddressInFull;
    }

    @JsonProperty(value="registered_address_in_full")
    public void setRegisteredAddressInFull(String registeredAddressInFull) {
        this.registeredAddressInFull = registeredAddressInFull;
    }

    @JsonProperty(value="industry_codes")
    public List<OCIndustryCode> getIndustryCodes() {
        return this.industryCodes;
    }

    @JsonProperty(value="industry_codes")
    public void setIndustryCodes(List<OCIndustryCode> industryCodes) {
        this.industryCodes = industryCodes;
    }

    @JsonProperty(value="identifiers")
    public List<OCIdentifier> getIdentifiers() {
        return this.identifiers;
    }

    @JsonProperty(value="identifiers")
    public void setIdentifiers(List<OCIdentifier> identifiers) {
        this.identifiers = identifiers;
    }

    @JsonProperty(value="registered_address")
    public OCCompanyAddress getRegisteredAddress() {
        return this.registeredAddress;
    }

    @JsonProperty(value="registered_address")
    public void setRegisteredAddress(OCCompanyAddress registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    @JsonProperty(value="filings")
    public List<OCFiling> getFilings() {
        return this.filings;
    }

    @JsonProperty(value="filings")
    public void setFilings(List<OCFiling> filings) {
        this.filings = filings;
    }

    @JsonProperty(value="officers")
    public List<OCOfficer> getOfficers() {
        return this.officers;
    }

    @JsonProperty(value="officers")
    public void setOfficers(List<OCOfficer> officers) {
        this.officers = officers;
    }

    @JsonProperty(value="website")
    public Object getWebsite() {
        return this.website;
    }

    @JsonProperty(value="website")
    public void setWebsite(Object website) {
        this.website = website;
    }

    @JsonProperty(value="telephone_number")
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    @JsonProperty(value="telephone_number")
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    @JsonProperty(value="fax_number")
    public String getFaxNumber() {
        return this.faxNumber;
    }

    @JsonProperty(value="fax_number")
    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    @JsonProperty(value="headquarters_address")
    public Object getHeadquartersAddress() {
        return this.headquartersAddress;
    }

    @JsonProperty(value="headquarters_address")
    public void setHeadquartersAddress(Object headquartersAddress) {
        this.headquartersAddress = headquartersAddress;
    }

    @JsonProperty(value="mailing_address")
    public Object getMailingAddress() {
        return this.mailingAddress;
    }

    @JsonProperty(value="mailing_address")
    public void setMailingAddress(Object mailingAddress) {
        this.mailingAddress = mailingAddress;
    }

    @JsonProperty(value="share_parcels")
    public List<OCShareParcel> getShareParcels() {
        return this.shareParcels;
    }

    @JsonProperty(value="share_parcels")
    public void setShareParcels(List<OCShareParcel> shareParcels) {
        this.shareParcels = shareParcels;
    }

    @JsonProperty(value="total_shares")
    public OCTotalShares getTotalShares() {
        return this.totalShares;
    }

    @JsonProperty(value="total_shares")
    public void setTotalShares(OCTotalShares totalShares) {
        this.totalShares = totalShares;
    }

    @JsonProperty(value="subsequent_registrations")
    public List<OCSubsequentRegistrationSchema> getSubsequentRegistrations() {
        return this.subsequentRegistrations;
    }

    @JsonProperty(value="subsequent_registrations")
    public void setSubsequentRegistrations(List<OCSubsequentRegistrationSchema> subsequentRegistrations) {
        this.subsequentRegistrations = subsequentRegistrations;
    }

    @JsonProperty(value="alternate_registrations")
    public List<OCAlternateRegistrationSchema> getAlternateRegistrations() {
        return this.alternateRegistrations;
    }

    @JsonProperty(value="alternate_registrations")
    public void setAlternateRegistrations(List<OCAlternateRegistrationSchema> alternateRegistrations) {
        this.alternateRegistrations = alternateRegistrations;
    }

    @JsonProperty(value="all_attributes")
    public OCAllAttributes getAllAttributes() {
        return this.allAttributes;
    }

    @JsonProperty(value="all_attributes")
    public void setAllAttributes(OCAllAttributes allAttributes) {
        this.allAttributes = allAttributes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCCompanySchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("companyNumber");
        sb.append('=');
        sb.append(this.companyNumber == null ? "<null>" : this.companyNumber);
        sb.append(',');
        sb.append("jurisdictionCode");
        sb.append('=');
        sb.append(this.jurisdictionCode == null ? "<null>" : this.jurisdictionCode);
        sb.append(',');
        sb.append("incorporationDate");
        sb.append('=');
        sb.append(this.incorporationDate == null ? "<null>" : this.incorporationDate);
        sb.append(',');
        sb.append("dissolutionDate");
        sb.append('=');
        sb.append(this.dissolutionDate == null ? "<null>" : this.dissolutionDate);
        sb.append(',');
        sb.append("companyType");
        sb.append('=');
        sb.append(this.companyType == null ? "<null>" : this.companyType);
        sb.append(',');
        sb.append("registryUrl");
        sb.append('=');
        sb.append(this.registryUrl == null ? "<null>" : this.registryUrl);
        sb.append(',');
        sb.append("branch");
        sb.append('=');
        sb.append(this.branch == null ? "<null>" : this.branch);
        sb.append(',');
        sb.append("branchStatus");
        sb.append('=');
        sb.append(this.branchStatus == null ? "<null>" : this.branchStatus);
        sb.append(',');
        sb.append("inactive");
        sb.append('=');
        sb.append(this.inactive == null ? "<null>" : this.inactive);
        sb.append(',');
        sb.append("currentStatus");
        sb.append('=');
        sb.append(this.currentStatus == null ? "<null>" : this.currentStatus);
        sb.append(',');
        sb.append("createdAt");
        sb.append('=');
        sb.append(this.createdAt == null ? "<null>" : this.createdAt);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(this.retrievedAt == null ? "<null>" : this.retrievedAt);
        sb.append(',');
        sb.append("opencorporatesUrl");
        sb.append('=');
        sb.append(this.opencorporatesUrl == null ? "<null>" : this.opencorporatesUrl);
        sb.append(',');
        sb.append("source");
        sb.append('=');
        sb.append(this.source == null ? "<null>" : this.source);
        sb.append(',');
        sb.append("agentName");
        sb.append('=');
        sb.append(this.agentName == null ? "<null>" : this.agentName);
        sb.append(',');
        sb.append("agentAddress");
        sb.append('=');
        sb.append(this.agentAddress == null ? "<null>" : this.agentAddress);
        sb.append(',');
        sb.append("alternativeNames");
        sb.append('=');
        sb.append(this.alternativeNames == null ? "<null>" : this.alternativeNames);
        sb.append(',');
        sb.append("previousNames");
        sb.append('=');
        sb.append(this.previousNames == null ? "<null>" : this.previousNames);
        sb.append(',');
        sb.append("numberOfEmployees");
        sb.append('=');
        sb.append(this.numberOfEmployees == null ? "<null>" : this.numberOfEmployees);
        sb.append(',');
        sb.append("nativeCompanyNumber");
        sb.append('=');
        sb.append(this.nativeCompanyNumber == null ? "<null>" : this.nativeCompanyNumber);
        sb.append(',');
        sb.append("registeredAddressInFull");
        sb.append('=');
        sb.append(this.registeredAddressInFull == null ? "<null>" : this.registeredAddressInFull);
        sb.append(',');
        sb.append("industryCodes");
        sb.append('=');
        sb.append(this.industryCodes == null ? "<null>" : this.industryCodes);
        sb.append(',');
        sb.append("identifiers");
        sb.append('=');
        sb.append(this.identifiers == null ? "<null>" : this.identifiers);
        sb.append(',');
        sb.append("registeredAddress");
        sb.append('=');
        sb.append(this.registeredAddress == null ? "<null>" : this.registeredAddress);
        sb.append(',');
        sb.append("filings");
        sb.append('=');
        sb.append(this.filings == null ? "<null>" : this.filings);
        sb.append(',');
        sb.append("officers");
        sb.append('=');
        sb.append(this.officers == null ? "<null>" : this.officers);
        sb.append(',');
        sb.append("website");
        sb.append('=');
        sb.append(this.website == null ? "<null>" : this.website);
        sb.append(',');
        sb.append("telephoneNumber");
        sb.append('=');
        sb.append(this.telephoneNumber == null ? "<null>" : this.telephoneNumber);
        sb.append(',');
        sb.append("faxNumber");
        sb.append('=');
        sb.append(this.faxNumber == null ? "<null>" : this.faxNumber);
        sb.append(',');
        sb.append("headquartersAddress");
        sb.append('=');
        sb.append(this.headquartersAddress == null ? "<null>" : this.headquartersAddress);
        sb.append(',');
        sb.append("mailingAddress");
        sb.append('=');
        sb.append(this.mailingAddress == null ? "<null>" : this.mailingAddress);
        sb.append(',');
        sb.append("shareParcels");
        sb.append('=');
        sb.append(this.shareParcels == null ? "<null>" : this.shareParcels);
        sb.append(',');
        sb.append("totalShares");
        sb.append('=');
        sb.append(this.totalShares == null ? "<null>" : this.totalShares);
        sb.append(',');
        sb.append("subsequentRegistrations");
        sb.append('=');
        sb.append(this.subsequentRegistrations == null ? "<null>" : this.subsequentRegistrations);
        sb.append(',');
        sb.append("alternateRegistrations");
        sb.append('=');
        sb.append(this.alternateRegistrations == null ? "<null>" : this.alternateRegistrations);
        sb.append(',');
        sb.append("allAttributes");
        sb.append('=');
        sb.append(this.allAttributes == null ? "<null>" : this.allAttributes);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.telephoneNumber == null ? 0 : this.telephoneNumber.hashCode());
        result = result * 31 + (this.dissolutionDate == null ? 0 : this.dissolutionDate.hashCode());
        result = result * 31 + (this.allAttributes == null ? 0 : this.allAttributes.hashCode());
        result = result * 31 + (this.source == null ? 0 : this.source.hashCode());
        result = result * 31 + (this.industryCodes == null ? 0 : this.industryCodes.hashCode());
        result = result * 31 + (this.branch == null ? 0 : this.branch.hashCode());
        result = result * 31 + (this.createdAt == null ? 0 : this.createdAt.hashCode());
        result = result * 31 + (this.alternativeNames == null ? 0 : this.alternativeNames.hashCode());
        result = result * 31 + (this.filings == null ? 0 : this.filings.hashCode());
        result = result * 31 + (this.registeredAddress == null ? 0 : this.registeredAddress.hashCode());
        result = result * 31 + (this.inactive == null ? 0 : this.inactive.hashCode());
        result = result * 31 + (this.companyNumber == null ? 0 : this.companyNumber.hashCode());
        result = result * 31 + (this.branchStatus == null ? 0 : this.branchStatus.hashCode());
        result = result * 31 + (this.registeredAddressInFull == null ? 0 : this.registeredAddressInFull.hashCode());
        result = result * 31 + (this.incorporationDate == null ? 0 : this.incorporationDate.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        result = result * 31 + (this.officers == null ? 0 : this.officers.hashCode());
        result = result * 31 + (this.registryUrl == null ? 0 : this.registryUrl.hashCode());
        result = result * 31 + (this.agentAddress == null ? 0 : this.agentAddress.hashCode());
        result = result * 31 + (this.website == null ? 0 : this.website.hashCode());
        result = result * 31 + (this.companyType == null ? 0 : this.companyType.hashCode());
        result = result * 31 + (this.currentStatus == null ? 0 : this.currentStatus.hashCode());
        result = result * 31 + (this.identifiers == null ? 0 : this.identifiers.hashCode());
        result = result * 31 + (this.agentName == null ? 0 : this.agentName.hashCode());
        result = result * 31 + (this.headquartersAddress == null ? 0 : this.headquartersAddress.hashCode());
        result = result * 31 + (this.shareParcels == null ? 0 : this.shareParcels.hashCode());
        result = result * 31 + (this.numberOfEmployees == null ? 0 : this.numberOfEmployees.hashCode());
        result = result * 31 + (this.totalShares == null ? 0 : this.totalShares.hashCode());
        result = result * 31 + (this.opencorporatesUrl == null ? 0 : this.opencorporatesUrl.hashCode());
        result = result * 31 + (this.nativeCompanyNumber == null ? 0 : this.nativeCompanyNumber.hashCode());
        result = result * 31 + (this.retrievedAt == null ? 0 : this.retrievedAt.hashCode());
        result = result * 31 + (this.mailingAddress == null ? 0 : this.mailingAddress.hashCode());
        result = result * 31 + (this.subsequentRegistrations == null ? 0 : this.subsequentRegistrations.hashCode());
        result = result * 31 + (this.previousNames == null ? 0 : this.previousNames.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.jurisdictionCode == null ? 0 : this.jurisdictionCode.hashCode());
        result = result * 31 + (this.faxNumber == null ? 0 : this.faxNumber.hashCode());
        result = result * 31 + (this.alternateRegistrations == null ? 0 : this.alternateRegistrations.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCCompanySchema)) {
            return false;
        }
        OCCompanySchema rhs = (OCCompanySchema)other;
        return (this.telephoneNumber == rhs.telephoneNumber || this.telephoneNumber != null && this.telephoneNumber.equals(rhs.telephoneNumber)) && (this.dissolutionDate == rhs.dissolutionDate || this.dissolutionDate != null && this.dissolutionDate.equals(rhs.dissolutionDate)) && (this.allAttributes == rhs.allAttributes || this.allAttributes != null && this.allAttributes.equals(rhs.allAttributes)) && (this.source == rhs.source || this.source != null && this.source.equals(rhs.source)) && (this.industryCodes == rhs.industryCodes || this.industryCodes != null && this.industryCodes.equals(rhs.industryCodes)) && (this.branch == rhs.branch || this.branch != null && this.branch.equals((Object)rhs.branch)) && (this.createdAt == rhs.createdAt || this.createdAt != null && this.createdAt.equals(rhs.createdAt)) && (this.alternativeNames == rhs.alternativeNames || this.alternativeNames != null && this.alternativeNames.equals(rhs.alternativeNames)) && (this.filings == rhs.filings || this.filings != null && this.filings.equals(rhs.filings)) && (this.registeredAddress == rhs.registeredAddress || this.registeredAddress != null && this.registeredAddress.equals(rhs.registeredAddress)) && (this.inactive == rhs.inactive || this.inactive != null && this.inactive.equals(rhs.inactive)) && (this.companyNumber == rhs.companyNumber || this.companyNumber != null && this.companyNumber.equals(rhs.companyNumber)) && (this.branchStatus == rhs.branchStatus || this.branchStatus != null && this.branchStatus.equals(rhs.branchStatus)) && (this.registeredAddressInFull == rhs.registeredAddressInFull || this.registeredAddressInFull != null && this.registeredAddressInFull.equals(rhs.registeredAddressInFull)) && (this.incorporationDate == rhs.incorporationDate || this.incorporationDate != null && this.incorporationDate.equals(rhs.incorporationDate)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt)) && (this.officers == rhs.officers || this.officers != null && this.officers.equals(rhs.officers)) && (this.registryUrl == rhs.registryUrl || this.registryUrl != null && this.registryUrl.equals(rhs.registryUrl)) && (this.agentAddress == rhs.agentAddress || this.agentAddress != null && this.agentAddress.equals(rhs.agentAddress)) && (this.website == rhs.website || this.website != null && this.website.equals(rhs.website)) && (this.companyType == rhs.companyType || this.companyType != null && this.companyType.equals(rhs.companyType)) && (this.currentStatus == rhs.currentStatus || this.currentStatus != null && this.currentStatus.equals(rhs.currentStatus)) && (this.identifiers == rhs.identifiers || this.identifiers != null && this.identifiers.equals(rhs.identifiers)) && (this.agentName == rhs.agentName || this.agentName != null && this.agentName.equals(rhs.agentName)) && (this.headquartersAddress == rhs.headquartersAddress || this.headquartersAddress != null && this.headquartersAddress.equals(rhs.headquartersAddress)) && (this.shareParcels == rhs.shareParcels || this.shareParcels != null && this.shareParcels.equals(rhs.shareParcels)) && (this.numberOfEmployees == rhs.numberOfEmployees || this.numberOfEmployees != null && this.numberOfEmployees.equals(rhs.numberOfEmployees)) && (this.totalShares == rhs.totalShares || this.totalShares != null && this.totalShares.equals(rhs.totalShares)) && (this.opencorporatesUrl == rhs.opencorporatesUrl || this.opencorporatesUrl != null && this.opencorporatesUrl.equals(rhs.opencorporatesUrl)) && (this.nativeCompanyNumber == rhs.nativeCompanyNumber || this.nativeCompanyNumber != null && this.nativeCompanyNumber.equals(rhs.nativeCompanyNumber)) && (this.retrievedAt == rhs.retrievedAt || this.retrievedAt != null && this.retrievedAt.equals(rhs.retrievedAt)) && (this.mailingAddress == rhs.mailingAddress || this.mailingAddress != null && this.mailingAddress.equals(rhs.mailingAddress)) && (this.subsequentRegistrations == rhs.subsequentRegistrations || this.subsequentRegistrations != null && this.subsequentRegistrations.equals(rhs.subsequentRegistrations)) && (this.previousNames == rhs.previousNames || this.previousNames != null && this.previousNames.equals(rhs.previousNames)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.jurisdictionCode == rhs.jurisdictionCode || this.jurisdictionCode != null && this.jurisdictionCode.equals(rhs.jurisdictionCode)) && (this.faxNumber == rhs.faxNumber || this.faxNumber != null && this.faxNumber.equals(rhs.faxNumber)) && (this.alternateRegistrations == rhs.alternateRegistrations || this.alternateRegistrations != null && this.alternateRegistrations.equals(rhs.alternateRegistrations));
    }

    public String getId() {
        return OCCompanySchemaAspect.ajc$interMethod$org_pubcoi_fos_aspects_OCCompanySchemaAspect$com_opencorporates_schemas_OCCompanySchema$getId(this);
    }

    public static enum Branch {
        F("F"),
        L("L");

        private final String value;
        private static final Map<String, Branch> CONSTANTS;

        private Branch(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Branch fromValue(String value) {
            Branch constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Branch>();
            for (Branch c : Branch.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

