/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.opencorporates.schemas.OCCompany;
import com.opencorporates.schemas.OCFinancialPaymentDataObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"sample_date", "source_jurisdiction", "company", "data", "retrieved_at"})
public class OCFinancialPaymentSchema {
    @JsonProperty(value="sample_date")
    @NotNull
    private LocalDate sampleDate;
    @JsonProperty(value="source_jurisdiction")
    @JsonPropertyDescription(value="Jurisdiction of the source of the data")
    private String sourceJurisdiction;
    @JsonProperty(value="company")
    @JsonPropertyDescription(value="A company which is the subject of a statement")
    @Valid
    @NotNull
    private OCCompany company;
    @JsonProperty(value="data")
    @JsonPropertyDescription(value="This is an array of data objects, that is the objects which actually contain the data about the datum. Generally there will only be one element in this, although in for some types of data_types there may naturally be several releated to the same company, e.g. shareholders")
    @Valid
    @NotNull
    private List<OCFinancialPaymentDataObject> data = new ArrayList<OCFinancialPaymentDataObject>();
    @JsonProperty(value="retrieved_at")
    private LocalDate retrievedAt;

    @JsonProperty(value="sample_date")
    public LocalDate getSampleDate() {
        return this.sampleDate;
    }

    @JsonProperty(value="sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    @JsonProperty(value="source_jurisdiction")
    public String getSourceJurisdiction() {
        return this.sourceJurisdiction;
    }

    @JsonProperty(value="source_jurisdiction")
    public void setSourceJurisdiction(String sourceJurisdiction) {
        this.sourceJurisdiction = sourceJurisdiction;
    }

    @JsonProperty(value="company")
    public OCCompany getCompany() {
        return this.company;
    }

    @JsonProperty(value="company")
    public void setCompany(OCCompany company) {
        this.company = company;
    }

    @JsonProperty(value="data")
    public List<OCFinancialPaymentDataObject> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(List<OCFinancialPaymentDataObject> data) {
        this.data = data;
    }

    @JsonProperty(value="retrieved_at")
    public LocalDate getRetrievedAt() {
        return this.retrievedAt;
    }

    @JsonProperty(value="retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCFinancialPaymentSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(this.sampleDate == null ? "<null>" : this.sampleDate);
        sb.append(',');
        sb.append("sourceJurisdiction");
        sb.append('=');
        sb.append(this.sourceJurisdiction == null ? "<null>" : this.sourceJurisdiction);
        sb.append(',');
        sb.append("company");
        sb.append('=');
        sb.append(this.company == null ? "<null>" : this.company);
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(this.data == null ? "<null>" : this.data);
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(this.retrievedAt == null ? "<null>" : this.retrievedAt);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.sampleDate == null ? 0 : this.sampleDate.hashCode());
        result = result * 31 + (this.company == null ? 0 : this.company.hashCode());
        result = result * 31 + (this.sourceJurisdiction == null ? 0 : this.sourceJurisdiction.hashCode());
        result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
        result = result * 31 + (this.retrievedAt == null ? 0 : this.retrievedAt.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCFinancialPaymentSchema)) {
            return false;
        }
        OCFinancialPaymentSchema rhs = (OCFinancialPaymentSchema)other;
        return (this.sampleDate == rhs.sampleDate || this.sampleDate != null && this.sampleDate.equals(rhs.sampleDate)) && (this.company == rhs.company || this.company != null && this.company.equals(rhs.company)) && (this.sourceJurisdiction == rhs.sourceJurisdiction || this.sourceJurisdiction != null && this.sourceJurisdiction.equals(rhs.sourceJurisdiction)) && (this.data == rhs.data || this.data != null && this.data.equals(rhs.data)) && (this.retrievedAt == rhs.retrievedAt || this.retrievedAt != null && this.retrievedAt.equals(rhs.retrievedAt));
    }
}

