/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.opencorporates.schemas.OCIssue;
import java.time.LocalDate;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"identifier", "date_published", "issue"})
public class OCObject {
    @JsonProperty(value="identifier")
    @JsonPropertyDescription(value="The publisher's identifier for the notice, which may not be unique")
    @NotNull
    private Integer identifier;
    @JsonProperty(value="date_published")
    @JsonPropertyDescription(value="The date of publication of the notice")
    private LocalDate datePublished;
    @JsonProperty(value="issue")
    @JsonPropertyDescription(value="The issue of the gazette in which the notice is published. An issue contains many notices.")
    @Valid
    @NotNull
    private OCIssue issue;

    @JsonProperty(value="identifier")
    public Integer getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    public void setIdentifier(Integer identifier) {
        this.identifier = identifier;
    }

    @JsonProperty(value="date_published")
    public LocalDate getDatePublished() {
        return this.datePublished;
    }

    @JsonProperty(value="date_published")
    public void setDatePublished(LocalDate datePublished) {
        this.datePublished = datePublished;
    }

    @JsonProperty(value="issue")
    public OCIssue getIssue() {
        return this.issue;
    }

    @JsonProperty(value="issue")
    public void setIssue(OCIssue issue) {
        this.issue = issue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCObject.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("identifier");
        sb.append('=');
        sb.append(this.identifier == null ? "<null>" : this.identifier);
        sb.append(',');
        sb.append("datePublished");
        sb.append('=');
        sb.append(this.datePublished == null ? "<null>" : this.datePublished);
        sb.append(',');
        sb.append("issue");
        sb.append('=');
        sb.append(this.issue == null ? "<null>" : this.issue);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.datePublished == null ? 0 : this.datePublished.hashCode());
        result = result * 31 + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = result * 31 + (this.issue == null ? 0 : this.issue.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCObject)) {
            return false;
        }
        OCObject rhs = (OCObject)other;
        return (this.datePublished == rhs.datePublished || this.datePublished != null && this.datePublished.equals(rhs.datePublished)) && (this.identifier == rhs.identifier || this.identifier != null && this.identifier.equals(rhs.identifier)) && (this.issue == rhs.issue || this.issue != null && this.issue.equals(rhs.issue));
    }
}

