
package com.opencorporates.schemas;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * An accounts statement is a set of financials from a given accounts filing. This may be have been derived from something as extensive as an XBRL filing, or just some headline financials. The actual accounts lines are made up of arrays of accounts elements. Some, like profit or turnover are explicitly declared here, but other arbitrary ones may be added in other_attributes, and should follow the same format
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "filing_subject",
    "uid",
    "filing_date",
    "accounts_date",
    "accounts_type",
    "profit",
    "revenue",
    "current_assets",
    "total_assets",
    "fixed_assets",
    "current_liabilities",
    "total_liabilities",
    "cash_at_bank",
    "documents",
    "filing_type_name",
    "filing_type_code",
    "title",
    "description",
    "url",
    "source_url",
    "confidence",
    "sample_date",
    "retrieved_at",
    "currency",
    "language",
    "source_location",
    "other_attributes"
})
public class OCAccountsStatementSchema {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("filing_subject")
    @Valid
    @NotNull
    private OCEntity filingSubject;
    /**
     * Unique id/reference for the filing if it has one
     * 
     */
    @JsonProperty("uid")
    @JsonPropertyDescription("Unique id/reference for the filing if it has one")
    private String uid;
    /**
     * Date on which the filing was made – note this is not necessarily the same date as the date on which it was published or the reporting/applicable data on the information contained within it
     * (Required)
     * 
     */
    @JsonProperty("filing_date")
    @JsonPropertyDescription("Date on which the filing was made \u2013 note this is not necessarily the same date as the date on which it was published or the reporting/applicable data on the information contained within it")
    @NotNull
    private LocalDate filingDate;
    @JsonProperty("accounts_date")
    private LocalDate accountsDate;
    /**
     * The type of accounts – either annual, or quarterly, or null if not known
     * (Required)
     * 
     */
    @JsonProperty("accounts_type")
    @JsonPropertyDescription("The type of accounts \u2013 either annual, or quarterly, or null if not known")
    @NotNull
    private OCAccountsStatementSchema.AccountsType accountsType;
    @JsonProperty("profit")
    @Valid
    private List<OCAccountsElement> profit = new ArrayList<OCAccountsElement>();
    @JsonProperty("revenue")
    private List<OCAccountsElement> revenue = new ArrayList<OCAccountsElement>();
    @JsonProperty("current_assets")
    private List<OCAccountsElement> currentAssets = new ArrayList<OCAccountsElement>();
    @JsonProperty("total_assets")
    private List<OCAccountsElement> totalAssets = new ArrayList<OCAccountsElement>();
    @JsonProperty("fixed_assets")
    private List<OCAccountsElement> fixedAssets = new ArrayList<OCAccountsElement>();
    @JsonProperty("current_liabilities")
    private List<OCAccountsElement> currentLiabilities = new ArrayList<OCAccountsElement>();
    @JsonProperty("total_liabilities")
    private List<OCAccountsElement> totalLiabilities = new ArrayList<OCAccountsElement>();
    @JsonProperty("cash_at_bank")
    private List<OCAccountsElement> cashAtBank = new ArrayList<OCAccountsElement>();
    @JsonProperty("documents")
    private List<OCFilingDocument> documents = new ArrayList<OCFilingDocument>();
    /**
     * The filing type in words, if given (e.g. 'Annual Return')
     * 
     */
    @JsonProperty("filing_type_name")
    @JsonPropertyDescription("The filing type in words, if given (e.g. 'Annual Return')")
    private String filingTypeName;
    /**
     * The code for filing type, if given (e.g. 'AR01')
     * 
     */
    @JsonProperty("filing_type_code")
    @JsonPropertyDescription("The code for filing type, if given (e.g. 'AR01')")
    private String filingTypeCode;
    /**
     * The title of the filing, if given
     * 
     */
    @JsonProperty("title")
    @JsonPropertyDescription("The title of the filing, if given")
    private String title;
    /**
     * The description or precis of the filing, if given
     * 
     */
    @JsonProperty("description")
    @JsonPropertyDescription("The description or precis of the filing, if given")
    private String description;
    /**
     * Persistent URL for the filing, if there is one
     * 
     */
    @JsonProperty("url")
    @JsonPropertyDescription("Persistent URL for the filing, if there is one")
    private String url;
    /**
     * Source of the accounts, e.g. the URL of the XBRL statement, or the download dump
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    @JsonPropertyDescription("Source of the accounts, e.g. the URL of the XBRL statement, or the download dump")
    @Size(min = 11)
    @NotNull
    private String sourceUrl;
    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    @JsonPropertyDescription("Confidence in accuracy of data")
    @NotNull
    private OCAccountsStatementSchema.Confidence confidence;
    /**
     * Date on which we know this to be true (usually date this information was retrieved from the source)
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    @JsonPropertyDescription("Date on which we know this to be true (usually date this information was retrieved from the source)")
    @NotNull
    private LocalDate sampleDate;
    @JsonProperty("retrieved_at")
    private LocalDate retrievedAt;
    /**
     * Standard ISO 4217 3-letter code for currency, e.g. USD, GBP, EUR
     * 
     */
    @JsonProperty("currency")
    @JsonPropertyDescription("Standard ISO 4217 3-letter code for currency, e.g. USD, GBP, EUR")
    private String currency;
    /**
     * Should be represented as two-letter ISO-639 code
     * 
     */
    @JsonProperty("language")
    @JsonPropertyDescription("Should be represented as two-letter ISO-639 code")
    @Size(min = 2, max = 2)
    private String language;
    /**
     * If the accounts filing has been put on sources.opencorporates.com the path to the filing
     * 
     */
    @JsonProperty("source_location")
    @JsonPropertyDescription("If the accounts filing has been put on sources.opencorporates.com the path to the filing")
    private String sourceLocation;
    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    @JsonPropertyDescription("Use for other attributes for which we don't yet have curated schema attributes")
    @Valid
    private OCOtherAttributes otherAttributes;

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("filing_subject")
    public OCEntity getFilingSubject() {
        return filingSubject;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("filing_subject")
    public void setFilingSubject(OCEntity filingSubject) {
        this.filingSubject = filingSubject;
    }

    /**
     * Unique id/reference for the filing if it has one
     * 
     */
    @JsonProperty("uid")
    public String getUid() {
        return uid;
    }

    /**
     * Unique id/reference for the filing if it has one
     * 
     */
    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    /**
     * Date on which the filing was made – note this is not necessarily the same date as the date on which it was published or the reporting/applicable data on the information contained within it
     * (Required)
     * 
     */
    @JsonProperty("filing_date")
    public LocalDate getFilingDate() {
        return filingDate;
    }

    /**
     * Date on which the filing was made – note this is not necessarily the same date as the date on which it was published or the reporting/applicable data on the information contained within it
     * (Required)
     * 
     */
    @JsonProperty("filing_date")
    public void setFilingDate(LocalDate filingDate) {
        this.filingDate = filingDate;
    }

    @JsonProperty("accounts_date")
    public LocalDate getAccountsDate() {
        return accountsDate;
    }

    @JsonProperty("accounts_date")
    public void setAccountsDate(LocalDate accountsDate) {
        this.accountsDate = accountsDate;
    }

    /**
     * The type of accounts – either annual, or quarterly, or null if not known
     * (Required)
     * 
     */
    @JsonProperty("accounts_type")
    public OCAccountsStatementSchema.AccountsType getAccountsType() {
        return accountsType;
    }

    /**
     * The type of accounts – either annual, or quarterly, or null if not known
     * (Required)
     * 
     */
    @JsonProperty("accounts_type")
    public void setAccountsType(OCAccountsStatementSchema.AccountsType accountsType) {
        this.accountsType = accountsType;
    }

    @JsonProperty("profit")
    public List<OCAccountsElement> getProfit() {
        return profit;
    }

    @JsonProperty("profit")
    public void setProfit(List<OCAccountsElement> profit) {
        this.profit = profit;
    }

    @JsonProperty("revenue")
    public List<OCAccountsElement> getRevenue() {
        return revenue;
    }

    @JsonProperty("revenue")
    public void setRevenue(List<OCAccountsElement> revenue) {
        this.revenue = revenue;
    }

    @JsonProperty("current_assets")
    public List<OCAccountsElement> getCurrentAssets() {
        return currentAssets;
    }

    @JsonProperty("current_assets")
    public void setCurrentAssets(List<OCAccountsElement> currentAssets) {
        this.currentAssets = currentAssets;
    }

    @JsonProperty("total_assets")
    public List<OCAccountsElement> getTotalAssets() {
        return totalAssets;
    }

    @JsonProperty("total_assets")
    public void setTotalAssets(List<OCAccountsElement> totalAssets) {
        this.totalAssets = totalAssets;
    }

    @JsonProperty("fixed_assets")
    public List<OCAccountsElement> getFixedAssets() {
        return fixedAssets;
    }

    @JsonProperty("fixed_assets")
    public void setFixedAssets(List<OCAccountsElement> fixedAssets) {
        this.fixedAssets = fixedAssets;
    }

    @JsonProperty("current_liabilities")
    public List<OCAccountsElement> getCurrentLiabilities() {
        return currentLiabilities;
    }

    @JsonProperty("current_liabilities")
    public void setCurrentLiabilities(List<OCAccountsElement> currentLiabilities) {
        this.currentLiabilities = currentLiabilities;
    }

    @JsonProperty("total_liabilities")
    public List<OCAccountsElement> getTotalLiabilities() {
        return totalLiabilities;
    }

    @JsonProperty("total_liabilities")
    public void setTotalLiabilities(List<OCAccountsElement> totalLiabilities) {
        this.totalLiabilities = totalLiabilities;
    }

    @JsonProperty("cash_at_bank")
    public List<OCAccountsElement> getCashAtBank() {
        return cashAtBank;
    }

    @JsonProperty("cash_at_bank")
    public void setCashAtBank(List<OCAccountsElement> cashAtBank) {
        this.cashAtBank = cashAtBank;
    }

    @JsonProperty("documents")
    public List<OCFilingDocument> getDocuments() {
        return documents;
    }

    @JsonProperty("documents")
    public void setDocuments(List<OCFilingDocument> documents) {
        this.documents = documents;
    }

    /**
     * The filing type in words, if given (e.g. 'Annual Return')
     * 
     */
    @JsonProperty("filing_type_name")
    public String getFilingTypeName() {
        return filingTypeName;
    }

    /**
     * The filing type in words, if given (e.g. 'Annual Return')
     * 
     */
    @JsonProperty("filing_type_name")
    public void setFilingTypeName(String filingTypeName) {
        this.filingTypeName = filingTypeName;
    }

    /**
     * The code for filing type, if given (e.g. 'AR01')
     * 
     */
    @JsonProperty("filing_type_code")
    public String getFilingTypeCode() {
        return filingTypeCode;
    }

    /**
     * The code for filing type, if given (e.g. 'AR01')
     * 
     */
    @JsonProperty("filing_type_code")
    public void setFilingTypeCode(String filingTypeCode) {
        this.filingTypeCode = filingTypeCode;
    }

    /**
     * The title of the filing, if given
     * 
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * The title of the filing, if given
     * 
     */
    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * The description or precis of the filing, if given
     * 
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * The description or precis of the filing, if given
     * 
     */
    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Persistent URL for the filing, if there is one
     * 
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    /**
     * Persistent URL for the filing, if there is one
     * 
     */
    @JsonProperty("url")
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * Source of the accounts, e.g. the URL of the XBRL statement, or the download dump
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    public String getSourceUrl() {
        return sourceUrl;
    }

    /**
     * Source of the accounts, e.g. the URL of the XBRL statement, or the download dump
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    public OCAccountsStatementSchema.Confidence getConfidence() {
        return confidence;
    }

    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    public void setConfidence(OCAccountsStatementSchema.Confidence confidence) {
        this.confidence = confidence;
    }

    /**
     * Date on which we know this to be true (usually date this information was retrieved from the source)
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public LocalDate getSampleDate() {
        return sampleDate;
    }

    /**
     * Date on which we know this to be true (usually date this information was retrieved from the source)
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    @JsonProperty("retrieved_at")
    public LocalDate getRetrievedAt() {
        return retrievedAt;
    }

    @JsonProperty("retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    /**
     * Standard ISO 4217 3-letter code for currency, e.g. USD, GBP, EUR
     * 
     */
    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    /**
     * Standard ISO 4217 3-letter code for currency, e.g. USD, GBP, EUR
     * 
     */
    @JsonProperty("currency")
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    /**
     * Should be represented as two-letter ISO-639 code
     * 
     */
    @JsonProperty("language")
    public String getLanguage() {
        return language;
    }

    /**
     * Should be represented as two-letter ISO-639 code
     * 
     */
    @JsonProperty("language")
    public void setLanguage(String language) {
        this.language = language;
    }

    /**
     * If the accounts filing has been put on sources.opencorporates.com the path to the filing
     * 
     */
    @JsonProperty("source_location")
    public String getSourceLocation() {
        return sourceLocation;
    }

    /**
     * If the accounts filing has been put on sources.opencorporates.com the path to the filing
     * 
     */
    @JsonProperty("source_location")
    public void setSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    public OCOtherAttributes getOtherAttributes() {
        return otherAttributes;
    }

    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    public void setOtherAttributes(OCOtherAttributes otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCAccountsStatementSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("filingSubject");
        sb.append('=');
        sb.append(((this.filingSubject == null)?"<null>":this.filingSubject));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("filingDate");
        sb.append('=');
        sb.append(((this.filingDate == null)?"<null>":this.filingDate));
        sb.append(',');
        sb.append("accountsDate");
        sb.append('=');
        sb.append(((this.accountsDate == null)?"<null>":this.accountsDate));
        sb.append(',');
        sb.append("accountsType");
        sb.append('=');
        sb.append(((this.accountsType == null)?"<null>":this.accountsType));
        sb.append(',');
        sb.append("profit");
        sb.append('=');
        sb.append(((this.profit == null)?"<null>":this.profit));
        sb.append(',');
        sb.append("revenue");
        sb.append('=');
        sb.append(((this.revenue == null)?"<null>":this.revenue));
        sb.append(',');
        sb.append("currentAssets");
        sb.append('=');
        sb.append(((this.currentAssets == null)?"<null>":this.currentAssets));
        sb.append(',');
        sb.append("totalAssets");
        sb.append('=');
        sb.append(((this.totalAssets == null)?"<null>":this.totalAssets));
        sb.append(',');
        sb.append("fixedAssets");
        sb.append('=');
        sb.append(((this.fixedAssets == null)?"<null>":this.fixedAssets));
        sb.append(',');
        sb.append("currentLiabilities");
        sb.append('=');
        sb.append(((this.currentLiabilities == null)?"<null>":this.currentLiabilities));
        sb.append(',');
        sb.append("totalLiabilities");
        sb.append('=');
        sb.append(((this.totalLiabilities == null)?"<null>":this.totalLiabilities));
        sb.append(',');
        sb.append("cashAtBank");
        sb.append('=');
        sb.append(((this.cashAtBank == null)?"<null>":this.cashAtBank));
        sb.append(',');
        sb.append("documents");
        sb.append('=');
        sb.append(((this.documents == null)?"<null>":this.documents));
        sb.append(',');
        sb.append("filingTypeName");
        sb.append('=');
        sb.append(((this.filingTypeName == null)?"<null>":this.filingTypeName));
        sb.append(',');
        sb.append("filingTypeCode");
        sb.append('=');
        sb.append(((this.filingTypeCode == null)?"<null>":this.filingTypeCode));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(((this.sourceUrl == null)?"<null>":this.sourceUrl));
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(((this.confidence == null)?"<null>":this.confidence));
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(((this.sampleDate == null)?"<null>":this.sampleDate));
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(((this.retrievedAt == null)?"<null>":this.retrievedAt));
        sb.append(',');
        sb.append("currency");
        sb.append('=');
        sb.append(((this.currency == null)?"<null>":this.currency));
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(((this.language == null)?"<null>":this.language));
        sb.append(',');
        sb.append("sourceLocation");
        sb.append('=');
        sb.append(((this.sourceLocation == null)?"<null>":this.sourceLocation));
        sb.append(',');
        sb.append("otherAttributes");
        sb.append('=');
        sb.append(((this.otherAttributes == null)?"<null>":this.otherAttributes));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.totalAssets == null)? 0 :this.totalAssets.hashCode()));
        result = ((result* 31)+((this.filingTypeName == null)? 0 :this.filingTypeName.hashCode()));
        result = ((result* 31)+((this.filingDate == null)? 0 :this.filingDate.hashCode()));
        result = ((result* 31)+((this.documents == null)? 0 :this.documents.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.language == null)? 0 :this.language.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.otherAttributes == null)? 0 :this.otherAttributes.hashCode()));
        result = ((result* 31)+((this.sourceUrl == null)? 0 :this.sourceUrl.hashCode()));
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.revenue == null)? 0 :this.revenue.hashCode()));
        result = ((result* 31)+((this.currentLiabilities == null)? 0 :this.currentLiabilities.hashCode()));
        result = ((result* 31)+((this.cashAtBank == null)? 0 :this.cashAtBank.hashCode()));
        result = ((result* 31)+((this.filingTypeCode == null)? 0 :this.filingTypeCode.hashCode()));
        result = ((result* 31)+((this.accountsType == null)? 0 :this.accountsType.hashCode()));
        result = ((result* 31)+((this.fixedAssets == null)? 0 :this.fixedAssets.hashCode()));
        result = ((result* 31)+((this.currency == null)? 0 :this.currency.hashCode()));
        result = ((result* 31)+((this.profit == null)? 0 :this.profit.hashCode()));
        result = ((result* 31)+((this.accountsDate == null)? 0 :this.accountsDate.hashCode()));
        result = ((result* 31)+((this.confidence == null)? 0 :this.confidence.hashCode()));
        result = ((result* 31)+((this.totalLiabilities == null)? 0 :this.totalLiabilities.hashCode()));
        result = ((result* 31)+((this.currentAssets == null)? 0 :this.currentAssets.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        result = ((result* 31)+((this.retrievedAt == null)? 0 :this.retrievedAt.hashCode()));
        result = ((result* 31)+((this.sampleDate == null)? 0 :this.sampleDate.hashCode()));
        result = ((result* 31)+((this.sourceLocation == null)? 0 :this.sourceLocation.hashCode()));
        result = ((result* 31)+((this.filingSubject == null)? 0 :this.filingSubject.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCAccountsStatementSchema) == false) {
            return false;
        }
        OCAccountsStatementSchema rhs = ((OCAccountsStatementSchema) other);
        return ((((((((((((((((((((((((((((this.totalAssets == rhs.totalAssets)||((this.totalAssets!= null)&&this.totalAssets.equals(rhs.totalAssets)))&&((this.filingTypeName == rhs.filingTypeName)||((this.filingTypeName!= null)&&this.filingTypeName.equals(rhs.filingTypeName))))&&((this.filingDate == rhs.filingDate)||((this.filingDate!= null)&&this.filingDate.equals(rhs.filingDate))))&&((this.documents == rhs.documents)||((this.documents!= null)&&this.documents.equals(rhs.documents))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.language == rhs.language)||((this.language!= null)&&this.language.equals(rhs.language))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.otherAttributes == rhs.otherAttributes)||((this.otherAttributes!= null)&&this.otherAttributes.equals(rhs.otherAttributes))))&&((this.sourceUrl == rhs.sourceUrl)||((this.sourceUrl!= null)&&this.sourceUrl.equals(rhs.sourceUrl))))&&((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid))))&&((this.revenue == rhs.revenue)||((this.revenue!= null)&&this.revenue.equals(rhs.revenue))))&&((this.currentLiabilities == rhs.currentLiabilities)||((this.currentLiabilities!= null)&&this.currentLiabilities.equals(rhs.currentLiabilities))))&&((this.cashAtBank == rhs.cashAtBank)||((this.cashAtBank!= null)&&this.cashAtBank.equals(rhs.cashAtBank))))&&((this.filingTypeCode == rhs.filingTypeCode)||((this.filingTypeCode!= null)&&this.filingTypeCode.equals(rhs.filingTypeCode))))&&((this.accountsType == rhs.accountsType)||((this.accountsType!= null)&&this.accountsType.equals(rhs.accountsType))))&&((this.fixedAssets == rhs.fixedAssets)||((this.fixedAssets!= null)&&this.fixedAssets.equals(rhs.fixedAssets))))&&((this.currency == rhs.currency)||((this.currency!= null)&&this.currency.equals(rhs.currency))))&&((this.profit == rhs.profit)||((this.profit!= null)&&this.profit.equals(rhs.profit))))&&((this.accountsDate == rhs.accountsDate)||((this.accountsDate!= null)&&this.accountsDate.equals(rhs.accountsDate))))&&((this.confidence == rhs.confidence)||((this.confidence!= null)&&this.confidence.equals(rhs.confidence))))&&((this.totalLiabilities == rhs.totalLiabilities)||((this.totalLiabilities!= null)&&this.totalLiabilities.equals(rhs.totalLiabilities))))&&((this.currentAssets == rhs.currentAssets)||((this.currentAssets!= null)&&this.currentAssets.equals(rhs.currentAssets))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))))&&((this.retrievedAt == rhs.retrievedAt)||((this.retrievedAt!= null)&&this.retrievedAt.equals(rhs.retrievedAt))))&&((this.sampleDate == rhs.sampleDate)||((this.sampleDate!= null)&&this.sampleDate.equals(rhs.sampleDate))))&&((this.sourceLocation == rhs.sourceLocation)||((this.sourceLocation!= null)&&this.sourceLocation.equals(rhs.sourceLocation))))&&((this.filingSubject == rhs.filingSubject)||((this.filingSubject!= null)&&this.filingSubject.equals(rhs.filingSubject))));
    }


    /**
     * The type of accounts – either annual, or quarterly, or null if not known
     * 
     */
    public enum AccountsType {

        ANNUAL("annual"),
        QUARTERLY("quarterly");
        private final String value;
        private final static Map<String, OCAccountsStatementSchema.AccountsType> CONSTANTS = new HashMap<String, OCAccountsStatementSchema.AccountsType>();

        static {
            for (OCAccountsStatementSchema.AccountsType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private AccountsType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCAccountsStatementSchema.AccountsType fromValue(String value) {
            OCAccountsStatementSchema.AccountsType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }


    /**
     * Confidence in accuracy of data
     * 
     */
    public enum Confidence {

        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");
        private final String value;
        private final static Map<String, OCAccountsStatementSchema.Confidence> CONSTANTS = new HashMap<String, OCAccountsStatementSchema.Confidence>();

        static {
            for (OCAccountsStatementSchema.Confidence c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Confidence(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCAccountsStatementSchema.Confidence fromValue(String value) {
            OCAccountsStatementSchema.Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
