
package com.opencorporates.schemas;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * A Control Statement is a statement by a company or entity about a the control of a company. In its most straightforward, Company A may say that Entity B controls it. Each statement should be about a single control relationship, i.e. if Company A has two controlling entities, B and C, and those   control relationships are distinct (e.g. they started at a different time) then they should each be stored as a indiviudal Control Statements. They should only be stored in the same Control Statement if it is logically part of the same control mechanism, e.g. if company A is controlled by person C and person D, who control the shares *jointly*. Control Statements can be used to describe that an entity has no controlling entity, or that the controlling entity is not disclosed. Beneficial Ownership is a specific example of control relationships, and the ultimate_beneficial_owner flag can be used to signify that a person is the Ultimate Beneficial Owner of a company
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "subject_entity",
    "control_level",
    "ultimate_beneficial_owner",
    "controlling_entities",
    "control_mechanisms",
    "no_controlling_entities_reasons",
    "uid",
    "url",
    "source_url",
    "confidence",
    "start_date",
    "start_date_type",
    "end_date",
    "end_date_type",
    "retrieved_at",
    "sample_date",
    "other_attributes"
})
public class OCControlStatementSchema {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("subject_entity")
    @Valid
    @NotNull
    private OCEntity subjectEntity;
    /**
     * The level of control, i.e. whether the control is direct (i.e. there are no intermediaries), indirect (there are intermediaries) or unknown. It can be null in the case where a company is saying that there are no controlling entities
     * (Required)
     * 
     */
    @JsonProperty("control_level")
    @JsonPropertyDescription("The level of control, i.e. whether the control is direct (i.e. there are no intermediaries), indirect (there are intermediaries) or unknown. It can be null in the case where a company is saying that there are no controlling entities")
    @NotNull
    private OCControlStatementSchema.ControlLevel controlLevel;
    /**
     * Whether the controlling entities are the ultimate beneficial owners (i.e. individuals who ultimately control the company)
     * 
     */
    @JsonProperty("ultimate_beneficial_owner")
    @JsonPropertyDescription("Whether the controlling entities are the ultimate beneficial owners (i.e. individuals who ultimately control the company)")
    private Boolean ultimateBeneficialOwner;
    @JsonProperty("controlling_entities")
    @Valid
    private List<OCEntity> controllingEntities = new ArrayList<OCEntity>();
    /**
     * The mechanism(s) by which the controlling party/parties control the company
     * 
     */
    @JsonProperty("control_mechanisms")
    @JsonPropertyDescription("The mechanism(s) by which the controlling party/parties control the company")
    @Valid
    private List<Object> controlMechanisms = new ArrayList<Object>();
    /**
     * The reason why no controlling entities are declared, for example because the entity has been unable to discover them, or there are no controlling entities (e.g. 100 people owned 1% each), or the companies is exempt from reporting (as some listed companies are in some jurisdictions)
     * 
     */
    @JsonProperty("no_controlling_entities_reasons")
    @JsonPropertyDescription("The reason why no controlling entities are declared, for example because the entity has been unable to discover them, or there are no controlling entities (e.g. 100 people owned 1% each), or the companies is exempt from reporting (as some listed companies are in some jurisdictions)")
    @Valid
    private List<String> noControllingEntitiesReasons = new ArrayList<String>();
    /**
     * Unique id/reference for the control relationship entity record if the external source has given it one
     * 
     */
    @JsonProperty("uid")
    @JsonPropertyDescription("Unique id/reference for the control relationship entity record if the external source has given it one")
    private String uid;
    /**
     * Persistent URL on the external source for the control relationship entity record, if there is one
     * 
     */
    @JsonProperty("url")
    @JsonPropertyDescription("Persistent URL on the external source for the control relationship entity record, if there is one")
    private String url;
    /**
     * Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    @JsonPropertyDescription("Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.")
    @Size(min = 11)
    @NotNull
    private String sourceUrl;
    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    @JsonPropertyDescription("Confidence in accuracy of data")
    @NotNull
    private OCControlStatementSchema.Confidence confidence;
    /**
     * Date on which control started
     * 
     */
    @JsonProperty("start_date")
    @JsonPropertyDescription("Date on which control started")
    private LocalDate startDate;
    @JsonProperty("start_date_type")
    private OCControlStatementSchema.StartDateType startDateType;
    /**
     * Date on which control ended
     * 
     */
    @JsonProperty("end_date")
    @JsonPropertyDescription("Date on which control ended")
    private LocalDate endDate;
    @JsonProperty("end_date_type")
    private OCControlStatementSchema.EndDateType endDateType;
    /**
     * Date-time this was retrieved from the source
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    @JsonPropertyDescription("Date-time this was retrieved from the source")
    @NotNull
    private OffsetDateTime retrievedAt;
    /**
     * Date on which we know this to be true (for example the date the control statement was published)
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    @JsonPropertyDescription("Date on which we know this to be true (for example the date the control statement was published)")
    @NotNull
    private LocalDate sampleDate;
    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    @JsonPropertyDescription("Use for other attributes for which we don't yet have curated schema attributes")
    @Valid
    private OCOtherAttributes__2 otherAttributes;

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("subject_entity")
    public OCEntity getSubjectEntity() {
        return subjectEntity;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("subject_entity")
    public void setSubjectEntity(OCEntity subjectEntity) {
        this.subjectEntity = subjectEntity;
    }

    /**
     * The level of control, i.e. whether the control is direct (i.e. there are no intermediaries), indirect (there are intermediaries) or unknown. It can be null in the case where a company is saying that there are no controlling entities
     * (Required)
     * 
     */
    @JsonProperty("control_level")
    public OCControlStatementSchema.ControlLevel getControlLevel() {
        return controlLevel;
    }

    /**
     * The level of control, i.e. whether the control is direct (i.e. there are no intermediaries), indirect (there are intermediaries) or unknown. It can be null in the case where a company is saying that there are no controlling entities
     * (Required)
     * 
     */
    @JsonProperty("control_level")
    public void setControlLevel(OCControlStatementSchema.ControlLevel controlLevel) {
        this.controlLevel = controlLevel;
    }

    /**
     * Whether the controlling entities are the ultimate beneficial owners (i.e. individuals who ultimately control the company)
     * 
     */
    @JsonProperty("ultimate_beneficial_owner")
    public Boolean getUltimateBeneficialOwner() {
        return ultimateBeneficialOwner;
    }

    /**
     * Whether the controlling entities are the ultimate beneficial owners (i.e. individuals who ultimately control the company)
     * 
     */
    @JsonProperty("ultimate_beneficial_owner")
    public void setUltimateBeneficialOwner(Boolean ultimateBeneficialOwner) {
        this.ultimateBeneficialOwner = ultimateBeneficialOwner;
    }

    @JsonProperty("controlling_entities")
    public List<OCEntity> getControllingEntities() {
        return controllingEntities;
    }

    @JsonProperty("controlling_entities")
    public void setControllingEntities(List<OCEntity> controllingEntities) {
        this.controllingEntities = controllingEntities;
    }

    /**
     * The mechanism(s) by which the controlling party/parties control the company
     * 
     */
    @JsonProperty("control_mechanisms")
    public List<Object> getControlMechanisms() {
        return controlMechanisms;
    }

    /**
     * The mechanism(s) by which the controlling party/parties control the company
     * 
     */
    @JsonProperty("control_mechanisms")
    public void setControlMechanisms(List<Object> controlMechanisms) {
        this.controlMechanisms = controlMechanisms;
    }

    /**
     * The reason why no controlling entities are declared, for example because the entity has been unable to discover them, or there are no controlling entities (e.g. 100 people owned 1% each), or the companies is exempt from reporting (as some listed companies are in some jurisdictions)
     * 
     */
    @JsonProperty("no_controlling_entities_reasons")
    public List<String> getNoControllingEntitiesReasons() {
        return noControllingEntitiesReasons;
    }

    /**
     * The reason why no controlling entities are declared, for example because the entity has been unable to discover them, or there are no controlling entities (e.g. 100 people owned 1% each), or the companies is exempt from reporting (as some listed companies are in some jurisdictions)
     * 
     */
    @JsonProperty("no_controlling_entities_reasons")
    public void setNoControllingEntitiesReasons(List<String> noControllingEntitiesReasons) {
        this.noControllingEntitiesReasons = noControllingEntitiesReasons;
    }

    /**
     * Unique id/reference for the control relationship entity record if the external source has given it one
     * 
     */
    @JsonProperty("uid")
    public String getUid() {
        return uid;
    }

    /**
     * Unique id/reference for the control relationship entity record if the external source has given it one
     * 
     */
    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    /**
     * Persistent URL on the external source for the control relationship entity record, if there is one
     * 
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    /**
     * Persistent URL on the external source for the control relationship entity record, if there is one
     * 
     */
    @JsonProperty("url")
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    public String getSourceUrl() {
        return sourceUrl;
    }

    /**
     * Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    public OCControlStatementSchema.Confidence getConfidence() {
        return confidence;
    }

    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    public void setConfidence(OCControlStatementSchema.Confidence confidence) {
        this.confidence = confidence;
    }

    /**
     * Date on which control started
     * 
     */
    @JsonProperty("start_date")
    public LocalDate getStartDate() {
        return startDate;
    }

    /**
     * Date on which control started
     * 
     */
    @JsonProperty("start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @JsonProperty("start_date_type")
    public OCControlStatementSchema.StartDateType getStartDateType() {
        return startDateType;
    }

    @JsonProperty("start_date_type")
    public void setStartDateType(OCControlStatementSchema.StartDateType startDateType) {
        this.startDateType = startDateType;
    }

    /**
     * Date on which control ended
     * 
     */
    @JsonProperty("end_date")
    public LocalDate getEndDate() {
        return endDate;
    }

    /**
     * Date on which control ended
     * 
     */
    @JsonProperty("end_date")
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    @JsonProperty("end_date_type")
    public OCControlStatementSchema.EndDateType getEndDateType() {
        return endDateType;
    }

    @JsonProperty("end_date_type")
    public void setEndDateType(OCControlStatementSchema.EndDateType endDateType) {
        this.endDateType = endDateType;
    }

    /**
     * Date-time this was retrieved from the source
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    public OffsetDateTime getRetrievedAt() {
        return retrievedAt;
    }

    /**
     * Date-time this was retrieved from the source
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    public void setRetrievedAt(OffsetDateTime retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    /**
     * Date on which we know this to be true (for example the date the control statement was published)
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public LocalDate getSampleDate() {
        return sampleDate;
    }

    /**
     * Date on which we know this to be true (for example the date the control statement was published)
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    public OCOtherAttributes__2 getOtherAttributes() {
        return otherAttributes;
    }

    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    public void setOtherAttributes(OCOtherAttributes__2 otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCControlStatementSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("subjectEntity");
        sb.append('=');
        sb.append(((this.subjectEntity == null)?"<null>":this.subjectEntity));
        sb.append(',');
        sb.append("controlLevel");
        sb.append('=');
        sb.append(((this.controlLevel == null)?"<null>":this.controlLevel));
        sb.append(',');
        sb.append("ultimateBeneficialOwner");
        sb.append('=');
        sb.append(((this.ultimateBeneficialOwner == null)?"<null>":this.ultimateBeneficialOwner));
        sb.append(',');
        sb.append("controllingEntities");
        sb.append('=');
        sb.append(((this.controllingEntities == null)?"<null>":this.controllingEntities));
        sb.append(',');
        sb.append("controlMechanisms");
        sb.append('=');
        sb.append(((this.controlMechanisms == null)?"<null>":this.controlMechanisms));
        sb.append(',');
        sb.append("noControllingEntitiesReasons");
        sb.append('=');
        sb.append(((this.noControllingEntitiesReasons == null)?"<null>":this.noControllingEntitiesReasons));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(((this.sourceUrl == null)?"<null>":this.sourceUrl));
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(((this.confidence == null)?"<null>":this.confidence));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("startDateType");
        sb.append('=');
        sb.append(((this.startDateType == null)?"<null>":this.startDateType));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("endDateType");
        sb.append('=');
        sb.append(((this.endDateType == null)?"<null>":this.endDateType));
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(((this.retrievedAt == null)?"<null>":this.retrievedAt));
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(((this.sampleDate == null)?"<null>":this.sampleDate));
        sb.append(',');
        sb.append("otherAttributes");
        sb.append('=');
        sb.append(((this.otherAttributes == null)?"<null>":this.otherAttributes));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.subjectEntity == null)? 0 :this.subjectEntity.hashCode()));
        result = ((result* 31)+((this.startDateType == null)? 0 :this.startDateType.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.confidence == null)? 0 :this.confidence.hashCode()));
        result = ((result* 31)+((this.ultimateBeneficialOwner == null)? 0 :this.ultimateBeneficialOwner.hashCode()));
        result = ((result* 31)+((this.noControllingEntitiesReasons == null)? 0 :this.noControllingEntitiesReasons.hashCode()));
        result = ((result* 31)+((this.otherAttributes == null)? 0 :this.otherAttributes.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        result = ((result* 31)+((this.sourceUrl == null)? 0 :this.sourceUrl.hashCode()));
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.controllingEntities == null)? 0 :this.controllingEntities.hashCode()));
        result = ((result* 31)+((this.retrievedAt == null)? 0 :this.retrievedAt.hashCode()));
        result = ((result* 31)+((this.controlLevel == null)? 0 :this.controlLevel.hashCode()));
        result = ((result* 31)+((this.sampleDate == null)? 0 :this.sampleDate.hashCode()));
        result = ((result* 31)+((this.endDateType == null)? 0 :this.endDateType.hashCode()));
        result = ((result* 31)+((this.controlMechanisms == null)? 0 :this.controlMechanisms.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCControlStatementSchema) == false) {
            return false;
        }
        OCControlStatementSchema rhs = ((OCControlStatementSchema) other);
        return ((((((((((((((((((this.subjectEntity == rhs.subjectEntity)||((this.subjectEntity!= null)&&this.subjectEntity.equals(rhs.subjectEntity)))&&((this.startDateType == rhs.startDateType)||((this.startDateType!= null)&&this.startDateType.equals(rhs.startDateType))))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.confidence == rhs.confidence)||((this.confidence!= null)&&this.confidence.equals(rhs.confidence))))&&((this.ultimateBeneficialOwner == rhs.ultimateBeneficialOwner)||((this.ultimateBeneficialOwner!= null)&&this.ultimateBeneficialOwner.equals(rhs.ultimateBeneficialOwner))))&&((this.noControllingEntitiesReasons == rhs.noControllingEntitiesReasons)||((this.noControllingEntitiesReasons!= null)&&this.noControllingEntitiesReasons.equals(rhs.noControllingEntitiesReasons))))&&((this.otherAttributes == rhs.otherAttributes)||((this.otherAttributes!= null)&&this.otherAttributes.equals(rhs.otherAttributes))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))))&&((this.sourceUrl == rhs.sourceUrl)||((this.sourceUrl!= null)&&this.sourceUrl.equals(rhs.sourceUrl))))&&((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid))))&&((this.controllingEntities == rhs.controllingEntities)||((this.controllingEntities!= null)&&this.controllingEntities.equals(rhs.controllingEntities))))&&((this.retrievedAt == rhs.retrievedAt)||((this.retrievedAt!= null)&&this.retrievedAt.equals(rhs.retrievedAt))))&&((this.controlLevel == rhs.controlLevel)||((this.controlLevel!= null)&&this.controlLevel.equals(rhs.controlLevel))))&&((this.sampleDate == rhs.sampleDate)||((this.sampleDate!= null)&&this.sampleDate.equals(rhs.sampleDate))))&&((this.endDateType == rhs.endDateType)||((this.endDateType!= null)&&this.endDateType.equals(rhs.endDateType))))&&((this.controlMechanisms == rhs.controlMechanisms)||((this.controlMechanisms!= null)&&this.controlMechanisms.equals(rhs.controlMechanisms))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))));
    }


    /**
     * Confidence in accuracy of data
     * 
     */
    public enum Confidence {

        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");
        private final String value;
        private final static Map<String, OCControlStatementSchema.Confidence> CONSTANTS = new HashMap<String, OCControlStatementSchema.Confidence>();

        static {
            for (OCControlStatementSchema.Confidence c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Confidence(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCControlStatementSchema.Confidence fromValue(String value) {
            OCControlStatementSchema.Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }


    /**
     * The level of control, i.e. whether the control is direct (i.e. there are no intermediaries), indirect (there are intermediaries) or unknown. It can be null in the case where a company is saying that there are no controlling entities
     * 
     */
    public enum ControlLevel {

        DIRECT("direct"),
        INDIRECT("indirect"),
        UNKNOWN("unknown");
        private final String value;
        private final static Map<String, OCControlStatementSchema.ControlLevel> CONSTANTS = new HashMap<String, OCControlStatementSchema.ControlLevel>();

        static {
            for (OCControlStatementSchema.ControlLevel c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private ControlLevel(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCControlStatementSchema.ControlLevel fromValue(String value) {
            OCControlStatementSchema.ControlLevel constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum EndDateType {

        AT("at"),
        BEFORE("before"),
        AFTER("after");
        private final String value;
        private final static Map<String, OCControlStatementSchema.EndDateType> CONSTANTS = new HashMap<String, OCControlStatementSchema.EndDateType>();

        static {
            for (OCControlStatementSchema.EndDateType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private EndDateType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCControlStatementSchema.EndDateType fromValue(String value) {
            OCControlStatementSchema.EndDateType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum StartDateType {

        AT("at"),
        BEFORE("before"),
        AFTER("after");
        private final String value;
        private final static Map<String, OCControlStatementSchema.StartDateType> CONSTANTS = new HashMap<String, OCControlStatementSchema.StartDateType>();

        static {
            for (OCControlStatementSchema.StartDateType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private StartDateType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCControlStatementSchema.StartDateType fromValue(String value) {
            OCControlStatementSchema.StartDateType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
