
package com.opencorporates.schemas;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * A filing is a document or set of documents published or submitted to registers or regulators by end entity. The standard example is an annual report detailing the companies activities. The filing object is for storing the meta data about the filing (e.g. filing date, filing type, title perhaps). There are also commonly associated documents with filings - often just one, but it's not unusual for there to be more than one, either because there are multiple supporting documents for the filing (e.g. SEC filings and FERC filings), or because there are multiple versions of the same file (e.g. PDF and XBRL file)
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "filing_subject",
    "filing_date",
    "documents",
    "uid",
    "filing_type_name",
    "filing_type_code",
    "corporate_register_filing",
    "title",
    "description",
    "url",
    "source_url",
    "confidence",
    "sample_date",
    "retrieved_at",
    "other_attributes"
})
public class OCFilingSchema {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("filing_subject")
    @Valid
    @NotNull
    private OCEntity filingSubject;
    /**
     * Date on which the filing was made – note this is not necessarily the same date as the date on which it was published or the reporting/applicable data on the information contained within it
     * (Required)
     * 
     */
    @JsonProperty("filing_date")
    @JsonPropertyDescription("Date on which the filing was made \u2013 note this is not necessarily the same date as the date on which it was published or the reporting/applicable data on the information contained within it")
    @NotNull
    private LocalDate filingDate;
    @JsonProperty("documents")
    @Valid
    private List<OCFilingDocument> documents = new ArrayList<OCFilingDocument>();
    /**
     * Unique id/reference for the filing if it has one
     * 
     */
    @JsonProperty("uid")
    @JsonPropertyDescription("Unique id/reference for the filing if it has one")
    private String uid;
    /**
     * The filing type in words, if given (e.g. 'Annual Return')
     * 
     */
    @JsonProperty("filing_type_name")
    @JsonPropertyDescription("The filing type in words, if given (e.g. 'Annual Return')")
    private String filingTypeName;
    /**
     * The code for filing type, if given (e.g. 'AR01')
     * 
     */
    @JsonProperty("filing_type_code")
    @JsonPropertyDescription("The code for filing type, if given (e.g. 'AR01')")
    private String filingTypeCode;
    /**
     * Whether the source of the filing is the corporate register where the company is incorporated/registered with
     * 
     */
    @JsonProperty("corporate_register_filing")
    @JsonPropertyDescription("Whether the source of the filing is the corporate register where the company is incorporated/registered with")
    private Boolean corporateRegisterFiling;
    /**
     * The title of the filing, if given
     * 
     */
    @JsonProperty("title")
    @JsonPropertyDescription("The title of the filing, if given")
    private String title;
    /**
     * The description or precis of the filing, if given
     * 
     */
    @JsonProperty("description")
    @JsonPropertyDescription("The description or precis of the filing, if given")
    private String description;
    /**
     * Persistent URL for the filing, if there is one
     * 
     */
    @JsonProperty("url")
    @JsonPropertyDescription("Persistent URL for the filing, if there is one")
    private String url;
    /**
     * Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    @JsonPropertyDescription("Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.")
    @Size(min = 11)
    @NotNull
    private String sourceUrl;
    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    @JsonPropertyDescription("Confidence in accuracy of data")
    @NotNull
    private OCFilingSchema.Confidence confidence;
    /**
     * Date on which we believe the contents of this filing to be true, e.g. the reporting date, applicable date
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    @JsonPropertyDescription("Date on which we believe the contents of this filing to be true, e.g. the reporting date, applicable date")
    @NotNull
    private LocalDate sampleDate;
    /**
     * The time or date at which the source URL was requested
     * 
     */
    @JsonProperty("retrieved_at")
    @JsonPropertyDescription("The time or date at which the source URL was requested")
    private LocalDate retrievedAt;
    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    @JsonPropertyDescription("Use for other attributes for which we don't yet have curated schema attributes")
    @Valid
    private OCOtherAttributes__3 otherAttributes;

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("filing_subject")
    public OCEntity getFilingSubject() {
        return filingSubject;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("filing_subject")
    public void setFilingSubject(OCEntity filingSubject) {
        this.filingSubject = filingSubject;
    }

    /**
     * Date on which the filing was made – note this is not necessarily the same date as the date on which it was published or the reporting/applicable data on the information contained within it
     * (Required)
     * 
     */
    @JsonProperty("filing_date")
    public LocalDate getFilingDate() {
        return filingDate;
    }

    /**
     * Date on which the filing was made – note this is not necessarily the same date as the date on which it was published or the reporting/applicable data on the information contained within it
     * (Required)
     * 
     */
    @JsonProperty("filing_date")
    public void setFilingDate(LocalDate filingDate) {
        this.filingDate = filingDate;
    }

    @JsonProperty("documents")
    public List<OCFilingDocument> getDocuments() {
        return documents;
    }

    @JsonProperty("documents")
    public void setDocuments(List<OCFilingDocument> documents) {
        this.documents = documents;
    }

    /**
     * Unique id/reference for the filing if it has one
     * 
     */
    @JsonProperty("uid")
    public String getUid() {
        return uid;
    }

    /**
     * Unique id/reference for the filing if it has one
     * 
     */
    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    /**
     * The filing type in words, if given (e.g. 'Annual Return')
     * 
     */
    @JsonProperty("filing_type_name")
    public String getFilingTypeName() {
        return filingTypeName;
    }

    /**
     * The filing type in words, if given (e.g. 'Annual Return')
     * 
     */
    @JsonProperty("filing_type_name")
    public void setFilingTypeName(String filingTypeName) {
        this.filingTypeName = filingTypeName;
    }

    /**
     * The code for filing type, if given (e.g. 'AR01')
     * 
     */
    @JsonProperty("filing_type_code")
    public String getFilingTypeCode() {
        return filingTypeCode;
    }

    /**
     * The code for filing type, if given (e.g. 'AR01')
     * 
     */
    @JsonProperty("filing_type_code")
    public void setFilingTypeCode(String filingTypeCode) {
        this.filingTypeCode = filingTypeCode;
    }

    /**
     * Whether the source of the filing is the corporate register where the company is incorporated/registered with
     * 
     */
    @JsonProperty("corporate_register_filing")
    public Boolean getCorporateRegisterFiling() {
        return corporateRegisterFiling;
    }

    /**
     * Whether the source of the filing is the corporate register where the company is incorporated/registered with
     * 
     */
    @JsonProperty("corporate_register_filing")
    public void setCorporateRegisterFiling(Boolean corporateRegisterFiling) {
        this.corporateRegisterFiling = corporateRegisterFiling;
    }

    /**
     * The title of the filing, if given
     * 
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * The title of the filing, if given
     * 
     */
    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * The description or precis of the filing, if given
     * 
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * The description or precis of the filing, if given
     * 
     */
    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Persistent URL for the filing, if there is one
     * 
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    /**
     * Persistent URL for the filing, if there is one
     * 
     */
    @JsonProperty("url")
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    public String getSourceUrl() {
        return sourceUrl;
    }

    /**
     * Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    public OCFilingSchema.Confidence getConfidence() {
        return confidence;
    }

    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    public void setConfidence(OCFilingSchema.Confidence confidence) {
        this.confidence = confidence;
    }

    /**
     * Date on which we believe the contents of this filing to be true, e.g. the reporting date, applicable date
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public LocalDate getSampleDate() {
        return sampleDate;
    }

    /**
     * Date on which we believe the contents of this filing to be true, e.g. the reporting date, applicable date
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    /**
     * The time or date at which the source URL was requested
     * 
     */
    @JsonProperty("retrieved_at")
    public LocalDate getRetrievedAt() {
        return retrievedAt;
    }

    /**
     * The time or date at which the source URL was requested
     * 
     */
    @JsonProperty("retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    public OCOtherAttributes__3 getOtherAttributes() {
        return otherAttributes;
    }

    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    public void setOtherAttributes(OCOtherAttributes__3 otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCFilingSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("filingSubject");
        sb.append('=');
        sb.append(((this.filingSubject == null)?"<null>":this.filingSubject));
        sb.append(',');
        sb.append("filingDate");
        sb.append('=');
        sb.append(((this.filingDate == null)?"<null>":this.filingDate));
        sb.append(',');
        sb.append("documents");
        sb.append('=');
        sb.append(((this.documents == null)?"<null>":this.documents));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("filingTypeName");
        sb.append('=');
        sb.append(((this.filingTypeName == null)?"<null>":this.filingTypeName));
        sb.append(',');
        sb.append("filingTypeCode");
        sb.append('=');
        sb.append(((this.filingTypeCode == null)?"<null>":this.filingTypeCode));
        sb.append(',');
        sb.append("corporateRegisterFiling");
        sb.append('=');
        sb.append(((this.corporateRegisterFiling == null)?"<null>":this.corporateRegisterFiling));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(((this.sourceUrl == null)?"<null>":this.sourceUrl));
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(((this.confidence == null)?"<null>":this.confidence));
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(((this.sampleDate == null)?"<null>":this.sampleDate));
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(((this.retrievedAt == null)?"<null>":this.retrievedAt));
        sb.append(',');
        sb.append("otherAttributes");
        sb.append('=');
        sb.append(((this.otherAttributes == null)?"<null>":this.otherAttributes));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.corporateRegisterFiling == null)? 0 :this.corporateRegisterFiling.hashCode()));
        result = ((result* 31)+((this.filingTypeName == null)? 0 :this.filingTypeName.hashCode()));
        result = ((result* 31)+((this.filingDate == null)? 0 :this.filingDate.hashCode()));
        result = ((result* 31)+((this.documents == null)? 0 :this.documents.hashCode()));
        result = ((result* 31)+((this.confidence == null)? 0 :this.confidence.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.otherAttributes == null)? 0 :this.otherAttributes.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        result = ((result* 31)+((this.sourceUrl == null)? 0 :this.sourceUrl.hashCode()));
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.retrievedAt == null)? 0 :this.retrievedAt.hashCode()));
        result = ((result* 31)+((this.filingTypeCode == null)? 0 :this.filingTypeCode.hashCode()));
        result = ((result* 31)+((this.sampleDate == null)? 0 :this.sampleDate.hashCode()));
        result = ((result* 31)+((this.filingSubject == null)? 0 :this.filingSubject.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCFilingSchema) == false) {
            return false;
        }
        OCFilingSchema rhs = ((OCFilingSchema) other);
        return ((((((((((((((((this.corporateRegisterFiling == rhs.corporateRegisterFiling)||((this.corporateRegisterFiling!= null)&&this.corporateRegisterFiling.equals(rhs.corporateRegisterFiling)))&&((this.filingTypeName == rhs.filingTypeName)||((this.filingTypeName!= null)&&this.filingTypeName.equals(rhs.filingTypeName))))&&((this.filingDate == rhs.filingDate)||((this.filingDate!= null)&&this.filingDate.equals(rhs.filingDate))))&&((this.documents == rhs.documents)||((this.documents!= null)&&this.documents.equals(rhs.documents))))&&((this.confidence == rhs.confidence)||((this.confidence!= null)&&this.confidence.equals(rhs.confidence))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.otherAttributes == rhs.otherAttributes)||((this.otherAttributes!= null)&&this.otherAttributes.equals(rhs.otherAttributes))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))))&&((this.sourceUrl == rhs.sourceUrl)||((this.sourceUrl!= null)&&this.sourceUrl.equals(rhs.sourceUrl))))&&((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid))))&&((this.retrievedAt == rhs.retrievedAt)||((this.retrievedAt!= null)&&this.retrievedAt.equals(rhs.retrievedAt))))&&((this.filingTypeCode == rhs.filingTypeCode)||((this.filingTypeCode!= null)&&this.filingTypeCode.equals(rhs.filingTypeCode))))&&((this.sampleDate == rhs.sampleDate)||((this.sampleDate!= null)&&this.sampleDate.equals(rhs.sampleDate))))&&((this.filingSubject == rhs.filingSubject)||((this.filingSubject!= null)&&this.filingSubject.equals(rhs.filingSubject))));
    }


    /**
     * Confidence in accuracy of data
     * 
     */
    public enum Confidence {

        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");
        private final String value;
        private final static Map<String, OCFilingSchema.Confidence> CONSTANTS = new HashMap<String, OCFilingSchema.Confidence>();

        static {
            for (OCFilingSchema.Confidence c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Confidence(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCFilingSchema.Confidence fromValue(String value) {
            OCFilingSchema.Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
