
package com.opencorporates.schemas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * Details of the trademark itself (rather than the registration)
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "mark_text",
    "mark_form",
    "mark_type",
    "mark_image",
    "classification"
})
public class OCMarkDetails {

    /**
     * Text of the trademark
     * 
     */
    @JsonProperty("mark_text")
    @JsonPropertyDescription("Text of the trademark")
    private String markText;
    /**
     * The form (i.e. category) of the mark. Sensory marks include smells and sounds
     * 
     */
    @JsonProperty("mark_form")
    @JsonPropertyDescription("The form (i.e. category) of the mark. Sensory marks include smells and sounds")
    private OCMarkDetails.MarkForm markForm;
    /**
     * Free text description of mark type (as provided by register), e.g. 'Illustration', 'Typeset: Word(s)/letter(s)/number(s)'
     * 
     */
    @JsonProperty("mark_type")
    @JsonPropertyDescription("Free text description of mark type (as provided by register), e.g. 'Illustration', 'Typeset: Word(s)/letter(s)/number(s)'")
    private String markType;
    @JsonProperty("mark_image")
    private OCMarkImage markImage;
    /**
     * Classification of the trademark
     * 
     */
    @JsonProperty("classification")
    @JsonPropertyDescription("Classification of the trademark")
    @Valid
    private List<OCNiceClassification> classification = new ArrayList<OCNiceClassification>();

    /**
     * Text of the trademark
     * 
     */
    @JsonProperty("mark_text")
    public String getMarkText() {
        return markText;
    }

    /**
     * Text of the trademark
     * 
     */
    @JsonProperty("mark_text")
    public void setMarkText(String markText) {
        this.markText = markText;
    }

    /**
     * The form (i.e. category) of the mark. Sensory marks include smells and sounds
     * 
     */
    @JsonProperty("mark_form")
    public OCMarkDetails.MarkForm getMarkForm() {
        return markForm;
    }

    /**
     * The form (i.e. category) of the mark. Sensory marks include smells and sounds
     * 
     */
    @JsonProperty("mark_form")
    public void setMarkForm(OCMarkDetails.MarkForm markForm) {
        this.markForm = markForm;
    }

    /**
     * Free text description of mark type (as provided by register), e.g. 'Illustration', 'Typeset: Word(s)/letter(s)/number(s)'
     * 
     */
    @JsonProperty("mark_type")
    public String getMarkType() {
        return markType;
    }

    /**
     * Free text description of mark type (as provided by register), e.g. 'Illustration', 'Typeset: Word(s)/letter(s)/number(s)'
     * 
     */
    @JsonProperty("mark_type")
    public void setMarkType(String markType) {
        this.markType = markType;
    }

    @JsonProperty("mark_image")
    public OCMarkImage getMarkImage() {
        return markImage;
    }

    @JsonProperty("mark_image")
    public void setMarkImage(OCMarkImage markImage) {
        this.markImage = markImage;
    }

    /**
     * Classification of the trademark
     * 
     */
    @JsonProperty("classification")
    public List<OCNiceClassification> getClassification() {
        return classification;
    }

    /**
     * Classification of the trademark
     * 
     */
    @JsonProperty("classification")
    public void setClassification(List<OCNiceClassification> classification) {
        this.classification = classification;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCMarkDetails.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("markText");
        sb.append('=');
        sb.append(((this.markText == null)?"<null>":this.markText));
        sb.append(',');
        sb.append("markForm");
        sb.append('=');
        sb.append(((this.markForm == null)?"<null>":this.markForm));
        sb.append(',');
        sb.append("markType");
        sb.append('=');
        sb.append(((this.markType == null)?"<null>":this.markType));
        sb.append(',');
        sb.append("markImage");
        sb.append('=');
        sb.append(((this.markImage == null)?"<null>":this.markImage));
        sb.append(',');
        sb.append("classification");
        sb.append('=');
        sb.append(((this.classification == null)?"<null>":this.classification));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.markText == null)? 0 :this.markText.hashCode()));
        result = ((result* 31)+((this.markForm == null)? 0 :this.markForm.hashCode()));
        result = ((result* 31)+((this.classification == null)? 0 :this.classification.hashCode()));
        result = ((result* 31)+((this.markType == null)? 0 :this.markType.hashCode()));
        result = ((result* 31)+((this.markImage == null)? 0 :this.markImage.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCMarkDetails) == false) {
            return false;
        }
        OCMarkDetails rhs = ((OCMarkDetails) other);
        return ((((((this.markText == rhs.markText)||((this.markText!= null)&&this.markText.equals(rhs.markText)))&&((this.markForm == rhs.markForm)||((this.markForm!= null)&&this.markForm.equals(rhs.markForm))))&&((this.classification == rhs.classification)||((this.classification!= null)&&this.classification.equals(rhs.classification))))&&((this.markType == rhs.markType)||((this.markType!= null)&&this.markType.equals(rhs.markType))))&&((this.markImage == rhs.markImage)||((this.markImage!= null)&&this.markImage.equals(rhs.markImage))));
    }


    /**
     * The form (i.e. category) of the mark. Sensory marks include smells and sounds
     * 
     */
    public enum MarkForm {

        TEXT("text"),
        IMAGE("image"),
        SENSORY_MARK("sensory_mark"),
        THREE_D_MARK("three_d_mark");
        private final String value;
        private final static Map<String, OCMarkDetails.MarkForm> CONSTANTS = new HashMap<String, OCMarkDetails.MarkForm>();

        static {
            for (OCMarkDetails.MarkForm c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private MarkForm(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCMarkDetails.MarkForm fromValue(String value) {
            OCMarkDetails.MarkForm constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
