
package com.opencorporates.schemas;

import java.time.LocalDate;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Information on the merger of this company into a 'survivor' company
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "surviving_company",
    "effective_date"
})
public class OCMergedInto {

    /**
     * the surviving_company that this has been merged into
     * (Required)
     * 
     */
    @JsonProperty("surviving_company")
    @JsonPropertyDescription("the surviving_company that this has been merged into")
    @NotNull
    private OCSurvivingCompany survivingCompany;
    /**
     * The date of the merger
     * 
     */
    @JsonProperty("effective_date")
    @JsonPropertyDescription("The date of the merger")
    private LocalDate effectiveDate;

    /**
     * the surviving_company that this has been merged into
     * (Required)
     * 
     */
    @JsonProperty("surviving_company")
    public OCSurvivingCompany getSurvivingCompany() {
        return survivingCompany;
    }

    /**
     * the surviving_company that this has been merged into
     * (Required)
     * 
     */
    @JsonProperty("surviving_company")
    public void setSurvivingCompany(OCSurvivingCompany survivingCompany) {
        this.survivingCompany = survivingCompany;
    }

    /**
     * The date of the merger
     * 
     */
    @JsonProperty("effective_date")
    public LocalDate getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * The date of the merger
     * 
     */
    @JsonProperty("effective_date")
    public void setEffectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCMergedInto.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("survivingCompany");
        sb.append('=');
        sb.append(((this.survivingCompany == null)?"<null>":this.survivingCompany));
        sb.append(',');
        sb.append("effectiveDate");
        sb.append('=');
        sb.append(((this.effectiveDate == null)?"<null>":this.effectiveDate));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.survivingCompany == null)? 0 :this.survivingCompany.hashCode()));
        result = ((result* 31)+((this.effectiveDate == null)? 0 :this.effectiveDate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCMergedInto) == false) {
            return false;
        }
        OCMergedInto rhs = ((OCMergedInto) other);
        return (((this.survivingCompany == rhs.survivingCompany)||((this.survivingCompany!= null)&&this.survivingCompany.equals(rhs.survivingCompany)))&&((this.effectiveDate == rhs.effectiveDate)||((this.effectiveDate!= null)&&this.effectiveDate.equals(rhs.effectiveDate))));
    }

}
