
package com.opencorporates.schemas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * NICE Trademark Classification
 * <p>
 * A classification from a the WIPO Nice classification system for trademarks. See http://web2.wipo.int/classifications/nice/nicepub/en/fr/edition-20170101/classheadings/ and https://en.wikipedia.org/wiki/International_(Nice)_Classification_of_Goods_and_Services
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "code_scheme_id",
    "code",
    "enhanced_descriptions"
})
public class OCNiceClassification {

    /**
     * The scheme of the classification
     * (Required)
     * 
     */
    @JsonProperty("code_scheme_id")
    @JsonPropertyDescription("The scheme of the classification")
    @NotNull
    private OCNiceClassification.CodeSchemeId codeSchemeId;
    /**
     * The classification code
     * (Required)
     * 
     */
    @JsonProperty("code")
    @JsonPropertyDescription("The classification code")
    @NotNull
    private String code;
    /**
     * Enhanced descriptions of the classification (may enhance restrict, or otherwise alter standard classification)
     * 
     */
    @JsonProperty("enhanced_descriptions")
    @JsonPropertyDescription("Enhanced descriptions of the classification (may enhance restrict, or otherwise alter standard classification)")
    @Valid
    private List<OCNiceEnhancedDescription> enhancedDescriptions = new ArrayList<OCNiceEnhancedDescription>();

    /**
     * The scheme of the classification
     * (Required)
     * 
     */
    @JsonProperty("code_scheme_id")
    public OCNiceClassification.CodeSchemeId getCodeSchemeId() {
        return codeSchemeId;
    }

    /**
     * The scheme of the classification
     * (Required)
     * 
     */
    @JsonProperty("code_scheme_id")
    public void setCodeSchemeId(OCNiceClassification.CodeSchemeId codeSchemeId) {
        this.codeSchemeId = codeSchemeId;
    }

    /**
     * The classification code
     * (Required)
     * 
     */
    @JsonProperty("code")
    public String getCode() {
        return code;
    }

    /**
     * The classification code
     * (Required)
     * 
     */
    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * Enhanced descriptions of the classification (may enhance restrict, or otherwise alter standard classification)
     * 
     */
    @JsonProperty("enhanced_descriptions")
    public List<OCNiceEnhancedDescription> getEnhancedDescriptions() {
        return enhancedDescriptions;
    }

    /**
     * Enhanced descriptions of the classification (may enhance restrict, or otherwise alter standard classification)
     * 
     */
    @JsonProperty("enhanced_descriptions")
    public void setEnhancedDescriptions(List<OCNiceEnhancedDescription> enhancedDescriptions) {
        this.enhancedDescriptions = enhancedDescriptions;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCNiceClassification.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("codeSchemeId");
        sb.append('=');
        sb.append(((this.codeSchemeId == null)?"<null>":this.codeSchemeId));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("enhancedDescriptions");
        sb.append('=');
        sb.append(((this.enhancedDescriptions == null)?"<null>":this.enhancedDescriptions));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.enhancedDescriptions == null)? 0 :this.enhancedDescriptions.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.codeSchemeId == null)? 0 :this.codeSchemeId.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCNiceClassification) == false) {
            return false;
        }
        OCNiceClassification rhs = ((OCNiceClassification) other);
        return ((((this.enhancedDescriptions == rhs.enhancedDescriptions)||((this.enhancedDescriptions!= null)&&this.enhancedDescriptions.equals(rhs.enhancedDescriptions)))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.codeSchemeId == rhs.codeSchemeId)||((this.codeSchemeId!= null)&&this.codeSchemeId.equals(rhs.codeSchemeId))));
    }


    /**
     * The scheme of the classification
     * 
     */
    public enum CodeSchemeId {

        WIPO_NICE("wipo_nice");
        private final String value;
        private final static Map<String, OCNiceClassification.CodeSchemeId> CONSTANTS = new HashMap<String, OCNiceClassification.CodeSchemeId>();

        static {
            for (OCNiceClassification.CodeSchemeId c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private CodeSchemeId(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCNiceClassification.CodeSchemeId fromValue(String value) {
            OCNiceClassification.CodeSchemeId constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
