
package com.opencorporates.schemas;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * A sanctioned entity is a record of a person or company that has been barred or prohibited from some activity, e.g. disqualified from being a director, banned from bidding for contracts, or is on a sanctions list
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "subject_entity",
    "category",
    "sanctions_list",
    "sanctions",
    "uid",
    "title",
    "url",
    "source_url",
    "confidence",
    "start_date",
    "end_date",
    "retrieved_at",
    "sample_date",
    "other_attributes"
})
public class OCSanctionedEntitySchema {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("subject_entity")
    @Valid
    @NotNull
    private OCEntity subjectEntity;
    /**
     * Category of sanction. This field is required (other options may be added in the future). A listed_sanctioned_entity is an entity that is on a national or international sanctions list, e.g. OFAC
     * (Required)
     * 
     */
    @JsonProperty("category")
    @JsonPropertyDescription("Category of sanction. This field is required (other options may be added in the future). A listed_sanctioned_entity is an entity that is on a national or international sanctions list, e.g. OFAC")
    @NotNull
    private OCSanctionedEntitySchema.Category category;
    /**
     * Sanctions List
     * <p>
     * The sanctions list from which this entry is taken
     * 
     */
    @JsonProperty("sanctions_list")
    @JsonPropertyDescription("The sanctions list from which this entry is taken")
    @Valid
    private OCSanctionsList sanctionsList;
    @JsonProperty("sanctions")
    @Valid
    private List<Object> sanctions = new ArrayList<Object>();
    /**
     * Unique id/reference for the sanctioned entity record if the sanctioning body has given it one
     * 
     */
    @JsonProperty("uid")
    @JsonPropertyDescription("Unique id/reference for the sanctioned entity record if the sanctioning body has given it one")
    private String uid;
    /**
     * The title of the sanction entity record, if given
     * 
     */
    @JsonProperty("title")
    @JsonPropertyDescription("The title of the sanction entity record, if given")
    private String title;
    /**
     * Persistent URL for the sanctioned entity record, if there is one
     * 
     */
    @JsonProperty("url")
    @JsonPropertyDescription("Persistent URL for the sanctioned entity record, if there is one")
    private String url;
    /**
     * Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    @JsonPropertyDescription("Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.")
    @Size(min = 11)
    @NotNull
    private String sourceUrl;
    /**
     * Confidence in accuracy of data
     * 
     */
    @JsonProperty("confidence")
    @JsonPropertyDescription("Confidence in accuracy of data")
    private OCSanctionedEntitySchema.Confidence confidence;
    /**
     * Date on which the sanction started
     * 
     */
    @JsonProperty("start_date")
    @JsonPropertyDescription("Date on which the sanction started")
    private LocalDate startDate;
    /**
     * Date on which the sanction ended, or is scheduled to end
     * 
     */
    @JsonProperty("end_date")
    @JsonPropertyDescription("Date on which the sanction ended, or is scheduled to end")
    private LocalDate endDate;
    /**
     * Date-time this was retrieved from the source
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    @JsonPropertyDescription("Date-time this was retrieved from the source")
    @NotNull
    private OffsetDateTime retrievedAt;
    /**
     * Date on which we know this to be true (for example the date the sanction list was published)
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    @JsonPropertyDescription("Date on which we know this to be true (for example the date the sanction list was published)")
    @NotNull
    private LocalDate sampleDate;
    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    @JsonPropertyDescription("Use for other attributes for which we don't yet have curated schema attributes")
    @Valid
    private OCOtherAttributes__7 otherAttributes;

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("subject_entity")
    public OCEntity getSubjectEntity() {
        return subjectEntity;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("subject_entity")
    public void setSubjectEntity(OCEntity subjectEntity) {
        this.subjectEntity = subjectEntity;
    }

    /**
     * Category of sanction. This field is required (other options may be added in the future). A listed_sanctioned_entity is an entity that is on a national or international sanctions list, e.g. OFAC
     * (Required)
     * 
     */
    @JsonProperty("category")
    public OCSanctionedEntitySchema.Category getCategory() {
        return category;
    }

    /**
     * Category of sanction. This field is required (other options may be added in the future). A listed_sanctioned_entity is an entity that is on a national or international sanctions list, e.g. OFAC
     * (Required)
     * 
     */
    @JsonProperty("category")
    public void setCategory(OCSanctionedEntitySchema.Category category) {
        this.category = category;
    }

    /**
     * Sanctions List
     * <p>
     * The sanctions list from which this entry is taken
     * 
     */
    @JsonProperty("sanctions_list")
    public OCSanctionsList getSanctionsList() {
        return sanctionsList;
    }

    /**
     * Sanctions List
     * <p>
     * The sanctions list from which this entry is taken
     * 
     */
    @JsonProperty("sanctions_list")
    public void setSanctionsList(OCSanctionsList sanctionsList) {
        this.sanctionsList = sanctionsList;
    }

    @JsonProperty("sanctions")
    public List<Object> getSanctions() {
        return sanctions;
    }

    @JsonProperty("sanctions")
    public void setSanctions(List<Object> sanctions) {
        this.sanctions = sanctions;
    }

    /**
     * Unique id/reference for the sanctioned entity record if the sanctioning body has given it one
     * 
     */
    @JsonProperty("uid")
    public String getUid() {
        return uid;
    }

    /**
     * Unique id/reference for the sanctioned entity record if the sanctioning body has given it one
     * 
     */
    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    /**
     * The title of the sanction entity record, if given
     * 
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * The title of the sanction entity record, if given
     * 
     */
    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * Persistent URL for the sanctioned entity record, if there is one
     * 
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    /**
     * Persistent URL for the sanctioned entity record, if there is one
     * 
     */
    @JsonProperty("url")
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    public String getSourceUrl() {
        return sourceUrl;
    }

    /**
     * Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    /**
     * Confidence in accuracy of data
     * 
     */
    @JsonProperty("confidence")
    public OCSanctionedEntitySchema.Confidence getConfidence() {
        return confidence;
    }

    /**
     * Confidence in accuracy of data
     * 
     */
    @JsonProperty("confidence")
    public void setConfidence(OCSanctionedEntitySchema.Confidence confidence) {
        this.confidence = confidence;
    }

    /**
     * Date on which the sanction started
     * 
     */
    @JsonProperty("start_date")
    public LocalDate getStartDate() {
        return startDate;
    }

    /**
     * Date on which the sanction started
     * 
     */
    @JsonProperty("start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    /**
     * Date on which the sanction ended, or is scheduled to end
     * 
     */
    @JsonProperty("end_date")
    public LocalDate getEndDate() {
        return endDate;
    }

    /**
     * Date on which the sanction ended, or is scheduled to end
     * 
     */
    @JsonProperty("end_date")
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    /**
     * Date-time this was retrieved from the source
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    public OffsetDateTime getRetrievedAt() {
        return retrievedAt;
    }

    /**
     * Date-time this was retrieved from the source
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    public void setRetrievedAt(OffsetDateTime retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    /**
     * Date on which we know this to be true (for example the date the sanction list was published)
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public LocalDate getSampleDate() {
        return sampleDate;
    }

    /**
     * Date on which we know this to be true (for example the date the sanction list was published)
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    public OCOtherAttributes__7 getOtherAttributes() {
        return otherAttributes;
    }

    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    public void setOtherAttributes(OCOtherAttributes__7 otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCSanctionedEntitySchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("subjectEntity");
        sb.append('=');
        sb.append(((this.subjectEntity == null)?"<null>":this.subjectEntity));
        sb.append(',');
        sb.append("category");
        sb.append('=');
        sb.append(((this.category == null)?"<null>":this.category));
        sb.append(',');
        sb.append("sanctionsList");
        sb.append('=');
        sb.append(((this.sanctionsList == null)?"<null>":this.sanctionsList));
        sb.append(',');
        sb.append("sanctions");
        sb.append('=');
        sb.append(((this.sanctions == null)?"<null>":this.sanctions));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(((this.sourceUrl == null)?"<null>":this.sourceUrl));
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(((this.confidence == null)?"<null>":this.confidence));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(((this.retrievedAt == null)?"<null>":this.retrievedAt));
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(((this.sampleDate == null)?"<null>":this.sampleDate));
        sb.append(',');
        sb.append("otherAttributes");
        sb.append('=');
        sb.append(((this.otherAttributes == null)?"<null>":this.otherAttributes));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.subjectEntity == null)? 0 :this.subjectEntity.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.confidence == null)? 0 :this.confidence.hashCode()));
        result = ((result* 31)+((this.sanctionsList == null)? 0 :this.sanctionsList.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.otherAttributes == null)? 0 :this.otherAttributes.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        result = ((result* 31)+((this.sourceUrl == null)? 0 :this.sourceUrl.hashCode()));
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.retrievedAt == null)? 0 :this.retrievedAt.hashCode()));
        result = ((result* 31)+((this.sampleDate == null)? 0 :this.sampleDate.hashCode()));
        result = ((result* 31)+((this.category == null)? 0 :this.category.hashCode()));
        result = ((result* 31)+((this.sanctions == null)? 0 :this.sanctions.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCSanctionedEntitySchema) == false) {
            return false;
        }
        OCSanctionedEntitySchema rhs = ((OCSanctionedEntitySchema) other);
        return (((((((((((((((this.subjectEntity == rhs.subjectEntity)||((this.subjectEntity!= null)&&this.subjectEntity.equals(rhs.subjectEntity)))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.confidence == rhs.confidence)||((this.confidence!= null)&&this.confidence.equals(rhs.confidence))))&&((this.sanctionsList == rhs.sanctionsList)||((this.sanctionsList!= null)&&this.sanctionsList.equals(rhs.sanctionsList))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.otherAttributes == rhs.otherAttributes)||((this.otherAttributes!= null)&&this.otherAttributes.equals(rhs.otherAttributes))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))))&&((this.sourceUrl == rhs.sourceUrl)||((this.sourceUrl!= null)&&this.sourceUrl.equals(rhs.sourceUrl))))&&((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid))))&&((this.retrievedAt == rhs.retrievedAt)||((this.retrievedAt!= null)&&this.retrievedAt.equals(rhs.retrievedAt))))&&((this.sampleDate == rhs.sampleDate)||((this.sampleDate!= null)&&this.sampleDate.equals(rhs.sampleDate))))&&((this.category == rhs.category)||((this.category!= null)&&this.category.equals(rhs.category))))&&((this.sanctions == rhs.sanctions)||((this.sanctions!= null)&&this.sanctions.equals(rhs.sanctions))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))));
    }


    /**
     * Category of sanction. This field is required (other options may be added in the future). A listed_sanctioned_entity is an entity that is on a national or international sanctions list, e.g. OFAC
     * 
     */
    public enum Category {

        DISQUALIFIED_DIRECTOR("DisqualifiedDirector"),
        LISTED_SANCTIONED_ENTITY("ListedSanctionedEntity"),
        DEBARRED_SUPPLIER("DebarredSupplier");
        private final String value;
        private final static Map<String, OCSanctionedEntitySchema.Category> CONSTANTS = new HashMap<String, OCSanctionedEntitySchema.Category>();

        static {
            for (OCSanctionedEntitySchema.Category c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Category(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCSanctionedEntitySchema.Category fromValue(String value) {
            OCSanctionedEntitySchema.Category constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }


    /**
     * Confidence in accuracy of data
     * 
     */
    public enum Confidence {

        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");
        private final String value;
        private final static Map<String, OCSanctionedEntitySchema.Confidence> CONSTANTS = new HashMap<String, OCSanctionedEntitySchema.Confidence>();

        static {
            for (OCSanctionedEntitySchema.Confidence c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Confidence(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCSanctionedEntitySchema.Confidence fromValue(String value) {
            OCSanctionedEntitySchema.Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
