
package com.opencorporates.schemas;

import java.net.URI;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.opencorporates.schemas.includes.OCOrganisation;


/**
 * Sanctions List
 * <p>
 * The sanctions list from which this entry is taken
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "publisher",
    "jurisdiction",
    "title",
    "url"
})
public class OCSanctionsList {

    /**
     * An entity which is a distinct organisation, but is not a company nor an individual. Examples include governments and governmental entities (e.g. Multilateral Development Banks, Government Departments, municipalities, etc), and also membership organisations
     * 
     */
    @JsonProperty("publisher")
    @JsonPropertyDescription("An entity which is a distinct organisation, but is not a company nor an individual. Examples include governments and governmental entities (e.g. Multilateral Development Banks, Government Departments, municipalities, etc), and also membership organisations")
    @Valid
    private OCOrganisation publisher;
    /**
     * The jurisdiction covered by the register
     * 
     */
    @JsonProperty("jurisdiction")
    @JsonPropertyDescription("The jurisdiction covered by the register")
    private String jurisdiction;
    /**
     * The title of the sanctions list
     * (Required)
     * 
     */
    @JsonProperty("title")
    @JsonPropertyDescription("The title of the sanctions list")
    @NotNull
    private String title;
    /**
     * The URL of the sanctions list
     * 
     */
    @JsonProperty("url")
    @JsonPropertyDescription("The URL of the sanctions list")
    private URI url;

    /**
     * An entity which is a distinct organisation, but is not a company nor an individual. Examples include governments and governmental entities (e.g. Multilateral Development Banks, Government Departments, municipalities, etc), and also membership organisations
     * 
     */
    @JsonProperty("publisher")
    public OCOrganisation getPublisher() {
        return publisher;
    }

    /**
     * An entity which is a distinct organisation, but is not a company nor an individual. Examples include governments and governmental entities (e.g. Multilateral Development Banks, Government Departments, municipalities, etc), and also membership organisations
     * 
     */
    @JsonProperty("publisher")
    public void setPublisher(OCOrganisation publisher) {
        this.publisher = publisher;
    }

    /**
     * The jurisdiction covered by the register
     * 
     */
    @JsonProperty("jurisdiction")
    public String getJurisdiction() {
        return jurisdiction;
    }

    /**
     * The jurisdiction covered by the register
     * 
     */
    @JsonProperty("jurisdiction")
    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    /**
     * The title of the sanctions list
     * (Required)
     * 
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * The title of the sanctions list
     * (Required)
     * 
     */
    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * The URL of the sanctions list
     * 
     */
    @JsonProperty("url")
    public URI getUrl() {
        return url;
    }

    /**
     * The URL of the sanctions list
     * 
     */
    @JsonProperty("url")
    public void setUrl(URI url) {
        this.url = url;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCSanctionsList.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("publisher");
        sb.append('=');
        sb.append(((this.publisher == null)?"<null>":this.publisher));
        sb.append(',');
        sb.append("jurisdiction");
        sb.append('=');
        sb.append(((this.jurisdiction == null)?"<null>":this.jurisdiction));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.publisher == null)? 0 :this.publisher.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        result = ((result* 31)+((this.jurisdiction == null)? 0 :this.jurisdiction.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCSanctionsList) == false) {
            return false;
        }
        OCSanctionsList rhs = ((OCSanctionsList) other);
        return (((((this.publisher == rhs.publisher)||((this.publisher!= null)&&this.publisher.equals(rhs.publisher)))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))))&&((this.jurisdiction == rhs.jurisdiction)||((this.jurisdiction!= null)&&this.jurisdiction.equals(rhs.jurisdiction))));
    }

}
