
package com.opencorporates.schemas;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * A Financial Payment is a payment from government to a recipient
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "source_url",
    "sample_date",
    "confidence",
    "company_name",
    "company_jurisdiction",
    "value",
    "payee_name",
    "currency",
    "date",
    "transaction_number",
    "jurisdiction",
    "retrieved_at",
    "more_details_url",
    "description",
    "expense_type",
    "expense_area",
    "entity_name",
    "entity_uri",
    "department_name",
    "csv_line_number"
})
public class OCSimpleFinancialPaymentSchema {

    /**
     * Place where this fact can be verified
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    @JsonPropertyDescription("Place where this fact can be verified")
    @NotNull
    private String sourceUrl;
    /**
     * Date on which this fact was known to be true
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    @JsonPropertyDescription("Date on which this fact was known to be true")
    @NotNull
    private LocalDate sampleDate;
    /**
     * Confidence in accuracy of data
     * 
     */
    @JsonProperty("confidence")
    @JsonPropertyDescription("Confidence in accuracy of data")
    private OCSimpleFinancialPaymentSchema.Confidence confidence;
    /**
     * Name of the company that received the money
     * (Required)
     * 
     */
    @JsonProperty("company_name")
    @JsonPropertyDescription("Name of the company that received the money")
    @NotNull
    private String companyName;
    /**
     * Jurisdiction where company is based
     * (Required)
     * 
     */
    @JsonProperty("company_jurisdiction")
    @JsonPropertyDescription("Jurisdiction where company is based")
    @NotNull
    private String companyJurisdiction;
    /**
     * The amount transacted (e.g. 19.95)
     * (Required)
     * 
     */
    @JsonProperty("value")
    @JsonPropertyDescription("The amount transacted (e.g. 19.95)")
    @NotNull
    private String value;
    /**
     * The name of the payee (the entity that received the money)
     * (Required)
     * 
     */
    @JsonProperty("payee_name")
    @JsonPropertyDescription("The name of the payee (the entity that received the money)")
    @NotNull
    private String payeeName;
    /**
     * The currency of the payment (three letter symbol, e.g. USD, GBP, EUR)
     * (Required)
     * 
     */
    @JsonProperty("currency")
    @JsonPropertyDescription("The currency of the payment (three letter symbol, e.g. USD, GBP, EUR)")
    @NotNull
    private String currency;
    /**
     * The date on which the payment was made
     * (Required)
     * 
     */
    @JsonProperty("date")
    @JsonPropertyDescription("The date on which the payment was made")
    @NotNull
    private LocalDate date;
    /**
     * The unique identifier for the transaction, scoped to this bot
     * 
     */
    @JsonProperty("transaction_number")
    @JsonPropertyDescription("The unique identifier for the transaction, scoped to this bot")
    private String transactionNumber;
    /**
     * The jurisdiction of the body that made the payment, eg. UK, France, Delaware, Manchester
     * 
     */
    @JsonProperty("jurisdiction")
    @JsonPropertyDescription("The jurisdiction of the body that made the payment, eg. UK, France, Delaware, Manchester")
    private String jurisdiction;
    @JsonProperty("retrieved_at")
    private LocalDate retrievedAt;
    /**
     * A url from which more details can be seen (may be the same as the source_url)
     * 
     */
    @JsonProperty("more_details_url")
    @JsonPropertyDescription("A url from which more details can be seen (may be the same as the source_url)")
    private String moreDetailsUrl;
    /**
     * The description of the transaction as given in the raw data
     * 
     */
    @JsonProperty("description")
    @JsonPropertyDescription("The description of the transaction as given in the raw data")
    private String description;
    /**
     * The type of expense -- can be either capital, revenue (i.e. current expenditure) or null
     * 
     */
    @JsonProperty("expense_type")
    @JsonPropertyDescription("The type of expense -- can be either capital, revenue (i.e. current expenditure) or null")
    private OCSimpleFinancialPaymentSchema.ExpenseType expenseType;
    /**
     * category (in words) of the expenditure
     * 
     */
    @JsonProperty("expense_area")
    @JsonPropertyDescription("category (in words) of the expenditure")
    private String expenseArea;
    /**
     * The name of the government entity that made the payment, e.g. Environment Agency
     * 
     */
    @JsonProperty("entity_name")
    @JsonPropertyDescription("The name of the government entity that made the payment, e.g. Environment Agency")
    private String entityName;
    /**
     * A unique URL (ideally a dereferencable URI) for the government entity
     * 
     */
    @JsonProperty("entity_uri")
    @JsonPropertyDescription("A unique URL (ideally a dereferencable URI) for the government entity")
    private String entityUri;
    /**
     * The name of the government department which the entity belongs to (if relevant), e.g. Department of Health
     * 
     */
    @JsonProperty("department_name")
    @JsonPropertyDescription("The name of the government department which the entity belongs to (if relevant), e.g. Department of Health")
    private String departmentName;
    /**
     * If the source for the data is a CSV file, you can optionally include the line number of the CSV from which this data was retrieved
     * 
     */
    @JsonProperty("csv_line_number")
    @JsonPropertyDescription("If the source for the data is a CSV file, you can optionally include the line number of the CSV from which this data was retrieved")
    private String csvLineNumber;

    /**
     * Place where this fact can be verified
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    public String getSourceUrl() {
        return sourceUrl;
    }

    /**
     * Place where this fact can be verified
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    /**
     * Date on which this fact was known to be true
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public LocalDate getSampleDate() {
        return sampleDate;
    }

    /**
     * Date on which this fact was known to be true
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    /**
     * Confidence in accuracy of data
     * 
     */
    @JsonProperty("confidence")
    public OCSimpleFinancialPaymentSchema.Confidence getConfidence() {
        return confidence;
    }

    /**
     * Confidence in accuracy of data
     * 
     */
    @JsonProperty("confidence")
    public void setConfidence(OCSimpleFinancialPaymentSchema.Confidence confidence) {
        this.confidence = confidence;
    }

    /**
     * Name of the company that received the money
     * (Required)
     * 
     */
    @JsonProperty("company_name")
    public String getCompanyName() {
        return companyName;
    }

    /**
     * Name of the company that received the money
     * (Required)
     * 
     */
    @JsonProperty("company_name")
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * Jurisdiction where company is based
     * (Required)
     * 
     */
    @JsonProperty("company_jurisdiction")
    public String getCompanyJurisdiction() {
        return companyJurisdiction;
    }

    /**
     * Jurisdiction where company is based
     * (Required)
     * 
     */
    @JsonProperty("company_jurisdiction")
    public void setCompanyJurisdiction(String companyJurisdiction) {
        this.companyJurisdiction = companyJurisdiction;
    }

    /**
     * The amount transacted (e.g. 19.95)
     * (Required)
     * 
     */
    @JsonProperty("value")
    public String getValue() {
        return value;
    }

    /**
     * The amount transacted (e.g. 19.95)
     * (Required)
     * 
     */
    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * The name of the payee (the entity that received the money)
     * (Required)
     * 
     */
    @JsonProperty("payee_name")
    public String getPayeeName() {
        return payeeName;
    }

    /**
     * The name of the payee (the entity that received the money)
     * (Required)
     * 
     */
    @JsonProperty("payee_name")
    public void setPayeeName(String payeeName) {
        this.payeeName = payeeName;
    }

    /**
     * The currency of the payment (three letter symbol, e.g. USD, GBP, EUR)
     * (Required)
     * 
     */
    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    /**
     * The currency of the payment (three letter symbol, e.g. USD, GBP, EUR)
     * (Required)
     * 
     */
    @JsonProperty("currency")
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    /**
     * The date on which the payment was made
     * (Required)
     * 
     */
    @JsonProperty("date")
    public LocalDate getDate() {
        return date;
    }

    /**
     * The date on which the payment was made
     * (Required)
     * 
     */
    @JsonProperty("date")
    public void setDate(LocalDate date) {
        this.date = date;
    }

    /**
     * The unique identifier for the transaction, scoped to this bot
     * 
     */
    @JsonProperty("transaction_number")
    public String getTransactionNumber() {
        return transactionNumber;
    }

    /**
     * The unique identifier for the transaction, scoped to this bot
     * 
     */
    @JsonProperty("transaction_number")
    public void setTransactionNumber(String transactionNumber) {
        this.transactionNumber = transactionNumber;
    }

    /**
     * The jurisdiction of the body that made the payment, eg. UK, France, Delaware, Manchester
     * 
     */
    @JsonProperty("jurisdiction")
    public String getJurisdiction() {
        return jurisdiction;
    }

    /**
     * The jurisdiction of the body that made the payment, eg. UK, France, Delaware, Manchester
     * 
     */
    @JsonProperty("jurisdiction")
    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    @JsonProperty("retrieved_at")
    public LocalDate getRetrievedAt() {
        return retrievedAt;
    }

    @JsonProperty("retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    /**
     * A url from which more details can be seen (may be the same as the source_url)
     * 
     */
    @JsonProperty("more_details_url")
    public String getMoreDetailsUrl() {
        return moreDetailsUrl;
    }

    /**
     * A url from which more details can be seen (may be the same as the source_url)
     * 
     */
    @JsonProperty("more_details_url")
    public void setMoreDetailsUrl(String moreDetailsUrl) {
        this.moreDetailsUrl = moreDetailsUrl;
    }

    /**
     * The description of the transaction as given in the raw data
     * 
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * The description of the transaction as given in the raw data
     * 
     */
    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * The type of expense -- can be either capital, revenue (i.e. current expenditure) or null
     * 
     */
    @JsonProperty("expense_type")
    public OCSimpleFinancialPaymentSchema.ExpenseType getExpenseType() {
        return expenseType;
    }

    /**
     * The type of expense -- can be either capital, revenue (i.e. current expenditure) or null
     * 
     */
    @JsonProperty("expense_type")
    public void setExpenseType(OCSimpleFinancialPaymentSchema.ExpenseType expenseType) {
        this.expenseType = expenseType;
    }

    /**
     * category (in words) of the expenditure
     * 
     */
    @JsonProperty("expense_area")
    public String getExpenseArea() {
        return expenseArea;
    }

    /**
     * category (in words) of the expenditure
     * 
     */
    @JsonProperty("expense_area")
    public void setExpenseArea(String expenseArea) {
        this.expenseArea = expenseArea;
    }

    /**
     * The name of the government entity that made the payment, e.g. Environment Agency
     * 
     */
    @JsonProperty("entity_name")
    public String getEntityName() {
        return entityName;
    }

    /**
     * The name of the government entity that made the payment, e.g. Environment Agency
     * 
     */
    @JsonProperty("entity_name")
    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    /**
     * A unique URL (ideally a dereferencable URI) for the government entity
     * 
     */
    @JsonProperty("entity_uri")
    public String getEntityUri() {
        return entityUri;
    }

    /**
     * A unique URL (ideally a dereferencable URI) for the government entity
     * 
     */
    @JsonProperty("entity_uri")
    public void setEntityUri(String entityUri) {
        this.entityUri = entityUri;
    }

    /**
     * The name of the government department which the entity belongs to (if relevant), e.g. Department of Health
     * 
     */
    @JsonProperty("department_name")
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * The name of the government department which the entity belongs to (if relevant), e.g. Department of Health
     * 
     */
    @JsonProperty("department_name")
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    /**
     * If the source for the data is a CSV file, you can optionally include the line number of the CSV from which this data was retrieved
     * 
     */
    @JsonProperty("csv_line_number")
    public String getCsvLineNumber() {
        return csvLineNumber;
    }

    /**
     * If the source for the data is a CSV file, you can optionally include the line number of the CSV from which this data was retrieved
     * 
     */
    @JsonProperty("csv_line_number")
    public void setCsvLineNumber(String csvLineNumber) {
        this.csvLineNumber = csvLineNumber;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCSimpleFinancialPaymentSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(((this.sourceUrl == null)?"<null>":this.sourceUrl));
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(((this.sampleDate == null)?"<null>":this.sampleDate));
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(((this.confidence == null)?"<null>":this.confidence));
        sb.append(',');
        sb.append("companyName");
        sb.append('=');
        sb.append(((this.companyName == null)?"<null>":this.companyName));
        sb.append(',');
        sb.append("companyJurisdiction");
        sb.append('=');
        sb.append(((this.companyJurisdiction == null)?"<null>":this.companyJurisdiction));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("payeeName");
        sb.append('=');
        sb.append(((this.payeeName == null)?"<null>":this.payeeName));
        sb.append(',');
        sb.append("currency");
        sb.append('=');
        sb.append(((this.currency == null)?"<null>":this.currency));
        sb.append(',');
        sb.append("date");
        sb.append('=');
        sb.append(((this.date == null)?"<null>":this.date));
        sb.append(',');
        sb.append("transactionNumber");
        sb.append('=');
        sb.append(((this.transactionNumber == null)?"<null>":this.transactionNumber));
        sb.append(',');
        sb.append("jurisdiction");
        sb.append('=');
        sb.append(((this.jurisdiction == null)?"<null>":this.jurisdiction));
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(((this.retrievedAt == null)?"<null>":this.retrievedAt));
        sb.append(',');
        sb.append("moreDetailsUrl");
        sb.append('=');
        sb.append(((this.moreDetailsUrl == null)?"<null>":this.moreDetailsUrl));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("expenseType");
        sb.append('=');
        sb.append(((this.expenseType == null)?"<null>":this.expenseType));
        sb.append(',');
        sb.append("expenseArea");
        sb.append('=');
        sb.append(((this.expenseArea == null)?"<null>":this.expenseArea));
        sb.append(',');
        sb.append("entityName");
        sb.append('=');
        sb.append(((this.entityName == null)?"<null>":this.entityName));
        sb.append(',');
        sb.append("entityUri");
        sb.append('=');
        sb.append(((this.entityUri == null)?"<null>":this.entityUri));
        sb.append(',');
        sb.append("departmentName");
        sb.append('=');
        sb.append(((this.departmentName == null)?"<null>":this.departmentName));
        sb.append(',');
        sb.append("csvLineNumber");
        sb.append('=');
        sb.append(((this.csvLineNumber == null)?"<null>":this.csvLineNumber));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.date == null)? 0 :this.date.hashCode()));
        result = ((result* 31)+((this.departmentName == null)? 0 :this.departmentName.hashCode()));
        result = ((result* 31)+((this.expenseType == null)? 0 :this.expenseType.hashCode()));
        result = ((result* 31)+((this.confidence == null)? 0 :this.confidence.hashCode()));
        result = ((result* 31)+((this.companyName == null)? 0 :this.companyName.hashCode()));
        result = ((result* 31)+((this.companyJurisdiction == null)? 0 :this.companyJurisdiction.hashCode()));
        result = ((result* 31)+((this.transactionNumber == null)? 0 :this.transactionNumber.hashCode()));
        result = ((result* 31)+((this.jurisdiction == null)? 0 :this.jurisdiction.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.moreDetailsUrl == null)? 0 :this.moreDetailsUrl.hashCode()));
        result = ((result* 31)+((this.expenseArea == null)? 0 :this.expenseArea.hashCode()));
        result = ((result* 31)+((this.sourceUrl == null)? 0 :this.sourceUrl.hashCode()));
        result = ((result* 31)+((this.payeeName == null)? 0 :this.payeeName.hashCode()));
        result = ((result* 31)+((this.entityUri == null)? 0 :this.entityUri.hashCode()));
        result = ((result* 31)+((this.retrievedAt == null)? 0 :this.retrievedAt.hashCode()));
        result = ((result* 31)+((this.csvLineNumber == null)? 0 :this.csvLineNumber.hashCode()));
        result = ((result* 31)+((this.entityName == null)? 0 :this.entityName.hashCode()));
        result = ((result* 31)+((this.sampleDate == null)? 0 :this.sampleDate.hashCode()));
        result = ((result* 31)+((this.currency == null)? 0 :this.currency.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCSimpleFinancialPaymentSchema) == false) {
            return false;
        }
        OCSimpleFinancialPaymentSchema rhs = ((OCSimpleFinancialPaymentSchema) other);
        return (((((((((((((((((((((this.date == rhs.date)||((this.date!= null)&&this.date.equals(rhs.date)))&&((this.departmentName == rhs.departmentName)||((this.departmentName!= null)&&this.departmentName.equals(rhs.departmentName))))&&((this.expenseType == rhs.expenseType)||((this.expenseType!= null)&&this.expenseType.equals(rhs.expenseType))))&&((this.confidence == rhs.confidence)||((this.confidence!= null)&&this.confidence.equals(rhs.confidence))))&&((this.companyName == rhs.companyName)||((this.companyName!= null)&&this.companyName.equals(rhs.companyName))))&&((this.companyJurisdiction == rhs.companyJurisdiction)||((this.companyJurisdiction!= null)&&this.companyJurisdiction.equals(rhs.companyJurisdiction))))&&((this.transactionNumber == rhs.transactionNumber)||((this.transactionNumber!= null)&&this.transactionNumber.equals(rhs.transactionNumber))))&&((this.jurisdiction == rhs.jurisdiction)||((this.jurisdiction!= null)&&this.jurisdiction.equals(rhs.jurisdiction))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.moreDetailsUrl == rhs.moreDetailsUrl)||((this.moreDetailsUrl!= null)&&this.moreDetailsUrl.equals(rhs.moreDetailsUrl))))&&((this.expenseArea == rhs.expenseArea)||((this.expenseArea!= null)&&this.expenseArea.equals(rhs.expenseArea))))&&((this.sourceUrl == rhs.sourceUrl)||((this.sourceUrl!= null)&&this.sourceUrl.equals(rhs.sourceUrl))))&&((this.payeeName == rhs.payeeName)||((this.payeeName!= null)&&this.payeeName.equals(rhs.payeeName))))&&((this.entityUri == rhs.entityUri)||((this.entityUri!= null)&&this.entityUri.equals(rhs.entityUri))))&&((this.retrievedAt == rhs.retrievedAt)||((this.retrievedAt!= null)&&this.retrievedAt.equals(rhs.retrievedAt))))&&((this.csvLineNumber == rhs.csvLineNumber)||((this.csvLineNumber!= null)&&this.csvLineNumber.equals(rhs.csvLineNumber))))&&((this.entityName == rhs.entityName)||((this.entityName!= null)&&this.entityName.equals(rhs.entityName))))&&((this.sampleDate == rhs.sampleDate)||((this.sampleDate!= null)&&this.sampleDate.equals(rhs.sampleDate))))&&((this.currency == rhs.currency)||((this.currency!= null)&&this.currency.equals(rhs.currency))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))));
    }


    /**
     * Confidence in accuracy of data
     * 
     */
    public enum Confidence {

        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");
        private final String value;
        private final static Map<String, OCSimpleFinancialPaymentSchema.Confidence> CONSTANTS = new HashMap<String, OCSimpleFinancialPaymentSchema.Confidence>();

        static {
            for (OCSimpleFinancialPaymentSchema.Confidence c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Confidence(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCSimpleFinancialPaymentSchema.Confidence fromValue(String value) {
            OCSimpleFinancialPaymentSchema.Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }


    /**
     * The type of expense -- can be either capital, revenue (i.e. current expenditure) or null
     * 
     */
    public enum ExpenseType {

        CAPITAL("capital"),
        REVENUE("revenue");
        private final String value;
        private final static Map<String, OCSimpleFinancialPaymentSchema.ExpenseType> CONSTANTS = new HashMap<String, OCSimpleFinancialPaymentSchema.ExpenseType>();

        static {
            for (OCSimpleFinancialPaymentSchema.ExpenseType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private ExpenseType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCSimpleFinancialPaymentSchema.ExpenseType fromValue(String value) {
            OCSimpleFinancialPaymentSchema.ExpenseType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
