
package com.opencorporates.schemas;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "source_url",
    "sample_date",
    "start_date",
    "end_date",
    "confidence",
    "company_name",
    "company_jurisdiction",
    "licence_number",
    "jurisdiction_classification",
    "regulator",
    "licence_jurisdiction",
    "status",
    "retrieved_at",
    "category"
})
public class OCSimpleLicenceSchema {

    /**
     * Place where this fact can be verified
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    @JsonPropertyDescription("Place where this fact can be verified")
    @Size(min = 1)
    @NotNull
    private String sourceUrl;
    /**
     * Date on which this fact was known to be true
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    @JsonPropertyDescription("Date on which this fact was known to be true")
    @NotNull
    private LocalDate sampleDate;
    @JsonProperty("start_date")
    private LocalDate startDate;
    @JsonProperty("end_date")
    private LocalDate endDate;
    /**
     * Confidence in accuracy of data
     * 
     */
    @JsonProperty("confidence")
    @JsonPropertyDescription("Confidence in accuracy of data")
    private OCSimpleLicenceSchema.Confidence confidence;
    /**
     * Name of the company holding the licence
     * (Required)
     * 
     */
    @JsonProperty("company_name")
    @JsonPropertyDescription("Name of the company holding the licence")
    @Size(min = 1)
    @NotNull
    private String companyName;
    /**
     * Jurisdiction where company is based
     * (Required)
     * 
     */
    @JsonProperty("company_jurisdiction")
    @JsonPropertyDescription("Jurisdiction where company is based")
    @Size(min = 1)
    @NotNull
    private String companyJurisdiction;
    /**
     * Licence number or code
     * 
     */
    @JsonProperty("licence_number")
    @JsonPropertyDescription("Licence number or code")
    private String licenceNumber;
    /**
     * Description of how regulator classifies licence
     * 
     */
    @JsonProperty("jurisdiction_classification")
    @JsonPropertyDescription("Description of how regulator classifies licence")
    private String jurisdictionClassification;
    /**
     * The regulating body that issued the licence
     * 
     */
    @JsonProperty("regulator")
    @JsonPropertyDescription("The regulating body that issued the licence")
    private String regulator;
    /**
     * Jurisdiction for which licence is issued
     * 
     */
    @JsonProperty("licence_jurisdiction")
    @JsonPropertyDescription("Jurisdiction for which licence is issued")
    @Size(min = 1)
    private String licenceJurisdiction;
    /**
     * Status of the licence
     * 
     */
    @JsonProperty("status")
    @JsonPropertyDescription("Status of the licence")
    private String status;
    @JsonProperty("retrieved_at")
    private LocalDate retrievedAt;
    /**
     * Category of licence
     * 
     */
    @JsonProperty("category")
    @JsonPropertyDescription("Category of licence")
    private OCSimpleLicenceSchema.Category category;

    /**
     * Place where this fact can be verified
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    public String getSourceUrl() {
        return sourceUrl;
    }

    /**
     * Place where this fact can be verified
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    /**
     * Date on which this fact was known to be true
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public LocalDate getSampleDate() {
        return sampleDate;
    }

    /**
     * Date on which this fact was known to be true
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    @JsonProperty("start_date")
    public LocalDate getStartDate() {
        return startDate;
    }

    @JsonProperty("start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @JsonProperty("end_date")
    public LocalDate getEndDate() {
        return endDate;
    }

    @JsonProperty("end_date")
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    /**
     * Confidence in accuracy of data
     * 
     */
    @JsonProperty("confidence")
    public OCSimpleLicenceSchema.Confidence getConfidence() {
        return confidence;
    }

    /**
     * Confidence in accuracy of data
     * 
     */
    @JsonProperty("confidence")
    public void setConfidence(OCSimpleLicenceSchema.Confidence confidence) {
        this.confidence = confidence;
    }

    /**
     * Name of the company holding the licence
     * (Required)
     * 
     */
    @JsonProperty("company_name")
    public String getCompanyName() {
        return companyName;
    }

    /**
     * Name of the company holding the licence
     * (Required)
     * 
     */
    @JsonProperty("company_name")
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * Jurisdiction where company is based
     * (Required)
     * 
     */
    @JsonProperty("company_jurisdiction")
    public String getCompanyJurisdiction() {
        return companyJurisdiction;
    }

    /**
     * Jurisdiction where company is based
     * (Required)
     * 
     */
    @JsonProperty("company_jurisdiction")
    public void setCompanyJurisdiction(String companyJurisdiction) {
        this.companyJurisdiction = companyJurisdiction;
    }

    /**
     * Licence number or code
     * 
     */
    @JsonProperty("licence_number")
    public String getLicenceNumber() {
        return licenceNumber;
    }

    /**
     * Licence number or code
     * 
     */
    @JsonProperty("licence_number")
    public void setLicenceNumber(String licenceNumber) {
        this.licenceNumber = licenceNumber;
    }

    /**
     * Description of how regulator classifies licence
     * 
     */
    @JsonProperty("jurisdiction_classification")
    public String getJurisdictionClassification() {
        return jurisdictionClassification;
    }

    /**
     * Description of how regulator classifies licence
     * 
     */
    @JsonProperty("jurisdiction_classification")
    public void setJurisdictionClassification(String jurisdictionClassification) {
        this.jurisdictionClassification = jurisdictionClassification;
    }

    /**
     * The regulating body that issued the licence
     * 
     */
    @JsonProperty("regulator")
    public String getRegulator() {
        return regulator;
    }

    /**
     * The regulating body that issued the licence
     * 
     */
    @JsonProperty("regulator")
    public void setRegulator(String regulator) {
        this.regulator = regulator;
    }

    /**
     * Jurisdiction for which licence is issued
     * 
     */
    @JsonProperty("licence_jurisdiction")
    public String getLicenceJurisdiction() {
        return licenceJurisdiction;
    }

    /**
     * Jurisdiction for which licence is issued
     * 
     */
    @JsonProperty("licence_jurisdiction")
    public void setLicenceJurisdiction(String licenceJurisdiction) {
        this.licenceJurisdiction = licenceJurisdiction;
    }

    /**
     * Status of the licence
     * 
     */
    @JsonProperty("status")
    public String getStatus() {
        return status;
    }

    /**
     * Status of the licence
     * 
     */
    @JsonProperty("status")
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty("retrieved_at")
    public LocalDate getRetrievedAt() {
        return retrievedAt;
    }

    @JsonProperty("retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    /**
     * Category of licence
     * 
     */
    @JsonProperty("category")
    public OCSimpleLicenceSchema.Category getCategory() {
        return category;
    }

    /**
     * Category of licence
     * 
     */
    @JsonProperty("category")
    public void setCategory(OCSimpleLicenceSchema.Category category) {
        this.category = category;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCSimpleLicenceSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(((this.sourceUrl == null)?"<null>":this.sourceUrl));
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(((this.sampleDate == null)?"<null>":this.sampleDate));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(((this.confidence == null)?"<null>":this.confidence));
        sb.append(',');
        sb.append("companyName");
        sb.append('=');
        sb.append(((this.companyName == null)?"<null>":this.companyName));
        sb.append(',');
        sb.append("companyJurisdiction");
        sb.append('=');
        sb.append(((this.companyJurisdiction == null)?"<null>":this.companyJurisdiction));
        sb.append(',');
        sb.append("licenceNumber");
        sb.append('=');
        sb.append(((this.licenceNumber == null)?"<null>":this.licenceNumber));
        sb.append(',');
        sb.append("jurisdictionClassification");
        sb.append('=');
        sb.append(((this.jurisdictionClassification == null)?"<null>":this.jurisdictionClassification));
        sb.append(',');
        sb.append("regulator");
        sb.append('=');
        sb.append(((this.regulator == null)?"<null>":this.regulator));
        sb.append(',');
        sb.append("licenceJurisdiction");
        sb.append('=');
        sb.append(((this.licenceJurisdiction == null)?"<null>":this.licenceJurisdiction));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(((this.retrievedAt == null)?"<null>":this.retrievedAt));
        sb.append(',');
        sb.append("category");
        sb.append('=');
        sb.append(((this.category == null)?"<null>":this.category));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.confidence == null)? 0 :this.confidence.hashCode()));
        result = ((result* 31)+((this.companyName == null)? 0 :this.companyName.hashCode()));
        result = ((result* 31)+((this.companyJurisdiction == null)? 0 :this.companyJurisdiction.hashCode()));
        result = ((result* 31)+((this.licenceNumber == null)? 0 :this.licenceNumber.hashCode()));
        result = ((result* 31)+((this.jurisdictionClassification == null)? 0 :this.jurisdictionClassification.hashCode()));
        result = ((result* 31)+((this.sourceUrl == null)? 0 :this.sourceUrl.hashCode()));
        result = ((result* 31)+((this.retrievedAt == null)? 0 :this.retrievedAt.hashCode()));
        result = ((result* 31)+((this.licenceJurisdiction == null)? 0 :this.licenceJurisdiction.hashCode()));
        result = ((result* 31)+((this.sampleDate == null)? 0 :this.sampleDate.hashCode()));
        result = ((result* 31)+((this.regulator == null)? 0 :this.regulator.hashCode()));
        result = ((result* 31)+((this.category == null)? 0 :this.category.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCSimpleLicenceSchema) == false) {
            return false;
        }
        OCSimpleLicenceSchema rhs = ((OCSimpleLicenceSchema) other);
        return (((((((((((((((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate)))&&((this.confidence == rhs.confidence)||((this.confidence!= null)&&this.confidence.equals(rhs.confidence))))&&((this.companyName == rhs.companyName)||((this.companyName!= null)&&this.companyName.equals(rhs.companyName))))&&((this.companyJurisdiction == rhs.companyJurisdiction)||((this.companyJurisdiction!= null)&&this.companyJurisdiction.equals(rhs.companyJurisdiction))))&&((this.licenceNumber == rhs.licenceNumber)||((this.licenceNumber!= null)&&this.licenceNumber.equals(rhs.licenceNumber))))&&((this.jurisdictionClassification == rhs.jurisdictionClassification)||((this.jurisdictionClassification!= null)&&this.jurisdictionClassification.equals(rhs.jurisdictionClassification))))&&((this.sourceUrl == rhs.sourceUrl)||((this.sourceUrl!= null)&&this.sourceUrl.equals(rhs.sourceUrl))))&&((this.retrievedAt == rhs.retrievedAt)||((this.retrievedAt!= null)&&this.retrievedAt.equals(rhs.retrievedAt))))&&((this.licenceJurisdiction == rhs.licenceJurisdiction)||((this.licenceJurisdiction!= null)&&this.licenceJurisdiction.equals(rhs.licenceJurisdiction))))&&((this.sampleDate == rhs.sampleDate)||((this.sampleDate!= null)&&this.sampleDate.equals(rhs.sampleDate))))&&((this.regulator == rhs.regulator)||((this.regulator!= null)&&this.regulator.equals(rhs.regulator))))&&((this.category == rhs.category)||((this.category!= null)&&this.category.equals(rhs.category))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }


    /**
     * Category of licence
     * 
     */
    public enum Category {

        FINANCIAL("Financial"),
        BUSINESS("Business");
        private final String value;
        private final static Map<String, OCSimpleLicenceSchema.Category> CONSTANTS = new HashMap<String, OCSimpleLicenceSchema.Category>();

        static {
            for (OCSimpleLicenceSchema.Category c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Category(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCSimpleLicenceSchema.Category fromValue(String value) {
            OCSimpleLicenceSchema.Category constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }


    /**
     * Confidence in accuracy of data
     * 
     */
    public enum Confidence {

        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");
        private final String value;
        private final static Map<String, OCSimpleLicenceSchema.Confidence> CONSTANTS = new HashMap<String, OCSimpleLicenceSchema.Confidence>();

        static {
            for (OCSimpleLicenceSchema.Confidence c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Confidence(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCSimpleLicenceSchema.Confidence fromValue(String value) {
            OCSimpleLicenceSchema.Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
