
package com.opencorporates.schemas;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "data_type",
    "customer",
    "supplier",
    "start_date",
    "start_date_type",
    "end_date",
    "end_date_type",
    "sample_date",
    "retrieved_at",
    "source_url",
    "confidence"
})
public class OCSupplierRelationshipSchema {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("data_type")
    @NotNull
    private OCSupplierRelationshipSchema.DataType dataType;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("customer")
    @Valid
    @NotNull
    private OCEntity customer;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("supplier")
    @Valid
    @NotNull
    private OCEntity supplier;
    @JsonProperty("start_date")
    private LocalDate startDate;
    @JsonProperty("start_date_type")
    private OCSupplierRelationshipSchema.StartDateType startDateType;
    @JsonProperty("end_date")
    private LocalDate endDate;
    @JsonProperty("end_date_type")
    private OCSupplierRelationshipSchema.EndDateType endDateType;
    @JsonProperty("sample_date")
    private LocalDate sampleDate;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    @NotNull
    private LocalDate retrievedAt;
    @JsonProperty("source_url")
    private String sourceUrl;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    @NotNull
    private OCSupplierRelationshipSchema.Confidence confidence;

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("data_type")
    public OCSupplierRelationshipSchema.DataType getDataType() {
        return dataType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("data_type")
    public void setDataType(OCSupplierRelationshipSchema.DataType dataType) {
        this.dataType = dataType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("customer")
    public OCEntity getCustomer() {
        return customer;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("customer")
    public void setCustomer(OCEntity customer) {
        this.customer = customer;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("supplier")
    public OCEntity getSupplier() {
        return supplier;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("supplier")
    public void setSupplier(OCEntity supplier) {
        this.supplier = supplier;
    }

    @JsonProperty("start_date")
    public LocalDate getStartDate() {
        return startDate;
    }

    @JsonProperty("start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @JsonProperty("start_date_type")
    public OCSupplierRelationshipSchema.StartDateType getStartDateType() {
        return startDateType;
    }

    @JsonProperty("start_date_type")
    public void setStartDateType(OCSupplierRelationshipSchema.StartDateType startDateType) {
        this.startDateType = startDateType;
    }

    @JsonProperty("end_date")
    public LocalDate getEndDate() {
        return endDate;
    }

    @JsonProperty("end_date")
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    @JsonProperty("end_date_type")
    public OCSupplierRelationshipSchema.EndDateType getEndDateType() {
        return endDateType;
    }

    @JsonProperty("end_date_type")
    public void setEndDateType(OCSupplierRelationshipSchema.EndDateType endDateType) {
        this.endDateType = endDateType;
    }

    @JsonProperty("sample_date")
    public LocalDate getSampleDate() {
        return sampleDate;
    }

    @JsonProperty("sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    public LocalDate getRetrievedAt() {
        return retrievedAt;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    @JsonProperty("source_url")
    public String getSourceUrl() {
        return sourceUrl;
    }

    @JsonProperty("source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    public OCSupplierRelationshipSchema.Confidence getConfidence() {
        return confidence;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    public void setConfidence(OCSupplierRelationshipSchema.Confidence confidence) {
        this.confidence = confidence;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCSupplierRelationshipSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataType");
        sb.append('=');
        sb.append(((this.dataType == null)?"<null>":this.dataType));
        sb.append(',');
        sb.append("customer");
        sb.append('=');
        sb.append(((this.customer == null)?"<null>":this.customer));
        sb.append(',');
        sb.append("supplier");
        sb.append('=');
        sb.append(((this.supplier == null)?"<null>":this.supplier));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("startDateType");
        sb.append('=');
        sb.append(((this.startDateType == null)?"<null>":this.startDateType));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("endDateType");
        sb.append('=');
        sb.append(((this.endDateType == null)?"<null>":this.endDateType));
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(((this.sampleDate == null)?"<null>":this.sampleDate));
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(((this.retrievedAt == null)?"<null>":this.retrievedAt));
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(((this.sourceUrl == null)?"<null>":this.sourceUrl));
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(((this.confidence == null)?"<null>":this.confidence));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.sourceUrl == null)? 0 :this.sourceUrl.hashCode()));
        result = ((result* 31)+((this.retrievedAt == null)? 0 :this.retrievedAt.hashCode()));
        result = ((result* 31)+((this.startDateType == null)? 0 :this.startDateType.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.dataType == null)? 0 :this.dataType.hashCode()));
        result = ((result* 31)+((this.supplier == null)? 0 :this.supplier.hashCode()));
        result = ((result* 31)+((this.confidence == null)? 0 :this.confidence.hashCode()));
        result = ((result* 31)+((this.sampleDate == null)? 0 :this.sampleDate.hashCode()));
        result = ((result* 31)+((this.endDateType == null)? 0 :this.endDateType.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        result = ((result* 31)+((this.customer == null)? 0 :this.customer.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCSupplierRelationshipSchema) == false) {
            return false;
        }
        OCSupplierRelationshipSchema rhs = ((OCSupplierRelationshipSchema) other);
        return ((((((((((((this.sourceUrl == rhs.sourceUrl)||((this.sourceUrl!= null)&&this.sourceUrl.equals(rhs.sourceUrl)))&&((this.retrievedAt == rhs.retrievedAt)||((this.retrievedAt!= null)&&this.retrievedAt.equals(rhs.retrievedAt))))&&((this.startDateType == rhs.startDateType)||((this.startDateType!= null)&&this.startDateType.equals(rhs.startDateType))))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.dataType == rhs.dataType)||((this.dataType!= null)&&this.dataType.equals(rhs.dataType))))&&((this.supplier == rhs.supplier)||((this.supplier!= null)&&this.supplier.equals(rhs.supplier))))&&((this.confidence == rhs.confidence)||((this.confidence!= null)&&this.confidence.equals(rhs.confidence))))&&((this.sampleDate == rhs.sampleDate)||((this.sampleDate!= null)&&this.sampleDate.equals(rhs.sampleDate))))&&((this.endDateType == rhs.endDateType)||((this.endDateType!= null)&&this.endDateType.equals(rhs.endDateType))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))))&&((this.customer == rhs.customer)||((this.customer!= null)&&this.customer.equals(rhs.customer))));
    }

    public enum Confidence {

        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");
        private final String value;
        private final static Map<String, OCSupplierRelationshipSchema.Confidence> CONSTANTS = new HashMap<String, OCSupplierRelationshipSchema.Confidence>();

        static {
            for (OCSupplierRelationshipSchema.Confidence c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Confidence(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCSupplierRelationshipSchema.Confidence fromValue(String value) {
            OCSupplierRelationshipSchema.Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum DataType {

        SUPPLIER_RELATIONSHIP("supplier-relationship");
        private final String value;
        private final static Map<String, OCSupplierRelationshipSchema.DataType> CONSTANTS = new HashMap<String, OCSupplierRelationshipSchema.DataType>();

        static {
            for (OCSupplierRelationshipSchema.DataType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private DataType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCSupplierRelationshipSchema.DataType fromValue(String value) {
            OCSupplierRelationshipSchema.DataType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum EndDateType {

        AT("at"),
        BEFORE("before"),
        AFTER("after");
        private final String value;
        private final static Map<String, OCSupplierRelationshipSchema.EndDateType> CONSTANTS = new HashMap<String, OCSupplierRelationshipSchema.EndDateType>();

        static {
            for (OCSupplierRelationshipSchema.EndDateType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private EndDateType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCSupplierRelationshipSchema.EndDateType fromValue(String value) {
            OCSupplierRelationshipSchema.EndDateType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum StartDateType {

        AT("at"),
        BEFORE("before"),
        AFTER("after");
        private final String value;
        private final static Map<String, OCSupplierRelationshipSchema.StartDateType> CONSTANTS = new HashMap<String, OCSupplierRelationshipSchema.StartDateType>();

        static {
            for (OCSupplierRelationshipSchema.StartDateType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private StartDateType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCSupplierRelationshipSchema.StartDateType fromValue(String value) {
            OCSupplierRelationshipSchema.StartDateType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
