
package com.opencorporates.schemas;

import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * the surviving_company that this has been merged into
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "company_number",
    "jurisdiction"
})
public class OCSurvivingCompany {

    /**
     * The legal name of the surviving company
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("The legal name of the surviving company")
    @Size(min = 1)
    private String name;
    /**
     * The company_number of the surviving company, if known
     * 
     */
    @JsonProperty("company_number")
    @JsonPropertyDescription("The company_number of the surviving company, if known")
    @Size(min = 1)
    private String companyNumber;
    /**
     * The jurisdiction of incorporation of the surviving company
     * 
     */
    @JsonProperty("jurisdiction")
    @JsonPropertyDescription("The jurisdiction of incorporation of the surviving company")
    @Size(min = 2)
    private String jurisdiction;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The legal name of the surviving company
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * The legal name of the surviving company
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * The company_number of the surviving company, if known
     * 
     */
    @JsonProperty("company_number")
    public String getCompanyNumber() {
        return companyNumber;
    }

    /**
     * The company_number of the surviving company, if known
     * 
     */
    @JsonProperty("company_number")
    public void setCompanyNumber(String companyNumber) {
        this.companyNumber = companyNumber;
    }

    /**
     * The jurisdiction of incorporation of the surviving company
     * 
     */
    @JsonProperty("jurisdiction")
    public String getJurisdiction() {
        return jurisdiction;
    }

    /**
     * The jurisdiction of incorporation of the surviving company
     * 
     */
    @JsonProperty("jurisdiction")
    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCSurvivingCompany.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("companyNumber");
        sb.append('=');
        sb.append(((this.companyNumber == null)?"<null>":this.companyNumber));
        sb.append(',');
        sb.append("jurisdiction");
        sb.append('=');
        sb.append(((this.jurisdiction == null)?"<null>":this.jurisdiction));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.companyNumber == null)? 0 :this.companyNumber.hashCode()));
        result = ((result* 31)+((this.jurisdiction == null)? 0 :this.jurisdiction.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCSurvivingCompany) == false) {
            return false;
        }
        OCSurvivingCompany rhs = ((OCSurvivingCompany) other);
        return (((((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.companyNumber == rhs.companyNumber)||((this.companyNumber!= null)&&this.companyNumber.equals(rhs.companyNumber))))&&((this.jurisdiction == rhs.jurisdiction)||((this.jurisdiction!= null)&&this.jurisdiction.equals(rhs.jurisdiction))));
    }

}
