
package com.opencorporates.schemas;

import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * Update action
 * <p>
 * An act of changing an object
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "type",
    "object"
})
public class OCUpdateAction {

    /**
     * The type of change
     * 
     */
    @JsonProperty("type")
    @JsonPropertyDescription("The type of change")
    private OCUpdateAction.Type type;
    /**
     * The object that was changed
     * (Required)
     * 
     */
    @JsonProperty("object")
    @JsonPropertyDescription("The object that was changed")
    @Valid
    @NotNull
    private OCObject object;

    /**
     * The type of change
     * 
     */
    @JsonProperty("type")
    public OCUpdateAction.Type getType() {
        return type;
    }

    /**
     * The type of change
     * 
     */
    @JsonProperty("type")
    public void setType(OCUpdateAction.Type type) {
        this.type = type;
    }

    /**
     * The object that was changed
     * (Required)
     * 
     */
    @JsonProperty("object")
    public OCObject getObject() {
        return object;
    }

    /**
     * The object that was changed
     * (Required)
     * 
     */
    @JsonProperty("object")
    public void setObject(OCObject object) {
        this.object = object;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCUpdateAction.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("object");
        sb.append('=');
        sb.append(((this.object == null)?"<null>":this.object));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.object == null)? 0 :this.object.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCUpdateAction) == false) {
            return false;
        }
        OCUpdateAction rhs = ((OCUpdateAction) other);
        return (((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type)))&&((this.object == rhs.object)||((this.object!= null)&&this.object.equals(rhs.object))));
    }


    /**
     * The type of change
     * 
     */
    public enum Type {

        CANCELLATION("cancellation"),
        CORRECTION("correction");
        private final String value;
        private final static Map<String, OCUpdateAction.Type> CONSTANTS = new HashMap<String, OCUpdateAction.Type>();

        static {
            for (OCUpdateAction.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCUpdateAction.Type fromValue(String value) {
            OCUpdateAction.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
