
package com.opencorporates.schemas.includes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.opencorporates.schemas.OCAlternativeName;
import com.opencorporates.schemas.OCIdentifier;
import com.opencorporates.schemas.OCIndustryCode;


/**
 * A person, for example, referenced in some other context, e.g. director of a company, shareholder, licence-holder, lobbyist. This should be used only if the person is the subject of the datum
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "jurisdiction",
    "company",
    "relationship_with_company",
    "website",
    "uid",
    "telephone_number",
    "fax_number",
    "registered_address",
    "headquarters_address",
    "mailing_address",
    "addresses",
    "industry_codes",
    "alternative_names",
    "date_of_birth",
    "nationality",
    "country_of_residence",
    "identifiers",
    "other_attributes"
})
public class OCPerson {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("name")
    @NotNull
    private Object name;
    /**
     * Name of the jurisdiction in which the entity is based
     * 
     */
    @JsonProperty("jurisdiction")
    @JsonPropertyDescription("Name of the jurisdiction in which the entity is based")
    private String jurisdiction;
    /**
     * A company in OpenCorporates
     * 
     */
    @JsonProperty("company")
    @JsonPropertyDescription("A company in OpenCorporates")
    @Valid
    private OCCompanyForNesting company;
    @JsonProperty("relationship_with_company")
    private OCPerson.RelationshipWithCompany relationshipWithCompany;
    @JsonProperty("website")
    private Object website;
    /**
     * Unique id of the person. Note: the unique id is not expected to be globally unique, but only unique with reference to the source from which it is derived. No check is made for uniqueness
     * 
     */
    @JsonProperty("uid")
    @JsonPropertyDescription("Unique id of the person. Note: the unique id is not expected to be globally unique, but only unique with reference to the source from which it is derived. No check is made for uniqueness")
    @Size(min = 1)
    private String uid;
    @JsonProperty("telephone_number")
    @Size(min = 4)
    private String telephoneNumber;
    @JsonProperty("fax_number")
    @Size(min = 4)
    private String faxNumber;
    @JsonProperty("registered_address")
    private Object registeredAddress;
    @JsonProperty("headquarters_address")
    private Object headquartersAddress;
    @JsonProperty("mailing_address")
    private Object mailingAddress;
    @JsonProperty("addresses")
    @Valid
    private List<OCAddressWithType> addresses = new ArrayList<OCAddressWithType>();
    @JsonProperty("industry_codes")
    @Valid
    private List<OCIndustryCode> industryCodes = new ArrayList<OCIndustryCode>();
    @JsonProperty("alternative_names")
    @Valid
    private List<OCAlternativeName> alternativeNames = new ArrayList<OCAlternativeName>();
    @JsonProperty("date_of_birth")
    private Object dateOfBirth;
    /**
     * The person's nationality
     * 
     */
    @JsonProperty("nationality")
    @JsonPropertyDescription("The person's nationality")
    private String nationality;
    /**
     * The normal country of residence for the person
     * 
     */
    @JsonProperty("country_of_residence")
    @JsonPropertyDescription("The normal country of residence for the person")
    private String countryOfResidence;
    @JsonProperty("identifiers")
    private List<OCIdentifier> identifiers = new ArrayList<OCIdentifier>();
    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    @JsonPropertyDescription("Use for other attributes for which we don't yet have curated schema attributes")
    @Valid
    private OCOtherAttributes__1 otherAttributes;

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("name")
    public Object getName() {
        return name;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(Object name) {
        this.name = name;
    }

    /**
     * Name of the jurisdiction in which the entity is based
     * 
     */
    @JsonProperty("jurisdiction")
    public String getJurisdiction() {
        return jurisdiction;
    }

    /**
     * Name of the jurisdiction in which the entity is based
     * 
     */
    @JsonProperty("jurisdiction")
    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    /**
     * A company in OpenCorporates
     * 
     */
    @JsonProperty("company")
    public OCCompanyForNesting getCompany() {
        return company;
    }

    /**
     * A company in OpenCorporates
     * 
     */
    @JsonProperty("company")
    public void setCompany(OCCompanyForNesting company) {
        this.company = company;
    }

    @JsonProperty("relationship_with_company")
    public OCPerson.RelationshipWithCompany getRelationshipWithCompany() {
        return relationshipWithCompany;
    }

    @JsonProperty("relationship_with_company")
    public void setRelationshipWithCompany(OCPerson.RelationshipWithCompany relationshipWithCompany) {
        this.relationshipWithCompany = relationshipWithCompany;
    }

    @JsonProperty("website")
    public Object getWebsite() {
        return website;
    }

    @JsonProperty("website")
    public void setWebsite(Object website) {
        this.website = website;
    }

    /**
     * Unique id of the person. Note: the unique id is not expected to be globally unique, but only unique with reference to the source from which it is derived. No check is made for uniqueness
     * 
     */
    @JsonProperty("uid")
    public String getUid() {
        return uid;
    }

    /**
     * Unique id of the person. Note: the unique id is not expected to be globally unique, but only unique with reference to the source from which it is derived. No check is made for uniqueness
     * 
     */
    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    @JsonProperty("telephone_number")
    public String getTelephoneNumber() {
        return telephoneNumber;
    }

    @JsonProperty("telephone_number")
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    @JsonProperty("fax_number")
    public String getFaxNumber() {
        return faxNumber;
    }

    @JsonProperty("fax_number")
    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    @JsonProperty("registered_address")
    public Object getRegisteredAddress() {
        return registeredAddress;
    }

    @JsonProperty("registered_address")
    public void setRegisteredAddress(Object registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    @JsonProperty("headquarters_address")
    public Object getHeadquartersAddress() {
        return headquartersAddress;
    }

    @JsonProperty("headquarters_address")
    public void setHeadquartersAddress(Object headquartersAddress) {
        this.headquartersAddress = headquartersAddress;
    }

    @JsonProperty("mailing_address")
    public Object getMailingAddress() {
        return mailingAddress;
    }

    @JsonProperty("mailing_address")
    public void setMailingAddress(Object mailingAddress) {
        this.mailingAddress = mailingAddress;
    }

    @JsonProperty("addresses")
    public List<OCAddressWithType> getAddresses() {
        return addresses;
    }

    @JsonProperty("addresses")
    public void setAddresses(List<OCAddressWithType> addresses) {
        this.addresses = addresses;
    }

    @JsonProperty("industry_codes")
    public List<OCIndustryCode> getIndustryCodes() {
        return industryCodes;
    }

    @JsonProperty("industry_codes")
    public void setIndustryCodes(List<OCIndustryCode> industryCodes) {
        this.industryCodes = industryCodes;
    }

    @JsonProperty("alternative_names")
    public List<OCAlternativeName> getAlternativeNames() {
        return alternativeNames;
    }

    @JsonProperty("alternative_names")
    public void setAlternativeNames(List<OCAlternativeName> alternativeNames) {
        this.alternativeNames = alternativeNames;
    }

    @JsonProperty("date_of_birth")
    public Object getDateOfBirth() {
        return dateOfBirth;
    }

    @JsonProperty("date_of_birth")
    public void setDateOfBirth(Object dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    /**
     * The person's nationality
     * 
     */
    @JsonProperty("nationality")
    public String getNationality() {
        return nationality;
    }

    /**
     * The person's nationality
     * 
     */
    @JsonProperty("nationality")
    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    /**
     * The normal country of residence for the person
     * 
     */
    @JsonProperty("country_of_residence")
    public String getCountryOfResidence() {
        return countryOfResidence;
    }

    /**
     * The normal country of residence for the person
     * 
     */
    @JsonProperty("country_of_residence")
    public void setCountryOfResidence(String countryOfResidence) {
        this.countryOfResidence = countryOfResidence;
    }

    @JsonProperty("identifiers")
    public List<OCIdentifier> getIdentifiers() {
        return identifiers;
    }

    @JsonProperty("identifiers")
    public void setIdentifiers(List<OCIdentifier> identifiers) {
        this.identifiers = identifiers;
    }

    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    public OCOtherAttributes__1 getOtherAttributes() {
        return otherAttributes;
    }

    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    public void setOtherAttributes(OCOtherAttributes__1 otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCPerson.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("jurisdiction");
        sb.append('=');
        sb.append(((this.jurisdiction == null)?"<null>":this.jurisdiction));
        sb.append(',');
        sb.append("company");
        sb.append('=');
        sb.append(((this.company == null)?"<null>":this.company));
        sb.append(',');
        sb.append("relationshipWithCompany");
        sb.append('=');
        sb.append(((this.relationshipWithCompany == null)?"<null>":this.relationshipWithCompany));
        sb.append(',');
        sb.append("website");
        sb.append('=');
        sb.append(((this.website == null)?"<null>":this.website));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("telephoneNumber");
        sb.append('=');
        sb.append(((this.telephoneNumber == null)?"<null>":this.telephoneNumber));
        sb.append(',');
        sb.append("faxNumber");
        sb.append('=');
        sb.append(((this.faxNumber == null)?"<null>":this.faxNumber));
        sb.append(',');
        sb.append("registeredAddress");
        sb.append('=');
        sb.append(((this.registeredAddress == null)?"<null>":this.registeredAddress));
        sb.append(',');
        sb.append("headquartersAddress");
        sb.append('=');
        sb.append(((this.headquartersAddress == null)?"<null>":this.headquartersAddress));
        sb.append(',');
        sb.append("mailingAddress");
        sb.append('=');
        sb.append(((this.mailingAddress == null)?"<null>":this.mailingAddress));
        sb.append(',');
        sb.append("addresses");
        sb.append('=');
        sb.append(((this.addresses == null)?"<null>":this.addresses));
        sb.append(',');
        sb.append("industryCodes");
        sb.append('=');
        sb.append(((this.industryCodes == null)?"<null>":this.industryCodes));
        sb.append(',');
        sb.append("alternativeNames");
        sb.append('=');
        sb.append(((this.alternativeNames == null)?"<null>":this.alternativeNames));
        sb.append(',');
        sb.append("dateOfBirth");
        sb.append('=');
        sb.append(((this.dateOfBirth == null)?"<null>":this.dateOfBirth));
        sb.append(',');
        sb.append("nationality");
        sb.append('=');
        sb.append(((this.nationality == null)?"<null>":this.nationality));
        sb.append(',');
        sb.append("countryOfResidence");
        sb.append('=');
        sb.append(((this.countryOfResidence == null)?"<null>":this.countryOfResidence));
        sb.append(',');
        sb.append("identifiers");
        sb.append('=');
        sb.append(((this.identifiers == null)?"<null>":this.identifiers));
        sb.append(',');
        sb.append("otherAttributes");
        sb.append('=');
        sb.append(((this.otherAttributes == null)?"<null>":this.otherAttributes));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.website == null)? 0 :this.website.hashCode()));
        result = ((result* 31)+((this.addresses == null)? 0 :this.addresses.hashCode()));
        result = ((result* 31)+((this.telephoneNumber == null)? 0 :this.telephoneNumber.hashCode()));
        result = ((result* 31)+((this.identifiers == null)? 0 :this.identifiers.hashCode()));
        result = ((result* 31)+((this.jurisdiction == null)? 0 :this.jurisdiction.hashCode()));
        result = ((result* 31)+((this.dateOfBirth == null)? 0 :this.dateOfBirth.hashCode()));
        result = ((result* 31)+((this.headquartersAddress == null)? 0 :this.headquartersAddress.hashCode()));
        result = ((result* 31)+((this.industryCodes == null)? 0 :this.industryCodes.hashCode()));
        result = ((result* 31)+((this.countryOfResidence == null)? 0 :this.countryOfResidence.hashCode()));
        result = ((result* 31)+((this.otherAttributes == null)? 0 :this.otherAttributes.hashCode()));
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.alternativeNames == null)? 0 :this.alternativeNames.hashCode()));
        result = ((result* 31)+((this.registeredAddress == null)? 0 :this.registeredAddress.hashCode()));
        result = ((result* 31)+((this.nationality == null)? 0 :this.nationality.hashCode()));
        result = ((result* 31)+((this.mailingAddress == null)? 0 :this.mailingAddress.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.relationshipWithCompany == null)? 0 :this.relationshipWithCompany.hashCode()));
        result = ((result* 31)+((this.faxNumber == null)? 0 :this.faxNumber.hashCode()));
        result = ((result* 31)+((this.company == null)? 0 :this.company.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCPerson) == false) {
            return false;
        }
        OCPerson rhs = ((OCPerson) other);
        return ((((((((((((((((((((this.website == rhs.website)||((this.website!= null)&&this.website.equals(rhs.website)))&&((this.addresses == rhs.addresses)||((this.addresses!= null)&&this.addresses.equals(rhs.addresses))))&&((this.telephoneNumber == rhs.telephoneNumber)||((this.telephoneNumber!= null)&&this.telephoneNumber.equals(rhs.telephoneNumber))))&&((this.identifiers == rhs.identifiers)||((this.identifiers!= null)&&this.identifiers.equals(rhs.identifiers))))&&((this.jurisdiction == rhs.jurisdiction)||((this.jurisdiction!= null)&&this.jurisdiction.equals(rhs.jurisdiction))))&&((this.dateOfBirth == rhs.dateOfBirth)||((this.dateOfBirth!= null)&&this.dateOfBirth.equals(rhs.dateOfBirth))))&&((this.headquartersAddress == rhs.headquartersAddress)||((this.headquartersAddress!= null)&&this.headquartersAddress.equals(rhs.headquartersAddress))))&&((this.industryCodes == rhs.industryCodes)||((this.industryCodes!= null)&&this.industryCodes.equals(rhs.industryCodes))))&&((this.countryOfResidence == rhs.countryOfResidence)||((this.countryOfResidence!= null)&&this.countryOfResidence.equals(rhs.countryOfResidence))))&&((this.otherAttributes == rhs.otherAttributes)||((this.otherAttributes!= null)&&this.otherAttributes.equals(rhs.otherAttributes))))&&((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid))))&&((this.alternativeNames == rhs.alternativeNames)||((this.alternativeNames!= null)&&this.alternativeNames.equals(rhs.alternativeNames))))&&((this.registeredAddress == rhs.registeredAddress)||((this.registeredAddress!= null)&&this.registeredAddress.equals(rhs.registeredAddress))))&&((this.nationality == rhs.nationality)||((this.nationality!= null)&&this.nationality.equals(rhs.nationality))))&&((this.mailingAddress == rhs.mailingAddress)||((this.mailingAddress!= null)&&this.mailingAddress.equals(rhs.mailingAddress))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.relationshipWithCompany == rhs.relationshipWithCompany)||((this.relationshipWithCompany!= null)&&this.relationshipWithCompany.equals(rhs.relationshipWithCompany))))&&((this.faxNumber == rhs.faxNumber)||((this.faxNumber!= null)&&this.faxNumber.equals(rhs.faxNumber))))&&((this.company == rhs.company)||((this.company!= null)&&this.company.equals(rhs.company))));
    }

    public enum RelationshipWithCompany {

        EMPLOYEE("employee"),
        DIRECTOR("director"),
        SHAREHOLDER("shareholder");
        private final String value;
        private final static Map<String, OCPerson.RelationshipWithCompany> CONSTANTS = new HashMap<String, OCPerson.RelationshipWithCompany>();

        static {
            for (OCPerson.RelationshipWithCompany c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private RelationshipWithCompany(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCPerson.RelationshipWithCompany fromValue(String value) {
            OCPerson.RelationshipWithCompany constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
