
package com.opencorporates.schemas.includes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * This represents a range of numeric values, particularly useful for where it is not clear of the exact numeric value, only that it is between two bounds, e.g. a shareholding percentage is greater than 50 but less than or equal to 75
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "minimum",
    "maximum",
    "exclusive_minimum",
    "exclusive_maximum"
})
public class OCRange {

    /**
     * The minimum value
     * 
     */
    @JsonProperty("minimum")
    @JsonPropertyDescription("The minimum value")
    private Double minimum;
    /**
     * The maximum value
     * 
     */
    @JsonProperty("maximum")
    @JsonPropertyDescription("The maximum value")
    private Double maximum;
    /**
     * True if the the minimum value is not included in the range, i.e. x > minumum (not x >= minumum)
     * 
     */
    @JsonProperty("exclusive_minimum")
    @JsonPropertyDescription("True if the the minimum value is not included in the range, i.e. x > minumum (not x >= minumum)")
    private Boolean exclusiveMinimum;
    /**
     * True if the the maximum value is not included in the range, i.e. x < maximum (not x <= maximum)
     * 
     */
    @JsonProperty("exclusive_maximum")
    @JsonPropertyDescription("True if the the maximum value is not included in the range, i.e. x < maximum (not x <= maximum)")
    private Boolean exclusiveMaximum;

    /**
     * The minimum value
     * 
     */
    @JsonProperty("minimum")
    public Double getMinimum() {
        return minimum;
    }

    /**
     * The minimum value
     * 
     */
    @JsonProperty("minimum")
    public void setMinimum(Double minimum) {
        this.minimum = minimum;
    }

    /**
     * The maximum value
     * 
     */
    @JsonProperty("maximum")
    public Double getMaximum() {
        return maximum;
    }

    /**
     * The maximum value
     * 
     */
    @JsonProperty("maximum")
    public void setMaximum(Double maximum) {
        this.maximum = maximum;
    }

    /**
     * True if the the minimum value is not included in the range, i.e. x > minumum (not x >= minumum)
     * 
     */
    @JsonProperty("exclusive_minimum")
    public Boolean getExclusiveMinimum() {
        return exclusiveMinimum;
    }

    /**
     * True if the the minimum value is not included in the range, i.e. x > minumum (not x >= minumum)
     * 
     */
    @JsonProperty("exclusive_minimum")
    public void setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
    }

    /**
     * True if the the maximum value is not included in the range, i.e. x < maximum (not x <= maximum)
     * 
     */
    @JsonProperty("exclusive_maximum")
    public Boolean getExclusiveMaximum() {
        return exclusiveMaximum;
    }

    /**
     * True if the the maximum value is not included in the range, i.e. x < maximum (not x <= maximum)
     * 
     */
    @JsonProperty("exclusive_maximum")
    public void setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCRange.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("minimum");
        sb.append('=');
        sb.append(((this.minimum == null)?"<null>":this.minimum));
        sb.append(',');
        sb.append("maximum");
        sb.append('=');
        sb.append(((this.maximum == null)?"<null>":this.maximum));
        sb.append(',');
        sb.append("exclusiveMinimum");
        sb.append('=');
        sb.append(((this.exclusiveMinimum == null)?"<null>":this.exclusiveMinimum));
        sb.append(',');
        sb.append("exclusiveMaximum");
        sb.append('=');
        sb.append(((this.exclusiveMaximum == null)?"<null>":this.exclusiveMaximum));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.exclusiveMaximum == null)? 0 :this.exclusiveMaximum.hashCode()));
        result = ((result* 31)+((this.maximum == null)? 0 :this.maximum.hashCode()));
        result = ((result* 31)+((this.exclusiveMinimum == null)? 0 :this.exclusiveMinimum.hashCode()));
        result = ((result* 31)+((this.minimum == null)? 0 :this.minimum.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCRange) == false) {
            return false;
        }
        OCRange rhs = ((OCRange) other);
        return (((((this.exclusiveMaximum == rhs.exclusiveMaximum)||((this.exclusiveMaximum!= null)&&this.exclusiveMaximum.equals(rhs.exclusiveMaximum)))&&((this.maximum == rhs.maximum)||((this.maximum!= null)&&this.maximum.equals(rhs.maximum))))&&((this.exclusiveMinimum == rhs.exclusiveMinimum)||((this.exclusiveMinimum!= null)&&this.exclusiveMinimum.equals(rhs.exclusiveMinimum))))&&((this.minimum == rhs.minimum)||((this.minimum!= null)&&this.minimum.equals(rhs.minimum))));
    }

}
