
package com.opencorporates.schemas.includes;

import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Company that is controlled
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "jurisdiction",
    "company_number",
    "identifier"
})
public class OCSubsidiary {

    /**
     * Name of company
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Name of company")
    @NotNull
    private String name;
    /**
     * Jurisdiction of registration
     * 
     */
    @JsonProperty("jurisdiction")
    @JsonPropertyDescription("Jurisdiction of registration")
    private String jurisdiction;
    /**
     * Company number, if company and known
     * 
     */
    @JsonProperty("company_number")
    @JsonPropertyDescription("Company number, if company and known")
    private String companyNumber;
    /**
     * Unique identifier of company
     * 
     */
    @JsonProperty("identifier")
    @JsonPropertyDescription("Unique identifier of company")
    private String identifier;

    /**
     * Name of company
     * (Required)
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Name of company
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Jurisdiction of registration
     * 
     */
    @JsonProperty("jurisdiction")
    public String getJurisdiction() {
        return jurisdiction;
    }

    /**
     * Jurisdiction of registration
     * 
     */
    @JsonProperty("jurisdiction")
    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    /**
     * Company number, if company and known
     * 
     */
    @JsonProperty("company_number")
    public String getCompanyNumber() {
        return companyNumber;
    }

    /**
     * Company number, if company and known
     * 
     */
    @JsonProperty("company_number")
    public void setCompanyNumber(String companyNumber) {
        this.companyNumber = companyNumber;
    }

    /**
     * Unique identifier of company
     * 
     */
    @JsonProperty("identifier")
    public String getIdentifier() {
        return identifier;
    }

    /**
     * Unique identifier of company
     * 
     */
    @JsonProperty("identifier")
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCSubsidiary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("jurisdiction");
        sb.append('=');
        sb.append(((this.jurisdiction == null)?"<null>":this.jurisdiction));
        sb.append(',');
        sb.append("companyNumber");
        sb.append('=');
        sb.append(((this.companyNumber == null)?"<null>":this.companyNumber));
        sb.append(',');
        sb.append("identifier");
        sb.append('=');
        sb.append(((this.identifier == null)?"<null>":this.identifier));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.identifier == null)? 0 :this.identifier.hashCode()));
        result = ((result* 31)+((this.companyNumber == null)? 0 :this.companyNumber.hashCode()));
        result = ((result* 31)+((this.jurisdiction == null)? 0 :this.jurisdiction.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCSubsidiary) == false) {
            return false;
        }
        OCSubsidiary rhs = ((OCSubsidiary) other);
        return (((((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name)))&&((this.identifier == rhs.identifier)||((this.identifier!= null)&&this.identifier.equals(rhs.identifier))))&&((this.companyNumber == rhs.companyNumber)||((this.companyNumber!= null)&&this.companyNumber.equals(rhs.companyNumber))))&&((this.jurisdiction == rhs.jurisdiction)||((this.jurisdiction!= null)&&this.jurisdiction.equals(rhs.jurisdiction))));
    }

}
