/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"value", "date", "start_date", "end_date", "currency"})
public class OCAccountsElement {
    @JsonProperty(value="value")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String value;
    @JsonProperty(value="date")
    @JsonPropertyDescription(value="If this element is an instant element, i.e. relates to a specific point in time (such as balance sheet item), then give the date this relates to, otherwise use start/end dates for element that occured over a period (e.g. Profit/Loss)")
    private LocalDate date;
    @JsonProperty(value="start_date")
    private LocalDate startDate;
    @JsonProperty(value="end_date")
    private LocalDate endDate;
    @JsonProperty(value="currency")
    @JsonPropertyDescription(value="ISO 4217 code for the currency")
    @Size(min=3, max=3)
    private @Size(min=3, max=3) String currency;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    @JsonProperty(value="date")
    public LocalDate getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    public void setDate(LocalDate date) {
        this.date = date;
    }

    @JsonProperty(value="start_date")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="end_date")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="end_date")
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCAccountsElement.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("value");
        sb.append('=');
        sb.append(this.value == null ? "<null>" : this.value);
        sb.append(',');
        sb.append("date");
        sb.append('=');
        sb.append(this.date == null ? "<null>" : this.date);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(this.endDate == null ? "<null>" : this.endDate);
        sb.append(',');
        sb.append("currency");
        sb.append('=');
        sb.append(this.currency == null ? "<null>" : this.currency);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.date == null ? 0 : this.date.hashCode());
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = result * 31 + (this.currency == null ? 0 : this.currency.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCAccountsElement)) {
            return false;
        }
        OCAccountsElement rhs = (OCAccountsElement)other;
        return (this.date == rhs.date || this.date != null && this.date.equals(rhs.date)) && (this.endDate == rhs.endDate || this.endDate != null && this.endDate.equals(rhs.endDate)) && (this.currency == rhs.currency || this.currency != null && this.currency.equals(rhs.currency)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.value == rhs.value || this.value != null && this.value.equals(rhs.value)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate));
    }
}

