/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"uid", "file_format", "original_source_url", "source_url", "source_location", "language", "classification", "pages"})
public class OCFilingDocument {
    @JsonProperty(value="uid")
    @JsonPropertyDescription(value="Unique id/reference for the filing if it has one")
    private String uid;
    @JsonProperty(value="file_format")
    @JsonPropertyDescription(value="Format of the document, if known")
    private FileFormat fileFormat;
    @JsonProperty(value="original_source_url")
    @JsonPropertyDescription(value="Persistent URL for the document, if there is one")
    private String originalSourceUrl;
    @JsonProperty(value="source_url")
    @JsonPropertyDescription(value="Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page)")
    @Size(min=11)
    private @Size(min=11) String sourceUrl;
    @JsonProperty(value="source_location")
    @JsonPropertyDescription(value="If the accounts filing has been put on sources.opencorporates.com the path to the filing")
    private String sourceLocation;
    @JsonProperty(value="language")
    @JsonPropertyDescription(value="Should be represented as two-letter ISO-639 code")
    @Size(min=2, max=2)
    private @Size(min=2, max=2) String language;
    @JsonProperty(value="classification")
    @JsonPropertyDescription(value="type of document (at the moment only XBRL is the only option here)")
    private Classification classification;
    @JsonProperty(value="pages")
    @JsonPropertyDescription(value="Number of pages, if known")
    private Integer pages;

    @JsonProperty(value="uid")
    public String getUid() {
        return this.uid;
    }

    @JsonProperty(value="uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    @JsonProperty(value="file_format")
    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    @JsonProperty(value="file_format")
    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    @JsonProperty(value="original_source_url")
    public String getOriginalSourceUrl() {
        return this.originalSourceUrl;
    }

    @JsonProperty(value="original_source_url")
    public void setOriginalSourceUrl(String originalSourceUrl) {
        this.originalSourceUrl = originalSourceUrl;
    }

    @JsonProperty(value="source_url")
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    @JsonProperty(value="source_location")
    public String getSourceLocation() {
        return this.sourceLocation;
    }

    @JsonProperty(value="source_location")
    public void setSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    @JsonProperty(value="classification")
    public Classification getClassification() {
        return this.classification;
    }

    @JsonProperty(value="classification")
    public void setClassification(Classification classification) {
        this.classification = classification;
    }

    @JsonProperty(value="pages")
    public Integer getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    public void setPages(Integer pages) {
        this.pages = pages;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCFilingDocument.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("uid");
        sb.append('=');
        sb.append(this.uid == null ? "<null>" : this.uid);
        sb.append(',');
        sb.append("fileFormat");
        sb.append('=');
        sb.append(this.fileFormat == null ? "<null>" : this.fileFormat);
        sb.append(',');
        sb.append("originalSourceUrl");
        sb.append('=');
        sb.append(this.originalSourceUrl == null ? "<null>" : this.originalSourceUrl);
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(this.sourceUrl == null ? "<null>" : this.sourceUrl);
        sb.append(',');
        sb.append("sourceLocation");
        sb.append('=');
        sb.append(this.sourceLocation == null ? "<null>" : this.sourceLocation);
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(this.language == null ? "<null>" : this.language);
        sb.append(',');
        sb.append("classification");
        sb.append('=');
        sb.append(this.classification == null ? "<null>" : this.classification);
        sb.append(',');
        sb.append("pages");
        sb.append('=');
        sb.append(this.pages == null ? "<null>" : this.pages);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.originalSourceUrl == null ? 0 : this.originalSourceUrl.hashCode());
        result = result * 31 + (this.sourceUrl == null ? 0 : this.sourceUrl.hashCode());
        result = result * 31 + (this.uid == null ? 0 : this.uid.hashCode());
        result = result * 31 + (this.pages == null ? 0 : this.pages.hashCode());
        result = result * 31 + (this.sourceLocation == null ? 0 : this.sourceLocation.hashCode());
        result = result * 31 + (this.language == null ? 0 : this.language.hashCode());
        result = result * 31 + (this.classification == null ? 0 : this.classification.hashCode());
        result = result * 31 + (this.fileFormat == null ? 0 : this.fileFormat.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCFilingDocument)) {
            return false;
        }
        OCFilingDocument rhs = (OCFilingDocument)other;
        return (this.originalSourceUrl == rhs.originalSourceUrl || this.originalSourceUrl != null && this.originalSourceUrl.equals(rhs.originalSourceUrl)) && (this.sourceUrl == rhs.sourceUrl || this.sourceUrl != null && this.sourceUrl.equals(rhs.sourceUrl)) && (this.uid == rhs.uid || this.uid != null && this.uid.equals(rhs.uid)) && (this.pages == rhs.pages || this.pages != null && this.pages.equals(rhs.pages)) && (this.sourceLocation == rhs.sourceLocation || this.sourceLocation != null && this.sourceLocation.equals(rhs.sourceLocation)) && (this.language == rhs.language || this.language != null && this.language.equals(rhs.language)) && (this.classification == rhs.classification || this.classification != null && this.classification.equals((Object)rhs.classification)) && (this.fileFormat == rhs.fileFormat || this.fileFormat != null && this.fileFormat.equals((Object)rhs.fileFormat));
    }

    public static enum FileFormat {
        XML("xml"),
        PDF("pdf"),
        HTML("html"),
        DOC("doc");

        private final String value;
        private static final Map<String, FileFormat> CONSTANTS;

        private FileFormat(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static FileFormat fromValue(String value) {
            FileFormat constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, FileFormat>();
            for (FileFormat c : FileFormat.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Classification {
        XBRL("xbrl");

        private final String value;
        private static final Map<String, Classification> CONSTANTS;

        private Classification(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Classification fromValue(String value) {
            Classification constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Classification>();
            for (Classification c : Classification.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

