/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.opencorporates.schemas.OCAbout;
import com.opencorporates.schemas.OCDocument;
import com.opencorporates.schemas.OCEntity;
import com.opencorporates.schemas.OCIssue__1;
import com.opencorporates.schemas.OCOtherAttributes__4;
import com.opencorporates.schemas.OCPublisher;
import com.opencorporates.schemas.OCUpdateAction;
import java.net.URI;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"identifier", "uid", "date_published", "summary", "subjects", "related_entities", "about", "update_action", "issue", "document", "creator", "publisher", "url", "media_type", "source_url", "sample_date", "retrieved_at", "confidence", "other_attributes"})
public class OCGazetteNoticeSchema {
    @JsonProperty(value="identifier")
    @JsonPropertyDescription(value="The publisher's identifier for the notice, which may not be unique")
    private Integer identifier;
    @JsonProperty(value="uid")
    @JsonPropertyDescription(value="An internal, constructed, unique identifier, which may be the same as `identifier`")
    @NotNull
    private String uid;
    @JsonProperty(value="date_published")
    @JsonPropertyDescription(value="The date of publication of the notice")
    private LocalDate datePublished;
    @JsonProperty(value="summary")
    @JsonPropertyDescription(value="A brief summary of the notice's content")
    private String summary;
    @JsonProperty(value="subjects")
    @JsonPropertyDescription(value="The entities that the notice is primarily about")
    @Valid
    private List<OCEntity> subjects = new ArrayList<OCEntity>();
    @JsonProperty(value="related_entities")
    @JsonPropertyDescription(value="Other entities that the notice is about")
    @Valid
    private List<OCEntity> relatedEntities = new ArrayList<OCEntity>();
    @JsonProperty(value="about")
    @JsonPropertyDescription(value="The content of the notice")
    @Valid
    private OCAbout about;
    @JsonProperty(value="update_action")
    @JsonPropertyDescription(value="An act of changing an object")
    @Valid
    private OCUpdateAction updateAction;
    @JsonProperty(value="issue")
    @JsonPropertyDescription(value="An issue of a gazette")
    @Valid
    @NotNull
    private OCIssue__1 issue;
    @JsonProperty(value="document")
    @JsonPropertyDescription(value="A section of an issue")
    @Valid
    private OCDocument document;
    @JsonProperty(value="creator")
    @Valid
    private OCEntity creator;
    @JsonProperty(value="publisher")
    @JsonPropertyDescription(value="A gazette publisher")
    @Valid
    private OCPublisher publisher;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="The URL of the notice, at which a human may verify the data")
    private URI url;
    @JsonProperty(value="media_type")
    @JsonPropertyDescription(value="The media type of the URL resource")
    private String mediaType;
    @JsonProperty(value="source_url")
    @JsonPropertyDescription(value="The URL of the file from which the data was extracted by the scraper")
    @NotNull
    private URI sourceUrl;
    @JsonProperty(value="sample_date")
    @JsonPropertyDescription(value="A date on which the data is known to be true")
    @NotNull
    private LocalDate sampleDate;
    @JsonProperty(value="retrieved_at")
    @JsonPropertyDescription(value="The time or date at which the source URL was requested")
    private LocalDate retrievedAt;
    @JsonProperty(value="confidence")
    @JsonPropertyDescription(value="The scraper's author's confidence in the accuracy of the data")
    @NotNull
    private Confidence confidence;
    @JsonProperty(value="other_attributes")
    @JsonPropertyDescription(value="Any other structured data from the notice")
    @Valid
    private OCOtherAttributes__4 otherAttributes;

    @JsonProperty(value="identifier")
    public Integer getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    public void setIdentifier(Integer identifier) {
        this.identifier = identifier;
    }

    @JsonProperty(value="uid")
    public String getUid() {
        return this.uid;
    }

    @JsonProperty(value="uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    @JsonProperty(value="date_published")
    public LocalDate getDatePublished() {
        return this.datePublished;
    }

    @JsonProperty(value="date_published")
    public void setDatePublished(LocalDate datePublished) {
        this.datePublished = datePublished;
    }

    @JsonProperty(value="summary")
    public String getSummary() {
        return this.summary;
    }

    @JsonProperty(value="summary")
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @JsonProperty(value="subjects")
    public List<OCEntity> getSubjects() {
        return this.subjects;
    }

    @JsonProperty(value="subjects")
    public void setSubjects(List<OCEntity> subjects) {
        this.subjects = subjects;
    }

    @JsonProperty(value="related_entities")
    public List<OCEntity> getRelatedEntities() {
        return this.relatedEntities;
    }

    @JsonProperty(value="related_entities")
    public void setRelatedEntities(List<OCEntity> relatedEntities) {
        this.relatedEntities = relatedEntities;
    }

    @JsonProperty(value="about")
    public OCAbout getAbout() {
        return this.about;
    }

    @JsonProperty(value="about")
    public void setAbout(OCAbout about) {
        this.about = about;
    }

    @JsonProperty(value="update_action")
    public OCUpdateAction getUpdateAction() {
        return this.updateAction;
    }

    @JsonProperty(value="update_action")
    public void setUpdateAction(OCUpdateAction updateAction) {
        this.updateAction = updateAction;
    }

    @JsonProperty(value="issue")
    public OCIssue__1 getIssue() {
        return this.issue;
    }

    @JsonProperty(value="issue")
    public void setIssue(OCIssue__1 issue) {
        this.issue = issue;
    }

    @JsonProperty(value="document")
    public OCDocument getDocument() {
        return this.document;
    }

    @JsonProperty(value="document")
    public void setDocument(OCDocument document) {
        this.document = document;
    }

    @JsonProperty(value="creator")
    public OCEntity getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    public void setCreator(OCEntity creator) {
        this.creator = creator;
    }

    @JsonProperty(value="publisher")
    public OCPublisher getPublisher() {
        return this.publisher;
    }

    @JsonProperty(value="publisher")
    public void setPublisher(OCPublisher publisher) {
        this.publisher = publisher;
    }

    @JsonProperty(value="url")
    public URI getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(URI url) {
        this.url = url;
    }

    @JsonProperty(value="media_type")
    public String getMediaType() {
        return this.mediaType;
    }

    @JsonProperty(value="media_type")
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    @JsonProperty(value="source_url")
    public URI getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="source_url")
    public void setSourceUrl(URI sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    @JsonProperty(value="sample_date")
    public LocalDate getSampleDate() {
        return this.sampleDate;
    }

    @JsonProperty(value="sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    @JsonProperty(value="retrieved_at")
    public LocalDate getRetrievedAt() {
        return this.retrievedAt;
    }

    @JsonProperty(value="retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    @JsonProperty(value="confidence")
    public Confidence getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="confidence")
    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    @JsonProperty(value="other_attributes")
    public OCOtherAttributes__4 getOtherAttributes() {
        return this.otherAttributes;
    }

    @JsonProperty(value="other_attributes")
    public void setOtherAttributes(OCOtherAttributes__4 otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCGazetteNoticeSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("identifier");
        sb.append('=');
        sb.append(this.identifier == null ? "<null>" : this.identifier);
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(this.uid == null ? "<null>" : this.uid);
        sb.append(',');
        sb.append("datePublished");
        sb.append('=');
        sb.append(this.datePublished == null ? "<null>" : this.datePublished);
        sb.append(',');
        sb.append("summary");
        sb.append('=');
        sb.append(this.summary == null ? "<null>" : this.summary);
        sb.append(',');
        sb.append("subjects");
        sb.append('=');
        sb.append(this.subjects == null ? "<null>" : this.subjects);
        sb.append(',');
        sb.append("relatedEntities");
        sb.append('=');
        sb.append(this.relatedEntities == null ? "<null>" : this.relatedEntities);
        sb.append(',');
        sb.append("about");
        sb.append('=');
        sb.append(this.about == null ? "<null>" : this.about);
        sb.append(',');
        sb.append("updateAction");
        sb.append('=');
        sb.append(this.updateAction == null ? "<null>" : this.updateAction);
        sb.append(',');
        sb.append("issue");
        sb.append('=');
        sb.append(this.issue == null ? "<null>" : this.issue);
        sb.append(',');
        sb.append("document");
        sb.append('=');
        sb.append(this.document == null ? "<null>" : this.document);
        sb.append(',');
        sb.append("creator");
        sb.append('=');
        sb.append(this.creator == null ? "<null>" : this.creator);
        sb.append(',');
        sb.append("publisher");
        sb.append('=');
        sb.append(this.publisher == null ? "<null>" : this.publisher);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("mediaType");
        sb.append('=');
        sb.append(this.mediaType == null ? "<null>" : this.mediaType);
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(this.sourceUrl == null ? "<null>" : this.sourceUrl);
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(this.sampleDate == null ? "<null>" : this.sampleDate);
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(this.retrievedAt == null ? "<null>" : this.retrievedAt);
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(this.confidence == null ? "<null>" : this.confidence);
        sb.append(',');
        sb.append("otherAttributes");
        sb.append('=');
        sb.append(this.otherAttributes == null ? "<null>" : this.otherAttributes);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.summary == null ? 0 : this.summary.hashCode());
        result = result * 31 + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = result * 31 + (this.creator == null ? 0 : this.creator.hashCode());
        result = result * 31 + (this.issue == null ? 0 : this.issue.hashCode());
        result = result * 31 + (this.subjects == null ? 0 : this.subjects.hashCode());
        result = result * 31 + (this.document == null ? 0 : this.document.hashCode());
        result = result * 31 + (this.confidence == null ? 0 : this.confidence.hashCode());
        result = result * 31 + (this.about == null ? 0 : this.about.hashCode());
        result = result * 31 + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        result = result * 31 + (this.otherAttributes == null ? 0 : this.otherAttributes.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        result = result * 31 + (this.datePublished == null ? 0 : this.datePublished.hashCode());
        result = result * 31 + (this.updateAction == null ? 0 : this.updateAction.hashCode());
        result = result * 31 + (this.sourceUrl == null ? 0 : this.sourceUrl.hashCode());
        result = result * 31 + (this.uid == null ? 0 : this.uid.hashCode());
        result = result * 31 + (this.retrievedAt == null ? 0 : this.retrievedAt.hashCode());
        result = result * 31 + (this.sampleDate == null ? 0 : this.sampleDate.hashCode());
        result = result * 31 + (this.publisher == null ? 0 : this.publisher.hashCode());
        result = result * 31 + (this.relatedEntities == null ? 0 : this.relatedEntities.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCGazetteNoticeSchema)) {
            return false;
        }
        OCGazetteNoticeSchema rhs = (OCGazetteNoticeSchema)other;
        return (this.summary == rhs.summary || this.summary != null && this.summary.equals(rhs.summary)) && (this.identifier == rhs.identifier || this.identifier != null && this.identifier.equals(rhs.identifier)) && (this.creator == rhs.creator || this.creator != null && this.creator.equals(rhs.creator)) && (this.issue == rhs.issue || this.issue != null && this.issue.equals(rhs.issue)) && (this.subjects == rhs.subjects || this.subjects != null && this.subjects.equals(rhs.subjects)) && (this.document == rhs.document || this.document != null && this.document.equals(rhs.document)) && (this.confidence == rhs.confidence || this.confidence != null && this.confidence.equals((Object)rhs.confidence)) && (this.about == rhs.about || this.about != null && this.about.equals(rhs.about)) && (this.mediaType == rhs.mediaType || this.mediaType != null && this.mediaType.equals(rhs.mediaType)) && (this.otherAttributes == rhs.otherAttributes || this.otherAttributes != null && this.otherAttributes.equals(rhs.otherAttributes)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url)) && (this.datePublished == rhs.datePublished || this.datePublished != null && this.datePublished.equals(rhs.datePublished)) && (this.updateAction == rhs.updateAction || this.updateAction != null && this.updateAction.equals(rhs.updateAction)) && (this.sourceUrl == rhs.sourceUrl || this.sourceUrl != null && this.sourceUrl.equals(rhs.sourceUrl)) && (this.uid == rhs.uid || this.uid != null && this.uid.equals(rhs.uid)) && (this.retrievedAt == rhs.retrievedAt || this.retrievedAt != null && this.retrievedAt.equals(rhs.retrievedAt)) && (this.sampleDate == rhs.sampleDate || this.sampleDate != null && this.sampleDate.equals(rhs.sampleDate)) && (this.publisher == rhs.publisher || this.publisher != null && this.publisher.equals(rhs.publisher)) && (this.relatedEntities == rhs.relatedEntities || this.relatedEntities != null && this.relatedEntities.equals(rhs.relatedEntities));
    }

    public static enum Confidence {
        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");

        private final String value;
        private static final Map<String, Confidence> CONSTANTS;

        private Confidence(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Confidence fromValue(String value) {
            Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Confidence>();
            for (Confidence c : Confidence.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

