/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.opencorporates.schemas.Category;
import com.opencorporates.schemas.OCEntity;
import com.opencorporates.schemas.OCOtherAttributes__5;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"licence_holder", "licence_issuer", "licenced_location", "licence_number", "start_date", "end_date", "source_url", "confidence", "renewal_date", "sample_date", "retrieved_at", "licence_url", "jurisdiction_of_licence", "status", "category", "permissions", "other_attributes"})
public class OCLicenceSchema {
    @JsonProperty(value="licence_holder")
    @Valid
    @NotNull
    private OCEntity licenceHolder;
    @JsonProperty(value="licence_issuer")
    @NotNull
    private Object licenceIssuer;
    @JsonProperty(value="licenced_location")
    private Object licencedLocation;
    @JsonProperty(value="licence_number")
    private String licenceNumber;
    @JsonProperty(value="start_date")
    @JsonPropertyDescription(value="The issue date of the licence")
    private LocalDate startDate;
    @JsonProperty(value="end_date")
    @JsonPropertyDescription(value="The expiry date of the licence")
    private LocalDate endDate;
    @JsonProperty(value="source_url")
    @JsonPropertyDescription(value="Place where this fact can be verified")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String sourceUrl;
    @JsonProperty(value="confidence")
    @JsonPropertyDescription(value="Confidence in accuracy of data")
    private Confidence confidence;
    @JsonProperty(value="renewal_date")
    private LocalDate renewalDate;
    @JsonProperty(value="sample_date")
    @JsonPropertyDescription(value="Date on which we know this to be true (usually date this information was retrieved from the source)")
    @NotNull
    private LocalDate sampleDate;
    @JsonProperty(value="retrieved_at")
    @JsonPropertyDescription(value="The time or date at which the source URL was requested")
    private LocalDate retrievedAt;
    @JsonProperty(value="licence_url")
    @JsonPropertyDescription(value="A public URL for the licence")
    private String licenceUrl;
    @JsonProperty(value="jurisdiction_of_licence")
    @JsonPropertyDescription(value="The area in which this licence is valid")
    @NotNull
    private String jurisdictionOfLicence;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="The status of the licence. If the licence is made up of a number of permissions, each of which has a status, store the status in the permissions field instead/as well")
    private String status;
    @JsonProperty(value="category")
    @JsonPropertyDescription(value="Category of licence")
    @Valid
    private List<Category> category = new ArrayList<Category>();
    @JsonProperty(value="permissions")
    @Valid
    @NotNull
    private List<Object> permissions = new ArrayList<Object>();
    @JsonProperty(value="other_attributes")
    @JsonPropertyDescription(value="Use for other licence attributes for which we don't yet have curated schema attributes")
    @Valid
    private OCOtherAttributes__5 otherAttributes;

    @JsonProperty(value="licence_holder")
    public OCEntity getLicenceHolder() {
        return this.licenceHolder;
    }

    @JsonProperty(value="licence_holder")
    public void setLicenceHolder(OCEntity licenceHolder) {
        this.licenceHolder = licenceHolder;
    }

    @JsonProperty(value="licence_issuer")
    public Object getLicenceIssuer() {
        return this.licenceIssuer;
    }

    @JsonProperty(value="licence_issuer")
    public void setLicenceIssuer(Object licenceIssuer) {
        this.licenceIssuer = licenceIssuer;
    }

    @JsonProperty(value="licenced_location")
    public Object getLicencedLocation() {
        return this.licencedLocation;
    }

    @JsonProperty(value="licenced_location")
    public void setLicencedLocation(Object licencedLocation) {
        this.licencedLocation = licencedLocation;
    }

    @JsonProperty(value="licence_number")
    public String getLicenceNumber() {
        return this.licenceNumber;
    }

    @JsonProperty(value="licence_number")
    public void setLicenceNumber(String licenceNumber) {
        this.licenceNumber = licenceNumber;
    }

    @JsonProperty(value="start_date")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="end_date")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="end_date")
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    @JsonProperty(value="source_url")
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    @JsonProperty(value="confidence")
    public Confidence getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="confidence")
    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    @JsonProperty(value="renewal_date")
    public LocalDate getRenewalDate() {
        return this.renewalDate;
    }

    @JsonProperty(value="renewal_date")
    public void setRenewalDate(LocalDate renewalDate) {
        this.renewalDate = renewalDate;
    }

    @JsonProperty(value="sample_date")
    public LocalDate getSampleDate() {
        return this.sampleDate;
    }

    @JsonProperty(value="sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    @JsonProperty(value="retrieved_at")
    public LocalDate getRetrievedAt() {
        return this.retrievedAt;
    }

    @JsonProperty(value="retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    @JsonProperty(value="licence_url")
    public String getLicenceUrl() {
        return this.licenceUrl;
    }

    @JsonProperty(value="licence_url")
    public void setLicenceUrl(String licenceUrl) {
        this.licenceUrl = licenceUrl;
    }

    @JsonProperty(value="jurisdiction_of_licence")
    public String getJurisdictionOfLicence() {
        return this.jurisdictionOfLicence;
    }

    @JsonProperty(value="jurisdiction_of_licence")
    public void setJurisdictionOfLicence(String jurisdictionOfLicence) {
        this.jurisdictionOfLicence = jurisdictionOfLicence;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="category")
    public List<Category> getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    public void setCategory(List<Category> category) {
        this.category = category;
    }

    @JsonProperty(value="permissions")
    public List<Object> getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="permissions")
    public void setPermissions(List<Object> permissions) {
        this.permissions = permissions;
    }

    @JsonProperty(value="other_attributes")
    public OCOtherAttributes__5 getOtherAttributes() {
        return this.otherAttributes;
    }

    @JsonProperty(value="other_attributes")
    public void setOtherAttributes(OCOtherAttributes__5 otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCLicenceSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("licenceHolder");
        sb.append('=');
        sb.append(this.licenceHolder == null ? "<null>" : this.licenceHolder);
        sb.append(',');
        sb.append("licenceIssuer");
        sb.append('=');
        sb.append(this.licenceIssuer == null ? "<null>" : this.licenceIssuer);
        sb.append(',');
        sb.append("licencedLocation");
        sb.append('=');
        sb.append(this.licencedLocation == null ? "<null>" : this.licencedLocation);
        sb.append(',');
        sb.append("licenceNumber");
        sb.append('=');
        sb.append(this.licenceNumber == null ? "<null>" : this.licenceNumber);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(this.endDate == null ? "<null>" : this.endDate);
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(this.sourceUrl == null ? "<null>" : this.sourceUrl);
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(this.confidence == null ? "<null>" : this.confidence);
        sb.append(',');
        sb.append("renewalDate");
        sb.append('=');
        sb.append(this.renewalDate == null ? "<null>" : this.renewalDate);
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(this.sampleDate == null ? "<null>" : this.sampleDate);
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(this.retrievedAt == null ? "<null>" : this.retrievedAt);
        sb.append(',');
        sb.append("licenceUrl");
        sb.append('=');
        sb.append(this.licenceUrl == null ? "<null>" : this.licenceUrl);
        sb.append(',');
        sb.append("jurisdictionOfLicence");
        sb.append('=');
        sb.append(this.jurisdictionOfLicence == null ? "<null>" : this.jurisdictionOfLicence);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("category");
        sb.append('=');
        sb.append(this.category == null ? "<null>" : this.category);
        sb.append(',');
        sb.append("permissions");
        sb.append('=');
        sb.append(this.permissions == null ? "<null>" : this.permissions);
        sb.append(',');
        sb.append("otherAttributes");
        sb.append('=');
        sb.append(this.otherAttributes == null ? "<null>" : this.otherAttributes);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = result * 31 + (this.licenceNumber == null ? 0 : this.licenceNumber.hashCode());
        result = result * 31 + (this.confidence == null ? 0 : this.confidence.hashCode());
        result = result * 31 + (this.licencedLocation == null ? 0 : this.licencedLocation.hashCode());
        result = result * 31 + (this.renewalDate == null ? 0 : this.renewalDate.hashCode());
        result = result * 31 + (this.otherAttributes == null ? 0 : this.otherAttributes.hashCode());
        result = result * 31 + (this.sourceUrl == null ? 0 : this.sourceUrl.hashCode());
        result = result * 31 + (this.licenceUrl == null ? 0 : this.licenceUrl.hashCode());
        result = result * 31 + (this.retrievedAt == null ? 0 : this.retrievedAt.hashCode());
        result = result * 31 + (this.licenceHolder == null ? 0 : this.licenceHolder.hashCode());
        result = result * 31 + (this.licenceIssuer == null ? 0 : this.licenceIssuer.hashCode());
        result = result * 31 + (this.permissions == null ? 0 : this.permissions.hashCode());
        result = result * 31 + (this.sampleDate == null ? 0 : this.sampleDate.hashCode());
        result = result * 31 + (this.jurisdictionOfLicence == null ? 0 : this.jurisdictionOfLicence.hashCode());
        result = result * 31 + (this.category == null ? 0 : this.category.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCLicenceSchema)) {
            return false;
        }
        OCLicenceSchema rhs = (OCLicenceSchema)other;
        return (this.endDate == rhs.endDate || this.endDate != null && this.endDate.equals(rhs.endDate)) && (this.licenceNumber == rhs.licenceNumber || this.licenceNumber != null && this.licenceNumber.equals(rhs.licenceNumber)) && (this.confidence == rhs.confidence || this.confidence != null && this.confidence.equals((Object)rhs.confidence)) && (this.licencedLocation == rhs.licencedLocation || this.licencedLocation != null && this.licencedLocation.equals(rhs.licencedLocation)) && (this.renewalDate == rhs.renewalDate || this.renewalDate != null && this.renewalDate.equals(rhs.renewalDate)) && (this.otherAttributes == rhs.otherAttributes || this.otherAttributes != null && this.otherAttributes.equals(rhs.otherAttributes)) && (this.sourceUrl == rhs.sourceUrl || this.sourceUrl != null && this.sourceUrl.equals(rhs.sourceUrl)) && (this.licenceUrl == rhs.licenceUrl || this.licenceUrl != null && this.licenceUrl.equals(rhs.licenceUrl)) && (this.retrievedAt == rhs.retrievedAt || this.retrievedAt != null && this.retrievedAt.equals(rhs.retrievedAt)) && (this.licenceHolder == rhs.licenceHolder || this.licenceHolder != null && this.licenceHolder.equals(rhs.licenceHolder)) && (this.licenceIssuer == rhs.licenceIssuer || this.licenceIssuer != null && this.licenceIssuer.equals(rhs.licenceIssuer)) && (this.permissions == rhs.permissions || this.permissions != null && this.permissions.equals(rhs.permissions)) && (this.sampleDate == rhs.sampleDate || this.sampleDate != null && this.sampleDate.equals(rhs.sampleDate)) && (this.jurisdictionOfLicence == rhs.jurisdictionOfLicence || this.jurisdictionOfLicence != null && this.jurisdictionOfLicence.equals(rhs.jurisdictionOfLicence)) && (this.category == rhs.category || this.category != null && this.category.equals(rhs.category)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate)) && (this.status == rhs.status || this.status != null && this.status.equals(rhs.status));
    }

    public static enum Confidence {
        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");

        private final String value;
        private static final Map<String, Confidence> CONSTANTS;

        private Confidence(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Confidence fromValue(String value) {
            Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Confidence>();
            for (Confidence c : Confidence.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

