/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.opencorporates.schemas.OCMarkImage;
import com.opencorporates.schemas.OCNiceClassification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"mark_text", "mark_form", "mark_type", "mark_image", "classification"})
public class OCMarkDetails {
    @JsonProperty(value="mark_text")
    @JsonPropertyDescription(value="Text of the trademark")
    private String markText;
    @JsonProperty(value="mark_form")
    @JsonPropertyDescription(value="The form (i.e. category) of the mark. Sensory marks include smells and sounds")
    private MarkForm markForm;
    @JsonProperty(value="mark_type")
    @JsonPropertyDescription(value="Free text description of mark type (as provided by register), e.g. 'Illustration', 'Typeset: Word(s)/letter(s)/number(s)'")
    private String markType;
    @JsonProperty(value="mark_image")
    private OCMarkImage markImage;
    @JsonProperty(value="classification")
    @JsonPropertyDescription(value="Classification of the trademark")
    @Valid
    private List<OCNiceClassification> classification = new ArrayList<OCNiceClassification>();

    @JsonProperty(value="mark_text")
    public String getMarkText() {
        return this.markText;
    }

    @JsonProperty(value="mark_text")
    public void setMarkText(String markText) {
        this.markText = markText;
    }

    @JsonProperty(value="mark_form")
    public MarkForm getMarkForm() {
        return this.markForm;
    }

    @JsonProperty(value="mark_form")
    public void setMarkForm(MarkForm markForm) {
        this.markForm = markForm;
    }

    @JsonProperty(value="mark_type")
    public String getMarkType() {
        return this.markType;
    }

    @JsonProperty(value="mark_type")
    public void setMarkType(String markType) {
        this.markType = markType;
    }

    @JsonProperty(value="mark_image")
    public OCMarkImage getMarkImage() {
        return this.markImage;
    }

    @JsonProperty(value="mark_image")
    public void setMarkImage(OCMarkImage markImage) {
        this.markImage = markImage;
    }

    @JsonProperty(value="classification")
    public List<OCNiceClassification> getClassification() {
        return this.classification;
    }

    @JsonProperty(value="classification")
    public void setClassification(List<OCNiceClassification> classification) {
        this.classification = classification;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCMarkDetails.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("markText");
        sb.append('=');
        sb.append(this.markText == null ? "<null>" : this.markText);
        sb.append(',');
        sb.append("markForm");
        sb.append('=');
        sb.append(this.markForm == null ? "<null>" : this.markForm);
        sb.append(',');
        sb.append("markType");
        sb.append('=');
        sb.append(this.markType == null ? "<null>" : this.markType);
        sb.append(',');
        sb.append("markImage");
        sb.append('=');
        sb.append(this.markImage == null ? "<null>" : this.markImage);
        sb.append(',');
        sb.append("classification");
        sb.append('=');
        sb.append(this.classification == null ? "<null>" : this.classification);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.markText == null ? 0 : this.markText.hashCode());
        result = result * 31 + (this.markForm == null ? 0 : this.markForm.hashCode());
        result = result * 31 + (this.classification == null ? 0 : this.classification.hashCode());
        result = result * 31 + (this.markType == null ? 0 : this.markType.hashCode());
        result = result * 31 + (this.markImage == null ? 0 : this.markImage.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCMarkDetails)) {
            return false;
        }
        OCMarkDetails rhs = (OCMarkDetails)other;
        return (this.markText == rhs.markText || this.markText != null && this.markText.equals(rhs.markText)) && (this.markForm == rhs.markForm || this.markForm != null && this.markForm.equals((Object)rhs.markForm)) && (this.classification == rhs.classification || this.classification != null && this.classification.equals(rhs.classification)) && (this.markType == rhs.markType || this.markType != null && this.markType.equals(rhs.markType)) && (this.markImage == rhs.markImage || this.markImage != null && this.markImage.equals(rhs.markImage));
    }

    public static enum MarkForm {
        TEXT("text"),
        IMAGE("image"),
        SENSORY_MARK("sensory_mark"),
        THREE_D_MARK("three_d_mark");

        private final String value;
        private static final Map<String, MarkForm> CONSTANTS;

        private MarkForm(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MarkForm fromValue(String value) {
            MarkForm constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, MarkForm>();
            for (MarkForm c : MarkForm.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

